/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.publiclinks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.exception.ResourceUnavailableException;
import de.justsoftware.drive.business.publiclinks.PublicLinkService;
import de.justsoftware.drive.business.track.TrackingService;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.common.publiclinks.model.PublicLinkBO;
import de.justsoftware.drive.persistence.publiclinks.PublicLinkDAO;
import java.time.Clock;
import java.time.Instant;
import java.util.Objects;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class PublicLinkServiceImpl
implements PublicLinkService {
    private static final String LINK_ID_TRACKING_PARAM_KEY = "linkID";
    private static final PasswordEncoder PASSWORD_ENCODER = Pbkdf2PasswordEncoder.defaultsForSpringSecurity_v5_5();
    private final PublicLinkDAO _dao;
    private final TrackingService _trackingService;
    private final Clock _clock;

    @Autowired
    public PublicLinkServiceImpl(PublicLinkDAO dao, TrackingService trackingService, Clock clock) {
        this._dao = dao;
        this._trackingService = trackingService;
        this._clock = clock;
    }

    private void checkExpirationDate(Instant expires) {
        if (expires.isBefore(Instant.now())) {
            throw new IllegalArgumentException("The given expiration date is before the current date.");
        }
    }

    public PublicLinkBO createPublicLink(PersonId personId, DocumentId fileId, Instant expires) {
        this.checkExpirationDate(expires);
        String linkID = this._dao.createPublicLink(personId, fileId, expires);
        PublicLinkBO newLink = this.getLink(linkID);
        if (newLink == null) {
            throw new RuntimeException("Couldn't retrieve the newly generated link. This should never have happened. Investigate!");
        }
        return newLink;
    }

    public PublicLinkBO getLink(String linkID) {
        return this._dao.getPublicLink(linkID);
    }

    public ImmutableList<PublicLinkBO> getLinks(DocumentId fileId) {
        return this._dao.getPublicLinks(fileId);
    }

    public ImmutableSet<DocumentId> hasLinks(Set<DocumentId> documentsToCheck) {
        return this._dao.hasLinks(documentsToCheck);
    }

    public void deleteLink(DocumentId fileID, String linkID) {
        this._dao.deleteLink(fileID, linkID);
    }

    public void updateLink(DocumentId fileID, String linkID, Instant expirationDate, String password) {
        String newPassword;
        PublicLinkBO oldLink = this.getLink(linkID);
        ResourceUnavailableException.checkNotNull((Object)oldLink, (String)("The public link with id " + linkID + " was not found."));
        if (expirationDate != null && !Objects.equals(oldLink.getExpirationDate(), expirationDate)) {
            this.checkExpirationDate(expirationDate);
            this._trackingService.track(TrackingService.TrackingAction.EXPIRATION_DATE_CHANGED, TrackingService.TrackingType.DRIVE_PUBLIC_LINKS, LINK_ID_TRACKING_PARAM_KEY, linkID);
        }
        if (password == null) {
            newPassword = null;
        } else if (password.isEmpty()) {
            newPassword = "";
            this._trackingService.track(TrackingService.TrackingAction.PASSWORD_REMOVED, TrackingService.TrackingType.DRIVE_PUBLIC_LINKS, LINK_ID_TRACKING_PARAM_KEY, linkID);
        } else {
            newPassword = PASSWORD_ENCODER.encode((CharSequence)password);
            this._trackingService.track(TrackingService.TrackingAction.PASSWORD_SET, TrackingService.TrackingType.DRIVE_PUBLIC_LINKS, LINK_ID_TRACKING_PARAM_KEY, linkID);
        }
        this._dao.updateLink(fileID, linkID, expirationDate, newPassword);
    }

    public boolean passwordMatches(String password, String derivedKey) {
        return PASSWORD_ENCODER.matches((CharSequence)password, derivedKey);
    }
}

