/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.document.impl;

import com.fasterxml.jackson.databind.JsonNode;
import de.justsoftware.drive.business.kafka.AbstractKafkaConsumer;
import de.justsoftware.drive.business.kafka.KafkaConfigurationProvider;
import de.justsoftware.drive.persistence.transaction.TransactionSupport;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class HolmesTrackingConsumer
extends AbstractKafkaConsumer<String, String> {
    private static final String TRACKING = "tracking";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"tracking");
    static final String TOPIC_NAME = "tracking";

    @Autowired
    public HolmesTrackingConsumer(KafkaConfigurationProvider configurationProvider, TransactionSupport transactionSupport) {
        super(configurationProvider.stringConsumer("just.drive.HolmesTrackingConsumer"), transactionSupport, "tracking");
    }

    protected Logger getLog() {
        return LOGGER;
    }

    protected void process(ConsumerRecords<String, String> records, Consumer<Runnable> afterCommitCallbackConsumer) {
        records.forEach(arg_0 -> this.processRecord(arg_0));
    }

    private void processRecord(ConsumerRecord<String, String> record) {
        String recordValue = (String)record.value();
        if (recordValue == null) {
            return;
        }
        JsonNode parsedRecord = this.parseJson(recordValue);
        if (parsedRecord == null) {
            return;
        }
        JsonNode targetNode = parsedRecord.get("target");
        if (targetNode == null) {
            return;
        }
        JsonNode typeNode = targetNode.get("type");
        if (typeNode == null) {
            return;
        }
        String type = typeNode.asText();
        if (!"DRIVE".equals(type)) {
            return;
        }
        LOGGER.info(record.timestamp() + ": " + targetNode.toString());
    }
}

