/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.authorization.item;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.SetMultimap;
import com.google.common.eventbus.EventBus;
import de.justsoftware.drive.business.authorization.AuthorizationService;
import de.justsoftware.drive.business.authorization.ItemReadRoleService;
import de.justsoftware.drive.business.event.ItemVisibilitiesChangedEvent;
import de.justsoftware.drive.common.authorization.model.Role;
import de.justsoftware.drive.common.authorization.model.StaticAction;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.persistence.authorization.ItemReadRoleDAO;
import de.justsoftware.ornot.CollectEvalContext;
import java.util.Objects;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ItemReadRoleServiceImpl
implements ItemReadRoleService {
    private static final ImmutableSet<StaticAction> READ_ACTIONS = ImmutableSet.of((Object)StaticAction.DOCUMENT_READ, (Object)StaticAction.DOCUMENT_READ_PRIVATE);
    private final AuthorizationService _authorizationService;
    private final ItemReadRoleDAO _itemReadRoleDAO;
    private final EventBus _eventBus;

    @Autowired
    public ItemReadRoleServiceImpl(AuthorizationService authorizationService, ItemReadRoleDAO itemReadRoleDAO, EventBus eventBus) {
        this._authorizationService = authorizationService;
        this._itemReadRoleDAO = itemReadRoleDAO;
        this._eventBus = eventBus;
    }

    public ImmutableSetMultimap<Role, ItemId> getItemsWithReadRoles(Set<? extends Role> roles) {
        return this._itemReadRoleDAO.getItemsWithReadRoles(roles);
    }

    public void updateItemReadRoles(Set<ItemId> items) {
        ImmutableSetMultimap itemsPerAction = (ImmutableSetMultimap)items.stream().collect(ImmutableSetMultimap.flatteningToImmutableSetMultimap(key -> key, value -> READ_ACTIONS.stream()));
        ImmutableTable permissions = this._authorizationService.loadPermissions((SetMultimap)itemsPerAction);
        for (ItemId itemId : items) {
            FluentIterable perm = FluentIterable.from((Iterable)READ_ACTIONS).transform(arg_0 -> ((ImmutableMap)permissions.row((Object)itemId)).get(arg_0)).filter(Objects::nonNull);
            this._itemReadRoleDAO.setReadRoles(itemId, (Set)CollectEvalContext.collect((Iterable)perm));
        }
        this._eventBus.post((Object)new ItemVisibilitiesChangedEvent(items));
    }

    public void setReadRoles(ItemId itemId, Set<? extends Role> roles) {
        this._itemReadRoleDAO.setReadRoles(itemId, roles);
    }
}

