/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.authorization.item;

import com.google.common.base.Optional;
import de.justsoftware.drive.business.authorization.AuthorizationItem;
import de.justsoftware.drive.common.item.model.ItemBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.model.AbstractId;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DependentItem
extends AuthorizationItem<ItemId> {
    private final Optional<ItemId> _parent;
    private final boolean _deleted;

    public DependentItem(ItemId id, @Nullable ItemBO item) {
        this(id, item != null ? item.getParent() : Optional.absent(), item != null && item.isDeleted());
    }

    public DependentItem(ItemId id, Optional<ItemId> parent, boolean deleted) {
        super((AbstractId)id);
        this._parent = parent;
        this._deleted = deleted;
    }

    public boolean isDeleted() {
        return this._deleted;
    }

    @Nonnull
    public Optional<ItemId> getParent() {
        return this._parent;
    }

    public <R> R accept(AuthorizationItem.Visitor<R> visitor) {
        return (R)visitor.visitDependentItem(this);
    }
}

