/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.authorization.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.eventbus.EventBus;
import de.justsoftware.drive.business.authorization.impl.PersonRolesKafkaConsumer;
import de.justsoftware.drive.business.event.PersonRolesChangedEvent;
import de.justsoftware.drive.business.kafka.AbstractKafkaConsumer;
import de.justsoftware.drive.business.kafka.KafkaConfigurationProvider;
import de.justsoftware.drive.persistence.authorization.PersonRoleDAO;
import de.justsoftware.drive.persistence.transaction.TransactionSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class PersonRolesKafkaConsumer
extends AbstractKafkaConsumer<String, String> {
    static final String TOPIC_NAME = "just.roles";
    private final PersonRoleDAO _personRoleDAO;
    private final EventBus _eventBus;

    @Autowired
    public PersonRolesKafkaConsumer(KafkaConfigurationProvider kafkaConfigurationProvider, TransactionSupport transactionSupport, PersonRoleDAO personRoleDAO, EventBus eventBus) {
        this(kafkaConfigurationProvider.stringConsumer("just.drive.PersonRolesConsumer"), transactionSupport, personRoleDAO, eventBus);
    }

    @VisibleForTesting
    PersonRolesKafkaConsumer(@Nullable Consumer<String, String> consumer, TransactionSupport transactionSupport, PersonRoleDAO personRoleDAO, EventBus eventBus) {
        super(consumer, transactionSupport, "just.roles");
        this._personRoleDAO = personRoleDAO;
        this._eventBus = eventBus;
    }

    protected void process(ConsumerRecords<String, String> records, java.util.function.Consumer<Runnable> afterCommitCallbackConsumer) {
        HashMultimap rolesToAdd = HashMultimap.create();
        HashMultimap rolesToRemove = HashMultimap.create();
        for (ConsumerRecord record : records) {
            PersonRoleTuple key = PersonRoleTuple.parse((String)((String)record.key()));
            if (key == null) continue;
            if ("t".equals(record.value())) {
                rolesToAdd.put((Object)key._person, (Object)key._role);
                rolesToRemove.remove((Object)key._person, (Object)key._role);
                continue;
            }
            rolesToAdd.remove((Object)key._person, (Object)key._role);
            rolesToRemove.put((Object)key._person, (Object)key._role);
        }
        ImmutableSetMultimap add = ImmutableSetMultimap.copyOf((Multimap)rolesToAdd);
        ImmutableSetMultimap remove = ImmutableSetMultimap.copyOf((Multimap)rolesToRemove);
        if (!add.isEmpty() || !remove.isEmpty()) {
            if (!add.isEmpty()) {
                this._personRoleDAO.addRoles((SetMultimap)add);
            }
            if (!remove.isEmpty()) {
                this._personRoleDAO.removeRoles((SetMultimap)remove);
            }
            this._eventBus.post((Object)new PersonRolesChangedEvent(add, remove));
        }
    }
}

