/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.mobile.service;

import de.justsoftware.chat.authorization.AuthorizationService;
import de.justsoftware.chat.business.ChatParticipantService;
import de.justsoftware.chat.business.ChatReadDateService;
import de.justsoftware.chat.business.ChatService;
import de.justsoftware.chat.business.ChatSettingsService;
import de.justsoftware.chat.business.ProfileService;
import de.justsoftware.chat.business.model.Chat;
import de.justsoftware.chat.business.model.ChatMessage;
import de.justsoftware.chat.business.model.ChatParticipant;
import de.justsoftware.chat.business.model.ChatSettings;
import de.justsoftware.chat.business.model.DeletedMessage;
import de.justsoftware.chat.business.model.SystemMessage;
import de.justsoftware.chat.business.model.UserMessage;
import de.justsoftware.chat.business.model.event.ChatCreatedEvent;
import de.justsoftware.chat.business.model.event.ChatMarkedAsReadEvent;
import de.justsoftware.chat.business.model.event.ChatMarkedAsUnreadEvent;
import de.justsoftware.chat.business.model.event.ChatMessageCreatedEvent;
import de.justsoftware.chat.business.model.event.ChatMessageDeletedEvent;
import de.justsoftware.chat.business.model.event.ChatParticipantsChangedEvent;
import de.justsoftware.chat.business.model.event.ChatSettingsChangedEvent;
import de.justsoftware.chat.business.model.event.ChatUpdatedEvent;
import de.justsoftware.chat.business.model.event.UserMessageUpdatedEvent;
import de.justsoftware.chat.mobile.model.MobilePlatform;
import de.justsoftware.chat.mobile.model.MobilePushNotification;
import de.justsoftware.chat.mobile.model.MobilePushToken;
import de.justsoftware.chat.mobile.service.InternalNotificationService;
import de.justsoftware.chat.mobile.service.MobilePushNotificationProducer;
import de.justsoftware.chat.mobile.service.MobilePushNotificationSendService;
import de.justsoftware.chat.mobile.service.MobilePushTokenService;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ChatMessageId;
import de.justsoftware.chat.model.PermissionType;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.util.CollectionUtilsKt;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ce\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0017\u0018\u0000 I2\u00020\u0001:\u0002IJBU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015JD\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001b2\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0!0\u001bH\u0012J(\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001d2\u0006\u0010$\u001a\u00020%2\u0010\b\u0002\u0010&\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010!H\u0012J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020#0\u001d2\u0006\u0010(\u001a\u00020\u0019H\u0012J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001eH\u0012J\u0018\u0010,\u001a\u00020-2\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u0017H\u0012J\"\u0010/\u001a\u0014\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0!0\u001b2\u0006\u00100\u001a\u00020%H\u0012J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0017J\u0010\u00105\u001a\u0002022\u0006\u00103\u001a\u000206H\u0017J\u0010\u00107\u001a\u0002022\u0006\u00103\u001a\u000208H\u0017J\u0010\u00109\u001a\u0002022\u0006\u00103\u001a\u00020:H\u0017J\u0010\u0010;\u001a\u0002022\u0006\u00103\u001a\u00020<H\u0017J\u0010\u0010=\u001a\u0002022\u0006\u00103\u001a\u00020>H\u0017J\u0010\u0010?\u001a\u0002022\u0006\u00103\u001a\u00020@H\u0017J\u0010\u0010A\u001a\u0002022\u0006\u00103\u001a\u00020BH\u0017J\u0010\u0010C\u001a\u0002022\u0006\u00103\u001a\u00020DH\u0017J\u0018\u0010E\u001a\u00020F2\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u0017H\u0012J\u0016\u0010G\u001a\u0002022\f\u0010H\u001a\b\u0012\u0004\u0012\u00020#0\u001dH\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lde/justsoftware/chat/mobile/service/MobilePushNotificationProducer;", "", "mobileApnsSendService", "Lde/justsoftware/chat/mobile/service/MobilePushNotificationSendService;", "mobileFcmSendService", "mobilePushTokenService", "Lde/justsoftware/chat/mobile/service/MobilePushTokenService;", "chatService", "Lde/justsoftware/chat/business/ChatService;", "profileService", "Lde/justsoftware/chat/business/ProfileService;", "chatParticipantService", "Lde/justsoftware/chat/business/ChatParticipantService;", "chatSettingsService", "Lde/justsoftware/chat/business/ChatSettingsService;", "chatReadDateService", "Lde/justsoftware/chat/business/ChatReadDateService;", "internalNotificationService", "Lde/justsoftware/chat/mobile/service/InternalNotificationService;", "authorizationService", "Lde/justsoftware/chat/authorization/AuthorizationService;", "(Lde/justsoftware/chat/mobile/service/MobilePushNotificationSendService;Lde/justsoftware/chat/mobile/service/MobilePushNotificationSendService;Lde/justsoftware/chat/mobile/service/MobilePushTokenService;Lde/justsoftware/chat/business/ChatService;Lde/justsoftware/chat/business/ProfileService;Lde/justsoftware/chat/business/ChatParticipantService;Lde/justsoftware/chat/business/ChatSettingsService;Lde/justsoftware/chat/business/ChatReadDateService;Lde/justsoftware/chat/mobile/service/InternalNotificationService;Lde/justsoftware/chat/authorization/AuthorizationService;)V", "buildNewChatMessageContext", "Lde/justsoftware/chat/mobile/service/MobilePushNotificationProducer$NewChatMessageContext;", "message", "Lde/justsoftware/chat/business/model/UserMessage;", "pushTokens", "", "Lde/justsoftware/chat/model/ProfileId;", "", "Lde/justsoftware/chat/mobile/model/MobilePushToken;", "profileIdsOfParticipants", "Lde/justsoftware/chat/business/model/ChatParticipant;", "", "createAllForChatUpdate", "Lde/justsoftware/chat/mobile/model/MobilePushNotification;", "updatedChatId", "Lde/justsoftware/chat/model/ChatId;", "affectedProfileIds", "createAllForNewChatMessage", "newMessage", "createForChatUpdate", "Lde/justsoftware/chat/mobile/model/MobilePushNotification$ChatUpdate;", "pushToken", "createForNewChatMessage", "Lde/justsoftware/chat/mobile/model/MobilePushNotification$NewChatMessage;", "context", "getProfileIdsOfParticipants", "chatId", "onChatCreatedEvent", "", "event", "Lde/justsoftware/chat/business/model/event/ChatCreatedEvent;", "onChatMarkedAsReadEvent", "Lde/justsoftware/chat/business/model/event/ChatMarkedAsReadEvent;", "onChatMarkedAsUnreadEvent", "Lde/justsoftware/chat/business/model/event/ChatMarkedAsUnreadEvent;", "onChatMessageCreatedEvent", "Lde/justsoftware/chat/business/model/event/ChatMessageCreatedEvent;", "onChatMessageDeletedEvent", "Lde/justsoftware/chat/business/model/event/ChatMessageDeletedEvent;", "onChatParticipantsChangedEvent", "Lde/justsoftware/chat/business/model/event/ChatParticipantsChangedEvent;", "onChatSettingsChangedEvent", "Lde/justsoftware/chat/business/model/event/ChatSettingsChangedEvent;", "onChatUpdatedEvent", "Lde/justsoftware/chat/business/model/event/ChatUpdatedEvent;", "onUserMessageUpdatedEvent", "Lde/justsoftware/chat/business/model/event/UserMessageUpdatedEvent;", "requiresOnlyChatUpdate", "", "send", "pushNotifications", "Companion", "NewChatMessageContext", "chat-service"})
@SourceDebugExtension(value={"SMAP\nMobilePushNotificationProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobilePushNotificationProducer.kt\nde/justsoftware/chat/mobile/service/MobilePushNotificationProducer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,282:1\n1477#2:283\n1502#2,3:284\n1505#2,3:294\n1549#2:299\n1620#2,3:300\n1549#2:303\n1620#2,3:304\n1747#2,3:310\n372#3,7:287\n526#3:307\n511#3,2:308\n513#3,4:313\n215#4,2:297\n*S KotlinDebug\n*F\n+ 1 MobilePushNotificationProducer.kt\nde/justsoftware/chat/mobile/service/MobilePushNotificationProducer\n*L\n125#1:283\n125#1:284,3\n125#1:294,3\n141#1:299\n141#1:300,3\n158#1:303\n158#1:304,3\n227#1:310,3\n125#1:287,7\n227#1:307\n227#1:308,2\n227#1:313,4\n131#1:297,2\n*E\n"})
public class MobilePushNotificationProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MobilePushNotificationSendService mobileApnsSendService;
    @NotNull
    private final MobilePushNotificationSendService mobileFcmSendService;
    @NotNull
    private final MobilePushTokenService mobilePushTokenService;
    @NotNull
    private final ChatService chatService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final ChatParticipantService chatParticipantService;
    @NotNull
    private final ChatSettingsService chatSettingsService;
    @NotNull
    private final ChatReadDateService chatReadDateService;
    @NotNull
    private final InternalNotificationService internalNotificationService;
    @NotNull
    private final AuthorizationService authorizationService;

    public MobilePushNotificationProducer(@NotNull MobilePushNotificationSendService mobileApnsSendService, @NotNull MobilePushNotificationSendService mobileFcmSendService, @NotNull MobilePushTokenService mobilePushTokenService, @NotNull ChatService chatService, @NotNull ProfileService profileService, @NotNull ChatParticipantService chatParticipantService, @NotNull ChatSettingsService chatSettingsService, @NotNull ChatReadDateService chatReadDateService, @NotNull InternalNotificationService internalNotificationService, @NotNull AuthorizationService authorizationService) {
        Intrinsics.checkNotNullParameter((Object)mobileApnsSendService, (String)"mobileApnsSendService");
        Intrinsics.checkNotNullParameter((Object)mobileFcmSendService, (String)"mobileFcmSendService");
        Intrinsics.checkNotNullParameter((Object)mobilePushTokenService, (String)"mobilePushTokenService");
        Intrinsics.checkNotNullParameter((Object)chatService, (String)"chatService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)chatParticipantService, (String)"chatParticipantService");
        Intrinsics.checkNotNullParameter((Object)chatSettingsService, (String)"chatSettingsService");
        Intrinsics.checkNotNullParameter((Object)chatReadDateService, (String)"chatReadDateService");
        Intrinsics.checkNotNullParameter((Object)internalNotificationService, (String)"internalNotificationService");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        this.mobileApnsSendService = mobileApnsSendService;
        this.mobileFcmSendService = mobileFcmSendService;
        this.mobilePushTokenService = mobilePushTokenService;
        this.chatService = chatService;
        this.profileService = profileService;
        this.chatParticipantService = chatParticipantService;
        this.chatSettingsService = chatSettingsService;
        this.chatReadDateService = chatReadDateService;
        this.internalNotificationService = internalNotificationService;
        this.authorizationService = authorizationService;
    }

    @EventListener
    public void onChatMessageCreatedEvent(@NotNull ChatMessageCreatedEvent event) {
        List list;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ChatMessage message = event.getChatMessage();
        if (message instanceof UserMessage) {
            list = this.createAllForNewChatMessage((UserMessage)message);
        } else if (message instanceof SystemMessage ? true : message instanceof DeletedMessage) {
            list = MobilePushNotificationProducer.createAllForChatUpdate$default((MobilePushNotificationProducer)this, (ChatId)message.getChatId(), null, (int)2, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.send(list);
    }

    @EventListener
    public void onChatMessageDeletedEvent(@NotNull ChatMessageDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.send(MobilePushNotificationProducer.createAllForChatUpdate$default((MobilePushNotificationProducer)this, (ChatId)event.getChat().getId(), null, (int)2, null));
    }

    @EventListener
    public void onUserMessageUpdatedEvent(@NotNull UserMessageUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.send(MobilePushNotificationProducer.createAllForChatUpdate$default((MobilePushNotificationProducer)this, (ChatId)event.getChatId(), null, (int)2, null));
    }

    @EventListener
    public void onChatParticipantsChangedEvent(@NotNull ChatParticipantsChangedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Set[] setArray = new Set[]{event.getEffectiveProfileIdsAdded(), event.getEffectiveProfileIdsRemoved(), event.getEffectiveProfileIdsUpdated()};
        this.send(this.createAllForChatUpdate(event.getChatId(), CollectionUtilsKt.concat((Set[])setArray)));
    }

    @EventListener
    public void onChatCreatedEvent(@NotNull ChatCreatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.send(MobilePushNotificationProducer.createAllForChatUpdate$default((MobilePushNotificationProducer)this, (ChatId)event.getChat().getId(), null, (int)2, null));
    }

    @EventListener
    public void onChatUpdatedEvent(@NotNull ChatUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.send(MobilePushNotificationProducer.createAllForChatUpdate$default((MobilePushNotificationProducer)this, (ChatId)event.getChatId(), null, (int)2, null));
    }

    @EventListener
    public void onChatSettingsChangedEvent(@NotNull ChatSettingsChangedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.send(this.createAllForChatUpdate(event.getChatId(), SetsKt.setOf((Object)event.getProfileId())));
    }

    @EventListener
    public void onChatMarkedAsReadEvent(@NotNull ChatMarkedAsReadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.send(this.createAllForChatUpdate(event.getChatId(), SetsKt.setOf((Object)event.getProfileId())));
    }

    @EventListener
    public void onChatMarkedAsUnreadEvent(@NotNull ChatMarkedAsUnreadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.send(this.createAllForChatUpdate(event.getChatId(), SetsKt.setOf((Object)event.getProfileId())));
    }

    /*
     * WARNING - void declaration
     */
    private void send(List<? extends MobilePushNotification> pushNotifications) {
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = pushNotifications;
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            MobilePushNotificationSendService mobilePushNotificationSendService;
            MobilePushNotification pushNotification = (MobilePushNotification)element$iv$iv;
            boolean bl = false;
            MobilePushNotification mobilePushNotification = pushNotification;
            if (mobilePushNotification instanceof MobilePushNotification.Apns) {
                mobilePushNotificationSendService = this.mobileApnsSendService;
            } else if (mobilePushNotification instanceof MobilePushNotification.Fcm) {
                mobilePushNotificationSendService = this.mobileFcmSendService;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            MobilePushNotificationSendService key$iv$iv = mobilePushNotificationSendService;
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            MobilePushNotificationSendService sendService = (MobilePushNotificationSendService)entry.getKey();
            List pushNotifications2 = (List)entry.getValue();
            sendService.sendAll(pushNotifications2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<MobilePushNotification> createAllForChatUpdate(ChatId updatedChatId, Set<ProfileId> affectedProfileIds) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Set set = affectedProfileIds;
        if (set == null) {
            set = CollectionUtilsKt.flattenValuesToSet((Map)this.getProfileIdsOfParticipants(updatedChatId));
        }
        Set profileIds = set;
        Iterable iterable = CollectionUtilsKt.flattenValues((Map)this.mobilePushTokenService.findByProfileIds(profileIds));
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            MobilePushToken mobilePushToken = (MobilePushToken)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createForChatUpdate((MobilePushToken)p0));
        }
        return (List)destination$iv$iv;
    }

    static /* synthetic */ List createAllForChatUpdate$default(MobilePushNotificationProducer mobilePushNotificationProducer, ChatId chatId, Set set, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createAllForChatUpdate");
        }
        if ((n & 2) != 0) {
            set = null;
        }
        return mobilePushNotificationProducer.createAllForChatUpdate(chatId, set);
    }

    /*
     * WARNING - void declaration
     */
    private List<MobilePushNotification> createAllForNewChatMessage(UserMessage newMessage) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map profileIdsOfParticipants = this.getProfileIdsOfParticipants(newMessage.getChatId());
        Map pushTokens = this.mobilePushTokenService.findByProfileIds(CollectionUtilsKt.flattenValuesToSet((Map)profileIdsOfParticipants));
        boolean bl = false;
        NewChatMessageContext context = this.buildNewChatMessageContext(newMessage, pushTokens, profileIdsOfParticipants);
        Iterable iterable = CollectionUtilsKt.flattenValues((Map)pushTokens);
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void pushToken;
            MobilePushToken mobilePushToken = (MobilePushToken)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(this.requiresOnlyChatUpdate((MobilePushToken)pushToken, context) ? (MobilePushNotification)this.createForChatUpdate((MobilePushToken)pushToken) : (MobilePushNotification)this.createForNewChatMessage((MobilePushToken)pushToken, context));
        }
        return (List)destination$iv$iv;
    }

    private Map<ChatParticipant, Set<ProfileId>> getProfileIdsOfParticipants(ChatId chatId) {
        return this.chatParticipantService.getProfileIdsOfParticipants(chatId);
    }

    private MobilePushNotification.ChatUpdate createForChatUpdate(MobilePushToken pushToken) {
        return switch (WhenMappings.$EnumSwitchMapping$0[pushToken.getPlatform().ordinal()]) {
            case 1 -> (MobilePushNotification.ChatUpdate)new MobilePushNotification.FcmChatUpdate(null, MobilePushNotification.Token.constructor-impl((String)pushToken.getToken()), 1, null);
            case 2 -> (MobilePushNotification.ChatUpdate)new MobilePushNotification.ApnsChatUpdate(null, MobilePushNotification.Token.constructor-impl((String)pushToken.getToken()), 1, null);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private MobilePushNotification.NewChatMessage createForNewChatMessage(MobilePushToken pushToken, NewChatMessageContext context) {
        return switch (WhenMappings.$EnumSwitchMapping$0[pushToken.getPlatform().ordinal()]) {
            case 1 -> (MobilePushNotification.NewChatMessage)new MobilePushNotification.FcmNewChatMessage(null, MobilePushNotification.Token.constructor-impl((String)pushToken.getToken()), context.getAuthor().getFullName(), UserMessage.Companion.teaserMessage(context.getMessage(), true), context.androidUnreadMessageCount(pushToken.getUserId()), context.androidUnreadChatCount(pushToken.getUserId()), 1, null);
            case 2 -> {
                String var3_3 = MobilePushNotification.Token.constructor-impl((String)pushToken.getToken());
                ProfileId var4_4 = pushToken.getUserId();
                ChatId var5_5 = context.getMessage().getChatId();
                ChatMessageId var6_6 = context.getMessage().getId();
                Instant var7_7 = context.getMessage().getCreatedAt();
                String var8_8 = context.getAuthor().getFullName();
                String var9_9 = Companion.access$multiUserChatTitleOrNull((Companion)Companion, (Chat)context.getChat());
                String var10_10 = UserMessage.Companion.teaserMessage(context.getMessage(), true);
                int var11_11 = context.iosUnreadMessageCount(pushToken.getUserId());
                boolean var12_12 = (Boolean)MapsKt.getValue((Map)context.isPostMessageAllowed(), (Object)pushToken.getUserId());
                int var13_13 = context.iosUnreadSocialNotificationCount(pushToken.getUserId());
                yield (MobilePushNotification.NewChatMessage)new MobilePushNotification.ApnsNewChatMessage(null, var3_3, var4_4, var5_5, var6_6, var7_7, var8_8, var9_9, var10_10, var11_11, var13_13, var12_12, 1, null);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private boolean requiresOnlyChatUpdate(MobilePushToken pushToken, NewChatMessageContext context) {
        ProfileId userId = pushToken.getUserId();
        boolean isAuthor = Intrinsics.areEqual((Object)context.getAuthor().getId(), (Object)userId);
        ChatSettings chatSettings2 = (ChatSettings)context.getChatSettings().get(userId);
        boolean isChatMuted = chatSettings2 != null ? chatSettings2.getMuted() : false;
        boolean isSilenceIosAlerts = pushToken.getPlatform() == MobilePlatform.IOS && pushToken.getIosSilenceAlerts();
        return isAuthor || isChatMuted || isSilenceIosAlerts;
    }

    /*
     * WARNING - void declaration
     */
    private NewChatMessageContext buildNewChatMessageContext(UserMessage message, Map<ProfileId, ? extends List<MobilePushToken>> pushTokens, Map<ChatParticipant, ? extends Set<ProfileId>> profileIdsOfParticipants) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Set<ProfileId> allProfileIds = pushTokens.keySet();
        Map<ProfileId, ? extends List<MobilePushToken>> map = pushTokens;
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Map.Entry element$iv$iv;
            block4: {
                Map.Entry entry = element$iv$iv = iterator.next();
                boolean bl2 = false;
                Iterable $this$any$iv = (Iterable)entry.getValue();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        MobilePushToken pushToken = (MobilePushToken)element$iv;
                        boolean bl3 = false;
                        if (!(pushToken.getPlatform() == MobilePlatform.IOS)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Set iosProfileIds = destination$iv$iv.keySet();
        Map unreadCounts = ChatReadDateService.getUnreadCountsForUsers$default((ChatReadDateService)this.chatReadDateService, allProfileIds, (boolean)false, (int)2, null);
        Map iosUnreadSocialNotificationCounts = this.internalNotificationService.getUnreadSocialNotificationCounts(iosProfileIds);
        return new NewChatMessageContext(message, this.chatService.getById(message.getChatId()), this.profileService.getById(message.getAuthor()), this.chatSettingsService.getSettingsForChat(message.getChatId(), allProfileIds), this.authorizationService.havePermission(profileIdsOfParticipants, PermissionType.WRITER), unreadCounts, iosUnreadSocialNotificationCounts);
    }
}

