/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.business.CacheService;
import de.justsoftware.chat.business.UserGroupService;
import de.justsoftware.chat.business.model.UserGroup;
import de.justsoftware.chat.business.model.UserGroupMember;
import de.justsoftware.chat.cache.CachedResults;
import de.justsoftware.chat.kafka.model.KafkaUserGroup;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.TenantId;
import de.justsoftware.chat.model.UserGroupId;
import de.justsoftware.chat.persistence.UserGroupMemberRepository;
import de.justsoftware.chat.persistence.UserGroupRepository;
import de.justsoftware.chat.persistence.model.DbUserGroup;
import de.justsoftware.chat.persistence.model.DbUserGroupMember;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.chat.util.KafkaUtilsKt;
import de.justsoftware.chat.util.TransactionUtils;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0017\u0018\u0000 32\u00020\u0001:\u000234B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J\u0016\u0010\u0017\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0017J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\"\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001c0 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\u0012H\u0016J(\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\u00120 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\u0012H\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160\u00122\u0006\u0010%\u001a\u00020#H\u0016J#\u0010&\u001a\u00020\u00142\u0014\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00110(H\u0011\u00a2\u0006\u0002\b)J#\u0010*\u001a\u00020\u00142\u0014\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010+0(H\u0011\u00a2\u0006\u0002\b,J\u0010\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\u001cH\u0017J\u0016\u0010/\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0017J$\u00100\u001a\u00020\u00142\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0017R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00120\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lde/justsoftware/chat/business/UserGroupService;", "", "userGroupRepository", "Lde/justsoftware/chat/persistence/UserGroupRepository;", "userGroupMemberRepository", "Lde/justsoftware/chat/persistence/UserGroupMemberRepository;", "transactionUtils", "Lde/justsoftware/chat/util/TransactionUtils;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "clock", "Ljava/time/Clock;", "cacheService", "Lde/justsoftware/chat/business/CacheService;", "(Lde/justsoftware/chat/persistence/UserGroupRepository;Lde/justsoftware/chat/persistence/UserGroupMemberRepository;Lde/justsoftware/chat/util/TransactionUtils;Lorg/springframework/context/ApplicationEventPublisher;Ljava/time/Clock;Lde/justsoftware/chat/business/CacheService;)V", "userGroupIdsByProfileIdCache", "Lde/justsoftware/chat/cache/CachedResults;", "", "", "deleteById", "", "groupId", "Lde/justsoftware/chat/model/UserGroupId;", "deleteMembers", "members", "", "Lde/justsoftware/chat/business/model/UserGroupMember;", "findAllUsersGroup", "Lde/justsoftware/chat/business/model/UserGroup;", "tenantId", "Lde/justsoftware/chat/model/TenantId;", "findByIds", "", "userGroupIds", "getMemberProfileIds", "Lde/justsoftware/chat/model/ProfileId;", "getUserGroupIdsByProfileId", "profileId", "onUserGroupMembersUpdate", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "onUserGroupMembersUpdate$chat_service", "onUserGroupsUpdated", "Lde/justsoftware/chat/kafka/model/KafkaUserGroup;", "onUserGroupsUpdated$chat_service", "save", "group", "saveMembers", "updateMembers", "membersToSave", "membersToDelete", "Companion", "ParsedUserGroupMemberRecord", "chat-service"})
@SourceDebugExtension(value={"SMAP\nUserGroupService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserGroupService.kt\nde/justsoftware/chat/business/UserGroupService\n+ 2 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 LoggerUtils.kt\nde/justsoftware/chat/util/LoggerUtilsKt\n*L\n1#1,225:1\n7#2:226\n7#2:252\n7#2:268\n90#2,3:291\n93#2,3:295\n96#2:299\n1620#3,3:227\n1549#3:230\n1620#3,3:231\n1549#3:234\n1620#3,3:235\n1549#3:238\n1620#3,3:239\n1549#3:242\n1620#3,3:243\n1194#3,2:246\n1222#3,4:248\n1620#3,3:253\n1549#3:256\n1620#3,3:257\n1179#3,2:260\n1253#3,2:262\n1549#3:264\n1620#3,3:265\n1256#3:269\n1855#3,2:270\n1603#3,9:272\n1855#3:281\n1856#3:283\n1612#3:284\n1194#3,2:285\n1222#3,4:287\n1855#3:294\n1856#3:298\n1#4:282\n9#5:300\n8#5,3:301\n*S KotlinDebug\n*F\n+ 1 UserGroupService.kt\nde/justsoftware/chat/business/UserGroupService\n*L\n62#1:226\n110#1:252\n118#1:268\n171#1:291,3\n171#1:295,3\n171#1:299\n62#1:227,3\n71#1:230\n71#1:231,3\n80#1:234\n80#1:235,3\n102#1:238\n102#1:239,3\n103#1:242\n103#1:243,3\n104#1:246,2\n104#1:248,4\n110#1:253,3\n114#1:256\n114#1:257,3\n116#1:260,2\n116#1:262,2\n118#1:264\n118#1:265,3\n116#1:269\n135#1:270,2\n168#1:272,9\n168#1:281\n168#1:283\n168#1:284\n169#1:285,2\n169#1:287,4\n171#1:294\n171#1:298\n168#1:282\n188#1:300\n188#1:301,3\n*E\n"})
public class UserGroupService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final UserGroupRepository userGroupRepository;
    @NotNull
    private final UserGroupMemberRepository userGroupMemberRepository;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final Clock clock;
    @NotNull
    private final CachedResults<String, Set<String>> userGroupIdsByProfileIdCache;
    @NotNull
    public static final String USER_GROUP_TOPIC = "just.people.userGroup";
    @NotNull
    public static final String USER_GROUP_MEMBERS_TOPIC = "just.people.userGroupMembers";
    @NotNull
    private static final Logger LOG;

    public UserGroupService(@NotNull UserGroupRepository userGroupRepository, @NotNull UserGroupMemberRepository userGroupMemberRepository, @NotNull TransactionUtils transactionUtils, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull Clock clock, @NotNull CacheService cacheService) {
        Intrinsics.checkNotNullParameter((Object)userGroupRepository, (String)"userGroupRepository");
        Intrinsics.checkNotNullParameter((Object)userGroupMemberRepository, (String)"userGroupMemberRepository");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)cacheService, (String)"cacheService");
        this.userGroupRepository = userGroupRepository;
        this.userGroupMemberRepository = userGroupMemberRepository;
        this.transactionUtils = transactionUtils;
        this.applicationEventPublisher = applicationEventPublisher;
        this.clock = clock;
        this.userGroupIdsByProfileIdCache = cacheService.createCache("UserGroupIdsByProfileIdCache", (Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Transactional
    @NotNull
    public UserGroup save(@NotNull UserGroup group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Object object = this.userGroupRepository.save((Object)DbUserGroup.Companion.toDbUserGroup(group));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"save(...)");
        return DbUserGroup.Companion.toUserGroup((DbUserGroup)object);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void deleteById(@NotNull UserGroupId groupId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Iterable $this$mapToSet$iv = this.userGroupMemberRepository.findUserGroupMembersByGroupIds((Iterable)SetsKt.setOf((Object)groupId.toCanonicalId())).getOrDefault(groupId.toCanonicalId(), SetsKt.emptySet());
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DbUserGroupMember dbUserGroupMember = (DbUserGroupMember)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DbUserGroupMember.Companion.toUserGroupMember((DbUserGroupMember)it));
        }
        Set userGroupMembers = (Set)destination$iv$iv;
        this.userGroupRepository.deleteById((Object)groupId.toCanonicalId());
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void saveMembers(@NotNull List<UserGroupMember> members) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(members, (String)"members");
        Iterable iterable = members;
        UserGroupMemberRepository userGroupMemberRepository = this.userGroupMemberRepository;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UserGroupMember userGroupMember = (UserGroupMember)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DbUserGroupMember.Companion.toDbUserGroupMember((UserGroupMember)it));
        }
        userGroupMemberRepository.saveAll((Iterable)((List)destination$iv$iv));
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void deleteMembers(@NotNull List<UserGroupMember> members) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(members, (String)"members");
        Iterable iterable = members;
        UserGroupMemberRepository userGroupMemberRepository = this.userGroupMemberRepository;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UserGroupMember userGroupMember = (UserGroupMember)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DbUserGroupMember.Companion.toDbUserGroupMember((UserGroupMember)it));
        }
        userGroupMemberRepository.deleteAll((Iterable)((List)destination$iv$iv));
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Transactional
    public void updateMembers(@NotNull List<UserGroupMember> membersToSave, @NotNull List<UserGroupMember> membersToDelete) {
        Intrinsics.checkNotNullParameter(membersToSave, (String)"membersToSave");
        Intrinsics.checkNotNullParameter(membersToDelete, (String)"membersToDelete");
        if (!((Collection)membersToSave).isEmpty()) {
            this.saveMembers(membersToSave);
        }
        if (!((Collection)membersToDelete).isEmpty()) {
            this.deleteMembers(membersToDelete);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<UserGroupId, UserGroup> findByIds(@NotNull Set<UserGroupId> userGroupIds) {
        void $this$associateByTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(userGroupIds, (String)"userGroupIds");
        Iterable iterable = userGroupIds;
        Object object = this.userGroupRepository;
        boolean $i$f$map22 = false;
        void var5_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void p0;
            UserGroupId userGroupId = (UserGroupId)item$iv$iv2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        List list = object.findAllById((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAllById(...)");
        Iterable $this$map$iv2 = list;
        boolean $i$f$map = false;
        Iterable $i$f$map22 = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void dbUserGroup;
            Object item$iv$iv2;
            item$iv$iv2 = (DbUserGroup)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)dbUserGroup);
            object.add(DbUserGroup.Companion.toUserGroup((DbUserGroup)dbUserGroup));
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv2;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associateBy$iv;
        Map destination$iv$iv22 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            UserGroup bl = (UserGroup)element$iv$iv;
            object = destination$iv$iv22;
            boolean bl2 = false;
            object.put(p0.getId(), element$iv$iv);
        }
        return destination$iv$iv22;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<UserGroupId> getUserGroupIdsByProfileId(@NotNull ProfileId profileId) {
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Set set = (Set)this.userGroupIdsByProfileIdCache.get((Object)profileId.toCanonicalId());
        if (set == null) {
            set = SetsKt.emptySet();
        }
        Iterable iterable = set;
        UserGroupId.Companion companion = UserGroupId.Companion;
        boolean $i$f$mapToSet = false;
        void var5_5 = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(companion.fromCanonicalId((String)p0));
        }
        return (Set)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<UserGroupId, Set<ProfileId>> getMemberProfileIds(@NotNull Set<UserGroupId> userGroupIds) {
        void $this$associateTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(userGroupIds, (String)"userGroupIds");
        Iterable iterable = userGroupIds;
        UserGroupMemberRepository userGroupMemberRepository = this.userGroupMemberRepository;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            UserGroupId userGroupId = (UserGroupId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        Iterable $this$associate$iv = userGroupMemberRepository.findUserGroupMembersByGroupIds((Iterable)((List)destination$iv$iv)).entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$mapToSet$iv;
            Collection collection;
            void $this$mapTo$iv$iv3;
            Map map = destination$iv$iv2;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String id = (String)entry.getKey();
            Set members = (Set)entry.getValue();
            UserGroupId userGroupId = UserGroupId.Companion.fromCanonicalId(id);
            Iterable $this$map$iv2 = members;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void p0;
                DbUserGroupMember dbUserGroupMember = (DbUserGroupMember)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl2 = false;
                collection.add(p0.getProfileId());
            }
            $this$map$iv2 = (List)destination$iv$iv3;
            ProfileId.Companion companion = ProfileId.Companion;
            boolean $i$f$mapToSet = false;
            destination$iv$iv3 = $this$mapToSet$iv;
            Collection destination$iv$iv4 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void p0;
                String bl2 = (String)item$iv$iv;
                collection = destination$iv$iv4;
                boolean bl3 = false;
                collection.add(companion.fromCanonicalId((String)p0));
            }
            Set profileIds = (Set)destination$iv$iv4;
            entry = TuplesKt.to((Object)userGroupId, (Object)profileIds);
            map.put(entry.getFirst(), entry.getSecond());
        }
        return destination$iv$iv2;
    }

    @Nullable
    public UserGroup findAllUsersGroup(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        DbUserGroup dbUserGroup = this.userGroupRepository.findOneByTenantIdAndIsAllTenantUsersGroupTrue(tenantId.getValue());
        return dbUserGroup != null ? DbUserGroup.Companion.toUserGroup(dbUserGroup) : null;
    }

    @KafkaListener(id="userGroupConsumer", containerFactory="userGroupConsumerFactory", topics={"just.people.userGroup"}, idIsGroup=false)
    public void onUserGroupsUpdated$chat_service(@NotNull ConsumerRecords<String, KafkaUserGroup> records) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Iterable $this$forEach$iv = KafkaUtilsKt.filterAndLogDeserializationErrors(records);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConsumerRecord record = (ConsumerRecord)element$iv;
            boolean bl = false;
            try {
                KafkaUserGroup value = (KafkaUserGroup)record.value();
                if (value == null) {
                    Object object = record.key();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"key(...)");
                    this.deleteById(UserGroupId.Companion.fromCanonicalId((String)object));
                    continue;
                }
                this.save(KafkaUserGroup.Companion.toUserGroup(value, this.clock));
            }
            catch (IllegalArgumentException e) {
                LOG.error("Failed to update user group - record was '" + record.key() + " -> " + record.value() + "'. Skipping...", (Throwable)e);
            }
            catch (EmptyResultDataAccessException e) {
                LOG.error("UserGroup does not exist - record was '" + record.key() + "'. Skipping...", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @KafkaListener(id="userGroupMembersConsumer", containerFactory="userGroupMembersConsumerFactory", topics={"just.people.userGroupMembers"}, idIsGroup=false)
    public void onUserGroupMembersUpdate$chat_service(@NotNull ConsumerRecords<String, String> records) {
        Object object;
        void $this$associateByTo$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Iterable $this$mapNotNull$iv = KafkaUtilsKt.filterAndLogDeserializationErrors(records);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<ParsedUserGroupMemberRecord> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ParsedUserGroupMemberRecord it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ConsumerRecord record = (ConsumerRecord)element$iv$iv;
            boolean bl2 = false;
            if (Companion.access$parseToUserGroupMemberRecord((Companion)Companion, (ConsumerRecord)record, (Clock)this.clock) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            element$iv$iv$iv = (ParsedUserGroupMemberRecord)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.put(p0.getId(), element$iv$iv);
        }
        Iterable $this$partition$iv = destination$iv$iv2.values();
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        Iterable $this$forEach$iv$iv = $this$partition$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void p0;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            ParsedUserGroupMemberRecord p02 = (ParsedUserGroupMemberRecord)element$iv;
            boolean $i$a$-partition-UserGroupService$onUserGroupMembersUpdate$52 = false;
            ArrayList target$iv = p02.isMember() ? first$iv : second$iv;
            ParsedUserGroupMemberRecord $i$a$-partition-UserGroupService$onUserGroupMembersUpdate$52 = (ParsedUserGroupMemberRecord)element$iv;
            object = target$iv;
            boolean bl4 = false;
            ((ArrayList)object).add(p0.getUserGroupMember());
        }
        Pair pair = TuplesKt.to(first$iv, second$iv);
        List membersToSave = (List)pair.component1();
        List membersToDelete = (List)pair.component2();
        this.updateMembers(membersToSave, membersToDelete);
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getApplicationEventPublisher$p(UserGroupService $this) {
        return $this.applicationEventPublisher;
    }

    public static final /* synthetic */ CachedResults access$getUserGroupIdsByProfileIdCache$p(UserGroupService $this) {
        return $this.userGroupIdsByProfileIdCache;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

