--liquibase formatted sql

--changeset christian.ewers:add_timestamps dbms:postgresql runAlways:true splitStatements:false
CREATE OR REPLACE FUNCTION update_mtime()
RETURNS TRIGGER AS $$
BEGIN
   NEW.mtime = clock_timestamp();
   RETURN NEW;
END;
$$ language 'plpgsql';

CREATE OR REPLACE FUNCTION ctime_mtime_columns(tname TEXT)
RETURNS VOID AS $$
BEGIN
    EXECUTE 'ALTER TABLE ' || tname || ' ADD COLUMN ctime TIMESTAMP WITHOUT TIME ZONE NOT NULL DEFAULT clock_timestamp();';
    EXECUTE 'ALTER TABLE ' || tname || ' ADD COLUMN mtime TIMESTAMP WITHOUT TIME ZONE NOT NULL DEFAULT clock_timestamp();';
    EXECUTE 'CREATE TRIGGER ' || tname || '_mtrg BEFORE UPDATE ON ' || tname || ' FOR EACH ROW EXECUTE PROCEDURE update_mtime();';
END;
$$ language 'plpgsql';

--changeset christian.ewers:add_now_function dbms:oracle runAlways:true splitStatements:false
CREATE OR REPLACE FUNCTION now
    RETURN DATE
AS
BEGIN
    RETURN SYSDATE;
END now;

--changeset christian.ewers:add_clock_timestamp_function dbms:oracle runAlways:true splitStatements:false
CREATE OR REPLACE FUNCTION clock_timestamp
    RETURN TIMESTAMP WITH TIME ZONE
AS
BEGIN
    RETURN SYSTIMESTAMP;
END clock_timestamp;

--changeset christian.ewers:add_timestamps dbms:oracle runAlways:true splitStatements:false
CREATE OR REPLACE PROCEDURE ctime_mtime_columns(tname VARCHAR2)
IS
BEGIN
    EXECUTE IMMEDIATE 'ALTER TABLE ' || tname || ' ADD (ctime TIMESTAMP DEFAULT SYSDATE NOT NULL,mtime TIMESTAMP DEFAULT SYSTIMESTAMP NOT NULL )';
    EXECUTE IMMEDIATE 'CREATE TRIGGER ' || tname || '_mtrg BEFORE UPDATE ON ' || tname || ' FOR EACH ROW BEGIN :new.mtime := SYSTIMESTAMP; END;';
END ctime_mtime_columns;

--changeset christian.ewers:create_migration_function dbms:postgresql splitStatements:false
CREATE OR REPLACE FUNCTION run_if_table_exists(table_to_check text, statement TEXT)
RETURNS VOID AS $$
BEGIN
    IF EXISTS
        ( SELECT 1
          FROM   information_schema.tables
          WHERE  table_schema = 'public'
          AND    table_name = table_to_check
        )
    THEN
        EXECUTE statement;
    END IF;
END;
$$ language 'plpgsql';


--changeset christian.ewers:add_oauth2_tables
CREATE TABLE oauth2_registered_client (
    id ${uuid} NOT NULL,
    client_id ${varchar255} NOT NULL,
    client_name ${varchar255} NOT NULL,
    --client_id_issued_at ${timestamp} DEFAULT CURRENT_${timestamp} NOT NULL,
    client_secret ${varchar255} DEFAULT NULL,
    client_authentication_methods ${varchar1024} NOT NULL,
    authorization_grant_types ${varchar1024} NOT NULL,
    redirect_uris ${varchar1024} DEFAULT NULL,
    post_logout_redirect_uris ${varchar1024} DEFAULT NULL,
    scopes ${varchar1024} NOT NULL,
    client_settings ${varchar4000} NULL,
    token_settings ${varchar4000} NULL,
    PRIMARY KEY (id)
);
${execute} ctime_mtime_columns('oauth2_registered_client');

CREATE TABLE oauth2_authorization_consent (
    registered_client_id ${varchar255} NOT NULL,
    principal_name ${varchar255} NOT NULL,
    authorities ${varchar1024} NOT NULL,
    PRIMARY KEY (registered_client_id, principal_name)
);
${execute} ctime_mtime_columns('oauth2_authorization_consent');

CREATE TABLE oauth2_authorization (
    id ${uuid} NOT NULL,
    registered_client_id ${varchar255} NOT NULL,
    principal_name ${varchar255} NOT NULL,
    authorization_grant_type ${varchar255} NOT NULL,
    authorized_scopes ${varchar1024} DEFAULT NULL,
    authorization_attributes ${text} DEFAULT NULL,
    authorization_state ${varchar1024} DEFAULT NULL,
    authorization_code_value ${varchar1024} DEFAULT NULL,
    authorization_code_issued_at ${timestamp} DEFAULT NULL,
    authorization_code_expires_at ${timestamp} DEFAULT NULL,
    authorization_code_metadata ${text} DEFAULT NULL,
    access_token_value ${varchar4000} DEFAULT NULL,
    access_token_issued_at ${timestamp} DEFAULT NULL,
    access_token_expires_at ${timestamp} DEFAULT NULL,
    access_token_metadata ${text} DEFAULT NULL,
    access_token_type ${varchar255} DEFAULT NULL,
    access_token_scopes ${varchar1024} DEFAULT NULL,
    oidc_id_token_value ${varchar4000} DEFAULT NULL,
    oidc_id_token_issued_at ${timestamp} DEFAULT NULL,
    oidc_id_token_expires_at ${timestamp} DEFAULT NULL,
    oidc_id_token_metadata ${text} DEFAULT NULL,
    refresh_token_value ${varchar4000} DEFAULT NULL,
    refresh_token_issued_at ${timestamp} DEFAULT NULL,
    refresh_token_expires_at ${timestamp} DEFAULT NULL,
    refresh_token_metadata ${text} DEFAULT NULL,
    PRIMARY KEY (id)
);
${execute} ctime_mtime_columns('oauth2_authorization');

--changeset christian.ewers:migrate_oauth_clients dbms:postgresql
${execute} run_if_table_exists('oauth_client_details', '
    INSERT INTO oauth2_registered_client(id, client_id, client_name, client_secret, authorization_grant_types, client_authentication_methods, redirect_uris, scopes)
    SELECT ${generate_uuid}, ocd.client_id, ocd.client_id as client_name, ocd.client_secret, ocd.authorized_grant_types, ''client_secret_post'', ocd.web_server_redirect_uri, ocd.scope
    FROM public.oauth_client_details ocd
');
