/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.wikieditor.presentation.server;

import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.business.AntiSamyService;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.SaveCKResult;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import de.justsoftware.onx.util.server.HtmlDiffUtil;
import de.justsoftware.onx.wikieditor.business.WikiEditorService;
import de.justsoftware.onx.wikieditor.presentation.shared.WikiEditorRemoteService;
import de.justsoftware.onx.wikieditor.shared.model.DBWikiBackup;
import de.justsoftware.onx.wikieditor.shared.model.DBWikiEditor;
import de.justsoftware.onx.wikieditor.shared.model.WikiBackupTeaser;
import de.justsoftware.onx.wikieditor.shared.model.WikiEditor;
import de.justsoftware.onx.wikieditor.shared.model.WikiEditorId;
import de.justsoftware.onx.wikieditor.shared.model.WikiPreEditResult;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersion;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersionBadge;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersionId;
import de.justsoftware.onx.wikieditor.shared.server.model.AbstractDBWikiVersion;
import de.justsoftware.onx.wikieditor.shared.server.model.DBWikiVersion;
import de.justsoftware.onx.wikieditor.shared.server.model.WikiBackupItem;
import de.justsoftware.onx.wikieditor.shared.server.model.WikiEditorItem;
import de.justsoftware.onx.wikieditor.shared.server.model.WikiVersionItem;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.xml.transform.TransformerConfigurationException;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.xml.sax.SAXException;

@Service
public class WikiEditorRemoteServiceImpl
implements WikiEditorRemoteService {
    private static final Logger LOG = LoggerFactory.getLogger(WikiEditorRemoteServiceImpl.class);
    @Autowired
    private ProfileTeaserService _profileTeaserService;
    @Autowired
    private AntiSamyService _antiSamyService;
    @Autowired
    private SessionAuthorizationContextProvider _authorizationContextProvider;
    @Autowired
    private WikiEditorService _wikiEditorService;

    private void insertWikiVersion(WikiEditorId id, String text, @Nullable Integer restoredFromVersion, boolean generateFeedMessage) throws InvalidIdServiceException {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((ItemId)id, (Action)StaticAction.WIKI_SAVE);
        DBWikiVersion wikiVersion = new DBWikiVersion(id, text, authorizationContext.getUserId());
        try {
            this._wikiEditorService.insertWikiVersion(wikiVersion, restoredFromVersion, generateFeedMessage, true);
        }
        catch (InvalidIDException e) {
            throw new InvalidIdServiceException();
        }
    }

    public SaveCKResult saveWikiVersion(WikiEditorId id, String text, boolean generateFeedMessage) throws ServiceException {
        CleanResults cleanResults;
        try {
            cleanResults = this._antiSamyService.scan(text);
        }
        catch (ScanException e) {
            LOG.error("", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        catch (PolicyException e) {
            LOG.error("", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        boolean error = cleanResults.getNumberOfErrors() > 0;
        this.insertWikiVersion(id, cleanResults.getCleanHTML(), null, generateFeedMessage);
        return new SaveCKResult(error);
    }

    public void deleteWikiVersion(WikiVersionId id) throws ServiceException {
        this._wikiEditorService.deleteWikiVersion(id, (AuthorizationCheckContextWithUserId)this._authorizationContextProvider.getAuthorizationContextForCurrentUser());
    }

    public void saveWikiBackup(WikiEditorId id, String text) throws ServiceException {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((ItemId)id, (Action)StaticAction.WIKI_SAVE);
        this._wikiEditorService.saveWikiBackup(new DBWikiBackup(id, text, authorizationContext.getUserId()));
    }

    public DBWikiBackup getWikiBackup(WikiEditorId id) throws ServiceException {
        DBWikiBackup wikiBackup = this._wikiEditorService.getDBWikiBackupById(id.toWikiBackupId());
        if (wikiBackup == null) {
            return null;
        }
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((Item)new WikiBackupItem(wikiBackup), (Action)StaticAction.WIKI_READ_BACKUP);
        return wikiBackup;
    }

    public void deleteWikiBackup(WikiEditorId id) throws ServiceException {
        DBWikiBackup wikiBackup = this._wikiEditorService.getDBWikiBackupById(id.toWikiBackupId());
        if (wikiBackup != null) {
            AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
            authorizationContext.check((Item)new WikiBackupItem(wikiBackup), (Action)StaticAction.WIKI_DELETE);
            this._wikiEditorService.deleteWikiBackup(id.toWikiBackupId());
        }
    }

    public WikiBackupTeaser getWikiBackupTeaser(WikiEditorId id) throws ServiceException {
        DBWikiBackup wikiBackup = this._wikiEditorService.getDBWikiBackupById(id.toWikiBackupId());
        if (wikiBackup == null) {
            return null;
        }
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((Item)new WikiBackupItem(wikiBackup), (Action)StaticAction.WIKI_READ_BACKUP_TEASER);
        PersonTeaserModel author = this._profileTeaserService.getPersonTeaserById(wikiBackup.getAuthorId(), (AuthorizationCheckContextWithLocale)authorizationContext);
        return new WikiBackupTeaser(author, wikiBackup.getCreateDate());
    }

    public ListAndCount<WikiVersionBadge> getWikiVersionBadges(WikiEditorId id, int offset, int limit) throws ServiceException {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((ItemId)id, (Action)StaticAction.WIKI_READ_VERSIONS);
        return this._wikiEditorService.getWikiVersionBadges(id, offset, limit, (AuthorizationCheckContextWithLocale)authorizationContext);
    }

    public WikiVersion getWikiVersion(WikiVersionId id) throws ServiceException {
        DBWikiVersion dbWikiVersion = (DBWikiVersion)InvalidIdServiceException.check((Object)this._wikiEditorService.getDBWikiVersionById(id));
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((Item)new WikiVersionItem((AbstractDBWikiVersion)dbWikiVersion), (Action)StaticAction.WIKI_READ_VERSIONS);
        return this._wikiEditorService.dbToWikiVersion(dbWikiVersion, (AuthorizationCheckContextWithLocale)authorizationContext);
    }

    public WikiVersion getCurrentWikiVersion(WikiEditorId id) throws ServiceException {
        DBWikiVersion wikiVersion = this._wikiEditorService.getCurrentDBWikiVersion(id);
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((Item)new WikiVersionItem((AbstractDBWikiVersion)wikiVersion), (Action)StaticAction.WIKI_READ);
        return this._wikiEditorService.dbToWikiVersion(wikiVersion, (AuthorizationCheckContextWithLocale)authorizationContext);
    }

    public String getWikiVersionDiff(WikiVersionId oldId, WikiVersionId newId) throws ServiceException {
        Map versions = this._wikiEditorService.getDBWikiVersionsById((Set)ImmutableSet.of((Object)oldId, (Object)newId));
        DBWikiVersion oldVersion = (DBWikiVersion)InvalidIdServiceException.check((Object)((DBWikiVersion)versions.get(oldId)));
        DBWikiVersion newVersion = (DBWikiVersion)InvalidIdServiceException.check((Object)((DBWikiVersion)versions.get(newId)));
        if (!oldVersion.getWikiEditorId().equals((Object)newVersion.getWikiEditorId())) {
            throw new PermissionDeniedException("both versions have to be in the same editor");
        }
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((ItemId)oldVersion.getWikiEditorId(), (Action)StaticAction.WIKI_READ_VERSIONS);
        try {
            return HtmlDiffUtil.htmlDiff((String)oldVersion.getText(), (String)newVersion.getText());
        }
        catch (TransformerConfigurationException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (SAXException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void restoreVersion(WikiVersionId id) {
        DBWikiVersion oldVersion = (DBWikiVersion)InvalidIdServiceException.check((Object)this._wikiEditorService.getDBWikiVersionById(id));
        DBWikiVersion currentVersion = this._wikiEditorService.getCurrentDBWikiVersion(oldVersion.getWikiEditorId());
        if (currentVersion.getId().equals((Object)id)) {
            throw new PermissionDeniedException("You can not restore the current version");
        }
        this.insertWikiVersion(oldVersion.getWikiEditorId(), oldVersion.getText(), Integer.valueOf(oldVersion.getVersion()), true);
    }

    public WikiEditor getWikiEditorById(WikiEditorId id) {
        DBWikiEditor dbWikiEditor = this._wikiEditorService.getDBWikiEditorById(id);
        if (dbWikiEditor == null) {
            return null;
        }
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((Item)new WikiEditorItem(dbWikiEditor), (Action)StaticAction.WIKI_READ);
        return this._wikiEditorService.getWikiEditorById(dbWikiEditor, (AuthorizationCheckContextWithLocale)authorizationContext);
    }

    public WikiPreEditResult preEditCheck(WikiEditorId id, WikiVersionId versionId) {
        DBWikiEditor dbWikiEditor = this._wikiEditorService.getDBWikiEditorById(id);
        if (dbWikiEditor == null) {
            throw new InvalidIdServiceException();
        }
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((Item)new WikiEditorItem(dbWikiEditor), (Action)StaticAction.WIKI_SAVE);
        try {
            return this._wikiEditorService.preEditCheck(id, versionId, (AuthorizationCheckContextWithLocale)authorizationContext);
        }
        catch (InvalidIDException e) {
            throw new InvalidIdServiceException(e.getMessage());
        }
    }
}

