/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client.ui;

import com.freiheit.toro.client.mediator.HistoryManager;
import com.google.gwt.event.dom.client.KeyDownEvent;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.searchnew.presentation.client.SearchClientFactory;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchFilterTogglePresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchInputView;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;

public class SearchInputPresenter
implements SearchInputView.Presenter {
    private final SearchInputView _view;
    private final HistoryManager _historyManager;
    private final SearchClientFactory _clientFactory;
    private SearchParameters _searchParameters;

    @ParametersAreNonnullByDefault
    public SearchInputPresenter(ClientFactory clientFactory, boolean showSaveSearchFilterMenu, String trackingContext) {
        this._clientFactory = clientFactory.searchFactory();
        this._historyManager = clientFactory.historyManager();
        this._view = this._clientFactory.createSearchInputView((SearchInputView.Presenter)this, trackingContext);
        this._view.showSaveSearchFilterMenu(showSaveSearchFilterMenu && clientFactory.getLoginInfo().isLoggedIn());
    }

    public void onCompleteSearch() {
        this._clientFactory.getAndSetForceNewSearch(true);
        this._view.cancelSuggestionRequest();
        this.doSearch();
    }

    private void doSearch() {
        String searchString = this._view.getText();
        SearchParameters newParameters = this._searchParameters.withText(searchString);
        String searchToken = this._clientFactory.historyTokenFor(newParameters.hasDurationTimeActivatedFilter(this._clientFactory.searchConfigurationProvider()) ? newParameters.withoutSortType() : newParameters);
        this._historyManager.forceNewItem(searchToken);
    }

    public void onKeyDown(KeyDownEvent event) {
        if (13 == event.getNativeKeyCode()) {
            this._view.cancelSuggestionRequest();
            if (!this._view.checkIfItemWasSelected()) {
                this.onCompleteSearch();
            }
        }
    }

    public void update(SearchParameters searchParameters) {
        this._searchParameters = searchParameters;
        this._view.setText(searchParameters.getText());
        this._view.setSearchContextModel(searchParameters.synthesizeContextModel());
        this._view.setFilterType(searchParameters.getFilterType());
        this._view.setAdditionalFilter((Set)searchParameters.getSubfilter());
    }

    public SearchInputView getView() {
        return this._view;
    }

    public void setSearchFilterToggle(SearchFilterTogglePresenter searchFilterToggle) {
        this._view.setSearchFilterToggle(searchFilterToggle);
    }
}

