/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.ui.HTMLUtil;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.collect.ImmutableCollection;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.CommonClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.JCIconOnlyAnchor;
import de.justsoftware.onx.common.presentation.client.ui.PopupCloseHelper;
import de.justsoftware.onx.common.presentation.client.ui.SelectionList;
import de.justsoftware.onx.common.presentation.client.ui.TextBoxWithIcons;
import de.justsoftware.onx.components.presentation.client.ui.AnchorPanel;
import de.justsoftware.onx.searchnew.presentation.client.MultiSelectionFilterLink;
import de.justsoftware.onx.searchnew.presentation.client.ui.MultipleSelectionFilterView;
import de.justsoftware.onx.searchnew.presentation.client.ui.MultipleSelectionFilterViewImpl;
import javax.annotation.CheckForNull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MultipleSelectionFilterViewImpl<T>
extends Composite
implements MultipleSelectionFilterView<T> {
    private static final MultipleSelectionFilterViewImplUIBinder UI_BINDER = (MultipleSelectionFilterViewImplUIBinder)GWT.create(MultipleSelectionFilterViewImplUIBinder.class);
    @UiField
    AnchorPanel _filterHeader;
    @UiField
    InlineLabel _filterHeaderText;
    @UiField
    FlowPanel _dropdownMenu;
    @UiField
    SelectionList _filterLinks;
    @UiField
    FlowPanel _selectedFilter;
    @UiField
    TextBoxWithIcons _searchBox;
    private final MultipleSelectionFilterView.Presenter<T> _presenter;
    @CheckForNull
    private Anchor _filterHeaderAnchor;
    private final PopupCloseHelper _popupCloseHelper;
    private FlowPanel _clearLink;

    public MultipleSelectionFilterViewImpl(MultipleSelectionFilterView.Presenter<T> presenter, CommonClientFactory commonClientFactory) {
        this._presenter = presenter;
        this._popupCloseHelper = commonClientFactory.newPopupCloseHelper();
        this._popupCloseHelper.setHistoryMode(PopupCloseHelper.HistoyMode.IGNORE_HISTORY_CHANGE);
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
        this._dropdownMenu.addDomHandler((EventHandler)new ClosePopupKeyDownHandler(this), KeyDownEvent.getType());
        this._popupCloseHelper.ignoreElement((Element)this._filterHeader.getElement());
        this._popupCloseHelper.ignoreElement((Element)this._dropdownMenu.getElement());
        this._searchBox.setPlaceholder(I18nMediator.SEARCH.facetTypeaheadPlaceholder());
        this._searchBox.addRightIconClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this._searchBox.addKeyDownHandler((KeyDownHandler)new SelectFilterLinkKeyDownHandler(this));
        this._filterLinks.setMoveUpOutOfRangeFocusable((Focusable)this._searchBox);
    }

    protected void onLoad() {
        this._popupCloseHelper.setHandler((PopupCloseHelper.ClosePopupClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this._popupCloseHelper.registerHandler();
    }

    protected void onUnload() {
        this._popupCloseHelper.unregisterHandler();
    }

    public void setFilterHeader(String filterHeader) {
        this._filterHeaderText.setText(filterHeader + " ");
    }

    private void addSelectedFilter(MultiSelectionFilterLink<T> facetLink) {
        FlowPanel selectedFilterPanel = new FlowPanel();
        selectedFilterPanel.add((Widget)new InlineLabel(facetLink.getLabel()));
        JCIconOnlyAnchor removeIcon = new JCIconOnlyAnchor(IconType.REMOVE, (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        removeIcon.addStyleName("remove-filter-icon");
        selectedFilterPanel.add((Widget)removeIcon);
        this._selectedFilter.add((Widget)selectedFilterPanel);
    }

    public void clearDropdown() {
        this._filterLinks.clear();
    }

    public void dropdownAddFilterLinks(ImmutableCollection<MultiSelectionFilterLink<T>> links, boolean highlight) {
        for (MultiSelectionFilterLink facetlink : links) {
            this.addCheckbox(facetlink, highlight);
        }
    }

    public void dropdownAddClearLink() {
        this._clearLink = new FlowPanel("li");
        Anchor clearAnchor = new Anchor(I18nMediator.SEARCH.removeSelectedFilters());
        this._clearLink.add((Widget)clearAnchor);
        clearAnchor.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this._filterLinks.addSelectable((SelectionList.Selectable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void dropdownAddSeparator() {
        FlowPanel hLine = new FlowPanel("li");
        hLine.addStyleName("separator");
        this._filterLinks.add((Widget)hLine);
    }

    public void dropdownAddNoHits() {
        FlowPanel p = new FlowPanel("li");
        p.add((Widget)new Label(I18nMediator.SEARCH.noFacetTypeaheadHits()));
        this._filterLinks.add((Widget)p);
    }

    public void setSelectedFilter(ImmutableCollection<MultiSelectionFilterLink<T>> filterLinks) {
        this._selectedFilter.clear();
        for (MultiSelectionFilterLink facetlink : filterLinks) {
            this.addSelectedFilter(facetlink);
        }
    }

    public void setNoFilterSelected() {
        this._selectedFilter.clear();
        FlowPanel selectedFilterPanel = new FlowPanel();
        selectedFilterPanel.add((Widget)new InlineLabel(I18nMediator.BASIC_CONSTANTS.all()));
        this._selectedFilter.add((Widget)selectedFilterPanel);
    }

    public void setFilterEnabled(boolean enabled) {
        this.setStyleName("disabled", !enabled);
    }

    private void toggleLinkSelection(MultiSelectionFilterLink<T> link, boolean selected) {
        if (selected) {
            this._presenter.onSelected(link.getSelection());
        } else {
            this._presenter.onDeselected(link.getSelection());
        }
    }

    private void addCheckbox(MultiSelectionFilterLink<T> link, boolean highlight) {
        FlowPanel li = new FlowPanel("li");
        NavCheckbox checkbox = new NavCheckbox();
        checkbox.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        if (highlight) {
            checkbox.setHTML(HTMLUtil.highlightedHtmlEscape((String)(link.getLabel() + " ")));
        } else {
            checkbox.setText(link.getLabel() + " ");
        }
        checkbox.setValue(Boolean.valueOf(link.isSelected()), false);
        Long count = link.getFacetCount();
        if (count != null) {
            checkbox.setCount(count.longValue());
        }
        li.add((Widget)checkbox);
        this._filterLinks.addSelectable((SelectionList.Selectable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void showByToggler(boolean show) {
        this.setStyleName("search-filter-hidden", !show);
    }

    @UiHandler(value={"_filterHeader"})
    void onFilterHeaderClick(ClickEvent clickEvent) {
        this._presenter.onFilterHeaderClick();
    }

    @UiHandler(value={"_searchBox"})
    void onSearchBoxKeyUp(KeyUpEvent event) {
        this._presenter.onSearchTextChanged();
    }

    public void setDropdownOpen(boolean open) {
        this.setStyleName("open", open);
        if (open) {
            this._popupCloseHelper.registerHandler();
        } else {
            this._popupCloseHelper.unregisterHandler();
        }
    }

    public void setSearchBoxVisible(boolean visible) {
        this._searchBox.setVisible(visible);
    }

    public void setClearSearchBoxVisible(boolean visible) {
        this._searchBox.setRightIconVisible(visible);
    }

    public void setClearFilterLinksVisible(boolean b) {
        if (this._clearLink != null) {
            this._clearLink.setVisible(b);
        }
    }

    public String getSearchText() {
        return this._searchBox.getText();
    }

    public void setSearchText(String text) {
        this._searchBox.setText(text);
    }

    public void setFocusOnSearchBox() {
        this._searchBox.setFocus(true);
    }

    public void setFocusOnFilterList() {
        this._filterLinks.focus();
    }
}

