/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.multiwiki.presentation.client.ui.presenters;

import com.freiheit.toro.common.shared.util.Tuple;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.multiwiki.presentation.client.MultiWikiComponentFactory;
import de.justsoftware.onx.multiwiki.presentation.client.ui.presenters.MultiWikiTOCPresenter;
import de.justsoftware.onx.multiwiki.presentation.client.ui.views.MultiWikiTOCView;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiSectionClientModel;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiSectionId;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiTocType;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MultiWikiTOCPresenter
implements MultiWikiTOCView.Presenter {
    private static final String HEADLINE_PATTERN = "[hH][1-6]";
    private final MultiWikiComponentFactory _componentFactory;
    private final ScrollHandler _scrollHandler;
    private final MultiWikiTOCView _view;
    private final MultiWikiTocType _type;

    public MultiWikiTOCPresenter(ScrollHandler scrollHandler, MultiWikiComponentFactory componentFactory, MultiWikiTocType type) {
        this._scrollHandler = scrollHandler;
        this._componentFactory = componentFactory;
        this._type = type;
        switch (1.$SwitchMap$de$justsoftware$onx$multiwiki$shared$model$MultiWikiTocType[this._type.ordinal()]) {
            case 1: {
                this._view = this._componentFactory.tocHeadlinesView((MultiWikiTOCView.Presenter)this);
                break;
            }
            case 2: {
                this._view = this._componentFactory.tocSectionsView((MultiWikiTOCView.Presenter)this);
                this._view.setVisible(false);
                break;
            }
            case 3: {
                this._view = this._componentFactory.tocSectionsView((MultiWikiTOCView.Presenter)this);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown TOC type " + type.toString());
            }
        }
    }

    private boolean initializeHeadlinesTOC(ImmutableList<MultiWikiSectionClientModel> sections) {
        this._view.clear();
        boolean hasHeadlines = false;
        for (MultiWikiSectionClientModel section : sections) {
            int headingIndex = 0;
            LinkedList stack = new LinkedList();
            ArrayList headlines = new ArrayList();
            HTML html = new HTML(section.getText());
            this.addChildrenToStack(stack, (Element)html.getElement());
            while (!stack.isEmpty()) {
                Element element = (Element)stack.remove();
                this.checkForHeadline(headlines, element);
                this.addChildrenToStack(stack, element);
            }
            for (Tuple element : headlines) {
                this._view.addSection((String)element.getA(), section.getId(), headingIndex++, ((Short)element.getB()).shortValue());
                hasHeadlines = true;
            }
        }
        return hasHeadlines;
    }

    private void checkForHeadline(ArrayList<Tuple<String, Short>> headlines, Element element) {
        String text;
        if (element.getTagName().matches(HEADLINE_PATTERN) && !Strings.isNullOrEmpty((String)(text = element.getInnerText().trim().replaceAll("^\\s*$", "")))) {
            short level = (short)(element.getTagName().charAt(1) - 48);
            headlines.add((Tuple<String, Short>)new Tuple((Object)text, (Object)level));
        }
    }

    private void addChildrenToStack(LinkedList<Element> stack, Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
            Node node = nodeList.getItem(i);
            if (node.getNodeType() != 1) continue;
            stack.addFirst((Element)node);
        }
    }

    private boolean initializeSectionTOC(ImmutableList<MultiWikiSectionClientModel> sections) {
        this._view.clear();
        boolean hasHeadlines = false;
        for (int i = 0; i < sections.size(); ++i) {
            this._view.addSection(((MultiWikiSectionClientModel)sections.get(i)).getHeadline(), i);
            hasHeadlines = true;
        }
        return hasHeadlines;
    }

    public void showIn(AcceptsOneWidget container) {
        container.setWidget((IsWidget)this._view.asWidget());
    }

    public void onEntrySelected(MultiWikiSectionId sectionId, int headingPosition) {
        this._scrollHandler.scrollTo(sectionId, headingPosition);
    }

    public void onEntrySelected(int sectionIndex) {
        this._scrollHandler.scrollTo(sectionIndex);
    }

    public void setSections(ImmutableList<MultiWikiSectionClientModel> sections) {
        boolean hasHeadlines = false;
        switch (1.$SwitchMap$de$justsoftware$onx$multiwiki$shared$model$MultiWikiTocType[this._type.ordinal()]) {
            case 1: {
                hasHeadlines = this.initializeHeadlinesTOC(sections);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                hasHeadlines = this.initializeSectionTOC(sections);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown TOC type " + this._type.toString());
            }
        }
        this._view.setVisible(hasHeadlines);
    }
}

