/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.server;

import com.freiheit.toro.common.shared.model.ServiceException;
import com.freiheit.toro.common.shared.server.storage.StorageServerHelper;
import com.freiheit.toro.common.shared.util.ImageType;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.Actions;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.model.action.TabNameForConfiguration;
import de.justsoftware.onx.common.shared.model.action.VisibleActionSet;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.business.BreadcrumbService;
import de.justsoftware.onx.container.business.EntityAnchorService;
import de.justsoftware.onx.container.business.EntityDetailsService;
import de.justsoftware.onx.container.business.EntityParentsService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.EntityTeaserService;
import de.justsoftware.onx.container.presentation.shared.EntityController;
import de.justsoftware.onx.container.shared.model.BreadCrumbViewData;
import de.justsoftware.onx.container.shared.model.ComponentPositionConfig;
import de.justsoftware.onx.container.shared.model.DefaultEntityBaseData;
import de.justsoftware.onx.container.shared.model.EntityBadgeWithRole;
import de.justsoftware.onx.container.shared.model.EntityBaseData;
import de.justsoftware.onx.container.shared.model.EntityDetails;
import de.justsoftware.onx.container.shared.model.EntityExtendedData;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityInfoTabPrivacySettings;
import de.justsoftware.onx.container.shared.model.EntityStatistics;
import de.justsoftware.onx.container.shared.model.EntityTab;
import de.justsoftware.onx.container.shared.model.EntityTeaser;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.UpdateEntityResponse;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.db.DBEntityLink;
import de.justsoftware.onx.container.shared.model.db.DBPrivacyType;
import de.justsoftware.onx.container.shared.model.teasers.StaticTeaser;
import de.justsoftware.onx.container.shared.model.teasers.TeaserType;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.hierarchy.business.HierarchyService;
import de.justsoftware.onx.hierarchy.shared.model.EntityTreeItemData;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import de.justsoftware.onx.validation.shared.model.JucoConstraintViolation;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EntityControllerImpl
implements EntityController {
    private static final Function<Collection<Action>, ImmutableSet<Action>> ACTION_COLLECTION_TO_IMMUTABLE_SET = new /* Unavailable Anonymous Inner Class!! */;
    @Autowired
    private EntityService _entityService;
    @Autowired
    private EntityTeaserService _entityTeaserService;
    @Autowired
    private EntityDetailsService _entityDetailsService;
    @Autowired
    private StorageServerHelper _storageServerHelper;
    @Autowired
    private BreadcrumbService _breadcrumbService;
    @Autowired
    private SessionAuthorizationContextProvider _authCtxProvider;
    @Autowired
    private HierarchyService _hierarchyService;
    @Autowired
    private ProfileTeaserService _profileTeaserService;
    @Autowired
    private EntityParentsService _entityParentsService;
    @Autowired
    private EntityAnchorService _entityAnchorService;

    public void checkParentEntityAssigmentAllowed(EntityId childEntityId, EntityType childType, EntityId parentEntityId) {
        AuthorizationContext authCtx = this._authCtxProvider.getAuthorizationContextForCurrentUser();
        this._entityService.checkParentEntityAssignmentAllowed(childEntityId, childType, ImmutableSet.of((Object)parentEntityId), (AuthorizationCheckContextWithUserId)authCtx);
    }

    public EntityDetails getDetailsById(EntityId id) {
        return this._entityDetailsService.getDetailsById(id, this._authCtxProvider.getAuthorizationContextForCurrentUser());
    }

    public void deleteEntity(EntityId id) {
        AuthorizationContext authCtx = this._authCtxProvider.getAuthorizationContextForCurrentUser();
        this._entityService.deleteEntity(id, (AuthorizationCheckContextWithUserId)authCtx);
    }

    public void setEntityComponentPositions(EntityId entityId, ImmutableList<ComponentPositionConfig> positions) {
        this._entityService.setEntityComponentPositions(entityId, positions, (AuthorizationCheckContext)this._authCtxProvider.getAuthorizationContextForCurrentUser());
    }

    public UpdateEntityResponse updateEntityDescription(EntityId entityId, String description, boolean sendSubscriberNotification) {
        AuthorizationContext autorizationContext = this._authCtxProvider.getAuthorizationContextForCurrentUser();
        try {
            return this._entityService.updateEntityDescription((AuthorizationCheckContextWithUserId)autorizationContext, entityId, description, sendSubscriberNotification);
        }
        catch (InvalidIDException e) {
            throw new ServiceException("Entity Id does not exists");
        }
    }

    public UpdateEntityResponse updateEntityBaseData(EntityBaseData entityBaseData, boolean notifyMemberDataChange) {
        DBEntity entity = entityBaseData.getEntity();
        AuthorizationContext authCtx = this.checkEntityUpdateAllowed(entity);
        return this._entityService.updateEntityBaseData((AuthorizationCheckContextWithUserId)authCtx, entityBaseData, notifyMemberDataChange);
    }

    public ImmutableSet<JucoConstraintViolation> validateEntityBaseData(EntityBaseData entityBaseData) {
        AuthorizationContext authCtx = this._authCtxProvider.getAuthorizationContextForCurrentUser();
        return this._entityService.validateEntityBaseData(entityBaseData, (AuthorizationCheckContextWithUserId)authCtx);
    }

    @Nonnull
    private AuthorizationContext checkEntityUpdateAllowed(@Nonnull DBEntity entity) {
        AuthorizationContext authCtx = this._authCtxProvider.getAuthorizationContextForCurrentUser();
        authCtx.check((ItemId)entity.getId(), (Action)StaticEntityAction.ENTITY_MODIFY);
        this._entityService.checkParentEntityAssignmentAllowed(entity.getId(), entity.getType(), this.getParentEntityIds(entity), (AuthorizationCheckContextWithUserId)authCtx);
        return authCtx;
    }

    @Nonnull
    private ImmutableSet<EntityId> getParentEntityIds(@Nonnull DBEntity entity) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        List linkedEntities = entity.getLinkedEntities();
        if (!CollectionUtil.isEmpty((Iterable)linkedEntities)) {
            for (DBEntityLink entityLink : linkedEntities) {
                result.add((Object)entityLink.getLinkedEntityId());
            }
        }
        return result.build();
    }

    public ListAndCount<EntityBadgeWithRole> getBadgesByEntityTypeAndPerson(EntityType type, PersonId personId, int offset, int limit) {
        return this._entityService.getBadgesWithRoleByEntityTypeAndPerson(type, personId, offset, limit, (AuthorizationCheckContextWithUserId)this._authCtxProvider.getAuthorizationContextForCurrentUser());
    }

    public void deleteIcon(EntityId id) {
        AuthorizationContext authCtx = this._authCtxProvider.getAuthorizationContextForCurrentUser();
        DBEntity entity = this._entityService.getByIdNotNull(id);
        authCtx.check((Item)new EntityItem(entity), (Action)StaticEntityAction.ENTITY_MODIFY);
        String oldFilename = entity.getIcon();
        entity.setIcon("");
        this._entityService.updateEntity((AuthorizationCheckContextWithUserId)authCtx, entity);
        this._storageServerHelper.deleteFileOnStorageServer(ImageType.ENTITY_IMAGE.getPath(), oldFilename);
    }

    public void deleteLogo(EntityId id) {
        DBEntity entity = this._entityService.getByIdNotNull(id);
        AuthorizationContext authCtx = this._authCtxProvider.getAuthorizationContextForCurrentUser();
        authCtx.check((Item)new EntityItem(entity), (Action)StaticEntityAction.ENTITY_MODIFY);
        String oldFilename = entity.getLogo();
        entity.setLogo("");
        this._entityService.updateEntity((AuthorizationCheckContextWithUserId)authCtx, entity);
        this._storageServerHelper.deleteFileOnStorageServer(ImageType.ENTITY_IMAGE.getPath(), oldFilename);
    }

    public void deleteSlideshowImage(EntityId id) {
        DBEntity entity = this._entityService.getByIdNotNull(id);
        AuthorizationContext authCtx = this._authCtxProvider.getAuthorizationContextForCurrentUser();
        authCtx.check((Item)new EntityItem(entity), (Action)StaticEntityAction.ENTITY_MODIFY);
        String oldFilename = entity.getSlideshowImage();
        entity.setSlideshowImage("");
        this._entityService.updateEntity((AuthorizationCheckContextWithUserId)authCtx, entity);
        this._storageServerHelper.deleteFileOnStorageServer(ImageType.ENTITY_IMAGE.getPath(), oldFilename);
    }

    public void saveEntityExtendedData(EntityExtendedData entityPrivacySettings) {
        DBEntity dbEntity = this._entityService.getByIdNotNull(entityPrivacySettings.getEntityId());
        AuthorizationContext authCtx = this._authCtxProvider.getAuthorizationContextForCurrentUser();
        authCtx.check((Item)new EntityItem(dbEntity), (Action)Actions.entityModifyTab((TabNameForConfiguration)TabNameForConfiguration.PRIVACY));
        this._entityService.saveEntityExtendedData(entityPrivacySettings);
    }

    public ListAndCount<EntityInfo> getInfoForTypes(ImmutableSet<EntityType> types, int offset, int limit) {
        return this._entityService.getEntityInfoForTypes(types, offset, limit, (SearchAuthorizationCheckContext)this._authCtxProvider.getAuthorizationContextForCurrentUser());
    }

    public ListAndCount<EntityInfo> getParentSuggestionsForType(EntityId childId, ImmutableSet<EntityType> parentTypes, ImmutableSet<EntityId> selectedParents, int offset, int numberOfResults) {
        AuthorizationContext authCtx = this._authCtxProvider.getAuthorizationContextForCurrentUser();
        ListAndCount resultIds = this._entityParentsService.suggestEntityParents(childId, parentTypes, selectedParents, offset, numberOfResults, (SearchAuthorizationCheckContext)authCtx);
        ImmutableList infos = this._entityService.getInfosByIdsOrdered((Iterable)resultIds, (AuthorizationCheckContextWithLocale)authCtx);
        return new ListAndCount(resultIds.getMaxCount(), (Collection)infos);
    }

    public EntityInfo getInfoById(EntityId id) {
        return this._entityService.getInfoById(id, (AuthorizationCheckContextWithLocale)this._authCtxProvider.getAuthorizationContextForCurrentUser());
    }

    public ImmutableMap<EntityId, EntityInfo> getInfoMapByIds(ImmutableSet<EntityId> ids) throws ServiceException {
        return this._entityService.getInfoMapByIds(ids, (AuthorizationCheckContextWithLocale)this._authCtxProvider.getAuthorizationContextForCurrentUser());
    }

    public EntityId createEntity(EntityBaseData entityBaseData, EntityId parentId) {
        AuthorizationContext auth = this._authCtxProvider.getAuthorizationContextForCurrentUser();
        return this._entityService.createInheritingEntity(entityBaseData, parentId, (AuthorizationCheckContextWithUserId)auth);
    }

    public BreadCrumbViewData breadcrumb(GlobalId itemId, @Nullable EntityId currentEntityId, @Nullable EntityId currentLayoutEntityId) {
        AuthorizationContext authCtx = this._authCtxProvider.getAuthorizationContextForCurrentUser();
        return this._breadcrumbService.breadcrumb(itemId, currentEntityId, currentLayoutEntityId, (AuthorizationCheckContextWithLocale)authCtx);
    }

    public ImmutableSet<String> getPrivacySelectedAuthorityNames(EntityId id, DBPrivacyType type) {
        AuthorizationContext authCtx = this._authCtxProvider.getAuthorizationContextForCurrentUser();
        return this._entityService.getPrivacySettings(id, type, (AuthorizationCheckContext)authCtx);
    }

    public DefaultEntityBaseData defaultNewEntity(EntityId parentId, EntityType entityType, String defaultName, Date defaultDate) {
        return this._entityService.defaultNewEntity(parentId, entityType, defaultName, defaultDate, (AuthorizationCheckContextWithUserId)this._authCtxProvider.getAuthorizationContextForCurrentUser());
    }

    public ImmutableList<EntityTreeItemData> getDirectChildEntityTree(EntityId parentId, ImmutableSet<EntityType> typesForTree) {
        return this._hierarchyService.getDirectChildEntityTree(parentId, typesForTree, (SearchAuthorizationCheckContext)this._authCtxProvider.getAuthorizationContextForCurrentUser());
    }

    public ImmutableList<EntityTreeItemData> getEntityTreeWithParentNodeByEntityId(EntityId id, ImmutableSet<EntityType> treeEntityTypes) {
        return this._hierarchyService.getEntityTreeWithParentNodeByEntityId(id, treeEntityTypes, (SearchAuthorizationCheckContext)this._authCtxProvider.getAuthorizationContextForCurrentUser());
    }

    @Deprecated
    public ImmutableMap<PersonId, PersonTeaserModel> getPersonTeaserModelsForDynamicAttributes(ImmutableSet<PersonId> personIds) {
        return this._profileTeaserService.getPersonTeaserForUserWithFullNames(personIds, (AuthorizationCheckContextWithLocale)this._authCtxProvider.getAuthorizationContextForCurrentUser());
    }

    public ImmutableList<EntityInfo> getAdminInheritanceParentsByEntityId(EntityId id, boolean includeOwnEntity) {
        return this._entityService.getParentsEntityInfosSortedByName(id, includeOwnEntity, true, EntityService.SearchDepth.DIRECT_AND_INDIRECT_ADMIN_PARENTS, (AuthorizationCheckContextWithLocale)this._authCtxProvider.getAuthorizationContextForCurrentUser());
    }

    public ImmutableList<EntityInfo> getMemberInheritanceParentsByEntityId(EntityId id, boolean includeOwnEntity) {
        return this._entityService.getParentsEntityInfosSortedByName(id, includeOwnEntity, true, EntityService.SearchDepth.DIRECT_AND_INDIRECT_MEMBER_PARENTS, (AuthorizationCheckContextWithLocale)this._authCtxProvider.getAuthorizationContextForCurrentUser());
    }

    public HashMap<EntityId, ImmutableSet<Action>> getAllowedEntitySearchActions(ImmutableSet<EntityId> entities) {
        return Maps.newHashMap((Map)Maps.transformValues((Map)this.getAllowedEntityActions(entities, VisibleActionSet.SEARCH_BADGES).asMap(), (Function)ACTION_COLLECTION_TO_IMMUTABLE_SET));
    }

    @Nonnull
    private ImmutableSetMultimap<EntityId, Action> getAllowedEntityActions(@Nonnull ImmutableSet<EntityId> entities, @Nonnull VisibleActionSet context) {
        return this._entityService.getAllowedEntityActions(entities, context, (AuthorizationCheckContextWithUserId)this._authCtxProvider.getAuthorizationContextForCurrentUser());
    }

    public ImmutableSet<Action> getAllowedEntitySearchActions(EntityId entityId) {
        return this.getAllowedEntityActions(ImmutableSet.of((Object)entityId), VisibleActionSet.SEARCH_BADGES).get((Object)entityId);
    }

    public void updateEntityTitle(EntityId entityId, String newTitle) {
        this._entityService.updateTitle(entityId, newTitle, (AuthorizationCheckContextWithUserId)this._authCtxProvider.getAuthorizationContextForCurrentUser());
    }

    public EntityTeaser getTeaser(EntityId entityId) {
        List teasers = this._entityTeaserService.getTeasersByIds((TeaserType)StaticTeaser.SLIDESHOW_TEASER, (List)ImmutableList.of((Object)entityId), (AuthorizationCheckContextWithUserId)this._authCtxProvider.getAuthorizationContextForCurrentUser());
        if (teasers.isEmpty()) {
            return null;
        }
        return (EntityTeaser)teasers.get(0);
    }

    public HashMap<EntityId, EntityTeaser> getTeaser(ImmutableSet<EntityId> entityIds) {
        return new HashMap<EntityId, EntityTeaser>((Map<EntityId, EntityTeaser>)Maps.uniqueIndex((Iterable)this._entityTeaserService.getTeasersByIds((TeaserType)StaticTeaser.SLIDESHOW_TEASER, (List)entityIds.asList(), (AuthorizationCheckContextWithUserId)this._authCtxProvider.getAuthorizationContextForCurrentUser()), (Function)EntityTeaser.TO_ID));
    }

    public EntityStatistics getStatisticsById(EntityId entityId) {
        return this._entityService.getStatisticsById(entityId, (AuthorizationCheckContextWithUserId)this._authCtxProvider.getAuthorizationContextForCurrentUser());
    }

    public EntityInfoTabPrivacySettings getEntityInfoTabPrivacySettings(EntityId entityId) {
        return this._entityService.getEntityInfoTabPrivacySettings(entityId, (AuthorizationCheckContext)this._authCtxProvider.getAuthorizationContextForCurrentUser());
    }

    public ImmutableSet<String> getEntityAnchors(EntityId entityId) {
        return this._entityAnchorService.getAnchors(ImmutableSet.of((Object)entityId), (AuthorizationCheckContext)this._authCtxProvider.getAuthorizationContextForCurrentUser()).get((Object)entityId);
    }

    public HashMap<EntityId, ImmutableSet<String>> getEntityAnchors(ImmutableSet<EntityId> entities) {
        ImmutableMap anchors = this._entityAnchorService.getAnchors(entities, (AuthorizationCheckContext)this._authCtxProvider.getAuthorizationContextForCurrentUser()).asMap();
        return new HashMap<EntityId, ImmutableSet<String>>(Maps.transformValues((Map)anchors, (Function)new /* Unavailable Anonymous Inner Class!! */));
    }

    public EntityTab getTabForHash(EntityId entityId, String hash) {
        return this._entityAnchorService.getTabForHash(entityId, hash, (AuthorizationCheckContext)this._authCtxProvider.getAuthorizationContextForCurrentUser());
    }
}

