/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.freiheit.toro.account.presentation.ui.LoginManagerImpl;
import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.ui.PersonUtil;
import com.freiheit.toro.common.shared.util.ImageSize;
import com.github.gwtbootstrap.client.ui.NavLink;
import com.github.gwtbootstrap.client.ui.NavList;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.AbstractActionCommand;
import de.justsoftware.onx.common.presentation.client.ui.JCIconOnlyAnchor;
import de.justsoftware.onx.common.presentation.client.ui.JCPopupPanel;
import de.justsoftware.onx.common.presentation.client.ui.PanelPagingWidget;
import de.justsoftware.onx.common.presentation.client.ui.form.impl.Section;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.components.presentation.client.ui.ShowPopupUtils;
import de.justsoftware.onx.container.presentation.client.ui.EntityMemberActionCommand;
import de.justsoftware.onx.container.presentation.client.ui.EntityMemberConfiguratorPagingWidget;
import de.justsoftware.onx.container.presentation.shared.model.entityedit.MemberEntityEditModel;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberPagerParams;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import de.justsoftware.onx.container.shared.model.EntityMembership;
import de.justsoftware.onx.container.shared.model.PublicEntityMember;
import de.justsoftware.onx.container.shared.model.RoleOrInheritedRole;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityMemberConfiguratorPagingWidget
extends Composite {
    private static final int ITEM_PER_PAGE = 10;
    private static final ImmutableSet<RoleOrInheritedRole> NOT_SEARCHABLE_ROLES = ImmutableSet.of((Object)EntityMemberRole.ADMIN);
    private static final String CSS_USER_NAME = "user-name";
    private static final String CSS_ACTION_ICON = "action-icon";
    private static final String CSS_BATCH_EDIT = "batch-edit";
    private static final String CSS_VISIBLE = "visible";
    private static final ImmutableMap<EntityMemberActionCommand, EntityMemberRole> EVENT_ACTION_ROLE_MAP = ImmutableMap.of((Object)EntityMemberActionCommand.MOVE_TO_EVENT_PARTICIPANT_LIST, (Object)EntityMemberRole.EVENT_IS_ATTENDING, (Object)EntityMemberActionCommand.MOVE_TO_EVENT_WAITINGLIST, (Object)EntityMemberRole.EVENT_IS_ON_WAITINGLIST, (Object)EntityMemberActionCommand.MOVE_TO_EVENT_NOT_ATTENDING_LIST, (Object)EntityMemberRole.EVENT_IS_NOT_ATTENDING, (Object)EntityMemberActionCommand.MOVE_TO_EVENT_UNDECIDED_LIST, (Object)EntityMemberRole.EVENT_IS_MAYBE_ATTENDING);
    private final EntityMemberConfiguratorListType _listType;
    private final RoleOrInheritedRole _role;
    private final JCIconOnlyAnchor _addIcon;
    private final PanelPagingWidget<EntityMembership> _pager;
    private final ClientFactory _clientFactory;
    private final Set<PersonId> _batchSelectedUsers = new HashSet();
    private final MemberRoleActionProvider _memberStatusActionProvider = new MemberRoleActionProvider(this);
    private ImmutableSet<Action> _allowedActions = ImmutableSet.of();
    private final EntityId _entityId;
    private final MemberEntityEditModel _entityEditModel;
    private final FlowPanel _content;
    private final FlowPanel _batchActions;
    private final List<CheckBox> _batchEditCheckBoxes = new ArrayList();
    private CheckBox _markAllCheckbox;
    private Label _nameLabel;
    private FlowPanel _nameLabelContainer;
    private Anchor _deselectAllLink;
    private final SearchComponents _searchComponents;

    public EntityMemberConfiguratorPagingWidget(ClientFactory clientFactory, EntityId entityId, MemberEntityEditModel entityEditModel, RoleOrInheritedRole role, String title, String tooltipText, EntityMemberConfiguratorListType listType) {
        this._clientFactory = clientFactory;
        this._entityId = entityId;
        this._entityEditModel = entityEditModel;
        this._role = role;
        this._listType = listType;
        FlowPanel actionLinksPanel = new FlowPanel();
        actionLinksPanel.addStyleName("membershipActionLinks");
        this._pager = new /* Unavailable Anonymous Inner Class!! */;
        this._pager.setShowBottomPager(true);
        this._pager.setShowTopPager(false);
        this._pager.setNoDataWidget((Widget)new InlineLabel());
        this._content = new FlowPanel();
        this._batchActions = new FlowPanel();
        this._batchActions.addStyleName("batch-actions");
        this._searchComponents = NOT_SEARCHABLE_ROLES.contains((Object)this._role) ? null : new SearchComponents(this);
        FlowPanel clearfix = new FlowPanel();
        clearfix.addStyleName("clearfix");
        this._content.add((Widget)clearfix);
        if (this._searchComponents != null) {
            this._content.add((Widget)this._searchComponents._searchSlider);
        }
        this._content.add((Widget)this._batchActions);
        this._content.add((Widget)this._pager);
        Section section = new Section();
        section.addControlGroupContainer((Widget)this._content);
        section.insertIntoLegend((Widget)actionLinksPanel);
        section.setHeader(title);
        section.setTooltip(tooltipText);
        this._addIcon = this.setupAddIcon();
        if (this._searchComponents != null) {
            this._searchComponents._searchIcon.addStyleName("app-hover-color");
            actionLinksPanel.add((Widget)this._searchComponents._searchIcon);
        }
        this._addIcon.addStyleName("app-hover-color");
        actionLinksPanel.add((Widget)this._addIcon);
        this.initWidget((Widget)section);
    }

    @Nonnull
    private ImmutableSet<EntityMemberActionCommand> collectActionCommands() {
        return (ImmutableSet)this._role.accept((RoleOrInheritedRole.Visitor)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Nonnull
    private JCIconOnlyAnchor setupAddIcon() {
        JCPopupPanel popup = new JCPopupPanel(true);
        NavList panel = new NavList();
        ClickHandler closeHandler = event -> popup.hide();
        JCIconOnlyAnchor addIcon = new JCIconOnlyAnchor(IconType.PLUS);
        addIcon.addClickHandler(event -> {
            ImmutableList addActions = (ImmutableList)this._role.accept((RoleOrInheritedRole.Visitor)this._memberStatusActionProvider);
            if (addActions.size() == 1) {
                ((MenuItem)addActions.get((int)0))._clickHandler.onClick(null);
            } else {
                panel.clear();
                for (MenuItem m : addActions) {
                    NavLink navLink = new NavLink(m._text);
                    navLink.addClickHandler(closeHandler);
                    navLink.addClickHandler(m._clickHandler);
                    panel.add((Widget)navLink);
                }
                ShowPopupUtils.toggleRelativeTo((PopupPanel)popup, (Widget)panel, (Widget)addIcon);
            }
        });
        popup.addAutoHidePartner((Element)addIcon.getElement());
        return addIcon;
    }

    private void updateVisibility() {
        ListAndCount pageData = this._pager.getCurrentPageData();
        ImmutableList addActions = (ImmutableList)this._role.accept((RoleOrInheritedRole.Visitor)this._memberStatusActionProvider);
        boolean addIconVisible = addActions.size() > 0;
        this._addIcon.setVisible(addIconVisible);
        if (addActions.size() == 1) {
            this._addIcon.setTitle(((MenuItem)addActions.get((int)0))._text);
        }
        this.setVisible(pageData != null && pageData.getMaxCount() > 0 || addIconVisible || !StringUtil.isEmpty((String)this.getSearchText()));
    }

    @Nonnull
    private String getSearchText() {
        return this._searchComponents != null ? Strings.nullToEmpty((String)this._searchComponents._searchBox.getText()) : "";
    }

    @Nonnull
    private Widget handleCreateItemPublic(PublicEntityMember member) {
        PersonTeaserModel person = member.getPerson();
        FlowPanel container = new FlowPanel();
        container.addStyleName("memberRow");
        FlowPanel profileImageContainer = new FlowPanel();
        profileImageContainer.addStyleName("user-image-container");
        Widget profileImage = PersonUtil.createImage((PersonTeaserModel)person, (ImageSize)ImageSize.SMALL);
        profileImage.addStyleName("user-image");
        profileImageContainer.add(profileImage);
        container.add((Widget)profileImageContainer);
        if (!EntityMemberRole.ADMIN.equals((Object)this._role)) {
            this.addBatchSelectBox(member, profileImageContainer, container);
        }
        FlowPanel namePanel = new FlowPanel();
        namePanel.addStyleName(CSS_USER_NAME);
        namePanel.add(PersonUtil.profileInlineLink((PersonTeaserModel)person, (ClientFactory)this._clientFactory, (PersonUtil.PopupOption)PersonUtil.PopupOption.WITHOUT_POPUP));
        container.add((Widget)namePanel);
        ImmutableSet commands = this.resolveCommands(member);
        switch (commands.size()) {
            case 0: {
                return container;
            }
            case 1: {
                AbstractActionCommand icon = ((EntityMemberActionCommand)Iterables.getOnlyElement((Iterable)commands)).makeSingleActionCommand(member, this._entityEditModel.getEntityType(), this._entityId);
                icon.addStyleName(CSS_ACTION_ICON);
                icon.addStyleName("app-hover-color");
                container.add((Widget)icon);
                return container;
            }
        }
        container.add((Widget)this.createActionDropdown(member, commands));
        return container;
    }

    private void addBatchSelectBox(PublicEntityMember member, FlowPanel container, FlowPanel memberRow) {
        this._content.addStyleName("batch-editing-on");
        CheckBox batchSelectBox = new CheckBox();
        container.add((Widget)batchSelectBox);
        this._batchEditCheckBoxes.add(batchSelectBox);
        batchSelectBox.addValueChangeHandler(event -> {
            memberRow.setStyleName("checked", ((Boolean)event.getValue()).booleanValue());
            if (((Boolean)event.getValue()).booleanValue()) {
                this._batchSelectedUsers.add((PersonId)member.getPerson().getId());
                this._markAllCheckbox.setValue(Boolean.TRUE, false);
                this._markAllCheckbox.setTitle(I18nMediator.BASIC_CONSTANTS.unmarkAllEntries());
            } else {
                int checkedBoxes = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)this._batchEditCheckBoxes, input -> input.getValue())).size();
                if (checkedBoxes == 0) {
                    this._markAllCheckbox.setValue(Boolean.FALSE, false);
                    this._markAllCheckbox.setTitle(I18nMediator.BASIC_CONSTANTS.markAllEntries());
                }
                this._batchSelectedUsers.remove(member.getPerson().getId());
            }
            this.updateBatchSelectState();
        });
        if (this._batchSelectedUsers.contains(member.getPerson().getId())) {
            batchSelectBox.setValue(Boolean.TRUE, true);
            this._content.setStyleName(CSS_BATCH_EDIT, true);
        }
    }

    private void updateBatchSelectState() {
        int selectedUsers = this._batchSelectedUsers.size();
        this._content.setStyleName(CSS_BATCH_EDIT, selectedUsers > 0);
        if (selectedUsers > 0) {
            this._nameLabel.setText(selectedUsers == 1 ? I18nMediator.PROFILE_MSG.oneUserSelected() : I18nMediator.PROFILE_MSG.xUsersSelected(selectedUsers));
        } else {
            this._nameLabel.setText(I18nMediator.PROFILE.name());
        }
        this._deselectAllLink.setVisible(selectedUsers > 0);
    }

    @Nonnull
    private JCIconOnlyAnchor createActionDropdown(@Nullable PublicEntityMember member, ImmutableSet<EntityMemberActionCommand> commands) {
        JCIconOnlyAnchor actionAnchor = new JCIconOnlyAnchor();
        actionAnchor.addStyleName(CSS_ACTION_ICON);
        actionAnchor.addStyleName("app-hover-color");
        actionAnchor.setIcon(IconType.ELLIPSIS_VERTICAL);
        actionAnchor.setTitle(I18nMediator.BASIC_CONSTANTS.editThisEntry());
        actionAnchor.setIconSize(IconSize.LARGE);
        actionAnchor.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return actionAnchor;
    }

    @Nonnull
    private ImmutableSet<EntityMemberActionCommand> resolveCommands(PublicEntityMember member) {
        ImmutableSet.Builder commands = ImmutableSet.builder();
        switch (6.$SwitchMap$de$justsoftware$onx$container$presentation$client$ui$EntityMemberConfiguratorPagingWidget$EntityMemberConfiguratorListType[this._listType.ordinal()]) {
            case 1: {
                this.addMakeAdminCommand(commands, member);
                this.addMakeCoAdminCommand(commands, member);
                switch (6.$SwitchMap$de$justsoftware$onx$container$shared$model$EntityMemberWorkflow[this._entityEditModel.getMemberWorkflow().ordinal()]) {
                    case 1: {
                        this.addMoveToSpecificEventList(commands, member);
                        break;
                    }
                    case 2: {
                        this.addMakeMemberCommand(commands, member);
                    }
                }
                this.addDeleteCoAdmin(commands, member);
                break;
            }
            case 2: {
                this.addMakeAdminCommand(commands, member);
                this.addMakeCoAdminCommand(commands, member);
                this.addMoveToSpecificEventList(commands, member);
                break;
            }
            case 3: {
                this.addMakeAdminCommand(commands, member);
                this.addMakeCoAdminCommand(commands, member);
                this.addMakeMemberCommand(commands, member);
                this.addDeleteMember(commands, member);
            }
        }
        return commands.build();
    }

    private boolean canNotAlterAdmin(PublicEntityMember member) {
        return member.getRoles().contains((Object)EntityMemberRole.ADMIN) && (!this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MAKE_ADMIN) || ((PersonId)member.getPerson().getId()).equals((Object)LoginManagerImpl.getInstance().getPersonId()));
    }

    private void addDeleteMember(ImmutableSet.Builder<EntityMemberActionCommand> commands, PublicEntityMember member) {
        this._role.accept((RoleOrInheritedRole.Visitor)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addDeleteCoAdmin(ImmutableSet.Builder<EntityMemberActionCommand> commands, PublicEntityMember member) {
        this._role.accept((RoleOrInheritedRole.Visitor)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addMoveToSpecificEventList(ImmutableSet.Builder<EntityMemberActionCommand> commands, PublicEntityMember member) {
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MANAGE_MEMBER)) {
            for (EntityMemberActionCommand emac : EVENT_ACTION_ROLE_MAP.keySet()) {
                if (member.getRoles().contains(EVENT_ACTION_ROLE_MAP.get((Object)emac))) continue;
                commands.add((Object)emac);
            }
            if (EntityMemberRoles.ALL_EVENT_STATUS.contains((Object)this._role)) {
                commands.add((Object)EntityMemberActionCommand.REMOVE_FROM_EVENT);
            }
        }
    }

    private void addMakeMemberCommand(ImmutableSet.Builder<EntityMemberActionCommand> commands, PublicEntityMember member) {
        if (this.canNotAlterAdmin(member)) {
            return;
        }
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MANAGE_MEMBER) && !EntityMemberRoles.isMember((Set)member.getRoles())) {
            commands.add((Object)EntityMemberActionCommand.ASSIGN_MEMBERSHIP);
        }
    }

    private void addMakeCoAdminCommand(ImmutableSet.Builder<EntityMemberActionCommand> commands, PublicEntityMember member) {
        if (this.canNotAlterAdmin(member)) {
            return;
        }
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MAKE_COADMIN) && !EntityMemberRoles.isCoAdmin((Set)member.getRoles())) {
            commands.add((Object)EntityMemberActionCommand.MAKE_COADMIN);
        }
    }

    private void addMakeAdminCommand(ImmutableSet.Builder<EntityMemberActionCommand> commands, @Nullable PublicEntityMember member) {
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MAKE_ADMIN) && (member == null || !EntityMemberRoles.isAdmin((Set)member.getRoles()))) {
            commands.add((Object)EntityMemberActionCommand.MAKE_ADMIN);
        }
    }

    public int getDataCount() {
        ListAndCount currentPageData = this._pager.getCurrentPageData();
        if (currentPageData != null) {
            return currentPageData.getMaxCount();
        }
        return 0;
    }

    @Nonnull
    public EntityMemberPagerParams getFilter() {
        return new EntityMemberPagerParams(this._pager.getOffset(), this._pager.getItemPerPage());
    }

    @Nonnull
    public RoleOrInheritedRole getRole() {
        return this._role;
    }

    public void setCurrentPageData(int offset, int limit, ListAndCount<EntityMembership> listAndCount) {
        this.updateVisibility();
        this._batchSelectedUsers.clear();
        this._markAllCheckbox.setValue(Boolean.FALSE, false);
        this.updateBatchSelectState();
        this._pager.setCurrentPageData(offset, limit, listAndCount);
    }

    public void setAllowedActions(ImmutableSet<Action> may) {
        this._allowedActions = may;
        this._batchActions.clear();
        JCIconOnlyAnchor actionAnchor = this.createActionDropdown(null, this.collectActionCommands());
        actionAnchor.addStyleName(CSS_ACTION_ICON);
        actionAnchor.addStyleName("app-hover-color");
        actionAnchor.setIcon(IconType.ELLIPSIS_VERTICAL);
        actionAnchor.setIconSize(IconSize.LARGE);
        actionAnchor.setTitle(I18nMediator.BASIC_CONSTANTS.editAllMarkedEntries());
        this._markAllCheckbox = new CheckBox();
        this._markAllCheckbox.setTitle(I18nMediator.BASIC_CONSTANTS.markAllEntries());
        this._markAllCheckbox.addValueChangeHandler(event -> {
            Boolean value = (Boolean)event.getValue();
            this._markAllCheckbox.setTitle(value != false ? I18nMediator.BASIC_CONSTANTS.unmarkAllEntries() : I18nMediator.BASIC_CONSTANTS.markAllEntries());
            for (CheckBox cb : this._batchEditCheckBoxes) {
                cb.setValue(value, true);
            }
        });
        this._batchActions.add((Widget)this._markAllCheckbox);
        this._nameLabelContainer = new FlowPanel();
        this._nameLabelContainer.addStyleName("name-label");
        this._nameLabel = new InlineLabel(I18nMediator.PROFILE.name());
        this._deselectAllLink = new Anchor();
        this._deselectAllLink.setVisible(false);
        this._deselectAllLink.setText(I18nMediator.BASIC_CONSTANTS.deselectAll());
        this._deselectAllLink.addClickHandler(event -> {
            this._batchSelectedUsers.clear();
            this.updateBatchSelectState();
            for (CheckBox cb : this._batchEditCheckBoxes) {
                cb.setValue(Boolean.FALSE, true);
            }
        });
        this._nameLabelContainer.add((Widget)this._nameLabel);
        this._nameLabelContainer.add((Widget)this._deselectAllLink);
        this._batchActions.add((Widget)this._nameLabelContainer);
        this._batchActions.add((Widget)actionAnchor);
    }
}

