/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.export.servlet;

import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.freiheit.toro.common.shared.model.NotLoggedInException;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.calendar.business.CalendarFeedService;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.container.business.EntityDetailsService;
import de.justsoftware.onx.container.shared.model.EntityDetails;
import de.justsoftware.onx.container.shared.model.EntityDurationTimeOption;
import de.justsoftware.onx.container.shared.model.EntityId;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gwtwidgets.server.spring.ServletUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller(value="icsExportServlet")
@ParametersAreNonnullByDefault
public class IcsExportServlet {
    private static final Logger LOG = LoggerFactory.getLogger(IcsExportServlet.class);
    private final EntityDetailsService _entityDetailsService;
    private final SessionAuthorizationContextProvider _authorizationContextProvider;
    private final EntityConfigService _entityConfig;
    private final CalendarFeedService _calendarFeedService;

    @Autowired
    public IcsExportServlet(EntityDetailsService entityDetailsService, SessionAuthorizationContextProvider authorizationContextProvider, EntityConfigService entityConfig, CalendarFeedService calendarFeedService) {
        this._entityDetailsService = entityDetailsService;
        this._authorizationContextProvider = authorizationContextProvider;
        this._entityConfig = entityConfig;
        this._calendarFeedService = calendarFeedService;
    }

    @RequestMapping(value={"/resource/icsexport.ics"})
    @CheckForNull
    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"}, justification="its wanted here")
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String ics;
        ServletUtils.setResponse((HttpServletResponse)response);
        AuthorizationContext authCtx = this._authorizationContextProvider.getAuthorizationContextForCurrentUser(request);
        try {
            String tmp = request.getParameter("id");
            EntityId id = new EntityId(Long.parseLong(tmp));
            EntityDetails entity = this._entityDetailsService.getDetailsById(id, authCtx);
            if (!this._entityConfig.entityTypeActivated(entity.getType()) || this._entityConfig.getDurationTimeOption(entity.getType()) == EntityDurationTimeOption.OFF) {
                response.sendError(404);
                return null;
            }
            if (!entity.isVisible()) {
                response.sendError(403);
                return null;
            }
            ics = this._calendarFeedService.createICS(authCtx.getUserId(), (List)ImmutableList.of((Object)entity));
        }
        catch (InvalidIdServiceException | NumberFormatException e) {
            response.sendError(404);
            return null;
        }
        catch (NullPointerException e) {
            response.sendError(404);
            LOG.error("Null Pointer Exception during ICS Export", (Throwable)e);
            return null;
        }
        catch (NotLoggedInException | PermissionDeniedException e) {
            response.sendError(403);
            return null;
        }
        response.setContentType("text/calendar");
        response.setCharacterEncoding(Charsets.UTF_8.name());
        PrintWriter out = response.getWriter();
        out.print(ics);
        out.close();
        return null;
    }
}

