/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui.selectLink;

import com.freiheit.toro.client.mediator.Callback;
import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.freiheit.toro.common.shared.util.Verification;
import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.freiheit.toro.util.client.LoggingUtil;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.gwt.user.client.ui.Accordion;
import de.justsoftware.gwt.user.client.util.JoinRequests;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.TokenUtilClient;
import de.justsoftware.onx.common.presentation.client.ui.InlineFeedbackWidget;
import de.justsoftware.onx.common.presentation.client.ui.selectLink.SelectLinkWidgetImpl;
import de.justsoftware.onx.common.presentation.client.ui.selectLink.SelectedLink;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.common.shared.util.HistoryToken;
import de.justsoftware.onx.common.shared.util.HistoryTokenParser;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.common.shared.util.TokenUtil;
import de.justsoftware.onx.container.presentation.client.EntityMediator;
import de.justsoftware.onx.container.shared.i18n.EntityMessages;
import de.justsoftware.onx.container.shared.model.EntityDetailsNotVisibleException;
import de.justsoftware.onx.container.shared.model.EntityDetailsPublicData;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.linkinfo.shared.model.LinkType;
import de.justsoftware.onx.person.presentation.client.PersonMediator;
import de.justsoftware.onx.searchnew.presentation.client.ClientFilterTypes;
import de.justsoftware.onx.searchnew.presentation.client.SearchHandler;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeVisitor;
import de.justsoftware.onx.searchnew.shared.model.FilterTypes;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.StaticFilterType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SelectLinkWidgetImpl
extends Composite {
    private static final String INTERNAL_LINK_WIDTH = "300px";
    private static final String LINK_SELECT_WIDGET_CSS_CLASS = "link-select-widget";
    private static final List<? extends FilterType> FILTERS_PREFIX = ImmutableList.of((Object)StaticFilterType.PROFILES);
    private static final List<? extends FilterType> FILTERS_SUFFIX = ImmutableList.of((Object)StaticFilterType.DOCUMENTS);
    private static final SelectLinkWidgetImplUIBinder UI_BINDER = (SelectLinkWidgetImplUIBinder)GWT.create(SelectLinkWidgetImplUIBinder.class);
    @UiField
    Accordion _accordion;
    @UiField
    InlineLabel _listLabel;
    @UiField
    Panel _internalContent;
    @UiField
    Panel _internalInputPanel;
    @UiField(provided=true)
    final FilterSelectWidget _internalFilterSelectWidget;
    @UiField
    Panel _internalLinkTextPanel;
    @UiField
    InlineFeedbackWidget _internalError;
    @UiField
    ListBox _internalAnchorList;
    @UiField
    Panel _listHead;
    @UiField
    Panel _listContent;
    @UiField(provided=true)
    final FilterSelectWidget _listFilterSelectWidget;
    @UiField
    InlineFeedbackWidget _listError;
    @UiField
    Panel _externalContent;
    @UiField
    TextBox _externalLinkTextBox;
    @UiField
    InlineFeedbackWidget _externalError;
    @UiField
    Panel _mailToContent;
    @UiField
    TextBox _mailToTextBox;
    @UiField
    InlineFeedbackWidget _mailToError;
    @UiField
    Panel _anchorHead;
    @UiField
    Panel _anchorContent;
    @UiField
    ListBox _anchorList;
    private AsyncCallback<SelectedLink> _callback;
    private EntityDetailsPublicData _currentEntity;
    private InternalSelectTextBox _internalSelectTextBox = null;
    private Command _cancelCallback;
    private final ClientFactory _clientFactory;

    SelectLinkWidgetImpl(ClientFactory clientFactory, @Nullable EntityDetailsPublicData entityDetails, @Nullable String oldHref, @Nonnull List<String> anchors) {
        this._clientFactory = clientFactory;
        List filters = this.getFilters();
        this._internalFilterSelectWidget = new /* Unavailable Anonymous Inner Class!! */;
        this._listFilterSelectWidget = new FilterSelectWidget((Collection)filters, true);
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
        this._internalFilterSelectWidget.setChangeListener((Callback)new /* Unavailable Anonymous Inner Class!! */);
        this._internalFilterSelectWidget.setSelected(null);
        this.setAnchors(anchors);
        this.setCurrentEntity(entityDetails);
        this.initOldLink(oldHref);
    }

    @Nonnull
    private List<FilterType> getFilters() {
        ArrayList filters = Lists.newArrayList((Iterable)FILTERS_PREFIX);
        for (EntityType t : HostPropertiesMediator.getHostPropertiesBean().getActiveOrderedEntityTypes()) {
            filters.add(FilterTypes.getByEntityType((EntityType)t));
        }
        filters.addAll(FILTERS_SUFFIX);
        return filters;
    }

    private void internalFilterSelectCallback() {
        FilterType filter = this._internalFilterSelectWidget.getSelected();
        this._internalInputPanel.setVisible(filter != null);
        if (filter == null) {
            return;
        }
        this._internalSelectTextBox = (InternalSelectTextBox)((Optional)filter.accept((FilterTypeVisitor)new /* Unavailable Anonymous Inner Class!! */)).orNull();
        if (this._internalSelectTextBox == null) {
            LoggingUtil.error((Object)this, (String)("Filter Type '" + filter.getName() + "' not supported!"));
        }
        this._internalLinkTextPanel.clear();
        this._internalLinkTextPanel.add((Widget)this._internalSelectTextBox);
    }

    private void setExternalLink(String externalLink) {
        this._accordion.open((Widget)this._externalContent);
        this._externalLinkTextBox.setText(externalLink);
    }

    private void setMailToLink(String email) {
        this._accordion.open((Widget)this._mailToContent);
        this._mailToTextBox.setText(email.substring("mailto:".length()));
    }

    private void setInternalLink(String oldHref) {
        HistoryTokenParser parsed;
        if (oldHref.startsWith("#.")) {
            this.setAnchorLink(oldHref);
            return;
        }
        try {
            parsed = TokenUtilClient.INSTANCE.parse(oldHref);
        }
        catch (TokenUtil.TokenParseException e) {
            this.setExternalLink(oldHref);
            return;
        }
        HistoryToken token = parsed.getToken();
        if (token != null) {
            try {
                token.accept((HistoryToken.Visitor)new InitializeOldValueVisitor(this, oldHref, parsed.getParams(), parsed.getHash()));
            }
            catch (RuntimeException e) {
                this.setExternalLink(oldHref);
            }
        } else {
            this.setExternalLink(oldHref);
        }
    }

    private void setAnchorLink(String oldHref) {
        String anchor = oldHref.substring(1);
        this._accordion.open((Widget)this._anchorContent);
        for (int i = 0; i < this._anchorList.getItemCount(); ++i) {
            if (!this._anchorList.getValue(i).equals(anchor)) continue;
            this._anchorList.setSelectedIndex(i);
            return;
        }
    }

    private void initOldLink(@Nullable String oldHref) {
        if (!ClientStringUtil.hasText((String)oldHref)) {
            return;
        }
        LinkType link = LinkType.getLinkType((String)oldHref);
        switch (6.$SwitchMap$de$justsoftware$onx$linkinfo$shared$model$LinkType[link.ordinal()]) {
            case 1: {
                this.setInternalLink(oldHref);
                return;
            }
            case 2: {
                this.setExternalLink(oldHref);
                return;
            }
            case 3: {
                this.setMailToLink(oldHref);
            }
        }
    }

    private void setLinkToEntity(EntityId id, @Nullable String hash) {
        JoinRequests requests = new JoinRequests((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        EntityMediator.getInstance().getInfoById(id, requests.callbackA());
        EntityMediator.getInstance().getEntityAnchors(id, requests.callbackB());
    }

    private void setInternalAnchors(@Nullable ImmutableSet<String> anchors, @Nullable String selectedHash) {
        boolean hasAnchors;
        this._internalAnchorList.clear();
        this._internalAnchorList.addItem(I18nMediator.WIKI_EDITOR.selectOptionalAnchor(), "");
        this.addInternalAnchor(selectedHash);
        boolean bl = hasAnchors = !CollectionUtil.isEmpty(anchors);
        if (hasAnchors) {
            for (String anchor : anchors) {
                if (Objects.equal((Object)selectedHash, (Object)anchor)) continue;
                this.addInternalAnchor(anchor);
            }
        }
        boolean hasHash = !StringUtil.isBlank((String)selectedHash);
        this._internalAnchorList.setSelectedIndex(hasHash ? 1 : 0);
        this._internalAnchorList.setVisible(hasAnchors || hasHash);
    }

    private void addInternalAnchor(@Nullable String anchor) {
        if (!StringUtil.isBlank((String)anchor)) {
            this._internalAnchorList.addItem(anchor.substring(1), anchor);
        }
    }

    private void setLinkToProfile(PersonId id) {
        this._internalFilterSelectWidget.setSelected((FilterType)StaticFilterType.PROFILES);
        PersonMediator.getInstance().getPersonTeaserModelById(id, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    void setCurrentEntity(@Nullable EntityDetailsPublicData currentEntity) {
        if (currentEntity == null || currentEntity instanceof EntityDetailsNotVisibleException) {
            this._listContent.setVisible(false);
            this._listHead.setVisible(false);
            return;
        }
        this._currentEntity = currentEntity;
        EntityMessages entityMessages = I18nMediator.getEntityMessagesByEntityType((EntityType)((EntityType)this._currentEntity.getType()));
        this._listLabel.setText(entityMessages.listsOfEntity(this._currentEntity.getName()));
    }

    void setCallback(@Nullable AsyncCallback<SelectedLink> callback) {
        this._callback = callback;
    }

    private void callback(SelectedLink link) {
        if (this._callback != null) {
            this._callback.onSuccess((Object)link);
        }
    }

    private void setAnchors(List<String> anchors) {
        if (anchors == null || anchors.isEmpty()) {
            this._anchorHead.setVisible(false);
            this._anchorContent.setVisible(false);
        } else {
            this._anchorHead.setVisible(true);
            for (String anchor : anchors) {
                this._anchorList.addItem(anchor.substring(1), anchor);
            }
        }
    }

    @UiHandler(value={"_externalLinkButton"})
    void onExternalLink(@Nullable ClickEvent e) {
        if (StringUtil.isBlank((String)this._externalLinkTextBox.getText())) {
            this._externalError.showAndHideAfterDelay();
            return;
        }
        String href = ClientStringUtil.toURL((String)this._externalLinkTextBox.getText());
        this.callback(new SelectedLink(href, href));
    }

    @UiHandler(value={"_mailToTextBox"})
    void onMailToEnter(KeyPressEvent e) {
        if (e.getCharCode() == '\r') {
            this.onExternalLink(null);
        }
    }

    @UiHandler(value={"_mailToLinkButton"})
    void onMailToLink(ClickEvent e) {
        String email = this._mailToTextBox.getText();
        if (StringUtil.isBlank((String)email) || !Verification.verifyEmail((String)email)) {
            this._mailToError.showAndHideAfterDelay();
            return;
        }
        String mailRef = "mailto:" + email;
        this.callback(new SelectedLink(I18nMediator.WIKI_EDITOR_MSG.linkToMail(email), mailRef));
    }

    @UiHandler(value={"_externalLinkTextBox"})
    void onExternalEnter(KeyPressEvent e) {
        if (e.getCharCode() == '\r') {
            this.onExternalLink(null);
        }
    }

    @UiHandler(value={"_internalLinkButton"})
    void onInternalLink(ClickEvent e) {
        this._internalSelectTextBox.insertLink();
    }

    @UiHandler(value={"_listLinkButton"})
    void onListLink(ClickEvent e) {
        FilterType filterType = this._listFilterSelectWidget.getSelected();
        if (filterType == null) {
            this._listError.showAndHideAfterDelay();
            return;
        }
        this.callback(new SelectedLink(ClientFilterTypes.labelPlural((FilterType)filterType), "#" + SearchHandler.tokenFor((SearchParameters)SearchHandler.parameters((EntityDetailsPublicData)this._currentEntity).withFilter(filterType))));
    }

    @UiHandler(value={"_anchorLinkButton"})
    void onAnchorLink(ClickEvent e) {
        String value = this._anchorList.getSelectedValue();
        if (value != null) {
            String item = this._anchorList.getItemText(this._anchorList.getSelectedIndex());
            this.callback(new SelectedLink(item, "#" + value));
        }
    }

    @UiHandler(value={"_cancelBtn"})
    void onCancel(ClickEvent e) {
        if (this._cancelCallback != null) {
            this._cancelCallback.execute();
        }
    }

    void setCancelCallback(Command cancelCallback) {
        this._cancelCallback = cancelCallback;
    }

    public void clearInput() {
        this._accordion.closeAll();
        this._externalLinkTextBox.setText("");
        this._mailToTextBox.setText("");
        this._internalFilterSelectWidget.setSelected(null);
        this._listFilterSelectWidget.setSelected(null);
        this.setInternalAnchors(ImmutableSet.of(), null);
    }
}

