/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui.components;

import com.github.gwtbootstrap.client.ui.base.IconAnchor;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.components.AbstractInlineEditView;
import de.justsoftware.onx.common.presentation.client.ui.components.InlineEditView;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class AbstractInlineEditView
extends Composite
implements InlineEditView {
    private static final InlineEditViewUiBinder UI_BINDER = (InlineEditViewUiBinder)GWT.create(InlineEditViewUiBinder.class);
    protected final InlineEditView.Presenter _presenter;
    @UiField
    FlowPanel _editPanel;
    @UiField
    InlineLabel _label;
    @UiField
    IconAnchor _editAnchor;
    @UiField
    TextBox _inputBox;
    @UiField
    HTMLPanel _buttonPanel;
    private boolean _preventNextBlur = false;

    public AbstractInlineEditView(InlineEditView.Presenter presenter, boolean showInlineEditButtons) {
        this._presenter = presenter;
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
        this._buttonPanel.setVisible(showInlineEditButtons);
    }

    @Nonnull
    protected abstract String getCurrentLabel();

    public void showLabel() {
        this._label.setText(this.getCurrentLabel());
        this.setStyleName("edit-mode", false);
    }

    public void showEditor() {
        this.setStyleName("edit-mode", true);
        this._inputBox.setSelectionRange(0, this._inputBox.getValue().length());
        this._inputBox.setFocus(true);
    }

    public void marksAsDirty(boolean dirty) {
        this.setStyleName("tainted", dirty);
    }

    @UiHandler(value={"_editAnchor"})
    public void editClick(ClickEvent event) {
        this._presenter.edit();
    }

    @UiHandler(value={"_label"})
    public void labelClick(ClickEvent event) {
        this._presenter.edit();
    }

    private void preventNextBlur() {
        this._preventNextBlur = true;
    }

    private void enableBlur() {
        this._preventNextBlur = false;
    }

    @UiHandler(value={"_cancelButton"})
    public void cancelMouseDown(MouseDownEvent event) {
        this.preventNextBlur();
    }

    @UiHandler(value={"_cancelButton"})
    public void cancelClick(ClickEvent event) {
        this._presenter.cancel();
    }

    @UiHandler(value={"_saveButton"})
    public void saveMouseDown(MouseDownEvent event) {
        this.preventNextBlur();
    }

    @UiHandler(value={"_saveButton"})
    public void saveClick(ClickEvent event) {
        this._presenter.save();
    }

    @UiHandler(value={"_inputBox"})
    public void blur(BlurEvent event) {
        if (!this._preventNextBlur) {
            this._presenter.blur();
        }
    }

    @UiHandler(value={"_inputBox"})
    public void keyDown(KeyDownEvent event) {
        switch (event.getNativeKeyCode()) {
            case 13: {
                this._presenter.save();
                this._inputBox.setFocus(false);
                event.stopPropagation();
                break;
            }
            case 27: {
                this._presenter.cancel();
                this._inputBox.setFocus(false);
                event.stopPropagation();
                break;
            }
        }
    }

    @UiHandler(value={"_inputBox"})
    public void onFocusInputBox(FocusEvent event) {
        this.enableBlur();
    }
}

