/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.freiheit.toro.util.client.WidgetUtil;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.InlineFeedbackWidget;
import de.justsoftware.onx.common.presentation.client.ui.ValidationTextUtil;
import de.justsoftware.onx.common.shared.model.ValidationError;
import java.util.Collection;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ValidatableWidget<T extends Widget>
extends Composite {
    protected final T _validatableWidget;
    private final InlineFeedbackWidget _errorMessageWidget = new InlineFeedbackWidget(InlineFeedbackWidget.InlineType.ERROR, false);
    @Nullable
    private String _fieldId;

    public ValidatableWidget(T validatableWidget) {
        this._validatableWidget = validatableWidget;
        FlowPanel panel = new FlowPanel();
        this.initWidget((Widget)panel);
        panel.add(this._validatableWidget);
        panel.add((Widget)this._errorMessageWidget);
    }

    public void displayErrorMessage(Map<String, Collection<ValidationError>> validationErrorMap) {
        String errorMsgs = ValidationTextUtil.getErrorMessagesForFieldId(validationErrorMap, (String)this._fieldId);
        if (errorMsgs.length() > 0) {
            this._errorMessageWidget.setMessage(errorMsgs.toString());
            this._errorMessageWidget.setVisible(true);
        }
    }

    public void displayErrorMessage(String message) {
        this._errorMessageWidget.setMessage(message);
        this._errorMessageWidget.setVisible(true);
    }

    public void clearErrorMessages() {
        this._errorMessageWidget.setVisible(false);
    }

    public void setFieldId(@Nullable String id) {
        this._fieldId = id;
    }

    @CheckForNull
    public String getFieldId() {
        return this._fieldId;
    }

    public void setVisible(boolean visible) {
        this._validatableWidget.setVisible(visible);
    }

    public boolean isVisible() {
        return this._validatableWidget.isVisible();
    }

    public void setAutocompleteOff() {
        WidgetUtil.setAutocompleteOff((UIObject)this._validatableWidget);
    }
}

