/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.freiheit.toro.util.client.LoggingUtil;
import com.google.common.base.Enums;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArrayString;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Panel;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.JavascriptGwtWidgetRenderer;
import de.justsoftware.onx.menu.presentation.client.presenter.ProfileMenuPresenterImpl;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public final class JavascriptGwtWidgetRenderer {
    private static final Map<String, Panel> WIDGET_PANEL = new HashMap();
    private static long _idSequence = 0L;
    private static ClientFactory _clientFactory;

    private JavascriptGwtWidgetRenderer() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_STATIC_REP2"}, justification="its fine here")
    public static void init(ClientFactory clientFactory) {
        _clientFactory = clientFactory;
        JavascriptGwtWidgetRenderer.initJavaScriptRenderer();
    }

    @Nonnull
    private static native JavaScriptObject initJavaScriptRenderer();

    @Nonnull
    private static String getNextWidgetId() {
        return String.valueOf(++_idSequence);
    }

    private static void remove(String widgetId) {
        Panel panel = (Panel)WIDGET_PANEL.get(widgetId);
        if (panel != null) {
            panel.clear();
            panel.removeFromParent();
            WIDGET_PANEL.remove(widgetId);
        }
    }

    @Nonnull
    private static String[] fromJsArray(@Nullable JsArrayString input) {
        if (input == null || input.length() == 0) {
            return new String[0];
        }
        int l = input.length();
        String[] result = new String[l];
        for (int i = 0; i < input.length(); ++i) {
            result[i] = input.get(i);
        }
        return result;
    }

    @CheckForNull
    private static String render(Element element, String widgetType, @Nullable JsArrayString jsParams) {
        WidgetType type = (WidgetType)Enums.getIfPresent(WidgetType.class, (String)widgetType).orNull();
        Object[] params = JavascriptGwtWidgetRenderer.fromJsArray((JsArrayString)jsParams);
        if (type == null) {
            LoggingUtil.error((Object)JavascriptGwtWidgetRenderer.class.getName(), (String)("Unkonwn gwt widget of type " + widgetType + " and params " + Arrays.toString(params)));
            return null;
        }
        try {
            HTMLPanel panel = HTMLPanel.wrap((Element)element);
            String widgetId = JavascriptGwtWidgetRenderer.getNextWidgetId();
            JavascriptGwtWidgetRenderer.addWidgetToPanel((Panel)panel, (WidgetType)type, (String[])params);
            WIDGET_PANEL.put(widgetId, panel);
            return widgetId;
        }
        catch (RuntimeException e) {
            LoggingUtil.error((Object)JavascriptGwtWidgetRenderer.class.getName(), (String)("Failed to create gwt widget of type " + widgetType + " and params " + Arrays.toString(params)), (Throwable)e);
            return null;
        }
    }

    private static void addWidgetToPanel(Panel panel, WidgetType type, String[] params) {
        if (!WidgetType.PROFILE_MENU.equals((Object)type)) {
            throw new IllegalStateException("Could not create gwt widget of type " + type + " and params " + Arrays.toString(params));
        }
        JavascriptGwtWidgetRenderer.addProfileMenu((Panel)panel);
    }

    private static void addProfileMenu(Panel panel) {
        panel.add(new ProfileMenuPresenterImpl(_clientFactory, _clientFactory.eventManager()).getView());
    }
}

