/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.shared.i18n.BasicMessages;
import com.github.gwtbootstrap.client.ui.Icon;
import com.github.gwtbootstrap.client.ui.base.IconAnchor;
import com.github.gwtbootstrap.client.ui.base.InlineLabel;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.collect.ImmutableList;
import com.google.gwt.aria.client.Roles;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.AbstractPagingWidget;
import de.justsoftware.onx.common.presentation.client.ui.PagingWidgetProvider;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import java.util.Iterator;
import javax.annotation.Nonnull;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractPagingWidget<T, C extends Widget>
extends Composite {
    protected static final int DEFAULT_ITEM_PER_PAGE = 5;
    private static final BasicConstants BASIC = I18nMediator.BASIC_CONSTANTS;
    private static final BasicMessages BASIC_MESSAGES = I18nMediator.BASIC_MESSAGES;
    private static final PagingWidgetUIBinder UI_BINDER = (PagingWidgetUIBinder)GWT.create(PagingWidgetUIBinder.class);
    @UiField
    FlowPanel _pagerTopPanel;
    @UiField
    FlowPanel _pagerBottomPanel;
    @UiField
    FlowPanel _content;
    @UiField
    FlowPanel _pagerTopActions;
    @UiField
    FlowPanel _pagerBottomActions;
    private final PagingWidgetProvider<T> _widgetProvider;
    private final FlowPanel _pagerTop = new FlowPanel();
    private final FlowPanel _pagerBottom = new FlowPanel();
    private int _itemPerPage;
    private int _maxCount = 0;
    private int _currentPage = 1;
    private boolean _simplePager = false;
    private boolean _showTopPager = true;
    private boolean _showBottomPager = true;
    private final int _maxPagerNextPreviousRange = 2;
    private ListAndCount<T> _currentPageData;
    private String _leftText;
    private String _rightText;
    private boolean _showCurrentPageInSimplePager = false;
    private int _contentAreaIdx;
    private final ImmutableList<C> _contentAreas;

    public AbstractPagingWidget(int itemPerPage, C contentArea, C buffer, @Nonnull PagingWidgetProvider<T> widgetProvider) {
        this._itemPerPage = itemPerPage;
        this._contentAreaIdx = 0;
        this._contentAreas = ImmutableList.of(contentArea, buffer);
        this._widgetProvider = widgetProvider;
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
        this._content.add((Widget)this._contentAreas.get(this._contentAreaIdx));
        this.setLeftText(BASIC.pagerBack());
        this.setRightText(BASIC.pagerForward());
        this.clearPagerBottomActionsPanel();
        this.clearPagerTopActionsPanel();
    }

    protected void addNavigationRole() {
        Roles.getNavigationRole().set((Element)this._pagerBottom.getElement());
        Roles.getNavigationRole().set((Element)this._pagerTop.getElement());
    }

    @Nonnull
    public C getContentArea() {
        return (C)((Widget)this._contentAreas.get(this._contentAreaIdx));
    }

    @Nonnull
    private C getBufferArea() {
        return (C)((Widget)this._contentAreas.get(this._contentAreaIdx ^ 1));
    }

    private void switchContentArea() {
        this._content.clear();
        this._content.add(this.getBufferArea());
        this.clearContentArea(this.getContentArea());
        this._contentAreaIdx ^= 1;
    }

    protected void createPager(Panel pagerPanel) {
        pagerPanel.clear();
        int lastPage = this.getMaxPage();
        if (this._itemPerPage > 0 && lastPage > 1) {
            pagerPanel.add(this.createPageButton(IconType.CHEVRON_LEFT, this._currentPage - 1));
            if (!this._simplePager) {
                pagerPanel.add(this.createPageButton("1", 1));
                int firstPagerPage = PagingUtils.checkFirstPagerPage((int)(this._currentPage - 2));
                int lastPagerPage = PagingUtils.checkLastPagerPage((int)(this._currentPage + 2), (int)lastPage);
                if (firstPagerPage > 2) {
                    pagerPanel.add(this.createPageButtonSpacing());
                }
                for (int i = firstPagerPage; i <= lastPagerPage; ++i) {
                    Widget pageButton = this.createPageButton(String.valueOf(i), i);
                    pagerPanel.add(pageButton);
                    if (i != this._currentPage) continue;
                    pageButton.addStyleName("pagerButtonCurrentPage");
                }
                if (lastPagerPage < lastPage - 1) {
                    pagerPanel.add(this.createPageButtonSpacing());
                }
                pagerPanel.add(this.createPageButton(String.valueOf(lastPage), lastPage));
            } else if (this._showCurrentPageInSimplePager) {
                pagerPanel.add(this.createCurrentPageButtonForSimplePager());
            }
            pagerPanel.add(this.createPageButton(IconType.CHEVRON_RIGHT, this._currentPage + 1));
        }
    }

    @Nonnull
    private Widget createCurrentPageButtonForSimplePager() {
        Widget pageButton = this.createPageButton(BASIC_MESSAGES.page(this._currentPage), this._currentPage);
        pageButton.addStyleName("pagerButtonCurrentPage");
        return pageButton;
    }

    @Nonnull
    private Widget createPageButtonSpacing() {
        InlineLabel spacing = new InlineLabel("...");
        spacing.setStyleName("pagerButtonSpacing");
        return spacing;
    }

    @Nonnull
    private Widget createPageButton(@Nonnull IconType icon, int page) {
        if (page > 0 && page <= this.getMaxPage() && page != this._currentPage) {
            IconAnchor anchor = new IconAnchor();
            anchor.addStyleName("pagerButton");
            anchor.addStyleName("app-hover-color");
            anchor.setIcon(icon);
            anchor.addClickHandler((ClickHandler)new PagingClickHandler(this, page));
            return anchor;
        }
        Icon pagerIcon = new Icon(icon);
        pagerIcon.addStyleName("pagerButton");
        return pagerIcon;
    }

    @Nonnull
    private Widget createPageButton(@Nonnull String labelText, int page) {
        if (page > 0 && page <= this.getMaxPage() && page != this._currentPage) {
            Anchor pageLink = new Anchor(labelText);
            pageLink.addClickHandler((ClickHandler)new PagingClickHandler(this, page));
            pageLink.addStyleName("pagerButton");
            pageLink.addStyleName("app-hover-color");
            return pageLink;
        }
        InlineLabel label = new InlineLabel(labelText);
        label.addStyleName("pagerButton");
        label.addStyleName("pagerButtonDisabled");
        return label;
    }

    protected abstract void clearContentArea(C var1);

    protected abstract void createItem(C var1, T var2, int var3, boolean var4, boolean var5);

    protected abstract void createNoDataView(C var1);

    public ListAndCount<T> getCurrentPageData() {
        return this._currentPageData;
    }

    protected void clearPagerTop() {
        this._pagerTop.clear();
    }

    protected void clearPagerBottom() {
        this._pagerBottom.clear();
    }

    private void markInactivePager(boolean mark) {
        String css = "inactive";
        if (mark) {
            this.getPagerBottomPanel().addStyleName("inactive");
        } else {
            this.getPagerBottomPanel().removeStyleName("inactive");
        }
    }

    public void setCurrentPageData(int offsetOfListAndCountData, int limitOfListAndCountData, ListAndCount<T> currentPageData) {
        this._currentPageData = currentPageData;
        this._itemPerPage = limitOfListAndCountData;
        this.clearPagerTop();
        this.getPagerTopPanel().setVisible(false);
        this.clearPagerBottom();
        this.getPagerBottomPanel().setVisible(false);
        this.markInactivePager(false);
        if (currentPageData == null || currentPageData.getMaxCount() == 0) {
            this._maxCount = 0;
            this._currentPage = 1;
            this.clearContentArea(this.getContentArea());
            this.createNoDataView(this.getContentArea());
            return;
        }
        this._maxCount = currentPageData.getMaxCount();
        this._currentPage = this.getPageOfItemIndex(offsetOfListAndCountData);
        if (this._maxCount > 0 && currentPageData.size() == 0 && this._currentPage > 1) {
            this.clearContentArea(this.getContentArea());
            this.setCurrentPage(this.getMaxPage());
            return;
        }
        if (this._showTopPager) {
            if (!this.getPagerTopPanel().iterator().hasNext()) {
                this.getPagerTopPanel().add((Widget)this._pagerTop);
            }
            this.createPager((Panel)this._pagerTop);
            this.getPagerTopPanel().setVisible(true);
        } else {
            this.getPagerTopPanel().setVisible(false);
        }
        int index = offsetOfListAndCountData;
        Iterator it = currentPageData.iterator();
        boolean first = true;
        this.clearContentArea(this.getBufferArea());
        while (it.hasNext()) {
            Object next = it.next();
            this.createItem(this.getBufferArea(), next, index, first, !it.hasNext());
            ++index;
            if (!first) continue;
            first = false;
        }
        this.switchContentArea();
        if (this._showBottomPager) {
            if (!this.getPagerBottomPanel().iterator().hasNext()) {
                this.getPagerBottomPanel().add((Widget)this._pagerBottom);
            }
            this.createPager((Panel)this._pagerBottom);
            this.getPagerBottomPanel().setVisible(true);
        } else {
            this.getPagerBottomPanel().setVisible(false);
        }
        this.markInactivePager(this._maxCount <= this._itemPerPage);
    }

    public int getPageOfItemIndex(int itemIndex) {
        int page = (itemIndex + 1) / this._itemPerPage;
        if ((itemIndex + 1) % this._itemPerPage != 0) {
            ++page;
        }
        return page;
    }

    public int getMaxPage() {
        return this.getPageOfItemIndex(this._maxCount - 1);
    }

    public int getMaxCount() {
        return this._maxCount;
    }

    public void setCurrentPage(int page) {
        this._currentPage = page;
        this.buildPage(this._currentPage);
    }

    public int getCurrentPage() {
        return this._currentPage;
    }

    protected void buildPage(int page) {
        int offset = (page - 1) * this._itemPerPage;
        this._widgetProvider.getListAndCount(offset, this._itemPerPage, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setSimplePager(boolean simplePager) {
        this._simplePager = simplePager;
    }

    public void setShowBottomPager(boolean showBottomPager) {
        this._showBottomPager = showBottomPager;
    }

    public void setShowTopPager(boolean showTopPager) {
        this._showTopPager = showTopPager;
    }

    public boolean isShowBottomPager() {
        return this._showBottomPager;
    }

    public boolean isShowTopPager() {
        return this._showTopPager;
    }

    public void update() {
        this.setCurrentPage(this.getCurrentPage());
    }

    public int getItemPerPage() {
        return this._itemPerPage;
    }

    public int getOffset() {
        return (this._currentPage - 1) * this._itemPerPage;
    }

    public void setItemPerPage(int itemPerPage) {
        this._itemPerPage = itemPerPage;
    }

    public String getLeftText() {
        return this._leftText;
    }

    public void setLeftText(String leftText) {
        this._leftText = leftText;
    }

    public String getRightText() {
        return this._rightText;
    }

    public void setRightText(String rightText) {
        this._rightText = rightText;
    }

    protected Panel getPagerTopPanel() {
        return this._pagerTopPanel;
    }

    protected Panel getPagerBottomPanel() {
        return this._pagerBottomPanel;
    }

    public void clearPagerBottomActionsPanel() {
        this._pagerBottomActions.clear();
        this._pagerBottomActions.setVisible(false);
    }

    public void addPagerBottomActions(IsWidget action) {
        this._pagerBottomActions.add(action);
        this._pagerBottomActions.setVisible(true);
    }

    public void clearPagerTopActionsPanel() {
        this._pagerTopActions.clear();
        this._pagerTopActions.setVisible(false);
    }

    public void addPagerTopActions(IsWidget action) {
        this._pagerTopActions.add(action);
        this._pagerTopActions.setVisible(true);
    }

    public void setPagerTopActionsVisible(boolean visible) {
        this._pagerTopActions.setVisible(visible);
    }

    public void setShowCurrentPageInSimplePager(boolean showCurrentPage) {
        this._showCurrentPageInSimplePager = showCurrentPage;
    }

    public void clear() {
        this.clearContentArea(this.getContentArea());
        this.clearPagerBottom();
    }
}

