/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.calendar.presentation.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiFactory;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.calendar.presentation.client.CalendarDataProvider;
import de.justsoftware.onx.calendar.presentation.client.CalendarViewHandler;
import de.justsoftware.onx.calendar.presentation.client.ui.Calendar;
import de.justsoftware.onx.calendar.presentation.client.ui.CalendarView;
import de.justsoftware.onx.calendar.presentation.client.ui.CalendarViewInfoPopupPanel;
import de.justsoftware.onx.calendar.presentation.client.ui.MonthView;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.PopupCloseHelper;
import de.justsoftware.onx.common.presentation.client.ui.WaitSpinner;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.shared.model.EntityType;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Calendar
extends Composite {
    private static final CalendarUIBinder BINDER = (CalendarUIBinder)GWT.create(CalendarUIBinder.class);
    @UiField
    FlowPanel _content;
    @UiField
    JCButton _todayLink;
    @UiField
    JCButton _previousLink;
    @UiField
    JCButton _nextLink;
    @UiField
    Label _titleLabel;
    @UiField
    HTMLPanel _headerPanel;
    @UiField
    FlowPanel _createButtonPanel;
    @UiField
    WaitSpinner _loadingSpinner;
    private Date _selectedDate;
    private CalendarView _view;
    private final CalendarDataProvider _dataProvider;
    private final CalendarViewHandler _calendarViewHandler;
    private final PopupCloseHelper _popupCloseHelper;

    public Calendar(boolean mayCreate, CalendarDataProvider dataProvider, @Nullable Date selectedDate, int viewWidht, int viewHeight, EntityType type, CalendarViewHandler calendarViewHandler, ClientFactory clientFactory) {
        this._dataProvider = dataProvider;
        this._popupCloseHelper = clientFactory.commonClientFactory().newPopupCloseHelper();
        this._popupCloseHelper.setHistoryMode(PopupCloseHelper.HistoyMode.IGNORE_HISTORY_CHANGE);
        this._popupCloseHelper.setHandler((PopupCloseHelper.ClosePopupClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.initWidget((Widget)BINDER.createAndBindUi((Object)this));
        this._selectedDate = Dates.clone((Date)selectedDate);
        this._calendarViewHandler = calendarViewHandler;
        this.setView((CalendarView)new MonthView(viewWidht, viewHeight, mayCreate, type, clientFactory));
        this._popupCloseHelper.ignoreElement((Element)CalendarViewInfoPopupPanel.PopupPriority.PRIMARY.getInstance().getElement());
        this._popupCloseHelper.ignoreElement((Element)CalendarViewInfoPopupPanel.PopupPriority.SECONDARY.getInstance().getElement());
    }

    @Nonnull
    @UiFactory
    Anchor createAnchor() {
        return new Anchor(true);
    }

    @UiHandler(value={"_todayLink"})
    void handleTodayClick(ClickEvent event) {
        this.setSelectedDate(new Date());
    }

    @UiHandler(value={"_previousLink"})
    void handlePreviousLinkClick(ClickEvent event) {
        this.setSelectedDate(Dates.addMonth((Date)this.getSelectedDate(), (int)-1));
    }

    @UiHandler(value={"_nextLink"})
    void handleNextLinkClick(ClickEvent event) {
        this.setSelectedDate(Dates.addMonth((Date)this.getSelectedDate(), (int)1));
    }

    protected void onLoad() {
        super.onLoad();
        this._popupCloseHelper.registerHandler();
    }

    protected void onUnload() {
        super.onUnload();
        this._popupCloseHelper.unregisterHandler();
    }

    public void setView(CalendarView view) {
        this._content.clear();
        this._view = view;
        this._content.add((Widget)this._view);
        this._headerPanel.setWidth(this._view.getViewWidth() + "px");
        this.updateView();
    }

    public void setSelectedDate(@Nullable Date selectedDate) {
        Date oldSelectedDate = this._selectedDate;
        this._selectedDate = Dates.clone((Date)selectedDate);
        if (!Dates.areOnTheSameDay((Date)oldSelectedDate, (Date)this._selectedDate)) {
            CalendarViewInfoPopupPanel.hidePopups((CalendarViewInfoPopupPanel.PopupPriority)CalendarViewInfoPopupPanel.PopupPriority.PRIMARY);
            CalendarViewInfoPopupPanel.hidePopups((CalendarViewInfoPopupPanel.PopupPriority)CalendarViewInfoPopupPanel.PopupPriority.SECONDARY);
            this.updateView();
        }
    }

    @Nonnull
    public Date getSelectedDate() {
        return Dates.clone((Date)this._selectedDate);
    }

    private void updateView() {
        this._view.updateView(this);
        this._titleLabel.setText(this._view.getViewTitle(this));
    }

    public void addButtonToCreateButtonPanel(JCButton button) {
        this._createButtonPanel.add((Widget)button);
    }

    public void clearButtonToCreateButtonPanel() {
        this._createButtonPanel.clear();
    }

    @Nonnull
    public CalendarDataProvider getDataProvider() {
        return this._dataProvider;
    }

    @Nonnull
    public CalendarViewHandler getCalendarViewHandler() {
        return this._calendarViewHandler;
    }

    public void setDataLoadingInProgress(boolean value) {
        this._loadingSpinner.setVisible(value);
    }
}

