/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.album.presentation.client.ui;

import com.freiheit.toro.common.presentation.ui.NoHistoryHyperlink;
import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.freiheit.toro.common.shared.util.ImageSize;
import com.freiheit.toro.common.shared.util.ImageUrlUtil;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.album.presentation.client.AlbumMediator;
import de.justsoftware.onx.album.presentation.client.events.ImageTitleChangedEvent;
import de.justsoftware.onx.album.presentation.client.ui.AlbumWidget;
import de.justsoftware.onx.album.presentation.client.ui.ImageTeaserWidget;
import de.justsoftware.onx.album.shared.model.AlbumImage;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.common.presentation.client.ui.InPlaceOneLineTextBox;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ImageTeaserWidget
extends Composite {
    private static final ImageTeaserWidgetUIBinder UI_BINDER = (ImageTeaserWidgetUIBinder)GWT.create(ImageTeaserWidgetUIBinder.class);
    @UiField
    DivElement _imageSelectContainer;
    @UiField
    CheckBox _checkbox;
    @UiField
    SimplePanel _imagePanel;
    @UiField
    FlowPanel _titlePanel;
    @UiField
    InPlaceOneLineTextBox _title;
    @UiField
    NoHistoryHyperlink _insertImage;
    private final AlbumImage _image;
    private final EventManager.EventManagerHelper _eventManagerHelper;

    public ImageTeaserWidget(@Nonnull AlbumImage image, @Nullable AlbumWidget.ImageClickCallback imageClickCallback, boolean insertImageVisible, boolean imageTitleVisible, @Nonnull EventManager eventManager) {
        this._image = image;
        this._eventManagerHelper = new EventManager.EventManagerHelper(eventManager);
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
        Image i = new Image(ImageUrlUtil.getFullAlbumImageUrl((ImageSize)ImageSize.BIG, (String)image.getFilename()));
        if (imageClickCallback != null) {
            ClickHandler clickHandler = event -> imageClickCallback.onClick(this._image);
            i.addClickHandler(clickHandler);
            this._insertImage.addClickHandler(clickHandler);
            i.addStyleName("clickable");
        }
        this._imagePanel.setWidget((Widget)i);
        boolean titlePanelVisible = this.isTitlePanelVisible(imageTitleVisible);
        this._titlePanel.setVisible(titlePanelVisible);
        if (titlePanelVisible) {
            this._title.setValue((Object)image.getTitle());
            this._title.setEditLinkText("");
            this._title.setAsyncEnabled(true);
            this._title.setMaxLength(255);
            this._title.addValueChangeHandler(event -> AlbumMediator.getInstance().updateImageTitle(this._image.getId(), (String)event.getValue(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
            this._title.setEditable(image.getMay().contains((Object)StaticAction.ALBUM_UPDATE));
        }
        UIObject.setVisible((Element)this._imageSelectContainer, (boolean)image.getMay().contains((Object)StaticAction.ALBUM_DELETE));
        this._insertImage.setVisible(insertImageVisible);
    }

    private boolean isTitlePanelVisible(boolean imageTitleVisible) {
        return imageTitleVisible && (this._image.getMay().contains((Object)StaticAction.ALBUM_UPDATE) || ClientStringUtil.hasText((String)this._image.getTitle()));
    }

    public boolean isDeleteSelected() {
        return this._image.getMay().contains((Object)StaticAction.ALBUM_DELETE) && Boolean.TRUE.equals(this._checkbox.getValue());
    }

    @Nonnull
    public AlbumImage getImage() {
        return this._image;
    }

    protected void onLoad() {
        super.onLoad();
        this._eventManagerHelper.registerListener(ImageTitleChangedEvent.class, event -> {
            if (this._image.getId().equals((Object)event.getId())) {
                this._title.setValue((Object)event.getNewTitle());
            }
        });
    }

    protected void onUnload() {
        super.onUnload();
        this._eventManagerHelper.onUnloadRemoveHandlersFromManager();
    }
}

