/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.album.presentation.client.ui;

import com.freiheit.toro.client.Toro;
import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.ui.NoHistoryHyperlink;
import com.freiheit.toro.common.shared.i18n.AlbumConstants;
import com.github.gwtbootstrap.client.ui.base.IconAnchor;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.base.MoreObjects;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.LoadHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.album.presentation.client.ui.ImageEditPopup;
import de.justsoftware.onx.common.presentation.client.ui.IntegerTextBox;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.JCDialogBox;
import de.justsoftware.onx.common.presentation.client.ui.ValidatorPanel;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.util.StringUtil;
import javax.annotation.Nonnull;

public class ImageEditPopup
extends JCDialogBox {
    private static final AlbumConstants ALBUM = I18nMediator.ALBUM;
    private static final BasicConstants BASIC = I18nMediator.BASIC_CONSTANTS;
    private static final int DISPLAY_WIDTH = 150;
    private static final int DISPLAY_HEIGHT = 150;
    private static final ImageEditPopupUIBinder UI_BINDER = (ImageEditPopupUIBinder)GWT.create(ImageEditPopupUIBinder.class);
    @UiField
    Image _image;
    @UiField
    RadioButton _radioAutomaticSize;
    @UiField
    RadioButton _radioManualSize;
    @UiField
    IconAnchor _fitWidthImage;
    @UiField
    IconAnchor _orgSizeImage;
    @UiField
    IconAnchor _lockAspectImage;
    @UiField
    IntegerTextBox _width;
    @UiField
    IntegerTextBox _height;
    @UiField
    IntegerTextBox _hspace;
    @UiField
    IntegerTextBox _vspace;
    @UiField
    IntegerTextBox _border;
    @UiField
    TextBox _alt;
    @UiField
    ListBox _align;
    @UiField
    Panel _additionalSettingsPanel;
    @UiField
    Panel _manualSizePanel;
    @UiField
    NoHistoryHyperlink _additionalSettingsLabel;
    private final JCButton _close = new JCButton(BASIC.close());
    private final JCButton _save = new JCButton(BASIC.save());
    private final String _url;
    private final int _editorWidth;
    private int _orgWidth;
    private int _orgHeight;
    private boolean _orgSizeKnown = false;
    private int _currentWidth;
    private int _currentHeight;
    private boolean _currentSizeKnown;
    private final ImageEditCallback _imageEditCallback;
    private boolean _lockAspect = true;
    private boolean _autoSize = true;
    private final ValidatorPanel.ValidatorPanelUtils _validatorPanelUtils = new ValidatorPanel.ValidatorPanelUtils();

    public ImageEditPopup(int editorWidth, String url, String width, String height, String hspace, String vspace, String border, String align, String alt, @Nonnull ImageEditCallback imageEditCallback) {
        super(false, true, ALBUM.imageSettings());
        this._editorWidth = editorWidth;
        this._url = url;
        this._imageEditCallback = imageEditCallback;
        this.setContent((IsWidget)UI_BINDER.createAndBindUi((Object)this));
        this.setUpAlignList();
        this._hspace.setIntValue(StringUtil.parsePixels((String)hspace, (int)0));
        this._vspace.setIntValue(StringUtil.parsePixels((String)vspace, (int)0));
        this._border.setIntValue(StringUtil.parsePixels((String)border, (int)0));
        this.setAlign(align);
        this._alt.setText((String)MoreObjects.firstNonNull((Object)alt, (Object)""));
        try {
            this._currentHeight = StringUtil.parsePixels((String)height);
            this._currentWidth = StringUtil.parsePixels((String)width);
            this._currentSizeKnown = true;
        }
        catch (NumberFormatException e) {
            this._currentSizeKnown = false;
        }
        if (this._currentSizeKnown) {
            this._width.setText("" + this._currentWidth);
            this._height.setText("" + this._currentHeight);
        }
        Image measureSizeImage = new Image();
        measureSizeImage.setStyleName("measureSizeImage");
        measureSizeImage.addLoadHandler((LoadHandler)new /* Unavailable Anonymous Inner Class!! */);
        measureSizeImage.setUrl(this._url);
        Toro.MEASURE_IMAGE_SIZE_PANEL.add((Widget)measureSizeImage);
        this.addHandlers();
        this.addButton(this._save);
        this.addButton(this._close);
        this.initValidation();
    }

    private void addHandlers() {
        this._width.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this._height.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this._save.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this._close.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initValidation() {
        this._width.setMandatory(true);
        this._width.setMinValue(1);
        this._width.setMaxValue(Integer.MAX_VALUE);
        this._width.setFieldName(ALBUM.width());
        this._validatorPanelUtils.addWrappedValidatable((Widget)this._width);
        this._height.setMandatory(true);
        this._height.setMinValue(1);
        this._height.setMaxValue(Integer.MAX_VALUE);
        this._height.setFieldName(ALBUM.height());
        this._validatorPanelUtils.addWrappedValidatable((Widget)this._height);
        this._hspace.setMandatory(true);
        this._hspace.setMinValue(0);
        this._hspace.setMaxValue(Integer.MAX_VALUE);
        this._hspace.setFieldName(ALBUM.horizontalSpace());
        this._validatorPanelUtils.addWrappedValidatable((Widget)this._hspace);
        this._vspace.setMandatory(true);
        this._vspace.setMinValue(0);
        this._vspace.setMaxValue(Integer.MAX_VALUE);
        this._vspace.setFieldName(ALBUM.horizontalSpace());
        this._validatorPanelUtils.addWrappedValidatable((Widget)this._vspace);
        this._border.setMandatory(true);
        this._border.setMinValue(0);
        this._border.setMaxValue(Integer.MAX_VALUE);
        this._border.setFieldName(ALBUM.horizontalSpace());
        this._validatorPanelUtils.addWrappedValidatable((Widget)this._border);
    }

    private void setUpAlignList() {
        this._align.addItem(ALBUM.alignTopBottom(), "");
        this._align.addItem(ALBUM.alignLeft(), "left");
        this._align.addItem(ALBUM.alignRight(), "right");
    }

    private void setAlign(String align) {
        for (int i = 0; i < this._align.getItemCount(); ++i) {
            if (!this._align.getValue(i).equals(align)) continue;
            this._align.setSelectedIndex(i);
            return;
        }
        this._align.setSelectedIndex(0);
    }

    private void setAutoSize(boolean autoSize) {
        this._manualSizePanel.setVisible(!autoSize);
        this._autoSize = autoSize;
    }

    private String getAlign() {
        return this._align.getValue(this._align.getSelectedIndex());
    }

    private void gotImageSize(int width, int height) {
        this._orgWidth = width;
        this._orgHeight = height;
        this._orgSizeKnown = true;
        float scaleX = 150.0f / (float)width;
        float scaleY = 150.0f / (float)height;
        float scale = Math.min(scaleX, scaleY);
        this._image.setWidth(scale * (float)width + "px");
        this._image.setHeight(scale * (float)height + "px");
        this._image.setUrl(this._url);
        if (!this._currentSizeKnown) {
            this._width.setIntValue(this._orgWidth);
            this._height.setIntValue(this._orgHeight);
        }
    }

    @UiHandler(value={"_radioAutomaticSize"})
    void onSetAutomaticSize(ValueChangeEvent<Boolean> e) {
        this.setAutoSize(((Boolean)e.getValue()).booleanValue());
    }

    @UiHandler(value={"_radioManualSize"})
    void onSetManualSize(ValueChangeEvent<Boolean> e) {
        this.setAutoSize((Boolean)e.getValue() == false);
    }

    @UiHandler(value={"_fitWidthImage"})
    void onFitWidth(ClickEvent e) {
        if (this._orgSizeKnown) {
            this._width.setIntValue(this._editorWidth);
            if (this._lockAspect) {
                this._height.setIntValue(this._editorWidth * this._orgHeight / this._orgWidth);
            }
        }
    }

    @UiHandler(value={"_orgSizeImage"})
    void onOrgSize(ClickEvent e) {
        if (this._orgSizeKnown) {
            this._width.setIntValue(this._orgWidth);
            this._height.setIntValue(this._orgHeight);
        }
    }

    @UiHandler(value={"_lockAspectImage"})
    void onToggleLockAspect(ClickEvent e) {
        boolean bl = this._lockAspect = !this._lockAspect;
        if (this._lockAspect) {
            this._lockAspectImage.setIcon(IconType.LOCK);
            this._lockAspectImage.setTitle(ALBUM.lockAspectRatio());
        } else {
            this._lockAspectImage.setIcon(IconType.UNLOCK);
            this._lockAspectImage.setTitle(ALBUM.unlockAspectRatio());
        }
    }

    @UiHandler(value={"_additionalSettingsLabel"})
    void onToggleAdittionalSettings(ClickEvent e) {
        this._additionalSettingsPanel.setVisible(!this._additionalSettingsPanel.isVisible());
        this._additionalSettingsLabel.setText(this._additionalSettingsPanel.isVisible() ? ALBUM.hideAdditionalSettings() : ALBUM.showAdditionalSettings());
    }
}

