/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gwt.user.client.ui;

import com.freiheit.toro.client.mediator.HistoryManager;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.HandlerRegistration;
import de.justsoftware.gwt.user.client.ui.MessageComposerPresenter;
import de.justsoftware.gwt.user.client.ui.MessageComposerView;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.shared.util.StringUtil;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MessageComposerPresenter<T>
implements MessageComposerView.Presenter {
    protected final MessageComposerView _view;
    private final ClientFactory _clientfactory;
    private final ParentPresenter<T> _parent;
    private boolean _autoHideSubmitPanel = false;
    private boolean _submitPanelVisible = false;
    private ImmutableSet<String> _forbiddenTexts = ImmutableSet.of();
    private String _originalText;
    private HandlerRegistration _confirmEventRegistration;

    public MessageComposerPresenter(ClientFactory clientfactory, ParentPresenter<T> parent, String textPlaceholder) {
        this(clientfactory, parent, (MessageComposerView)clientfactory.commonClientFactory().messageComposerView(textPlaceholder));
    }

    public MessageComposerPresenter(ClientFactory clientfactory, ParentPresenter<T> parent, MessageComposerView view) {
        this._clientfactory = clientfactory;
        this._parent = parent;
        this._view = view;
        this._view.setPresenter((MessageComposerView.Presenter)this);
        this._originalText = this._view.getText();
    }

    public void setFocus(boolean focused) {
        this._view.setFocus(focused);
    }

    public void onCancel() {
        this._parent.onCancel();
    }

    public void onSubmit() {
        this._view.setSubmitEnabled(false);
        this._view.setMessageTextEnabled(false);
        this._parent.onSubmit(this._view.getText(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onUpdate() {
        this.updateSubmitEnabled();
    }

    public void onFocus() {
        this.setSubmitPanelVisible(true);
    }

    public void onBlur() {
        if (StringUtil.isBlank((String)this._view.getText())) {
            this.setSubmitPanelVisible(false);
        }
    }

    private void setSubmitPanelVisible(boolean submitPanelVisible) {
        this._submitPanelVisible = submitPanelVisible;
        this.updateSubmitPanelVisible();
    }

    public void setAutoHideSubmitPanel(boolean autoHideSubmitPanel) {
        this._autoHideSubmitPanel = autoHideSubmitPanel;
        this.updateSubmitPanelVisible();
    }

    private void updateSubmitPanelVisible() {
        this._view.setSubmitPanelVisible(!this._autoHideSubmitPanel || this._submitPanelVisible);
    }

    public void setText(String text) {
        this._originalText = text;
        this._view.setText(text);
        this.onUpdate();
    }

    public void setForbiddenTexts(ImmutableSet<String> forbiddenTexts) {
        this._forbiddenTexts = FluentIterable.from(forbiddenTexts).transform(String::trim).toSet();
        this.updateSubmitEnabled();
    }

    private void updateSubmitEnabled() {
        this._view.setSubmitEnabled(!this._forbiddenTexts.contains((Object)this._view.getText().trim()));
    }

    public void setSubmitButtonText(String submitButtonText) {
        this._view.setSubmitButtonText(submitButtonText);
    }

    public void setCancelVisible(boolean cancelVisible) {
        this._view.setCancelVisible(cancelVisible);
    }

    @OverridingMethodsMustInvokeSuper
    public void onAttachOrDetach(boolean attached) {
        if (this._confirmEventRegistration != null) {
            this._confirmEventRegistration.removeHandler();
        }
        this._confirmEventRegistration = attached ? this._clientfactory.historyManager().confirmNextHistoryChange((HistoryManager.ConfirmHistoryChangeCallback)new MessageComposerConfirmHistoryChangeCallback(this)) : null;
    }
}

