/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gwt.requestcollect.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
final class RequestProfilerNode {
    final String _methodName;
    private boolean _failure = false;
    private boolean _reqestReturned = false;
    private final long _start;
    private long _return = -1L;
    private boolean _callbackFinished = false;
    private long _finish = -1L;
    private final RequestProfilerNode _parentNode;
    private final List<RequestProfilerNode> _children = Lists.newLinkedList();

    RequestProfilerNode(@Nonnull String methodName, @Nullable RequestProfilerNode parentNode) {
        this._parentNode = parentNode;
        this._start = RequestProfilerNode.now();
        this._methodName = methodName;
        if (this._parentNode != null) {
            this._parentNode.addChild(this);
        }
    }

    private void addChild(@Nonnull RequestProfilerNode requestProfilerNode) {
        this._children.add(requestProfilerNode);
    }

    void requestReturned(boolean failure) {
        if (this._reqestReturned) {
            throw new IllegalStateException("request (" + this._methodName + ") allready returned");
        }
        this._return = RequestProfilerNode.now();
        this._failure = failure;
        this._reqestReturned = true;
    }

    void callbackFinished() {
        if (this._callbackFinished) {
            throw new IllegalStateException("callback (" + this._methodName + ") already finished");
        }
        this._finish = RequestProfilerNode.now();
        this._callbackFinished = true;
    }

    boolean isFinished() {
        if (!this._callbackFinished) {
            return false;
        }
        for (RequestProfilerNode child : this._children) {
            if (child.isFinished()) continue;
            return false;
        }
        return true;
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    @Nonnull
    public String buildMethodName() {
        return this._failure ? this._methodName + "(onFailure)" : this._methodName;
    }

    @Nonnull
    LinkedList<RequestProfilerNode> getPath() {
        RequestProfilerNode currentNode = this;
        LinkedList path = Lists.newLinkedList();
        path.addFirst(currentNode);
        while (currentNode._parentNode != null) {
            currentNode = currentNode._parentNode;
            path.addFirst(currentNode);
        }
        return path;
    }

    long getCallbackDuration() {
        return this._finish - this._return;
    }

    long getRequestDuration() {
        return this._return - this._start;
    }

    @Nonnull
    List<RequestProfilerNode> getChildren() {
        return ImmutableList.copyOf((Collection)this._children);
    }
}

