/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.kafka.search;

import de.justsoftware.news.events.ChannelCreatedEvent;
import de.justsoftware.news.events.ChannelDeletedEvent;
import de.justsoftware.news.events.ChannelPermissionChangedEvent;
import de.justsoftware.news.events.ChannelUpdatedEvent;
import de.justsoftware.news.events.PostDeletedEvent;
import de.justsoftware.news.events.PostPublishedEvent;
import de.justsoftware.news.events.PostUpdatedEvent;
import de.justsoftware.news.id.PostId;
import de.justsoftware.news.id.SearchableItemId;
import de.justsoftware.news.kafka.search.SearchIndexType;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B-\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0016H\u0017J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0018H\u0017J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u001aH\u0017J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u001bH\u0017R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lde/justsoftware/news/kafka/search/KafkaSearchProducer;", "", "producer", "Lorg/apache/kafka/clients/producer/KafkaProducer;", "Lde/justsoftware/news/id/SearchableItemId;", "Lde/justsoftware/news/kafka/search/SearchIndexType;", "itemChangedProducer", "", "(Lorg/apache/kafka/clients/producer/KafkaProducer;Lorg/apache/kafka/clients/producer/KafkaProducer;)V", "addToSearchIndexQueue", "", "itemIds", "", "indexChannel", "channelEvent", "Lde/justsoftware/news/events/ChannelCreatedEvent;", "channelUpdatedEvent", "Lde/justsoftware/news/events/ChannelUpdatedEvent;", "indexChannelPermissionChanges", "event", "Lde/justsoftware/news/events/ChannelPermissionChangedEvent;", "indexDeletedChannel", "Lde/justsoftware/news/events/ChannelDeletedEvent;", "indexDeletedPost", "Lde/justsoftware/news/events/PostDeletedEvent;", "indexPost", "Lde/justsoftware/news/events/PostPublishedEvent;", "Lde/justsoftware/news/events/PostUpdatedEvent;", "news-service"})
@SourceDebugExtension(value={"SMAP\nKafkaSearchProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KafkaSearchProducer.kt\nde/justsoftware/news/kafka/search/KafkaSearchProducer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1855#2,2:100\n1855#2,2:102\n*S KotlinDebug\n*F\n+ 1 KafkaSearchProducer.kt\nde/justsoftware/news/kafka/search/KafkaSearchProducer\n*L\n33#1:100,2\n52#1:102,2\n*E\n"})
public class KafkaSearchProducer {
    @NotNull
    private final KafkaProducer<SearchableItemId, SearchIndexType> producer;
    @NotNull
    private final KafkaProducer<String, String> itemChangedProducer;

    public KafkaSearchProducer(@NotNull KafkaProducer<SearchableItemId, SearchIndexType> producer, @NotNull KafkaProducer<String, String> itemChangedProducer) {
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        Intrinsics.checkNotNullParameter(itemChangedProducer, (String)"itemChangedProducer");
        this.producer = producer;
        this.itemChangedProducer = itemChangedProducer;
    }

    public void addToSearchIndexQueue(@NotNull Set<? extends SearchableItemId> itemIds) {
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        Iterable $this$forEach$iv = itemIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SearchableItemId it = (SearchableItemId)element$iv;
            boolean bl = false;
            this.producer.send(new ProducerRecord("just.news.searchIndexQueue", (Object)it, (Object)SearchIndexType.FULL));
        }
    }

    @Async
    @EventListener
    public void indexChannel(@NotNull ChannelUpdatedEvent channelUpdatedEvent) {
        Intrinsics.checkNotNullParameter((Object)channelUpdatedEvent, (String)"channelUpdatedEvent");
        this.producer.send(new ProducerRecord("just.news.searchIndexQueue", (Object)channelUpdatedEvent.getChannelId(), (Object)SearchIndexType.FULL));
    }

    @Async
    @EventListener
    public void indexChannel(@NotNull ChannelCreatedEvent channelEvent) {
        Intrinsics.checkNotNullParameter((Object)channelEvent, (String)"channelEvent");
        this.producer.send(new ProducerRecord("just.news.searchIndexQueue", (Object)channelEvent.getChannelId(), (Object)SearchIndexType.CONTENT));
    }

    @Async
    @EventListener
    public void indexDeletedChannel(@NotNull ChannelDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.producer.send(new ProducerRecord("just.news.searchIndexQueue", (Object)event.getChannelId(), (Object)SearchIndexType.DELETED));
        Iterable $this$forEach$iv = event.getPostIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PostId it = (PostId)element$iv;
            boolean bl = false;
            this.producer.send(new ProducerRecord("just.news.searchIndexQueue", (Object)it, (Object)SearchIndexType.DELETED));
        }
    }

    @Async
    @EventListener
    public void indexChannelPermissionChanges(@NotNull ChannelPermissionChangedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.producer.send(new ProducerRecord("just.news.searchIndexQueue", (Object)event.getChannelId(), (Object)SearchIndexType.PERMISSIONS));
        this.itemChangedProducer.send(new ProducerRecord("just.item.visibilityChanged", (Object)event.getChannelId().toTypedString(), null));
    }

    @Async
    @EventListener
    public void indexPost(@NotNull PostPublishedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.producer.send(new ProducerRecord("just.news.searchIndexQueue", (Object)event.getPost().getId(), (Object)SearchIndexType.FULL));
        this.itemChangedProducer.send(new ProducerRecord("just.item.visibilityChanged", (Object)event.getPost().getId().toTypedString(), null));
    }

    @Async
    @EventListener
    public void indexPost(@NotNull PostUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.producer.send(new ProducerRecord("just.news.searchIndexQueue", (Object)event.getPostId(), (Object)SearchIndexType.FULL));
    }

    @Async
    @EventListener
    public void indexDeletedPost(@NotNull PostDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.producer.send(new ProducerRecord("just.news.searchIndexQueue", (Object)event.getPostId(), (Object)SearchIndexType.DELETED));
        this.itemChangedProducer.send(new ProducerRecord("just.item.visibilityChanged", (Object)event.getPostId().toTypedString(), null));
    }
}

