/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.post;

import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.connector.drive.DriveApiConnector;
import de.justsoftware.news.connector.drive.DriveDocument;
import de.justsoftware.news.connector.permission.PermissionKafkaProducer;
import de.justsoftware.news.connector.translation.TranslationConnector;
import de.justsoftware.news.domain.attachment.Attachment;
import de.justsoftware.news.domain.attachment.AttachmentRepo;
import de.justsoftware.news.domain.channel.Channel;
import de.justsoftware.news.domain.channel.ChannelAction;
import de.justsoftware.news.domain.channel.ChannelRepo;
import de.justsoftware.news.domain.event.Event;
import de.justsoftware.news.domain.event.EventRepo;
import de.justsoftware.news.domain.poll.Poll;
import de.justsoftware.news.domain.poll.PollAnswer;
import de.justsoftware.news.domain.poll.PollAnswerRepo;
import de.justsoftware.news.domain.poll.PollRepo;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.domain.post.PostService;
import de.justsoftware.news.domain.post.PostService$findAllByIds$;
import de.justsoftware.news.domain.post.error.PostAlreadyUpdatedException;
import de.justsoftware.news.domain.post.model.PostAction;
import de.justsoftware.news.domain.post.model.PostTranslation;
import de.justsoftware.news.domain.post.model.TranslationLanguage;
import de.justsoftware.news.domain.subscription.SubscriptionRepoWrapper;
import de.justsoftware.news.domain.tenant.TenantRepo;
import de.justsoftware.news.id.ChannelId;
import de.justsoftware.news.id.DocumentId;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.PostId;
import de.justsoftware.news.id.ProfileId;
import de.justsoftware.news.util.PaginationSupportKt;
import de.justsoftware.news.util.TransactionSupport;
import de.justsoftware.news.util.Unauthorized;
import io.micrometer.observation.annotation.Observed;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.dialect.OracleDialect;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Observed
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00e6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0017\u0018\u00002\u00020\u0001Bu\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0002\u0010\u001eJ8\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020(2\b\b\u0002\u0010)\u001a\u00020*H\u0016J\"\u0010+\u001a\u00020,2\u000e\u0010-\u001a\n\u0012\u0004\u0012\u00020.\u0018\u00010 2\b\u0010/\u001a\u0004\u0018\u00010.H\u0012J\u00c5\u0001\u00100\u001a\u00020!2\u0006\u00101\u001a\u00020$2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u00105\u001a\u0002032\b\b\u0002\u00106\u001a\u0002072\u000e\b\u0002\u00108\u001a\b\u0012\u0004\u0012\u00020.0 2\n\b\u0002\u0010/\u001a\u0004\u0018\u00010.2\n\b\u0002\u00109\u001a\u0004\u0018\u00010:2\b\u0010;\u001a\u0004\u0018\u00010<2\n\b\u0002\u0010=\u001a\u0004\u0018\u00010>2\u0010\b\u0002\u0010?\u001a\n\u0012\u0004\u0012\u00020@\u0018\u00010 2\n\b\u0002\u0010A\u001a\u0004\u0018\u00010<2\b\u0010B\u001a\u0004\u0018\u00010<2\n\b\u0002\u0010C\u001a\u0004\u0018\u00010(2\b\b\u0002\u0010D\u001a\u00020(2\b\b\u0002\u0010E\u001a\u00020<2\u0006\u0010%\u001a\u00020&H\u0017\u00a2\u0006\u0002\u0010FJ\u001c\u0010G\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010H\u001a\b\u0012\u0004\u0012\u0002070 H\u0017J\u001a\u0010I\u001a\u0004\u0018\u00010!2\u0006\u0010J\u001a\u0002072\u0006\u0010%\u001a\u00020&H\u0016J\u0012\u0010K\u001a\u0004\u0018\u00010!2\u0006\u0010J\u001a\u000207H\u0017J0\u0010L\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\b\b\u0002\u0010'\u001a\u00020(2\b\b\u0002\u0010)\u001a\u00020*H\u0012J\u0018\u0010M\u001a\u00020!2\u0006\u0010J\u001a\u0002072\u0006\u0010%\u001a\u00020&H\u0016J>\u0010N\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u00101\u001a\u00020$2\u0006\u0010O\u001a\u00020*2\u0006\u0010)\u001a\u00020*2\u0006\u0010P\u001a\u00020(2\u0006\u0010Q\u001a\u00020(2\u0006\u0010%\u001a\u00020&H\u0016J&\u0010R\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010%\u001a\u00020&2\u0006\u0010O\u001a\u00020*2\u0006\u0010)\u001a\u00020*H\u0016J.\u0010S\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010O\u001a\u00020*2\u0006\u0010)\u001a\u00020*2\u0006\u0010Q\u001a\u00020(2\u0006\u0010%\u001a\u00020&H\u0016J6\u0010T\u001a \u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020V\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0W0U2\u0006\u0010P\u001a\u00020(2\u0006\u0010Q\u001a\u00020(H\u0012J4\u0010X\u001a&\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0#\u0012\u0004\u0012\u00020V\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0W0U2\u0006\u0010Q\u001a\u00020(H\u0012J\u0016\u0010Y\u001a\b\u0012\u0004\u0012\u00020$0Z2\u0006\u0010%\u001a\u00020&H\u0012J&\u0010[\u001a\u00020,2\u0006\u0010=\u001a\u00020>2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020@0 2\u0006\u00106\u001a\u000207H\u0012J*\u0010\\\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020(2\b\b\u0002\u0010)\u001a\u00020*H\u0016J\u000e\u0010]\u001a\b\u0012\u0004\u0012\u00020!0 H\u0017JJ\u0010^\u001a\u00020_2\u0006\u00106\u001a\u0002072\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\b\u0010`\u001a\u0004\u0018\u0001032\u000e\u0010?\u001a\n\u0012\u0004\u0012\u000203\u0018\u00010 2\u0006\u0010a\u001a\u00020b2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010c\u001a\u00020,H\u0017J\u00f5\u0001\u0010d\u001a\u00020!2\u0006\u00106\u001a\u0002072\n\b\u0002\u00102\u001a\u0004\u0018\u0001032\n\b\u0002\u00104\u001a\u0004\u0018\u0001032\n\b\u0002\u00105\u001a\u0004\u0018\u0001032\u0010\b\u0002\u00108\u001a\n\u0012\u0004\u0012\u00020.\u0018\u00010 2\n\b\u0002\u0010/\u001a\u0004\u0018\u00010.2\n\b\u0002\u00109\u001a\u0004\u0018\u00010:2\n\b\u0002\u0010e\u001a\u0004\u0018\u00010(2\n\b\u0002\u0010;\u001a\u0004\u0018\u00010<2\n\b\u0002\u0010=\u001a\u0004\u0018\u00010>2\u0010\b\u0002\u0010?\u001a\n\u0012\u0004\u0012\u00020@\u0018\u00010 2\n\b\u0002\u0010f\u001a\u0004\u0018\u00010(2\n\b\u0002\u0010A\u001a\u0004\u0018\u00010<2\n\b\u0002\u0010g\u001a\u0004\u0018\u00010(2\n\b\u0002\u0010h\u001a\u0004\u0018\u00010<2\n\b\u0002\u0010B\u001a\u0004\u0018\u00010<2\n\b\u0002\u0010i\u001a\u0004\u0018\u00010(2\n\b\u0002\u0010C\u001a\u0004\u0018\u00010(2\u0006\u0010%\u001a\u00020&H\u0017\u00a2\u0006\u0002\u0010jR\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006k"}, d2={"Lde/justsoftware/news/domain/post/PostService;", "", "attachmentRepo", "Lde/justsoftware/news/domain/attachment/AttachmentRepo;", "channelRepo", "Lde/justsoftware/news/domain/channel/ChannelRepo;", "eventRepo", "Lde/justsoftware/news/domain/event/EventRepo;", "pollRepo", "Lde/justsoftware/news/domain/poll/PollRepo;", "pollAnswerRepo", "Lde/justsoftware/news/domain/poll/PollAnswerRepo;", "driveApiConnector", "Lde/justsoftware/news/connector/drive/DriveApiConnector;", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "permissionKafkaProducer", "Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;", "subscriptionRepoWrapper", "Lde/justsoftware/news/domain/subscription/SubscriptionRepoWrapper;", "tenantRepo", "Lde/justsoftware/news/domain/tenant/TenantRepo;", "transactionSupport", "Lde/justsoftware/news/util/TransactionSupport;", "translationConnector", "Lde/justsoftware/news/connector/translation/TranslationConnector;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "dbDialect", "Lorg/springframework/data/relational/core/dialect/Dialect;", "(Lde/justsoftware/news/domain/attachment/AttachmentRepo;Lde/justsoftware/news/domain/channel/ChannelRepo;Lde/justsoftware/news/domain/event/EventRepo;Lde/justsoftware/news/domain/poll/PollRepo;Lde/justsoftware/news/domain/poll/PollAnswerRepo;Lde/justsoftware/news/connector/drive/DriveApiConnector;Lde/justsoftware/news/domain/post/PostRepo;Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;Lde/justsoftware/news/domain/subscription/SubscriptionRepoWrapper;Lde/justsoftware/news/domain/tenant/TenantRepo;Lde/justsoftware/news/util/TransactionSupport;Lde/justsoftware/news/connector/translation/TranslationConnector;Lorg/springframework/context/ApplicationEventPublisher;Lorg/springframework/data/relational/core/dialect/Dialect;)V", "byChannelIds", "", "Lde/justsoftware/news/domain/post/Post;", "channelIds", "", "Lde/justsoftware/news/id/ChannelId;", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "pinnedOnly", "", "limit", "", "checkCoverInAttachments", "", "attachmentIds", "Lde/justsoftware/news/id/DocumentId;", "coverElementId", "create", "channelId", "title", "", "text", "jsonContent", "postId", "Lde/justsoftware/news/id/PostId;", "attachments", "event", "Lde/justsoftware/news/domain/event/Event;", "pinExpiration", "Ljava/time/Instant;", "poll", "Lde/justsoftware/news/domain/poll/Poll;", "pollAnswers", "Lde/justsoftware/news/domain/poll/PollAnswer;", "publishDate", "deleteDate", "commentsDisabled", "createNotifications", "createDate", "(Lde/justsoftware/news/id/ChannelId;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lde/justsoftware/news/id/PostId;Ljava/util/List;Lde/justsoftware/news/id/DocumentId;Lde/justsoftware/news/domain/event/Event;Ljava/time/Instant;Lde/justsoftware/news/domain/poll/Poll;Ljava/util/List;Ljava/time/Instant;Ljava/time/Instant;Ljava/lang/Boolean;ZLjava/time/Instant;Lde/justsoftware/news/auth/AuthorizationContext;)Lde/justsoftware/news/domain/post/Post;", "findAllByIds", "postIds", "findById", "id", "findByIdDeleted", "getByChannelIds", "getById", "getChannelPosts", "offset", "scheduled", "pinned", "getEvents", "getFeed", "getMatchingChannelQuery", "Lkotlin/Function3;", "Lorg/springframework/data/domain/Pageable;", "Lorg/springframework/data/domain/Page;", "getMatchingFeedQuery", "getSubscribedChannels", "", "insertPoll", "latest", "publishScheduledPosts", "translatePost", "Lde/justsoftware/news/domain/post/model/PostTranslation;", "pollQuestion", "targetLanguage", "Lde/justsoftware/news/domain/post/model/TranslationLanguage;", "unpinPostsAfterPinExpiration", "update", "pin", "deletePoll", "published", "lastKnownModifyDate", "removeDeleteDate", "(Lde/justsoftware/news/id/PostId;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lde/justsoftware/news/id/DocumentId;Lde/justsoftware/news/domain/event/Event;Ljava/lang/Boolean;Ljava/time/Instant;Lde/justsoftware/news/domain/poll/Poll;Ljava/util/List;Ljava/lang/Boolean;Ljava/time/Instant;Ljava/lang/Boolean;Ljava/time/Instant;Ljava/time/Instant;Ljava/lang/Boolean;Ljava/lang/Boolean;Lde/justsoftware/news/auth/AuthorizationContext;)Lde/justsoftware/news/domain/post/Post;", "news-service"})
@SourceDebugExtension(value={"SMAP\nPostService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostService.kt\nde/justsoftware/news/domain/post/PostService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,578:1\n1#2:579\n1864#3,3:580\n1549#3:583\n1620#3,3:584\n766#3:587\n857#3,2:588\n1855#3,2:590\n533#3,6:592\n766#3:598\n857#3,2:599\n1864#3,3:601\n1549#3:604\n1620#3,3:605\n1549#3:608\n1620#3,3:609\n1045#3:612\n1549#3:613\n1620#3,3:614\n1549#3:617\n1620#3,3:618\n1549#3:621\n1620#3,3:622\n766#3:625\n857#3,2:626\n1549#3:628\n1620#3,3:629\n*S KotlinDebug\n*F\n+ 1 PostService.kt\nde/justsoftware/news/domain/post/PostService\n*L\n133#1:580,3\n267#1:583\n267#1:584,3\n269#1:587\n269#1:588,2\n270#1:590,2\n276#1:592,6\n278#1:598\n278#1:599,2\n281#1:601,3\n349#1:604\n349#1:605,3\n369#1:608\n369#1:609,3\n379#1:612\n436#1:613\n436#1:614,3\n457#1:617\n457#1:618,3\n514#1:621\n514#1:622,3\n572#1:625\n572#1:626,2\n574#1:628\n574#1:629,3\n*E\n"})
public class PostService {
    @NotNull
    private final AttachmentRepo attachmentRepo;
    @NotNull
    private final ChannelRepo channelRepo;
    @NotNull
    private final EventRepo eventRepo;
    @NotNull
    private final PollRepo pollRepo;
    @NotNull
    private final PollAnswerRepo pollAnswerRepo;
    @NotNull
    private final DriveApiConnector driveApiConnector;
    @NotNull
    private final PostRepo postRepo;
    @NotNull
    private final PermissionKafkaProducer permissionKafkaProducer;
    @NotNull
    private final SubscriptionRepoWrapper subscriptionRepoWrapper;
    @NotNull
    private final TenantRepo tenantRepo;
    @NotNull
    private final TransactionSupport transactionSupport;
    @NotNull
    private final TranslationConnector translationConnector;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final Dialect dbDialect;

    public PostService(@NotNull AttachmentRepo attachmentRepo, @NotNull ChannelRepo channelRepo, @NotNull EventRepo eventRepo, @NotNull PollRepo pollRepo, @NotNull PollAnswerRepo pollAnswerRepo, @NotNull DriveApiConnector driveApiConnector, @NotNull PostRepo postRepo, @NotNull PermissionKafkaProducer permissionKafkaProducer, @NotNull SubscriptionRepoWrapper subscriptionRepoWrapper, @NotNull TenantRepo tenantRepo, @NotNull TransactionSupport transactionSupport, @NotNull TranslationConnector translationConnector, @NotNull ApplicationEventPublisher eventPublisher, @NotNull Dialect dbDialect) {
        Intrinsics.checkNotNullParameter((Object)attachmentRepo, (String)"attachmentRepo");
        Intrinsics.checkNotNullParameter((Object)channelRepo, (String)"channelRepo");
        Intrinsics.checkNotNullParameter((Object)eventRepo, (String)"eventRepo");
        Intrinsics.checkNotNullParameter((Object)pollRepo, (String)"pollRepo");
        Intrinsics.checkNotNullParameter((Object)pollAnswerRepo, (String)"pollAnswerRepo");
        Intrinsics.checkNotNullParameter((Object)driveApiConnector, (String)"driveApiConnector");
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        Intrinsics.checkNotNullParameter((Object)permissionKafkaProducer, (String)"permissionKafkaProducer");
        Intrinsics.checkNotNullParameter((Object)subscriptionRepoWrapper, (String)"subscriptionRepoWrapper");
        Intrinsics.checkNotNullParameter((Object)tenantRepo, (String)"tenantRepo");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        Intrinsics.checkNotNullParameter((Object)translationConnector, (String)"translationConnector");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)dbDialect, (String)"dbDialect");
        this.attachmentRepo = attachmentRepo;
        this.channelRepo = channelRepo;
        this.eventRepo = eventRepo;
        this.pollRepo = pollRepo;
        this.pollAnswerRepo = pollAnswerRepo;
        this.driveApiConnector = driveApiConnector;
        this.postRepo = postRepo;
        this.permissionKafkaProducer = permissionKafkaProducer;
        this.subscriptionRepoWrapper = subscriptionRepoWrapper;
        this.tenantRepo = tenantRepo;
        this.transactionSupport = transactionSupport;
        this.translationConnector = translationConnector;
        this.eventPublisher = eventPublisher;
        this.dbDialect = dbDialect;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Post create(@NotNull ChannelId channelId, @NotNull String title, @NotNull String text, @NotNull String jsonContent, @NotNull PostId postId, @NotNull List<DocumentId> attachments, @Nullable DocumentId coverElementId, @Nullable Event event, @Nullable Instant pinExpiration, @Nullable Poll poll, @Nullable List<PollAnswer> pollAnswers, @Nullable Instant publishDate, @Nullable Instant deleteDate, @Nullable Boolean commentsDisabled, boolean createNotifications, @NotNull Instant createDate, @NotNull AuthorizationContext authContext) {
        Collection $this$forEachIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)jsonContent, (String)"jsonContent");
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
        Intrinsics.checkNotNullParameter((Object)createDate, (String)"createDate");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkChannelAction(channelId, ChannelAction.CREATE_POST);
        this.checkCoverInAttachments(attachments, coverElementId);
        Instant now = Instant.now();
        if (publishDate != null && !publishDate.isAfter(now)) {
            boolean $i$a$-require-PostService$create$42 = false;
            String $i$a$-require-PostService$create$42 = "If provided, 'publishDate' must be a date in the future.";
            throw new IllegalArgumentException($i$a$-require-PostService$create$42.toString());
        }
        if (pinExpiration != null && !pinExpiration.isAfter(now)) {
            boolean $i$a$-require-PostService$create$52 = false;
            String $i$a$-require-PostService$create$52 = "If provided, 'pinExpiration' must be a date in the future.";
            throw new IllegalArgumentException($i$a$-require-PostService$create$52.toString());
        }
        if (pinExpiration != null && publishDate != null && !(pinExpiration.compareTo(publishDate) >= 0)) {
            boolean $i$a$-require-PostService$create$62 = false;
            String $i$a$-require-PostService$create$62 = "If provided, 'pinExpiration' must be set after publication date.";
            throw new IllegalArgumentException($i$a$-require-PostService$create$62.toString());
        }
        boolean isScheduled = publishDate != null && publishDate.isAfter(now);
        Boolean bl = commentsDisabled;
        PostRepo.insert$default((PostRepo)this.postRepo, (PostId)postId, (ProfileId)authContext.getUser(), (ChannelId)channelId, (Instant)createDate, (Instant)createDate, (String)title, (String)text, (String)jsonContent, (DocumentId)coverElementId, (Instant)pinExpiration, (Instant)(pinExpiration != null ? now : null), (Instant)(publishDate != null && isScheduled ? publishDate : createDate), (!isScheduled ? 1 : 0) != 0, (boolean)false, (Instant)deleteDate, (boolean)(bl != null ? bl : false), (int)8192, null);
        Event event2 = event;
        if (event2 != null) {
            Event it = event2;
            boolean bl2 = false;
            this.eventRepo.insert(it.getId(), it.getPostId(), it.getStartDate(), it.getEndDate());
        }
        if (!((Collection)attachments).isEmpty()) {
            Iterable $i$a$-require-PostService$create$62 = this.driveApiConnector.addFiles(attachments, postId, authContext.getUser());
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void attachment;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                DriveDocument driveDocument = (DriveDocument)item$iv;
                int index = n;
                boolean bl3 = false;
                this.attachmentRepo.insert(attachment.getDocumentId(), postId, attachment.getMimeType(), attachment.getName(), attachment.getSize(), index);
            }
        }
        if (poll != null && !(($this$forEachIndexed$iv = (Collection)pollAnswers) == null || $this$forEachIndexed$iv.isEmpty())) {
            this.insertPoll(poll, pollAnswers, postId);
        }
        Post post = this.postRepo.getByIdAndDeletedFalse(postId);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return post;
    }

    public static /* synthetic */ Post create$default(PostService postService, ChannelId channelId, String string, String string2, String string3, PostId postId, List list, DocumentId documentId, Event event, Instant instant, Poll poll, List list2, Instant instant2, Instant instant3, Boolean bl, boolean bl2, Instant instant4, AuthorizationContext authorizationContext, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create");
        }
        if ((n & 0x10) != 0) {
            postId = PostId.Companion.random();
        }
        if ((n & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            documentId = null;
        }
        if ((n & 0x80) != 0) {
            event = null;
        }
        if ((n & 0x200) != 0) {
            poll = null;
        }
        if ((n & 0x400) != 0) {
            list2 = null;
        }
        if ((n & 0x800) != 0) {
            instant2 = null;
        }
        if ((n & 0x2000) != 0) {
            bl = false;
        }
        if ((n & 0x4000) != 0) {
            bl2 = true;
        }
        if ((n & 0x8000) != 0) {
            Instant instant5 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant5, (String)"now(...)");
            instant4 = instant5;
        }
        return postService.create(channelId, string, string2, string3, postId, list, documentId, event, instant, poll, list2, instant2, instant3, bl, bl2, instant4, authorizationContext);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Post update(@NotNull PostId postId, @Nullable String title, @Nullable String text, @Nullable String jsonContent, @Nullable List<DocumentId> attachments, @Nullable DocumentId coverElementId, @Nullable Event event, @Nullable Boolean pin, @Nullable Instant pinExpiration, @Nullable Poll poll, @Nullable List<PollAnswer> pollAnswers, @Nullable Boolean deletePoll, @Nullable Instant publishDate, @Nullable Boolean published, @Nullable Instant lastKnownModifyDate, @Nullable Instant deleteDate, @Nullable Boolean removeDeleteDate, @Nullable Boolean commentsDisabled, @NotNull AuthorizationContext authContext) {
        Collection originPoll;
        Instant instant;
        Instant instant2;
        String string;
        Event event2;
        Event event3;
        String $i$a$-require-PostService$update$2$622;
        String string2;
        String string32;
        String string4;
        DocumentId newCoverElementId;
        Object object;
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Post origin = this.postRepo.getByIdAndDeletedFalse(postId);
        authContext.checkPostAction(origin.getId(), PostAction.EDIT);
        this.checkCoverInAttachments(attachments, coverElementId);
        boolean publishNow = !origin.getPublished() && Intrinsics.areEqual((Object)published, (Object)true);
        Instant now = Instant.now();
        if (!(lastKnownModifyDate == null || Intrinsics.areEqual((Object)lastKnownModifyDate, (Object)origin.getModifyDate().truncatedTo(ChronoUnit.SECONDS)))) {
            boolean bl = false;
            throw new PostAlreadyUpdatedException("Post has already been edited by someone else.");
        }
        if (origin.getPublished() && publishDate != null && publishDate.compareTo(now) > 0 || Intrinsics.areEqual((Object)published, (Object)false)) {
            throw new IllegalArgumentException("Already published posts may not be planned again.");
        }
        Instant instant3 = pinExpiration;
        if (instant3 != null) {
            Instant it = instant3;
            boolean string32 = false;
            if (!it.isAfter(now)) {
                boolean $i$a$-require-PostService$update$2$42 = false;
                String $i$a$-require-PostService$update$2$42 = "Pin expiration must be a date in the future.";
                throw new IllegalArgumentException($i$a$-require-PostService$update$2$42.toString());
            }
            if (publishDate != null) {
                if (!it.isAfter(publishDate)) {
                    boolean $i$a$-require-PostService$update$2$52 = false;
                    String $i$a$-require-PostService$update$2$52 = "'pinExpiration' must be set after publication date.";
                    throw new IllegalArgumentException($i$a$-require-PostService$update$2$52.toString());
                }
            } else if (!it.isAfter(origin.getPublishDate())) {
                boolean $i$a$-require-PostService$update$2$622 = false;
                String $i$a$-require-PostService$update$2$622 = "'pinExpiration' must be set after publication date.";
                throw new IllegalArgumentException($i$a$-require-PostService$update$2$622.toString());
            }
        }
        if ((object = coverElementId) == null) {
            List<DocumentId> list = attachments;
            boolean bl = list != null ? list.isEmpty() : false;
            if (bl) {
                object = null;
            } else {
                List<DocumentId> list2 = attachments;
                object = newCoverElementId = (list2 != null ? !CollectionsKt.contains((Iterable)list2, (Object)origin.getCoverElementId()) : false) ? null : origin.getCoverElementId();
            }
        }
        if ((string4 = title) == null) {
            string4 = string32 = origin.getTitle();
        }
        if ((string2 = text) == null) {
            string2 = $i$a$-require-PostService$update$2$622 = origin.getText();
        }
        if ((event3 = event) == null) {
            event3 = event2 = origin.getEvent();
        }
        if ((string = jsonContent) == null) {
            string = origin.getJsonContent();
        }
        String string5 = string;
        Instant instant4 = PostService.update$getPinExpiration((Instant)pinExpiration, (Boolean)pin, (Post)origin, (Instant)now, (Instant)publishDate);
        Instant instant5 = PostService.update$getPinnedAt((Boolean)pin, (Post)origin);
        if (publishNow) {
            instant2 = now;
        } else {
            instant2 = publishDate;
            if (instant2 == null) {
                instant2 = origin.getPublishDate();
            }
        }
        Object object2 = instant2;
        Boolean bl = published;
        boolean bl2 = bl != null ? bl.booleanValue() : origin.getPublished();
        ProfileId profileId = authContext.getUser();
        if (Intrinsics.areEqual((Object)removeDeleteDate, (Object)true)) {
            instant = null;
        } else {
            instant = deleteDate;
            if (instant == null) {
                instant = origin.getDeleteDate();
            }
        }
        Instant instant6 = instant;
        Boolean bl3 = commentsDisabled;
        boolean bl4 = bl3 != null ? bl3.booleanValue() : origin.getCommentsDisabled();
        Intrinsics.checkNotNull((Object)now);
        Intrinsics.checkNotNull((Object)object2);
        Post update2 = Post.copy$default((Post)origin, null, null, null, null, (Instant)now, (String)string32, (String)$i$a$-require-PostService$update$2$622, (String)string5, (DocumentId)newCoverElementId, (boolean)false, (Instant)instant6, (Instant)instant4, (Instant)instant5, (Instant)object2, (boolean)bl2, (ProfileId)profileId, (Event)event2, (boolean)bl4, (int)527, null);
        List<DocumentId> list = attachments;
        if (list != null) {
            void $this$forEachIndexed$iv;
            void $this$filterTo$iv$iv;
            Object v14;
            Object iterator$iv;
            List originAttachmentIds;
            block33: {
                Iterator $this$filterTo$iv$iv2;
                Attachment it;
                void $this$mapTo$iv$iv;
                List<DocumentId> it2 = list;
                boolean bl5 = false;
                List originAttachments = this.attachmentRepo.findAllByPostIdOrderByPosition(postId);
                Iterable $this$map$iv = originAttachments;
                boolean $i$f$map = false;
                object2 = $this$map$iv;
                Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Attachment attachment = (Attachment)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl6 = false;
                    collection.add(it.getId());
                }
                originAttachmentIds = (List)destination$iv$iv;
                Iterable $this$filter$iv = originAttachmentIds;
                boolean $i$f$filter = false;
                destination$iv$iv = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator item$iv$iv = $this$filterTo$iv$iv2.iterator();
                while (item$iv$iv.hasNext()) {
                    Object element$iv$iv = item$iv$iv.next();
                    DocumentId it3 = (DocumentId)element$iv$iv;
                    boolean bl7 = false;
                    if (!(!attachments.contains(it3))) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List toDelete = (List)destination$iv$iv2;
                Iterable $this$forEach$iv = toDelete;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DocumentId it4 = (DocumentId)element$iv;
                    boolean bl8 = false;
                    this.driveApiConnector.deleteFile(it4, authContext.getUser());
                }
                this.attachmentRepo.deleteAllById((Iterable)toDelete);
                List $this$lastOrNull$iv = originAttachments;
                boolean $i$f$lastOrNull = false;
                iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Object element$iv = iterator$iv.previous();
                    it = (Attachment)element$iv;
                    boolean bl9 = false;
                    if (!(!toDelete.contains(it.getId()))) continue;
                    v14 = element$iv;
                    break block33;
                }
                v14 = null;
            }
            Attachment attachment = v14;
            int nextPosition = attachment != null ? attachment.getPosition() + 1 : 0;
            Iterable $this$filter$iv = attachments;
            boolean $i$f$filter = false;
            iterator$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DocumentId it = (DocumentId)element$iv$iv;
                boolean bl10 = false;
                if (!(!originAttachmentIds.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List toAdd = (List)destination$iv$iv;
            $this$filter$iv = this.driveApiConnector.addFiles(toAdd, postId, authContext.getUser());
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void attachment2;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                DriveDocument element$iv$iv = (DriveDocument)item$iv;
                int index = n;
                boolean bl11 = false;
                this.attachmentRepo.insert(attachment2.getDocumentId(), postId, attachment2.getMimeType(), attachment2.getName(), attachment2.getSize(), index + nextPosition);
            }
        }
        if (Intrinsics.areEqual((Object)deletePoll, (Object)true) && (originPoll = this.pollRepo.findByPostId(origin.getId())) != null) {
            this.pollRepo.deleteById((Object)originPoll.getId());
        }
        if (poll != null) {
            originPoll = pollAnswers;
            if (!(!(originPoll == null || originPoll.isEmpty()))) {
                boolean bl12 = false;
                String string6 = "Answers are required when adding a Poll";
                throw new IllegalArgumentException(string6.toString());
            }
            originPoll = this.pollRepo.findByPostId(origin.getId());
            if (!(originPoll == null)) {
                boolean bl13 = false;
                String string7 = "The Post '" + origin.getId() + "' has already a Poll and can only have one Poll";
                throw new IllegalArgumentException(string7.toString());
            }
            this.insertPoll(poll, pollAnswers, postId);
        }
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        Object object3 = this.postRepo.save((Object)update2);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"save(...)");
        return (Post)object3;
    }

    public static /* synthetic */ Post update$default(PostService postService, PostId postId, String string, String string2, String string3, List list, DocumentId documentId, Event event, Boolean bl, Instant instant, Poll poll, List list2, Boolean bl2, Instant instant2, Boolean bl3, Instant instant3, Instant instant4, Boolean bl4, Boolean bl5, AuthorizationContext authorizationContext, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        if ((n & 0x10) != 0) {
            list = null;
        }
        if ((n & 0x20) != 0) {
            documentId = null;
        }
        if ((n & 0x40) != 0) {
            event = null;
        }
        if ((n & 0x80) != 0) {
            bl = null;
        }
        if ((n & 0x100) != 0) {
            instant = null;
        }
        if ((n & 0x200) != 0) {
            poll = null;
        }
        if ((n & 0x400) != 0) {
            list2 = null;
        }
        if ((n & 0x800) != 0) {
            bl2 = null;
        }
        if ((n & 0x1000) != 0) {
            instant2 = null;
        }
        if ((n & 0x2000) != 0) {
            bl3 = null;
        }
        if ((n & 0x4000) != 0) {
            instant3 = null;
        }
        if ((n & 0x8000) != 0) {
            instant4 = null;
        }
        if ((n & 0x10000) != 0) {
            bl4 = null;
        }
        if ((n & 0x20000) != 0) {
            bl5 = null;
        }
        return postService.update(postId, string, string2, string3, list, documentId, event, bl, instant, poll, list2, bl2, instant2, bl3, instant3, instant4, bl4, bl5, authorizationContext);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Post> getChannelPosts(@NotNull ChannelId channelId, int offset, int limit, boolean scheduled, boolean pinned, @NotNull AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        List posts2 = PaginationSupportKt.convertPaging((int)offset, (int)limit, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */));
        Iterable iterable = posts2;
        AuthorizationContext authorizationContext = authContext;
        boolean $i$f$map = false;
        void var10_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Post post = (Post)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        authorizationContext.checkReadAll((Collection)((List)destination$iv$iv));
        return posts2;
    }

    @NotNull
    public List<Post> getFeed(int offset, int limit, boolean pinned, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Set subscribedChannelIds = this.getSubscribedChannels(authContext);
        Function3 feedQuery = this.getMatchingFeedQuery(pinned);
        return PaginationSupportKt.convertPaging((int)offset, (int)limit, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Post> getEvents(@NotNull AuthorizationContext authContext, int offset, int limit) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Set tenantChannels = this.channelRepo.getByTenantIdAndDeletedFalse(authContext.getTenantId());
        Iterable iterable = tenantChannels;
        AuthorizationContext authorizationContext = authContext;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Channel channel = (Channel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Set channelIds = CollectionsKt.toSet((Iterable)authorizationContext.filterReadable((Collection)((List)destination$iv$iv)));
        if (channelIds.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if (this.dbDialect instanceof OracleDialect) {
            return this.postRepo.getEventsOracle(channelIds, offset, limit);
        }
        return this.postRepo.getEvents(channelIds, offset, limit);
    }

    @Unauthorized
    @NotNull
    public List<Post> findAllByIds(@NotNull List<PostId> postIds) {
        Intrinsics.checkNotNullParameter(postIds, (String)"postIds");
        Iterable $this$sortedBy$iv = this.postRepo.findAllPostsById((Collection)postIds);
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new findAllByIds$$inlined$sortedBy$1(postIds)));
    }

    @NotNull
    public Post getById(@NotNull PostId id, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Post post = this.findById(id, authContext);
        if (post == null) {
            throw new NoSuchElementException("Post with id :'" + id + "' does not exist.");
        }
        return post;
    }

    @Nullable
    public Post findById(@NotNull PostId id, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Post post = PostRepo.findByIdAndDeleted$default((PostRepo)this.postRepo, (PostId)id, (boolean)false, (int)2, null);
        if (post == null) {
            return null;
        }
        Post post2 = post;
        authContext.checkRead((ItemId)post2.getId());
        return post2;
    }

    @Unauthorized
    @Nullable
    public Post findByIdDeleted(@NotNull PostId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.postRepo.findByIdAndDeleted(id, true);
    }

    @NotNull
    public List<Post> latest(@NotNull AuthorizationContext authContext, boolean pinnedOnly, int limit) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        List channelIds = this.channelRepo.getIdsByTenant(authContext.getTenantId());
        List channelIdsReadable = authContext.filterReadable((Collection)channelIds);
        return this.getByChannelIds((Collection)channelIdsReadable, pinnedOnly, limit);
    }

    public static /* synthetic */ List latest$default(PostService postService, AuthorizationContext authorizationContext, boolean bl, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: latest");
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            n = 8;
        }
        return postService.latest(authorizationContext, bl, n);
    }

    @NotNull
    public List<Post> byChannelIds(@NotNull Collection<ChannelId> channelIds, @NotNull AuthorizationContext authContext, boolean pinnedOnly, int limit) {
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        List channelIdsReadable = authContext.filterReadable(channelIds);
        return this.getByChannelIds((Collection)channelIdsReadable, pinnedOnly, limit);
    }

    public static /* synthetic */ List byChannelIds$default(PostService postService, Collection collection, AuthorizationContext authorizationContext, boolean bl, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: byChannelIds");
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            n = 8;
        }
        return postService.byChannelIds(collection, authorizationContext, bl, n);
    }

    private List<Post> getByChannelIds(Collection<ChannelId> channelIds, boolean pinnedOnly, int limit) {
        List list;
        if (pinnedOnly) {
            PageRequest pageRequest = PageRequest.of((int)0, (int)limit);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            List list2 = this.postRepo.findByChannelIdInAndPinExpirationNotNullAndPublishedTrueAndDeletedFalseOrderByPinnedAtDesc(channelIds, (Pageable)pageRequest).getContent();
            Intrinsics.checkNotNull((Object)list2);
            list = list2;
        } else {
            PageRequest pageRequest = PageRequest.of((int)0, (int)limit);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            List list3 = this.postRepo.findByChannelIdInAndPublishedTrueAndDeletedFalseOrderByPublishDateDesc(channelIds, (Pageable)pageRequest).getContent();
            Intrinsics.checkNotNull((Object)list3);
            list = list3;
        }
        return list;
    }

    static /* synthetic */ List getByChannelIds$default(PostService postService, Collection collection, boolean bl, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getByChannelIds");
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            n = 8;
        }
        return postService.getByChannelIds(collection, bl, n);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @Unauthorized
    @NotNull
    public List<Post> publishScheduledPosts() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = PostRepo.getByDeletedFalseAndPublishedFalseAndPublishDateLessThanEqual$default((PostRepo)this.postRepo, null, (int)1, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Post post = (Post)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Post.copy$default((Post)it, null, null, null, null, null, null, null, null, null, (boolean)false, null, null, null, null, (boolean)true, null, null, (boolean)false, (int)245759, null));
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        Iterable iterable2 = this.postRepo.saveAll((Iterable)it);
        Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"let(...)");
        List publishedPosts = CollectionsKt.toList((Iterable)iterable2);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return publishedPosts;
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    public void unpinPostsAfterPinExpiration() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = PostRepo.getByDeletedFalseAndPinExpirationLessThanEqual$default((PostRepo)this.postRepo, null, (int)1, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Post post = (Post)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Post.copy$default((Post)it, null, null, null, null, null, null, null, null, null, (boolean)false, null, null, null, null, (boolean)false, null, null, (boolean)false, (int)255999, null));
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        this.postRepo.saveAll((Iterable)it);
    }

    @NotNull
    public PostTranslation translatePost(@NotNull PostId postId, @NotNull String title, @NotNull String text, @Nullable String pollQuestion, @Nullable List<String> pollAnswers, @NotNull TranslationLanguage targetLanguage, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)targetLanguage, (String)"targetLanguage");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkRead((ItemId)postId);
        String string = this.tenantRepo.getById(authContext.getTenantId()).getDeeplKey();
        if (string == null) {
            throw new IllegalArgumentException("This Tenant has no deeplKey.");
        }
        String deeplKey = string;
        Object[] objectArray = new String[]{title, pollQuestion};
        List<String> list = pollAnswers;
        List translationInput = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object[])objectArray), (Iterable)(list != null ? (Iterable)list : (Iterable)CollectionsKt.emptyList()));
        List translationOutput = this.translationConnector.translateTexts(translationInput, targetLanguage, deeplKey);
        String titleTranslated = (String)CollectionsKt.first((List)translationOutput);
        String pollQuestionTranslated = (String)CollectionsKt.getOrNull((List)translationOutput, (int)1);
        List pollAnswersTranslated = translationOutput.size() > 2 ? translationOutput.subList(2, translationOutput.size()) : null;
        return new PostTranslation(postId, targetLanguage, text, this.translationConnector.translateHtml(text, targetLanguage, deeplKey), title, titleTranslated, pollQuestion, pollQuestionTranslated, pollAnswers, pollAnswersTranslated);
    }

    /*
     * WARNING - void declaration
     */
    private void insertPoll(Poll poll, List<PollAnswer> pollAnswers, PostId postId) {
        void $this$mapTo$iv$iv;
        this.pollRepo.insert(poll.getId(), poll.getQuestion(), poll.getAllowMultipleAnswers(), postId, poll.getPrivacy());
        Iterable $this$map$iv = pollAnswers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void answer;
            PollAnswer pollAnswer = (PollAnswer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            this.pollAnswerRepo.insert(answer.getId(), answer.getText(), answer.getPosition(), answer.getPollId());
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    private Function3<PostRepo, ChannelId, Pageable, Page<Post>> getMatchingChannelQuery(boolean scheduled, boolean pinned) {
        return scheduled && pinned ? (Function3)getMatchingChannelQuery.1.INSTANCE : (scheduled && !pinned ? (Function3)getMatchingChannelQuery.2.INSTANCE : (!scheduled && pinned ? (Function3)getMatchingChannelQuery.3.INSTANCE : (Function3)getMatchingChannelQuery.4.INSTANCE));
    }

    private Function3<PostRepo, Collection<ChannelId>, Pageable, Page<Post>> getMatchingFeedQuery(boolean pinned) {
        return pinned ? (Function3)getMatchingFeedQuery.1.INSTANCE : (Function3)getMatchingFeedQuery.2.INSTANCE;
    }

    private void checkCoverInAttachments(List<DocumentId> attachmentIds, DocumentId coverElementId) {
        if (coverElementId == null) {
            return;
        }
        if (!(attachmentIds != null && attachmentIds.contains(coverElementId))) {
            boolean bl = false;
            String string = StringsKt.trimMargin$default((String)("\n                |You tried to set attachment with id " + coverElementId + " as cover element,\n                |but this attachment was not included in the attachment array.\n                |Submitted attachment ids: " + attachmentIds + ". \n            "), null, (int)1, null);
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private Set<ChannelId> getSubscribedChannels(AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        ChannelId channelId;
        void $this$filterTo$iv$iv;
        List channelIdsOfTenant = this.channelRepo.getIdsByTenant(authContext.getTenantId());
        Iterable $this$filter$iv = this.subscriptionRepoWrapper.getSubscribedChannelIds(authContext.getUser());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            channelId = (ChannelId)element$iv$iv;
            boolean bl = false;
            if (!channelIdsOfTenant.contains(channelId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it = (List)destination$iv$iv;
        boolean $i$a$-let-PostService$getSubscribedChannels$32 = false;
        Iterable $this$map$iv = authContext.filterReadable((Collection)it);
        boolean $i$f$map = false;
        Iterable $i$a$-let-PostService$getSubscribedChannels$32 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            channelId = (ChannelId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ChannelId.Companion.fromString(it2.toTypedString()));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private static final Instant update$getPinExpiration(Instant $pinExpiration, Boolean $pin, Post origin, Instant now, Instant $publishDate) {
        if ($pinExpiration != null) {
            return $pinExpiration;
        }
        if ($pin == null) {
            return origin.getPinExpiration();
        }
        if ($pin.booleanValue()) {
            return origin.getPublishDate().isBefore(now) ? now.plus(14L, ChronoUnit.DAYS) : ($publishDate == null ? origin.getPublishDate().plus(14L, ChronoUnit.DAYS) : $publishDate.plus(14L, ChronoUnit.DAYS));
        }
        return null;
    }

    private static final Instant update$getPinnedAt(Boolean $pin, Post origin) {
        if ($pin == null) {
            return origin.getPinnedAt();
        }
        if ($pin.booleanValue()) {
            return Instant.now();
        }
        return null;
    }

    public static final /* synthetic */ PermissionKafkaProducer access$getPermissionKafkaProducer$p(PostService $this) {
        return $this.permissionKafkaProducer;
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getEventPublisher$p(PostService $this) {
        return $this.eventPublisher;
    }

    public static final /* synthetic */ Function3 access$getMatchingChannelQuery(PostService $this, boolean scheduled, boolean pinned) {
        return $this.getMatchingChannelQuery(scheduled, pinned);
    }

    public static final /* synthetic */ PostRepo access$getPostRepo$p(PostService $this) {
        return $this.postRepo;
    }

    public static final /* synthetic */ ChannelRepo access$getChannelRepo$p(PostService $this) {
        return $this.channelRepo;
    }
}

