/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.poll;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.poll.Poll;
import de.justsoftware.news.domain.poll.PollAnswerDataLoader;
import de.justsoftware.news.domain.poll.PollCsvExportService;
import de.justsoftware.news.domain.poll.PollDataFetcherKt;
import de.justsoftware.news.domain.poll.PollExportLanguage;
import de.justsoftware.news.domain.poll.PollService;
import de.justsoftware.news.domain.poll.PollVote;
import de.justsoftware.news.domain.poll.PollVoteDataLoader;
import de.justsoftware.news.domain.poll.VotersDataLoader;
import de.justsoftware.news.graphql.generated.types.PollAnswer;
import de.justsoftware.news.graphql.generated.types.Profile;
import de.justsoftware.news.id.PollAnswerId;
import de.justsoftware.news.id.PollId;
import de.justsoftware.news.id.ProfileId;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.dataloader.DataLoader;
import org.jetbrains.annotations.NotNull;

@DgsComponent
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u001a\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u001a\u0010\u0010\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0017J*\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00162\u000e\b\u0001\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u001c\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u00180\b2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lde/justsoftware/news/domain/poll/PollDataFetcher;", "", "pollService", "Lde/justsoftware/news/domain/poll/PollService;", "pollCsvExportService", "Lde/justsoftware/news/domain/poll/PollCsvExportService;", "(Lde/justsoftware/news/domain/poll/PollService;Lde/justsoftware/news/domain/poll/PollCsvExportService;)V", "answers", "Ljava/util/concurrent/CompletableFuture;", "Lde/justsoftware/news/graphql/generated/types/PollAnswer;", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "csvExportFileUrl", "", "language", "Lde/justsoftware/news/domain/poll/PollExportLanguage;", "csvExportString", "isOwnVote", "", "votePoll", "Lde/justsoftware/news/graphql/generated/types/Poll;", "pollId", "Lde/justsoftware/news/id/PollId;", "yesAnswers", "", "Lde/justsoftware/news/id/PollAnswerId;", "voters", "Lde/justsoftware/news/graphql/generated/types/Profile;", "votes", "Lde/justsoftware/news/id/ProfileId;", "news-service"})
@SourceDebugExtension(value={"SMAP\nPollDataFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PollDataFetcher.kt\nde/justsoftware/news/domain/poll/PollDataFetcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n1549#2:161\n1620#2,3:162\n*S KotlinDebug\n*F\n+ 1 PollDataFetcher.kt\nde/justsoftware/news/domain/poll/PollDataFetcher\n*L\n68#1:161\n68#1:162,3\n*E\n"})
public class PollDataFetcher {
    @NotNull
    private final PollService pollService;
    @NotNull
    private final PollCsvExportService pollCsvExportService;

    public PollDataFetcher(@NotNull PollService pollService, @NotNull PollCsvExportService pollCsvExportService) {
        Intrinsics.checkNotNullParameter((Object)pollService, (String)"pollService");
        Intrinsics.checkNotNullParameter((Object)pollCsvExportService, (String)"pollCsvExportService");
        this.pollService = pollService;
        this.pollCsvExportService = pollCsvExportService;
    }

    @DgsData(parentType="Poll", field="answers")
    @NotNull
    public CompletableFuture<PollAnswer> answers(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(PollAnswerDataLoader.class);
        PollId pollId = ((de.justsoftware.news.graphql.generated.types.Poll)dfe.getSource()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)pollId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Poll", field="csvExportString")
    @NotNull
    public String csvExportString(@InputArgument @NotNull PollExportLanguage language, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return this.pollCsvExportService.export(((de.justsoftware.news.graphql.generated.types.Poll)dfe.getSource()).getId(), language, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)).getCsvContent();
    }

    @DgsData(parentType="Poll", field="csvExportFileUrl")
    @NotNull
    public String csvExportFileUrl(@InputArgument @NotNull PollExportLanguage language, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        String pollId = ((de.justsoftware.news.graphql.generated.types.Poll)dfe.getSource()).getId().toTypedString();
        return "/news/rest/poll/" + pollId + "/csv-export?language=" + language;
    }

    @DgsData(parentType="PollAnswer", field="votes")
    @NotNull
    public CompletableFuture<ProfileId> votes(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(PollVoteDataLoader.class);
        PollAnswerId pollAnswerId = ((PollAnswer)dfe.getSource()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)pollAnswerId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    /*
     * WARNING - void declaration
     */
    @DgsData(parentType="PollAnswer", field="isOwnVote")
    public boolean isOwnVote(@NotNull DgsDataFetchingEnvironment dfe) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        PollAnswerId answerId = ((PollAnswer)dfe.getSource()).getId();
        Iterable $this$map$iv = this.pollService.findVotesByAnswerId(answerId);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PollVote pollVote = (PollVote)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getProfileId());
        }
        List profileIds = (List)destination$iv$iv;
        return profileIds.contains(authContext.getUser());
    }

    @DgsData(parentType="PollAnswer", field="voters")
    @NotNull
    public CompletableFuture<List<Profile>> voters(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        PollAnswerId pollAnswerId = ((PollAnswer)dfe.getSource()).getId();
        DataLoader dataLoader = dfe.getDataLoader(VotersDataLoader.class);
        CompletableFuture completableFuture = dataLoader.load((Object)pollAnswerId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsMutation(field="votePoll")
    @NotNull
    public de.justsoftware.news.graphql.generated.types.Poll votePoll(@InputArgument @NotNull PollId pollId, @InputArgument @NotNull List<PollAnswerId> yesAnswers, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)pollId, (String)"pollId");
        Intrinsics.checkNotNullParameter(yesAnswers, (String)"yesAnswers");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return PollDataFetcherKt.toGql((Poll)this.pollService.vote(pollId, yesAnswers, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }
}

