/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.migration;

import de.justsoftware.news.auth.AuthSettingsService;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.connector.drive.DriveApiConnector;
import de.justsoftware.news.connector.permission.PermissionConnector;
import de.justsoftware.news.domain.migration.ExternalMigrationService;
import de.justsoftware.news.domain.post.PostService;
import de.justsoftware.news.domain.user.Profile;
import de.justsoftware.news.domain.user.UserService;
import de.justsoftware.news.graphql.generated.types.ExternalChannelMapping;
import de.justsoftware.news.graphql.generated.types.ExternalMigrationInput;
import de.justsoftware.news.graphql.generated.types.ExternalPostInput;
import de.justsoftware.news.graphql.generated.types.MigrationResult;
import de.justsoftware.news.id.ChannelId;
import de.justsoftware.news.id.DocumentId;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.ProfileId;
import de.justsoftware.news.id.TenantId;
import de.justsoftware.news.id.UserId;
import de.justsoftware.news.util.DateUtilsKt;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"just.news.externalMigration.enabled"}, havingValue="true", matchIfMissing=false)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lde/justsoftware/news/domain/migration/ExternalMigrationService;", "", "userService", "Lde/justsoftware/news/domain/user/UserService;", "permissionConnector", "Lde/justsoftware/news/connector/permission/PermissionConnector;", "postService", "Lde/justsoftware/news/domain/post/PostService;", "authSettingsService", "Lde/justsoftware/news/auth/AuthSettingsService;", "driveApiConnector", "Lde/justsoftware/news/connector/drive/DriveApiConnector;", "(Lde/justsoftware/news/domain/user/UserService;Lde/justsoftware/news/connector/permission/PermissionConnector;Lde/justsoftware/news/domain/post/PostService;Lde/justsoftware/news/auth/AuthSettingsService;Lde/justsoftware/news/connector/drive/DriveApiConnector;)V", "getAuthSettingsService", "()Lde/justsoftware/news/auth/AuthSettingsService;", "getDriveApiConnector", "()Lde/justsoftware/news/connector/drive/DriveApiConnector;", "getPermissionConnector", "()Lde/justsoftware/news/connector/permission/PermissionConnector;", "getPostService", "()Lde/justsoftware/news/domain/post/PostService;", "getUserService", "()Lde/justsoftware/news/domain/user/UserService;", "migrate", "Lde/justsoftware/news/graphql/generated/types/MigrationResult;", "input", "Lde/justsoftware/news/graphql/generated/types/ExternalMigrationInput;", "authorizationContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "Companion", "news-service"})
@SourceDebugExtension(value={"SMAP\nExternalMigrationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalMigrationService.kt\nde/justsoftware/news/domain/migration/ExternalMigrationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1855#2,2:123\n1855#2:125\n1855#2,2:126\n1856#2:128\n1855#2,2:129\n*S KotlinDebug\n*F\n+ 1 ExternalMigrationService.kt\nde/justsoftware/news/domain/migration/ExternalMigrationService\n*L\n59#1:123,2\n63#1:125\n76#1:126,2\n63#1:128\n113#1:129,2\n*E\n"})
public class ExternalMigrationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UserService userService;
    @NotNull
    private final PermissionConnector permissionConnector;
    @NotNull
    private final PostService postService;
    @NotNull
    private final AuthSettingsService authSettingsService;
    @NotNull
    private final DriveApiConnector driveApiConnector;
    @NotNull
    private static final Logger log;

    public ExternalMigrationService(@NotNull UserService userService, @NotNull PermissionConnector permissionConnector, @NotNull PostService postService, @NotNull AuthSettingsService authSettingsService, @NotNull DriveApiConnector driveApiConnector) {
        Intrinsics.checkNotNullParameter((Object)userService, (String)"userService");
        Intrinsics.checkNotNullParameter((Object)permissionConnector, (String)"permissionConnector");
        Intrinsics.checkNotNullParameter((Object)postService, (String)"postService");
        Intrinsics.checkNotNullParameter((Object)authSettingsService, (String)"authSettingsService");
        Intrinsics.checkNotNullParameter((Object)driveApiConnector, (String)"driveApiConnector");
        this.userService = userService;
        this.permissionConnector = permissionConnector;
        this.postService = postService;
        this.authSettingsService = authSettingsService;
        this.driveApiConnector = driveApiConnector;
    }

    @NotNull
    public UserService getUserService() {
        return this.userService;
    }

    @NotNull
    public PermissionConnector getPermissionConnector() {
        return this.permissionConnector;
    }

    @NotNull
    public PostService getPostService() {
        return this.postService;
    }

    @NotNull
    public AuthSettingsService getAuthSettingsService() {
        return this.authSettingsService;
    }

    @NotNull
    public DriveApiConnector getDriveApiConnector() {
        return this.driveApiConnector;
    }

    @NotNull
    public MigrationResult migrate(@NotNull ExternalMigrationInput input, @NotNull AuthorizationContext authorizationContext) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        log.info("start migration of news articles");
        log.info("################################");
        log.info("number of articles: " + input.getExternalPosts().size());
        authorizationContext.checkMayMigrate();
        int numberOfPosts = 0;
        int numberOfAttachments = 0;
        List errors = null;
        errors = new ArrayList();
        Profile profile = this.getUserService().findProfile(input.getMigrationUser());
        Intrinsics.checkNotNull((Object)profile);
        Profile migrationUser = profile;
        if (!this.getPermissionConnector().mayRead((ItemId)authorizationContext.getTenantId(), (UserId)migrationUser.getId())) {
            throw new IllegalArgumentException("migration User null or not part of current tenant");
        }
        ProfileId profileId = migrationUser.getId();
        TenantId tenantId = authorizationContext.getTenantId();
        PermissionConnector permissionConnector = this.getPermissionConnector();
        AuthSettingsService authSettingsService = this.getAuthSettingsService();
        AuthorizationContext migrationUserContext = new AuthorizationContext(tenantId, profileId, authSettingsService, permissionConnector);
        HashMap channelMap = new HashMap();
        List list = input.getChannelMapping();
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ExternalChannelMapping mapping = (ExternalChannelMapping)element$iv;
                boolean bl = false;
                ((Map)channelMap).put(mapping.getExternalChannel(), mapping.getChannelId());
            }
        }
        Iterable $this$forEach$iv = input.getExternalPosts();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ExternalPostInput)element$iv;
            boolean bl = false;
            ChannelId channelId = (ChannelId)((Map)channelMap).get(it.getCategoryId());
            if (channelId == null) {
                channelId = input.getDefaultChannelId();
            }
            List attachments = new ArrayList();
            if (it.getCoverImage() != null) {
                attachments.add(it.getCoverImage());
            }
            if (it.getImageUrls() != null) {
                attachments.addAll(it.getImageUrls());
            }
            if (it.getFileUrls() != null) {
                attachments.addAll(it.getFileUrls());
            }
            List migratedAttachments = new ArrayList();
            DocumentId coverElementId = null;
            Iterable $this$forEach$iv2 = attachments;
            boolean $i$f$forEach22 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String img = (String)element$iv2;
                boolean bl2 = false;
                try {
                    migratedAttachments.addAll(this.getDriveApiConnector().addTempFilesFromUrl(SetsKt.setOf((Object)img), migrationUser.getId()));
                    if (coverElementId == null) {
                        coverElementId = !((Collection)migratedAttachments).isEmpty() ? (DocumentId)CollectionsKt.first((List)migratedAttachments) : null;
                    }
                    ++numberOfAttachments;
                }
                catch (RuntimeException e) {
                    errors.add("image " + img + " of post: '" + it.getTitle() + "':  could not be migrated: " + e.getMessage());
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            Instant createDate = DateUtilsKt.toInstant((long)it.getCreateDate());
            try {
                PostService $i$f$forEach22 = this.getPostService();
                ChannelId channelId2 = channelId;
                String string = it.getTitle();
                String string2 = it.getTextContent();
                String string3 = it.getJsonContent();
                DocumentId documentId = coverElementId;
                PostService.create$default((PostService)$i$f$forEach22, (ChannelId)channelId2, (String)string, (String)string2, (String)string3, null, (List)migratedAttachments, (DocumentId)documentId, null, null, null, null, null, null, null, (boolean)false, (Instant)createDate, (AuthorizationContext)migrationUserContext, (int)11920, null);
                log.info("migrated successfully: " + it.getTitle());
                ++numberOfPosts;
            }
            catch (RuntimeException e) {
                errors.add("post: '" + it.getTitle() + "' could not be migrated: " + e.getMessage());
                log.error("post: '" + it.getTitle() + "' could not be migrated", (Throwable)e);
            }
        }
        log.info("migration finished: numberOfPosts " + numberOfPosts + ", numberIfAttachements: " + numberOfAttachments + ", errors: " + errors.size());
        $this$forEach$iv = errors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            log.info((String)it);
        }
        return new MigrationResult.Builder().withNumberOfPosts(numberOfPosts).withNumberOfAttachments(numberOfAttachments).withErrors(errors).build();
    }

    static {
        Logger logger = LoggerFactory.getLogger(ExternalMigrationService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }
}

