/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.comment;

import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.comment.PostComment;
import de.justsoftware.news.domain.comment.PostCommentAction;
import de.justsoftware.news.domain.comment.PostCommentRepo;
import de.justsoftware.news.domain.comment.PostCommentService$findAllByIds$;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.domain.post.error.PostCommentsAreDisabledException;
import de.justsoftware.news.domain.post.model.PostAction;
import de.justsoftware.news.events.PostCommentCreatedEvent;
import de.justsoftware.news.events.PostCommentUpdatedMentionsEvent;
import de.justsoftware.news.id.CommentId;
import de.justsoftware.news.id.CommentableId;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.PostId;
import de.justsoftware.news.id.ProfileId;
import de.justsoftware.news.util.QuillUtils;
import de.justsoftware.news.util.Sort;
import de.justsoftware.news.util.Unauthorized;
import io.micrometer.observation.annotation.Observed;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.stereotype.Service;

@Service
@Observed
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ@\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u0019H\u0017J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J0\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00190!2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J\"\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020%0!2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0'H\u0017J(\u0010(\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lde/justsoftware/news/domain/comment/PostCommentService;", "", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "commentRepo", "Lde/justsoftware/news/domain/comment/PostCommentRepo;", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "(Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/news/domain/comment/PostCommentRepo;Lde/justsoftware/news/domain/post/PostRepo;)V", "createComment", "Lde/justsoftware/news/domain/comment/PostComment;", "postId", "Lde/justsoftware/news/id/PostId;", "text", "", "jsonContent", "parentId", "Lde/justsoftware/news/id/CommentableId;", "referenceId", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "deleteComment", "Lde/justsoftware/news/id/CommentId;", "commentId", "findAllByIds", "", "commentIds", "findAllByPostId", "sort", "Lde/justsoftware/news/util/Sort;", "findById", "id", "findNestedCommentsByParent", "", "Lde/justsoftware/news/id/ItemId;", "parentIds", "getCommentCount", "", "postIds", "", "update", "news-service"})
@SourceDebugExtension(value={"SMAP\nPostCommentService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostCommentService.kt\nde/justsoftware/news/domain/comment/PostCommentService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n1045#2:147\n1271#2,2:148\n1285#2,2:150\n766#2:152\n857#2,2:153\n1288#2:155\n1549#2:156\n1620#2,3:157\n1179#2,2:160\n1253#2,4:162\n1271#2,2:166\n1285#2,4:168\n*S KotlinDebug\n*F\n+ 1 PostCommentService.kt\nde/justsoftware/news/domain/comment/PostCommentService\n*L\n113#1:147\n121#1:148,2\n121#1:150,2\n122#1:152\n122#1:153,2\n121#1:155\n138#1:156\n138#1:157,3\n141#1:160,2\n141#1:162,4\n143#1:166,2\n143#1:168,4\n*E\n"})
public class PostCommentService {
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final PostCommentRepo commentRepo;
    @NotNull
    private final PostRepo postRepo;

    public PostCommentService(@NotNull ApplicationEventPublisher eventPublisher, @NotNull PostCommentRepo commentRepo, @NotNull PostRepo postRepo) {
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)commentRepo, (String)"commentRepo");
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        this.eventPublisher = eventPublisher;
        this.commentRepo = commentRepo;
        this.postRepo = postRepo;
    }

    @NotNull
    public PostComment createComment(@NotNull PostId postId, @NotNull String text, @NotNull String jsonContent, @Nullable CommentableId parentId, @Nullable CommentableId referenceId, @NotNull AuthorizationContext authContext) {
        CommentableId commentableId;
        CommentableId commentableId2;
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)jsonContent, (String)"jsonContent");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Post post = this.postRepo.getByIdAndDeletedFalse(postId);
        authContext.checkPostAction(post.getId(), PostAction.COMMENT);
        if (post.getCommentsDisabled()) {
            throw new PostCommentsAreDisabledException(null, 1, null);
        }
        CommentId commentId = CommentId.Companion.random();
        Instant now = Instant.now();
        PostCommentRepo postCommentRepo = this.commentRepo;
        CommentableId commentableId3 = parentId;
        if (commentableId3 == null) {
            commentableId3 = commentableId2 = (CommentableId)postId;
        }
        if ((commentableId = referenceId) == null) {
            commentableId = (CommentableId)postId;
        }
        CommentableId commentableId4 = commentableId;
        ProfileId profileId = authContext.getUser();
        ProfileId profileId2 = authContext.getUser();
        ItemId itemId = (ItemId)commentableId2;
        ItemId itemId2 = (ItemId)commentableId4;
        Intrinsics.checkNotNull((Object)now);
        postCommentRepo.insert(commentId, postId, itemId, itemId2, profileId, now, now, profileId2, jsonContent, text);
        this.eventPublisher.publishEvent((ApplicationEvent)new PostCommentCreatedEvent(postId, (ItemId)parentId, jsonContent, authContext.getUser(), authContext.getTenantId()));
        return this.commentRepo.getById(commentId);
    }

    public static /* synthetic */ PostComment createComment$default(PostCommentService postCommentService, PostId postId, String string, String string2, CommentableId commentableId, CommentableId commentableId2, AuthorizationContext authorizationContext, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createComment");
        }
        if ((n & 8) != 0) {
            commentableId = (CommentableId)postId;
        }
        if ((n & 0x10) != 0) {
            commentableId2 = (CommentableId)postId;
        }
        return postCommentService.createComment(postId, string, string2, commentableId, commentableId2, authorizationContext);
    }

    @NotNull
    public PostComment update(@NotNull CommentId id, @NotNull String text, @NotNull String jsonContent, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)jsonContent, (String)"jsonContent");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        PostComment origin = this.commentRepo.getById(id);
        Post post = this.postRepo.getByIdAndDeletedFalse(origin.getPostId());
        authContext.checkPostCommentAction(post.getChannelId(), origin, PostCommentAction.EDIT);
        Instant instant = Instant.now();
        ProfileId profileId = authContext.getUser();
        Intrinsics.checkNotNull((Object)instant);
        PostComment update2 = PostComment.copy$default((PostComment)origin, null, null, null, null, null, null, (Instant)instant, (ProfileId)profileId, (String)jsonContent, (String)text, (boolean)false, null, null, (int)7231, null);
        this.commentRepo.save((Object)update2);
        Set originMentions = QuillUtils.Companion.extractMentions(origin.getJsonContent());
        Set updateMentions = QuillUtils.Companion.extractMentions(update2.getJsonContent());
        Set newMentions = CollectionsKt.subtract((Iterable)updateMentions, (Iterable)originMentions);
        if (!((Collection)newMentions).isEmpty()) {
            this.eventPublisher.publishEvent((ApplicationEvent)new PostCommentUpdatedMentionsEvent(update2.getPostId(), authContext.getTenantId(), (Collection)newMentions));
        }
        return update2;
    }

    @Nullable
    public PostComment findById(@NotNull CommentId id, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        PostComment postComment = (PostComment)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.commentRepo), (Object)id);
        if (postComment == null) {
            return null;
        }
        PostComment comment = postComment;
        authContext.checkRead((ItemId)comment.getPostId());
        return comment;
    }

    @Unauthorized
    @NotNull
    public List<PostComment> findAllByPostId(@NotNull PostId postId, @NotNull Sort sort) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        if (this.postRepo.getByIdAndDeletedFalse(postId).getCommentsDisabled()) {
            return CollectionsKt.emptyList();
        }
        return this.commentRepo.findAllByParentId((ItemId)postId, sort);
    }

    @Unauthorized
    @NotNull
    public List<PostComment> findAllByIds(@NotNull List<CommentId> commentIds) {
        Intrinsics.checkNotNullParameter(commentIds, (String)"commentIds");
        Iterable $this$sortedBy$iv = this.commentRepo.findAllCommentsById((Collection)commentIds);
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new findAllByIds$$inlined$sortedBy$1(commentIds)));
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    @NotNull
    public Map<ItemId, List<PostComment>> findNestedCommentsByParent(@NotNull List<? extends ItemId> parentIds, @NotNull Sort sort) {
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        if (parentIds.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Set comments = this.commentRepo.findAllByParentIdIn(parentIds, sort);
        Iterable $this$associateWith$iv = parentIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$filterTo$iv$iv;
            ItemId itemId = (ItemId)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Iterable $this$filter$iv = comments;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                void id;
                PostComment it = (PostComment)element$iv$iv2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getParentId(), (Object)id)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List list = (List)destination$iv$iv;
            map.put(t, list);
        }
        return result$iv;
    }

    @NotNull
    public CommentId deleteComment(@NotNull CommentId commentId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.commentRepo.findById((Object)commentId).ifPresent(arg_0 -> PostCommentService.deleteComment$lambda$3((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        return commentId;
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    @NotNull
    public Map<PostId, Integer> getCommentCount(@NotNull Set<PostId> postIds) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(postIds, (String)"postIds");
        Iterable $this$map$iv = postIds;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Iterator it;
            PostId postId = (PostId)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.toTypedString());
        }
        Set stringIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $i$f$map22 = this.commentRepo.commentCountByPostIds(stringIds);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void $i$f$mapTo22 = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv2 : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            Pair it = (Pair)element$iv$iv2;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getFirst(), (Object)it.getSecond());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map counts = destination$iv$iv2;
        Iterable $this$associateWith$iv = postIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            PostId element$iv$iv2 = (PostId)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            Integer n = ((Number)counts.getOrDefault(it, 0)).intValue();
            object.put(t, n);
        }
        return result$iv;
    }

    private static final void deleteComment$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ PostRepo access$getPostRepo$p(PostCommentService $this) {
        return $this.postRepo;
    }

    public static final /* synthetic */ PostCommentRepo access$getCommentRepo$p(PostCommentService $this) {
        return $this.commentRepo;
    }
}

