/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.domain.tracking;

import de.justsoftware.gateway.domain.tracking.TrackingSettings;
import de.justsoftware.gateway.domain.tracking.TrackingSettingsRepository;
import de.justsoftware.gateway.ids.TenantId;
import de.justsoftware.gateway.kafka.tenant.TrackingSettingsDto;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import reactor.core.publisher.Mono;

@ParametersAreNonnullByDefault
@Service
public class TrackingSettingsService {
    private static final Logger LOG = LoggerFactory.getLogger(TrackingSettingsService.class);
    private final TrackingSettingsRepository _trackingSettingsRepo;

    public TrackingSettingsService(TrackingSettingsRepository trackinSettingsRepository) {
        this._trackingSettingsRepo = trackinSettingsRepository;
    }

    @Transactional
    @Nonnull
    public Mono<Void> upsertSettings(TenantId tenantId, TrackingSettingsDto dto) {
        TrackingSettings newSettings = TrackingSettings.builder().tenantId(tenantId).matomoAuthToken(dto.getMatomoAuthToken()).matomoUrl(dto.getMatomoUrl()).matomoSiteId(dto.getMatomoSiteId()).build();
        return this._trackingSettingsRepo.findById((Object)tenantId).map(settingsFromDb -> {
            settingsFromDb.setMatomoAuthToken(dto.getMatomoAuthToken());
            settingsFromDb.setMatomoUrl(dto.getMatomoUrl());
            settingsFromDb.setMatomoSiteId(dto.getMatomoSiteId());
            return settingsFromDb;
        }).switchIfEmpty(Mono.just((Object)newSettings)).doOnSuccess(toSave -> {
            this._trackingSettingsRepo.save(toSave).subscribe();
            LOG.info("upsert done");
        }).then();
    }

    @Nonnull
    public Mono<TrackingSettings> findSettings(TenantId tenantId) {
        return this._trackingSettingsRepo.findById((Object)tenantId);
    }

    public void deleteSettingsById(TenantId tenantId) {
        this._trackingSettingsRepo.deleteById((Object)tenantId).subscribe();
    }
}

