/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.monitoring;

import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;

@ParametersAreNonnullByDefault
public class SolrPingHealthIndicator
extends AbstractHealthIndicator {
    private final SolrClient _solrClient;

    public SolrPingHealthIndicator(SolrClient solrClient) {
        super("Solr ping health check failed");
        this._solrClient = solrClient;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        SolrPingResponse response = this._solrClient.ping();
        int statusCode = response.getStatus();
        Status status = statusCode != 0 ? Status.DOWN : Status.UP;
        builder.status(status).withDetail("status", (Object)statusCode);
        if (this._solrClient instanceof HttpSolrClient) {
            builder.withDetail("baseUrl", (Object)((HttpSolrClient)this._solrClient).getBaseURL());
        }
    }
}

