/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.file;

import com.google.common.base.Function;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.common.file.model.TempFileId;
import de.justsoftware.drive.common.person.model.PersonId;
import java.time.Instant;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class TempFileCreateModel {
    public static final Function<TempFileCreateModel, StorageId> TO_STORAGE_ID = new /* Unavailable Anonymous Inner Class!! */;
    final TempFileId _id;
    String _mimeType;
    long _fileSize;
    StorageId _storageId;
    String _name;
    PersonId _owner;
    Instant _uploadDate;

    TempFileCreateModel() {
        this(TempFileId.random());
    }

    private TempFileCreateModel(TempFileId id) {
        this._id = id;
    }

    @Nonnull
    public TempFileCreateModel setMimeType(String mimeType) {
        this._mimeType = mimeType;
        return this;
    }

    @Nonnull
    public TempFileCreateModel setFilesize(long filesize) {
        this._fileSize = filesize;
        return this;
    }

    @Nonnull
    public TempFileCreateModel setStorageId(StorageId storageId) {
        this._storageId = storageId;
        return this;
    }

    @Nonnull
    public TempFileCreateModel setName(String name) {
        this._name = name;
        return this;
    }

    @Nonnull
    public TempFileCreateModel setOwner(PersonId owner) {
        this._owner = owner;
        return this;
    }

    @Nonnull
    public TempFileId getId() {
        return this._id;
    }

    @CheckForNull
    public StorageId getStorageId() {
        return this._storageId;
    }

    @Nonnull
    public TempFileCreateModel setUploadDate(Instant date) {
        this._uploadDate = date;
        return this;
    }
}

