/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.file;

import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.file.model.FilePreviewInfoBO;
import de.justsoftware.drive.common.file.model.FilePreviewStatus;
import de.justsoftware.drive.common.file.model.PreviewId;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.persistence.file.FileVersionPreviewCreateModel;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.ConstructorArgs;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Mapper
@ParametersAreNonnullByDefault
public interface FileVersionPreviewMapper {
    @Insert(value={"INSERT INTO file_version_preview(storage_id, preview_id, preview_status) ", "VALUES (#{_storageId}, #{_previewId}, #{_previewStatus})"})
    public void insertFileVersionPreview(FileVersionPreviewCreateModel var1);

    @Nonnull
    @Select(value={"<script>", "SELECT f.id ", "FROM file_version f", "JOIN document_version d ON f.id = d.id", "LEFT JOIN file_version_preview p ON p.storage_id = f.storage_id", "WHERE p.storage_id IS NULL", "ORDER BY d.change_date DESC", "</script>"})
    @ResultType(value=DocumentVersionId.class)
    public List<DocumentVersionId> getVersionsWithoutPreview(RowBounds var1);

    @Update(value={"<script>", "UPDATE file_version_preview ", "SET preview_status=#{_previewStatus}, preview_id=#{_previewId} ", "WHERE storage_id=#{_storageId}", "</script>"})
    public void updatePreviewStatus(FileVersionPreviewCreateModel var1);

    @Select(value={"<script>", "SELECT storage_id, preview_id, preview_status ", "FROM file_version_preview ", "WHERE storage_id IN ", "(<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    @ResultType(value=FilePreviewInfoBO.class)
    @ConstructorArgs(value={@Arg(column="storage_id", id=true, javaType=StorageId.class), @Arg(column="preview_id", javaType=PreviewId.class), @Arg(column="preview_status", javaType=FilePreviewStatus.class)})
    public void getInfoByStorageIds(ResultHandler<FilePreviewInfoBO> var1, @Param(value="ids") List<StorageId> var2);

    @Select(value={"<script>", "SELECT storage_id, preview_id, preview_status ", "FROM file_version_preview ", "WHERE preview_id IN ", "(<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    @ResultType(value=FilePreviewInfoBO.class)
    @ConstructorArgs(value={@Arg(column="storage_id", id=true, javaType=StorageId.class), @Arg(column="preview_id", javaType=PreviewId.class), @Arg(column="preview_status", javaType=FilePreviewStatus.class)})
    public void getInfoByPreviewIds(ResultHandler<FilePreviewInfoBO> var1, @Param(value="ids") List<PreviewId> var2);

    @Select(value={"<script>", "SELECT f.id, p.preview_id", "FROM file_version f", "JOIN file_version_preview p ON (p.storage_id = f.storage_id)", "WHERE f.id IN (<foreach collection='fileVersions' item='i' separator=','>#{i}</foreach>)", "AND preview_id IS NOT NULL", "</script>"})
    @Results(value={@Result(column="id", property="key", javaType=DocumentVersionId.class), @Result(column="preview_id", property="value", javaType=PreviewId.class)})
    @ResultType(value=Map.class)
    public void getPreviewIdByFileVersionId(ResultHandler<Map<String, Object>> var1, @Param(value="fileVersions") List<DocumentVersionId> var2);

    @Delete(value={"<script>", "DELETE FROM file_version_preview WHERE storage_id IN (", "<foreach collection='ids' item='i' separator=','>#{i}</foreach>", ")", "</script>"})
    public void deleteByStorageId(@Param(value="ids") List<StorageId> var1);

    @Delete(value={"DELETE FROM file_version_preview", "WHERE NOT EXISTS (", "    SELECT 1", "    FROM file_version", "    WHERE file_version.storage_id = file_version_preview.storage_id)"})
    public void deleteAllPreviewsWithoutVersions();
}

