/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.authorization;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.drive.common.authorization.model.Role;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.mybatis.DAOSupport;
import de.justsoftware.drive.persistence.authorization.ItemReadRoleDAO;
import de.justsoftware.drive.persistence.authorization.ItemReadRoleMapper;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class ItemReadRoleDAOImpl
implements ItemReadRoleDAO {
    private final ItemReadRoleMapper _mapper;
    private final DAOSupport _daoSupport;

    @Autowired
    public ItemReadRoleDAOImpl(DAOSupport daoSupport, ItemReadRoleMapper mapper) {
        this._daoSupport = daoSupport;
        this._mapper = mapper;
    }

    public void setReadRoles(ItemId itemId, Set<? extends Role> roles) {
        this._mapper.deleteAllRolesForItems((List)ImmutableList.of((Object)itemId));
        for (Role role : roles) {
            this._mapper.insert(itemId, role);
        }
    }

    public ImmutableSetMultimap<Role, ItemId> getItemsWithReadRoles(Set<? extends Role> roles) {
        return this._daoSupport.partition(roles).asSetMultimap((arg_0, arg_1) -> ((ItemReadRoleMapper)this._mapper).getItemsWithRoles(arg_0, arg_1));
    }

    public void deleteReadRoles(Set<ItemId> itemIds) {
        this._daoSupport.partition(itemIds).noResult(arg_0 -> ((ItemReadRoleMapper)this._mapper).deleteAllRolesForItems(arg_0));
    }
}

