/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.file;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSource;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.PublishedFilter;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface FileService {
    @Nonnull
    public ImmutableListMultimap<DocumentId, FileVersionBO> getVersionsByDocumentIds(Set<DocumentId> var1, PublishedFilter var2);

    @Nonnull
    public ImmutableList<FileVersionBO> getLatestVersions(DocumentId var1, PublishedFilter var2, int var3);

    @CheckForNull
    public FileVersionBO getLastFileVersion(DocumentId var1, PublishedFilter var2);

    @Nonnull
    public ImmutableMap<DocumentVersionId, FileVersionBO> getVersionsByIds(Set<DocumentVersionId> var1);

    @CheckForNull
    public FileVersionBO getSingleVersionById(DocumentVersionId var1);

    @Nonnull
    public ByteSource getFileByteSource(FileVersionBO var1);

    @Nonnull
    public String getFileStorageUrl(FileVersionBO var1);

    public boolean isFileStorageAvailable();

    public void updateMetadata(DocumentId var1, @Nullable String var2, @Nullable String var3);
}

