/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.authorization.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import de.justsoftware.drive.business.authorization.AuthorizationItem;
import de.justsoftware.drive.business.authorization.AuthorizationService;
import de.justsoftware.drive.business.authorization.RoleExprConverter;
import de.justsoftware.drive.business.authorization.impl.AuthorizationServiceImpl;
import de.justsoftware.drive.business.authorization.item.DependentItem;
import de.justsoftware.drive.business.authorization.item.Item;
import de.justsoftware.drive.business.authorization.item.ItemTypePredicates;
import de.justsoftware.drive.business.common.FeatureToggleProvider;
import de.justsoftware.drive.common.authorization.model.ItemRole;
import de.justsoftware.drive.common.authorization.model.Role;
import de.justsoftware.drive.common.authorization.model.StaticAction;
import de.justsoftware.drive.common.authorization.model.SubtypeAction;
import de.justsoftware.drive.common.item.model.ItemBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.persistence.authorization.ItemActionDAO;
import de.justsoftware.drive.persistence.authorization.PersonRoleDAO;
import de.justsoftware.drive.persistence.item.ItemDAO;
import de.justsoftware.ornot.BoolExpr;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class AuthorizationServiceImpl
implements AuthorizationService {
    private static final Function<? super StaticAction, BoolExpr<de.justsoftware.drive.common.authorization.model.Role>> ALL_FALSE = Functions.constant(null);
    @VisibleForTesting
    final PersonRoleDAO _roleDao;
    @VisibleForTesting
    final ItemActionDAO _itemActionDAO;
    @VisibleForTesting
    final ItemDAO _itemDAO;
    @VisibleForTesting
    final PermissionRequestConnector _permissionRequestConnector;
    @VisibleForTesting
    final FeatureToggleProvider _featureToggleProvider;

    @Autowired
    public AuthorizationServiceImpl(PersonRoleDAO roleDao, ItemActionDAO itemActionDAO, ItemDAO itemDAO, PermissionRequestConnector permissionRequestConnector, FeatureToggleProvider featureToggleProvider) {
        this._roleDao = roleDao;
        this._itemActionDAO = itemActionDAO;
        this._itemDAO = itemDAO;
        this._permissionRequestConnector = permissionRequestConnector;
        this._featureToggleProvider = featureToggleProvider;
    }

    public ImmutableSetMultimap<PersonId, de.justsoftware.drive.common.authorization.model.Role> filterRoles(SetMultimap<PersonId, de.justsoftware.drive.common.authorization.model.Role> rolesPerPerson) {
        ImmutableSetMultimap fromDb = this._roleDao.hasRoles(Multimaps.filterValues(rolesPerPerson, ItemRole.class::isInstance));
        ImmutableSetMultimap fromPermission = this._permissionRequestConnector.filterRoles((SetMultimap)AuthorizationServiceImpl.permissionRolesPerProfileRole(rolesPerPerson));
        return (ImmutableSetMultimap)rolesPerPerson.entries().stream().filter(e -> (Boolean)((de.justsoftware.drive.common.authorization.model.Role)e.getValue()).accept((Role.Visitor)new /* Unavailable Anonymous Inner Class!! */)).collect(ImmutableSetMultimap.toImmutableSetMultimap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Nonnull
    private static ImmutableSetMultimap<Role, Role> permissionRolesPerProfileRole(SetMultimap<PersonId, de.justsoftware.drive.common.authorization.model.Role> rolesPerPerson) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        rolesPerPerson.forEach((person, role) -> ((Optional)role.accept((Role.Visitor)new /* Unavailable Anonymous Inner Class!! */)).ifPresent(permissionRole -> result.put((Object)person.asPermissionRole(), permissionRole)));
        return result.build();
    }

    @Nonnull
    private Table<ItemId, StaticAction, BoolExpr<de.justsoftware.drive.common.authorization.model.Role>> loadRightsFromDB(SetMultimap<ItemId, StaticAction> itemsPerAction, ImmutableMap<ItemId, DependentItem> dependentItems) {
        ImmutableSetMultimap.Builder load = ImmutableSetMultimap.builder();
        for (DependentItem item : dependentItems.values()) {
            Optional parent = item.getParent().toJavaUtil();
            if (!parent.isPresent()) continue;
            for (StaticAction action : itemsPerAction.get((Object)((ItemId)item.getId()))) {
                load.put((Object)((ItemId)parent.get()), (Object)new SubtypeAction(((ItemId)item.getId()).getType(), action));
            }
        }
        load.putAll((Multimap)Multimaps.filterKeys(itemsPerAction, (Predicate)ItemTypePredicates.STORED_IN_DB.forIds()));
        Table result = Tables.transformValues((Table)this._itemActionDAO.getItemActions((SetMultimap)load.build()), (Function)RoleExprConverter.INSTANCE);
        ImmutableTable.Builder builder = ImmutableTable.builder();
        for (Map.Entry e : itemsPerAction.entries()) {
            BoolExpr other;
            ItemId itemId = (ItemId)e.getKey();
            StaticAction action = (StaticAction)e.getValue();
            BoolExpr res = (BoolExpr)result.get((Object)itemId, (Object)action);
            DependentItem dependentItem = (DependentItem)dependentItems.get((Object)itemId);
            if (res == null && dependentItem != null && dependentItem.getParent().isPresent() && (other = (BoolExpr)result.get(dependentItem.getParent().orNull(), (Object)new SubtypeAction(itemId.getType(), action))) != null) {
                res = other;
            }
            if (res == null) continue;
            builder.put((Object)itemId, (Object)action, (Object)res);
        }
        return builder.build();
    }

    @Nonnull
    private ImmutableMap<ItemId, DependentItem> loadDependentItems(SetMultimap<ItemId, StaticAction> itemsPerAction) {
        Set dependentItemIds = Sets.filter((Set)itemsPerAction.keySet(), (Predicate)ItemTypePredicates.DEPENDENT_ITEM.forIds());
        ImmutableMap items = this._itemDAO.getItems(dependentItemIds);
        return FluentIterable.from((Iterable)dependentItemIds).toMap(input -> new DependentItem(input, (ItemBO)items.get(input)));
    }

    public ImmutableTable<ItemId, StaticAction, BoolExpr<de.justsoftware.drive.common.authorization.model.Role>> loadPermissions(SetMultimap<ItemId, StaticAction> itemsPerAction) {
        ImmutableMap dependentItems = this.loadDependentItems(itemsPerAction);
        ImmutableSetMultimap.Builder actionsToLoadBuilder = ImmutableSetMultimap.builder();
        itemsPerAction.forEach((itemId, action) -> {
            if (action == StaticAction.DOCUMENT_DELETE) {
                actionsToLoadBuilder.put(itemId, (Object)StaticAction.DOCUMENT_WRITE);
            } else {
                actionsToLoadBuilder.put(itemId, action);
            }
        });
        Table rights = this.loadRightsFromDB((SetMultimap)actionsToLoadBuilder.build(), dependentItems);
        ItemVisitor itemVisitor = new ItemVisitor(rights);
        ImmutableTable.Builder result = ImmutableTable.builder();
        for (Map.Entry entry : itemsPerAction.entries()) {
            ItemId itemId2 = (ItemId)entry.getKey();
            StaticAction action2 = (StaticAction)entry.getValue();
            DependentItem dependentItem = (DependentItem)dependentItems.get((Object)itemId2);
            Object item = dependentItem != null ? dependentItem : new Item(itemId2, false);
            BoolExpr r = (BoolExpr)((Function)item.accept((AuthorizationItem.Visitor)itemVisitor)).apply((Object)action2);
            if (r == null) continue;
            result.put((Object)itemId2, (Object)action2, (Object)r);
        }
        return result.build();
    }

    public ImmutableSetMultimap<de.justsoftware.drive.common.authorization.model.Role, PersonId> getPersonWithRoles(Set<? extends de.justsoftware.drive.common.authorization.model.Role> roles) {
        return this._roleDao.getPersonWithRoles(roles);
    }
}

