/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.batch.search.impl;

import de.justsoftware.drive.batch.search.SearchIndexPublisher;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.file.model.StorageId;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class SearchIndexPublisherImpl
implements SearchIndexPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(SearchIndexPublisherImpl.class);
    private static final String TOPIC_PREFIX = "just.search.index.";
    static final String SUBSCRIBERS_TOPIC = "just.search.index.subscribers";
    static final String PARENTS_TOPIC = "just.search.index.parents";
    static final String CONTENT_TOPIC = "just.search.index.content";
    private final long _maxFileSize;
    private final Producer<String, String> _producer;

    @Autowired
    public SearchIndexPublisherImpl(@Nullable @Qualifier(value="KAFKA_STRING_PRODUCER") Producer<String, String> producer, @Value(value="${just.drive.contextExtractor.maxInputLength:50000000}") long maxFileSize) {
        this._maxFileSize = maxFileSize;
        this._producer = producer;
    }

    public void publishIndexSubscribers(DocumentId documentId) {
        this.send(documentId, SUBSCRIBERS_TOPIC);
    }

    public void publishIndexParents(DocumentId documentId) {
        this.send(documentId, PARENTS_TOPIC);
    }

    public void publishIndexContent(DocumentId documentId, StorageId storageId, long fileSize) {
        if (fileSize < this._maxFileSize) {
            this.send(documentId, CONTENT_TOPIC, (String)storageId.getId());
        }
    }

    private void send(DocumentId documentId, String topic) {
        this.send(documentId, topic, "");
    }

    private void send(DocumentId documentId, String topic, String value) {
        if (this._producer != null) {
            this._producer.send(new ProducerRecord(topic, (Object)("DRIVE_DOCUMENT," + documentId.toUUIDString()), (Object)value), (metadata, exception) -> {
                if (exception != null) {
                    LOG.error("Could not publish index of document " + documentId + " to topic " + topic, (Throwable)exception);
                }
            });
        }
    }
}

