/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jdoc.presentation.rest;

import de.justsoftware.jdoc.presentation.util.ExternalMessageFactory;
import de.justsoftware.jdoc.presentation.util.ExternalMessageReader;
import de.justsoftware.jdoc.rest.exceptions.DocumentRepositoryAPIException;
import de.justsoftware.jdoc.rest.model.ExternalDocumentType;
import de.justsoftware.jdoc.rest.model.ExternalServiceInfo;
import de.justsoftware.jdoc.rest.service.server.DocumentViewController;
import de.justsoftware.jdoc.rest.service.shared.JustDocumentsApiService;
import de.justsoftware.jdoc.services.business.DocumentService;
import de.justsoftware.jdoc.services.exceptions.DocumentRepositoryException;
import de.justsoftware.jdoc.services.exceptions.DocumentRepositoryRuntimeException;
import de.justsoftware.jdoc.util.streams.DocumentInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;

@Controller
public class DocumentViewControllerImpl
implements DocumentViewController,
JustDocumentsApiService {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentViewControllerImpl.class);
    @Autowired
    private DocumentService _service;

    public ResponseEntity<Resource> fetch(@PathVariable(value="documentId") String documentIdString, @PathVariable(value="documentType") ExternalDocumentType contentType) throws DocumentRepositoryAPIException {
        try {
            return ExternalMessageFactory.createResponseEntity((DocumentInputStream)this._service.getDocumentStream(ExternalMessageReader.getDocumentId((String)"documentId", (String)documentIdString), ExternalMessageReader.getDocumentType((String)"documentType", (ExternalDocumentType)contentType)));
        }
        catch (DocumentRepositoryException | DocumentRepositoryRuntimeException e) {
            LOG.error("Error while reading " + contentType + " of document by id " + documentIdString, e);
            throw new DocumentRepositoryAPIException(e);
        }
    }

    public ResponseEntity<Resource> fetchResources(@PathVariable(value="documentId") String documentIdString, @PathVariable(value="documentType") ExternalDocumentType contentType, @PathVariable(value="resourceName") String contentResource) throws DocumentRepositoryAPIException {
        try {
            return ExternalMessageFactory.createResponseEntity((DocumentInputStream)this._service.getDocumentResourceStream(ExternalMessageReader.getDocumentId((String)"documentId", (String)documentIdString), ExternalMessageReader.getDocumentType((String)"documentType", (ExternalDocumentType)contentType), ExternalMessageReader.getString((String)"resourceName", (String)contentResource)));
        }
        catch (DocumentRepositoryException | DocumentRepositoryRuntimeException e) {
            LOG.error("Error while fetching " + contentType + " resource " + contentResource + " of document " + documentIdString, e);
            throw new DocumentRepositoryAPIException(e);
        }
    }

    public ExternalServiceInfo getServiceInfo() {
        return ExternalMessageFactory.createServiceInfo((String)"Content Repository", (boolean)true, (String)"1.0", (String)"/content");
    }
}

