/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.mobile.service;

import de.justsoftware.chat.business.model.event.ProfileDeletedEvent;
import de.justsoftware.chat.business.model.event.ProfileUpdatedEvent;
import de.justsoftware.chat.exception.ValidationException;
import de.justsoftware.chat.mobile.model.MobilePlatform;
import de.justsoftware.chat.mobile.model.MobilePushToken;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.ProfileStatus;
import de.justsoftware.chat.persistence.MobilePushTokenRepository;
import de.justsoftware.chat.persistence.model.DbMobilePushToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J(\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0012J(\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0012J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!H\u0017J(\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010#\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lde/justsoftware/chat/mobile/service/MobilePushTokenService;", "", "mobilePushTokenRepository", "Lde/justsoftware/chat/persistence/MobilePushTokenRepository;", "(Lde/justsoftware/chat/persistence/MobilePushTokenRepository;)V", "deletePushTokens", "", "ids", "", "Lde/justsoftware/chat/mobile/model/MobilePushToken$Id;", "findByProfileIds", "", "Lde/justsoftware/chat/model/ProfileId;", "", "Lde/justsoftware/chat/mobile/model/MobilePushToken;", "profileIds", "", "findByTokenAndPlatform", "Ljava/util/Optional;", "Lde/justsoftware/chat/persistence/model/DbMobilePushToken;", "token", "", "platform", "Lde/justsoftware/chat/mobile/model/MobilePlatform;", "findOrCreate", "profileId", "iosSilenceAlerts", "", "onProfileDeleted", "profileDeletedEvent", "Lde/justsoftware/chat/business/model/event/ProfileDeletedEvent;", "onProfileUpdated", "profileUpdatedEvent", "Lde/justsoftware/chat/business/model/event/ProfileUpdatedEvent;", "registerPushToken", "unregisterPushToken", "chat-service"})
@SourceDebugExtension(value={"SMAP\nMobilePushTokenService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobilePushTokenService.kt\nde/justsoftware/chat/mobile/service/MobilePushTokenService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ValidationException.kt\nde/justsoftware/chat/exception/ValidationException$Companion\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1549#2:103\n1620#2,3:104\n1179#2,2:107\n1253#2,2:109\n1549#2:111\n1620#2,3:112\n1256#2:115\n1549#2:121\n1620#2,3:122\n10#3,2:116\n10#3,2:119\n1#4:118\n*S KotlinDebug\n*F\n+ 1 MobilePushTokenService.kt\nde/justsoftware/chat/mobile/service/MobilePushTokenService\n*L\n25#1:103\n25#1:104,3\n27#1:107,2\n27#1:109,2\n28#1:111\n28#1:112,3\n27#1:115\n56#1:121\n56#1:122,3\n37#1:116,2\n48#1:119,2\n*E\n"})
public class MobilePushTokenService {
    @NotNull
    private final MobilePushTokenRepository mobilePushTokenRepository;

    public MobilePushTokenService(@NotNull MobilePushTokenRepository mobilePushTokenRepository) {
        Intrinsics.checkNotNullParameter((Object)mobilePushTokenRepository, (String)"mobilePushTokenRepository");
        this.mobilePushTokenRepository = mobilePushTokenRepository;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ProfileId, List<MobilePushToken>> findByProfileIds(@NotNull Set<ProfileId> profileIds) {
        void $this$associateTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Iterable iterable = profileIds;
        MobilePushTokenRepository mobilePushTokenRepository = this.mobilePushTokenRepository;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ProfileId profileId = (ProfileId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        Iterable $this$associate$iv = mobilePushTokenRepository.findByProfileIds((Iterable)((List)destination$iv$iv)).entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Map map = destination$iv$iv2;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String profileId = (String)entry.getKey();
            List dbPushTokens = (List)entry.getValue();
            Iterable iterable2 = dbPushTokens;
            ProfileId profileId2 = ProfileId.Companion.fromCanonicalId(profileId);
            boolean $i$f$map2 = false;
            void var18_24 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                DbMobilePushToken dbMobilePushToken = (DbMobilePushToken)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl2 = false;
                collection.add(DbMobilePushToken.Companion.toMobilePushToken((DbMobilePushToken)it));
            }
            entry = TuplesKt.to((Object)profileId2, (Object)((List)destination$iv$iv3));
            map.put(entry.getFirst(), entry.getSecond());
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public MobilePushToken registerPushToken(@NotNull String token, @NotNull MobilePlatform platform, @NotNull ProfileId profileId, boolean iosSilenceAlerts) {
        void p0;
        void value$iv;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        ValidationException.Companion companion = ValidationException.Companion;
        boolean bl = !StringsKt.isBlank((CharSequence)token);
        boolean $i$f$validate = false;
        if (value$iv == false) {
            boolean bl2 = false;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 2;
            String string = null;
            String string2 = "Token is blank".toString();
            throw new ValidationException(string2, string, n, defaultConstructorMarker);
        }
        DbMobilePushToken dbMobilePushToken = this.findOrCreate(token, platform, profileId, iosSilenceAlerts);
        MobilePushTokenRepository mobilePushTokenRepository = this.mobilePushTokenRepository;
        DbMobilePushToken bl2 = dbMobilePushToken;
        DbMobilePushToken.Companion companion2 = DbMobilePushToken.Companion;
        boolean bl3 = false;
        DbMobilePushToken dbMobilePushToken2 = (DbMobilePushToken)mobilePushTokenRepository.save((Object)p0);
        Intrinsics.checkNotNullExpressionValue((Object)dbMobilePushToken2, (String)"let(...)");
        return companion2.toMobilePushToken(dbMobilePushToken2);
    }

    /*
     * WARNING - void declaration
     */
    public void unregisterPushToken(@NotNull String token, @NotNull MobilePlatform platform, @NotNull ProfileId profileId) {
        void value$iv;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        ValidationException.Companion companion = ValidationException.Companion;
        boolean bl = !StringsKt.isBlank((CharSequence)token);
        boolean $i$f$validate = false;
        if (value$iv == false) {
            boolean bl2 = false;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 2;
            String string = null;
            String string2 = "Token is blank".toString();
            throw new ValidationException(string2, string, n, defaultConstructorMarker);
        }
        this.findByTokenAndPlatform(token, platform).filter(arg_0 -> MobilePushTokenService.unregisterPushToken$lambda$5((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0)).ifPresent(arg_0 -> MobilePushTokenService.unregisterPushToken$lambda$6((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public void deletePushTokens(@NotNull Iterable<MobilePushToken.Id> ids) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Iterable<MobilePushToken.Id> iterable = ids;
        MobilePushTokenRepository mobilePushTokenRepository = this.mobilePushTokenRepository;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MobilePushToken.Id id = (MobilePushToken.Id)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DbMobilePushToken.Companion.toDbMobilePushTokenId((MobilePushToken.Id)it));
        }
        mobilePushTokenRepository.deleteAllByIdInBatch((Iterable)((List)destination$iv$iv));
    }

    @EventListener
    @Transactional
    public void onProfileDeleted(@NotNull ProfileDeletedEvent profileDeletedEvent) {
        Intrinsics.checkNotNullParameter((Object)profileDeletedEvent, (String)"profileDeletedEvent");
        this.mobilePushTokenRepository.deleteByProfileId(profileDeletedEvent.getProfileId().toCanonicalId());
    }

    @EventListener
    @Transactional
    public void onProfileUpdated(@NotNull ProfileUpdatedEvent profileUpdatedEvent) {
        Intrinsics.checkNotNullParameter((Object)profileUpdatedEvent, (String)"profileUpdatedEvent");
        if (profileUpdatedEvent.getOldStatus() == ProfileStatus.ACTIVE && profileUpdatedEvent.getNewStatus() != ProfileStatus.ACTIVE) {
            this.mobilePushTokenRepository.deleteByProfileId(profileUpdatedEvent.getProfileId().toCanonicalId());
        }
    }

    private DbMobilePushToken findOrCreate(String token, MobilePlatform platform, ProfileId profileId, boolean iosSilenceAlerts) {
        DbMobilePushToken dbMobilePushToken = this.findByTokenAndPlatform(token, platform).map(arg_0 -> MobilePushTokenService.findOrCreate$lambda$8((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0)).orElseGet(() -> MobilePushTokenService.findOrCreate$lambda$9(token, platform, profileId, iosSilenceAlerts));
        Intrinsics.checkNotNullExpressionValue((Object)dbMobilePushToken, (String)"orElseGet(...)");
        return dbMobilePushToken;
    }

    private Optional<DbMobilePushToken> findByTokenAndPlatform(String token, MobilePlatform platform) {
        Optional optional = this.mobilePushTokenRepository.findById((Object)new DbMobilePushToken.Id(token, platform));
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"findById(...)");
        return optional;
    }

    private static final boolean unregisterPushToken$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void unregisterPushToken$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final DbMobilePushToken findOrCreate$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DbMobilePushToken)$tmp0.invoke(p0);
    }

    private static final DbMobilePushToken findOrCreate$lambda$9(String $token, MobilePlatform $platform, ProfileId $profileId, boolean $iosSilenceAlerts) {
        Intrinsics.checkNotNullParameter((Object)$token, (String)"$token");
        Intrinsics.checkNotNullParameter((Object)$platform, (String)"$platform");
        Intrinsics.checkNotNullParameter((Object)$profileId, (String)"$profileId");
        return new DbMobilePushToken($token, $platform, $profileId.toCanonicalId(), $iosSilenceAlerts);
    }
}

