/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.chat.authorization.AuthorizationContext;
import de.justsoftware.chat.authorization.AuthorizationService;
import de.justsoftware.chat.config.ApplicationConfiguration;
import de.justsoftware.chat.config.AuthorizationContextResolver;
import de.justsoftware.chat.exception.UnauthorizedException;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.TenantId;
import de.justsoftware.jwtfilter.JwtAuthenticationToken;
import jakarta.servlet.http.HttpServletRequest;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.LocaleResolver;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0011\u001a\u00020\u00122\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0015H\u0002J\u001c\u0010\u0013\u001a\u00020\u00142\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000eH\u0002J,\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u000f\u001a\u00020\u0015H\u0002J\u001c\u0010\"\u001a\u00020#2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lde/justsoftware/chat/config/AuthorizationContextResolver;", "Lorg/springframework/web/method/support/HandlerMethodArgumentResolver;", "toroBaseUrl", "", "authorizationService", "Lde/justsoftware/chat/authorization/AuthorizationService;", "localeResolver", "Lorg/springframework/web/servlet/LocaleResolver;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "rest", "Lorg/springframework/web/client/RestTemplate;", "(Ljava/lang/String;Lde/justsoftware/chat/authorization/AuthorizationService;Lorg/springframework/web/servlet/LocaleResolver;Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/springframework/web/client/RestTemplate;)V", "currentPersonInfo", "", "authentication", "Lorg/springframework/security/oauth2/server/resource/authentication/BearerTokenAuthentication;", "locale", "Ljava/util/Locale;", "profileId", "Lde/justsoftware/chat/model/ProfileId;", "Lde/justsoftware/jwtfilter/JwtAuthenticationToken;", "resolveArgument", "Lde/justsoftware/chat/authorization/AuthorizationContext;", "parameter", "Lorg/springframework/core/MethodParameter;", "mavContainer", "Lorg/springframework/web/method/support/ModelAndViewContainer;", "webRequest", "Lorg/springframework/web/context/request/NativeWebRequest;", "binderFactory", "Lorg/springframework/web/bind/support/WebDataBinderFactory;", "supportsParameter", "", "tenantId", "Lde/justsoftware/chat/model/TenantId;", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nAuthorizationContextResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthorizationContextResolver.kt\nde/justsoftware/chat/config/AuthorizationContextResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 LoggerUtils.kt\nde/justsoftware/chat/util/LoggerUtilsKt\n*L\n1#1,168:1\n1#2:169\n1179#3,2:170\n1253#3,4:172\n9#4:176\n8#4,3:177\n*S KotlinDebug\n*F\n+ 1 AuthorizationContextResolver.kt\nde/justsoftware/chat/config/AuthorizationContextResolver\n*L\n102#1:170,2\n102#1:172,4\n165#1:176\n165#1:177,3\n*E\n"})
public final class AuthorizationContextResolver
implements HandlerMethodArgumentResolver {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String toroBaseUrl;
    @NotNull
    private final AuthorizationService authorizationService;
    @NotNull
    private final LocaleResolver localeResolver;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final RestTemplate rest;
    @NotNull
    private static final Logger LOG;

    public AuthorizationContextResolver(@NotNull String toroBaseUrl, @NotNull AuthorizationService authorizationService, @NotNull LocaleResolver localeResolver, @NotNull ObjectMapper objectMapper, @NotNull RestTemplate rest) {
        Intrinsics.checkNotNullParameter((Object)toroBaseUrl, (String)"toroBaseUrl");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        Intrinsics.checkNotNullParameter((Object)localeResolver, (String)"localeResolver");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)rest, (String)"rest");
        this.toroBaseUrl = toroBaseUrl;
        this.authorizationService = authorizationService;
        this.localeResolver = localeResolver;
        this.objectMapper = objectMapper;
        this.rest = rest;
    }

    public /* synthetic */ AuthorizationContextResolver(String string, AuthorizationService authorizationService, LocaleResolver localeResolver, ObjectMapper objectMapper, RestTemplate restTemplate, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            restTemplate = new RestTemplate();
        }
        this(string, authorizationService, localeResolver, objectMapper, restTemplate);
    }

    public boolean supportsParameter(@NotNull MethodParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        return Intrinsics.areEqual(AuthorizationContext.class, (Object)parameter.getParameterType());
    }

    @NotNull
    public AuthorizationContext resolveArgument(@NotNull MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, @NotNull NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws UnauthorizedException {
        AuthorizationContext authorizationContext;
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)webRequest, (String)"webRequest");
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new UnauthorizedException("You must be logged in to perform this request");
        }
        Authentication authentication2 = authentication;
        if ((authentication = authentication2) instanceof JwtAuthenticationToken) {
            Locale locale;
            Locale locale2;
            HttpServletRequest httpServletRequest;
            HttpServletRequest httpServletRequest2 = httpServletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
            if (httpServletRequest2 != null) {
                HttpServletRequest httpServletRequest3 = httpServletRequest2;
                LocaleResolver localeResolver = this.localeResolver;
                HttpServletRequest p0 = httpServletRequest3;
                boolean bl = false;
                locale2 = localeResolver.resolveLocale(p0);
            } else {
                locale2 = locale = null;
            }
            if (locale2 == null) {
                locale = ApplicationConfiguration.Companion.getDEFAULT_LOCALE();
            }
            Locale locale3 = locale;
            authorizationContext = new AuthorizationContext(this.profileId((JwtAuthenticationToken)authentication2), this.tenantId((JwtAuthenticationToken)authentication2), locale3, this.authorizationService);
        } else if (authentication instanceof BearerTokenAuthentication) {
            Map currentPersonInfo = this.currentPersonInfo((BearerTokenAuthentication)authentication2);
            authorizationContext = new AuthorizationContext(this.profileId(currentPersonInfo), this.tenantId(currentPersonInfo), this.locale(currentPersonInfo), this.authorizationService);
        } else {
            LOG.warn("We received an unknown type of authentication: " + authentication2.getClass().getName());
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        return authorizationContext;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> currentPersonInfo(BearerTokenAuthentication authentication) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        HttpHeaders headers2 = new HttpHeaders();
        headers2.add("Authorization", "Bearer " + ((OAuth2AccessToken)authentication.getToken()).getTokenValue());
        HttpEntity request = new HttpEntity((MultiValueMap)headers2);
        ResponseEntity response = this.rest.exchange(this.toroBaseUrl + "/api/v1/person/current", HttpMethod.GET, request, String.class, new Object[0]);
        boolean bl = false;
        if (response.getStatusCode() != HttpStatus.OK) {
            LOG.warn("Failed to retrieve person info from toro internal API: " + response.getStatusCode());
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        Iterable iterable = ((Map)this.objectMapper.readValue((String)response.getBody(), Map.class)).entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var9_9 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl2 = false;
            Object key = entry.getKey();
            Object value = entry.getValue();
            entry = TuplesKt.to((Object)String.valueOf(key), (Object)String.valueOf(value));
            map.put(entry.getFirst(), entry.getSecond());
        }
        return destination$iv$iv;
    }

    private final ProfileId profileId(JwtAuthenticationToken authentication) {
        ProfileId profileId;
        String principal = authentication.getPrincipal().toString();
        try {
            profileId = ProfileId.Companion.fromCanonicalId(principal);
        }
        catch (IllegalStateException ex) {
            LOG.warn("We received an unparsable profile ID: '" + principal + "'");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        return profileId;
    }

    private final ProfileId profileId(Map<String, String> currentPersonInfo) {
        ProfileId profileId;
        String profileIdString = currentPersonInfo.get("id");
        if (profileIdString == null) {
            LOG.warn("Failed to extract profile id from internal toro API response");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        try {
            profileId = ProfileId.Companion.fromCanonicalId(profileIdString);
        }
        catch (IllegalStateException ex) {
            LOG.warn("Received an unparsable profile ID from toro: '" + profileIdString + "'");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        return profileId;
    }

    private final TenantId tenantId(JwtAuthenticationToken authentication) {
        TenantId tenantId;
        Object object = authentication.getCustomJwtClaims().get((Object)"tenantId");
        if (object == null) {
            throw new UnauthorizedException("You must be logged in a valid tenant");
        }
        Object tenantId2 = object;
        try {
            tenantId = TenantId.Companion.fromCanonicalId(tenantId2.toString());
        }
        catch (IllegalStateException ex) {
            LOG.warn("We received an unparsable tenant ID: '" + tenantId2 + "'");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        return tenantId;
    }

    private final TenantId tenantId(Map<String, String> currentPersonInfo) {
        TenantId tenantId;
        String tenantIdString = currentPersonInfo.get("tenantId");
        if (tenantIdString == null) {
            LOG.warn("Failed to extract tenant id from internal toro API response");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        try {
            tenantId = TenantId.Companion.fromCanonicalId(tenantIdString);
        }
        catch (IllegalStateException ex) {
            LOG.warn("Received an unparsable tenant ID from toro: '" + tenantIdString + "'");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        return tenantId;
    }

    private final Locale locale(Map<String, String> currentPersonInfo) {
        Locale locale;
        String string = currentPersonInfo.get("language");
        if (string != null) {
            String p0 = string;
            boolean bl = false;
            locale = new Locale(p0);
        } else {
            locale = ApplicationConfiguration.Companion.getDEFAULT_LOCALE();
        }
        return locale;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

