/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.business.ChatMessageService;
import de.justsoftware.chat.business.ChatMessageService$validatedMessageForDelete$;
import de.justsoftware.chat.business.ChatService;
import de.justsoftware.chat.business.DriveService;
import de.justsoftware.chat.business.LoadDirection;
import de.justsoftware.chat.business.model.AttachmentFilter;
import de.justsoftware.chat.business.model.ChatMessage;
import de.justsoftware.chat.business.model.ChatMessageAttachment;
import de.justsoftware.chat.business.model.ChatMessageReaction;
import de.justsoftware.chat.business.model.MultiUserChat;
import de.justsoftware.chat.business.model.PersonMention;
import de.justsoftware.chat.business.model.SystemMessage;
import de.justsoftware.chat.business.model.UserMessage;
import de.justsoftware.chat.business.model.event.ChatCreatedEvent;
import de.justsoftware.chat.business.model.event.ChatParticipantsChangedEvent;
import de.justsoftware.chat.business.model.event.ChatUpdatedEvent;
import de.justsoftware.chat.exception.ChatMessageAlreadyExistsException;
import de.justsoftware.chat.exception.CitationDoesNotExistException;
import de.justsoftware.chat.exception.CitationOfNonUserMessageException;
import de.justsoftware.chat.exception.CrossChatCitationException;
import de.justsoftware.chat.exception.NotFoundException;
import de.justsoftware.chat.exception.ValidationException;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ChatMessageId;
import de.justsoftware.chat.model.ChatMessagePayload;
import de.justsoftware.chat.model.LimitOffset;
import de.justsoftware.chat.model.Offset;
import de.justsoftware.chat.model.ParticipantId;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.ReactionId;
import de.justsoftware.chat.model.UserGroupId;
import de.justsoftware.chat.persistence.ChatMessageReactionRepository;
import de.justsoftware.chat.persistence.ChatMessageRepository;
import de.justsoftware.chat.persistence.ChatMessageSpecifications;
import de.justsoftware.chat.persistence.ChatRepository;
import de.justsoftware.chat.persistence.PersonMentionRepository;
import de.justsoftware.chat.persistence.RemovedMessageReactionForSyncRepository;
import de.justsoftware.chat.persistence.model.DbChatMessage;
import de.justsoftware.chat.persistence.model.DbChatMessageAttachment;
import de.justsoftware.chat.persistence.model.DbChatMessageReaction;
import de.justsoftware.chat.persistence.model.DbProfileIdProjection;
import de.justsoftware.chat.persistence.model.DbReactionId;
import de.justsoftware.chat.persistence.model.DbRemovedMessageReactionForSync;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.chat.util.PagingUtilsKt;
import de.justsoftware.chat.util.TransactionUtils;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 m2\u00020\u0001:\u0001mBU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0017J\u001e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001e2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0012J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0012J\u0018\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0017J \u0010%\u001a\u00020&2\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020(2\u0006\u0010#\u001a\u00020$H\u0017J\u0010\u0010)\u001a\u00020&2\u0006\u0010!\u001a\u00020\"H\u0017J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00180+2\u0006\u0010,\u001a\u00020\"H\u0017J\"\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00180.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\"00H\u0017J$\u00101\u001a\b\u0012\u0004\u0012\u00020$002\f\u00102\u001a\b\u0012\u0004\u0012\u000204032\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\"H\u0017J$\u00108\u001a\b\u0012\u0004\u0012\u000209002\f\u00102\u001a\b\u0012\u0004\u0012\u000204032\u0006\u0010:\u001a\u000206H\u0016J4\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00180<2\u0006\u0010'\u001a\u00020(2\u0006\u0010=\u001a\u00020>2\b\b\u0002\u0010?\u001a\u00020@2\n\b\u0002\u0010A\u001a\u0004\u0018\u00010BH\u0017JD\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00180<2\u0006\u0010'\u001a\u00020(2\u0006\u0010=\u001a\u00020>2\b\b\u0002\u0010?\u001a\u00020@2\u0006\u0010D\u001a\u0002062\n\b\u0002\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010E\u001a\u00020FH\u0017JB\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00180<2\u0006\u0010?\u001a\u00020@2\u0006\u0010=\u001a\u00020>2\u0006\u0010'\u001a\u00020(2\b\u0010A\u001a\u0004\u0018\u00010B2\u0010\b\u0002\u0010H\u001a\n\u0012\u0004\u0012\u00020J\u0018\u00010IH\u0012J(\u0010K\u001a\u0014\u0012\u0004\u0012\u00020\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020L0\u001b0.2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\"03H\u0016J.\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00180<2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020(0P2\b\u0010:\u001a\u0004\u0018\u0001062\u0006\u0010=\u001a\u00020>H\u0016J$\u0010Q\u001a\b\u0012\u0004\u0012\u00020L0\u001b2\f\u00102\u001a\b\u0012\u0004\u0012\u000204032\u0006\u0010:\u001a\u000206H\u0016J\u0010\u0010R\u001a\u00020&2\u0006\u0010S\u001a\u00020TH\u0017J\u0010\u0010U\u001a\u00020&2\u0006\u0010V\u001a\u00020WH\u0017J\u0010\u0010X\u001a\u00020&2\u0006\u0010Y\u001a\u00020ZH\u0017J(\u0010[\u001a\u00020L2\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020(2\u0006\u0010#\u001a\u00020$2\u0006\u0010\\\u001a\u00020]H\u0017J\u0010\u0010^\u001a\u00020&2\u0006\u0010Y\u001a\u00020ZH\u0012J\u0010\u0010_\u001a\u00020&2\u0006\u0010Y\u001a\u00020ZH\u0012J\u001a\u0010`\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\"0b0aH\u0017J \u0010c\u001a\n d*\u0004\u0018\u00010\u001e0\u001e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0012J\f\u0010e\u001a\u00020&*\u00020\u001eH\u0016J\f\u0010f\u001a\u00020&*\u00020ZH\u0012J\f\u0010g\u001a\u00020&*\u00020\u001eH\u0016J+\u0010h\u001a\u0002Hi\"\b\b\u0000\u0010i*\u00020\u0018*\u0002Hi2\u000e\b\u0002\u0010j\u001a\b\u0012\u0004\u0012\u00020k0\u001bH\u0012\u00a2\u0006\u0002\u0010lR\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006n"}, d2={"Lde/justsoftware/chat/business/ChatMessageService;", "", "chatService", "Lde/justsoftware/chat/business/ChatService;", "chatMessageRepository", "Lde/justsoftware/chat/persistence/ChatMessageRepository;", "personMentionRepository", "Lde/justsoftware/chat/persistence/PersonMentionRepository;", "chatRepository", "Lde/justsoftware/chat/persistence/ChatRepository;", "chatMessageReactionRepository", "Lde/justsoftware/chat/persistence/ChatMessageReactionRepository;", "removedMessageReactionForSyncRepository", "Lde/justsoftware/chat/persistence/RemovedMessageReactionForSyncRepository;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "driveService", "Lde/justsoftware/chat/business/DriveService;", "transactionUtils", "Lde/justsoftware/chat/util/TransactionUtils;", "clock", "Ljava/time/Clock;", "(Lde/justsoftware/chat/business/ChatService;Lde/justsoftware/chat/persistence/ChatMessageRepository;Lde/justsoftware/chat/persistence/PersonMentionRepository;Lde/justsoftware/chat/persistence/ChatRepository;Lde/justsoftware/chat/persistence/ChatMessageReactionRepository;Lde/justsoftware/chat/persistence/RemovedMessageReactionForSyncRepository;Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/chat/business/DriveService;Lde/justsoftware/chat/util/TransactionUtils;Ljava/time/Clock;)V", "create", "Lde/justsoftware/chat/business/model/ChatMessage;", "chatMessage", "files", "", "Lorg/springframework/web/multipart/MultipartFile;", "createWithAttachments", "Lde/justsoftware/chat/business/model/UserMessage;", "createWithoutAttachments", "delete", "chatMessageId", "Lde/justsoftware/chat/model/ChatMessageId;", "profileId", "Lde/justsoftware/chat/model/ProfileId;", "deleteReaction", "", "chatId", "Lde/justsoftware/chat/model/ChatId;", "deleteReactions", "findById", "Ljava/util/Optional;", "id", "findByIds", "", "ids", "", "findUpdatedAuthorsAndReactors", "participantIds", "", "Lde/justsoftware/chat/model/ParticipantId;", "since", "Ljava/time/Instant;", "getById", "getDeletedReactionIds", "Lde/justsoftware/chat/model/ReactionId;", "updatedSince", "getMessages", "Lorg/springframework/data/domain/Page;", "limit", "", "loadDirection", "Lde/justsoftware/chat/business/LoadDirection;", "attachmentFilter", "Lde/justsoftware/chat/business/model/AttachmentFilter;", "getMessagesStartingAtTimestamp", "offsetTimestamp", "includeOffsetMessage", "", "getMessagesWithSpecification", "additionalSpecification", "Lorg/springframework/data/jpa/domain/Specification;", "Lde/justsoftware/chat/persistence/model/DbChatMessage;", "getReactions", "Lde/justsoftware/chat/business/model/ChatMessageReaction;", "messageIds", "getRecentMessages", "chatIds", "", "getUpdatedReactions", "onChatCreatedEvent", "chatCreatedEvent", "Lde/justsoftware/chat/business/model/event/ChatCreatedEvent;", "onChatInfoChangedEvent", "chatUpdatedEvent", "Lde/justsoftware/chat/business/model/event/ChatUpdatedEvent;", "onChatParticipantsChangedEvent", "chatParticipantsChangedEvent", "Lde/justsoftware/chat/business/model/event/ChatParticipantsChangedEvent;", "react", "reaction", "", "sendSystemMessageForAddedParticipants", "sendSystemMessageForRemovedParticipants", "streamAllUserMessageIds", "Ljava/util/stream/Stream;", "Lkotlin/Pair;", "validatedMessageForDelete", "kotlin.jvm.PlatformType", "checkNoDuplicateMentions", "handleDeletedParticipants", "validateCitation", "validatedForCreate", "T", "attachments", "Lde/justsoftware/chat/persistence/model/DbChatMessageAttachment;", "(Lde/justsoftware/chat/business/model/ChatMessage;Ljava/util/List;)Lde/justsoftware/chat/business/model/ChatMessage;", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nChatMessageService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatMessageService.kt\nde/justsoftware/chat/business/ChatMessageService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n+ 4 OptionalUtils.kt\nde/justsoftware/chat/util/OptionalUtilsKt\n*L\n1#1,611:1\n1549#2:612\n1620#2,3:613\n1549#2:616\n1620#2,3:617\n1179#2,2:620\n1253#2,4:622\n1549#2:626\n1620#2,3:627\n1549#2:630\n1620#2,3:631\n1620#2,3:635\n1620#2,3:639\n1549#2:642\n1620#2,3:643\n1271#2,2:646\n1285#2,2:648\n1549#2:650\n1620#2,3:651\n1288#2:654\n1549#2:655\n1620#2,3:656\n1549#2:659\n1620#2,3:660\n1549#2:663\n1620#2,3:664\n1620#2,3:668\n809#2,2:672\n1549#2:674\n1620#2,3:675\n7#3:634\n7#3:638\n7#3:667\n22#3:671\n5#4:678\n*S KotlinDebug\n*F\n+ 1 ChatMessageService.kt\nde/justsoftware/chat/business/ChatMessageService\n*L\n152#1:612\n152#1:613,3\n175#1:616\n175#1:617,3\n176#1:620,2\n176#1:622,4\n231#1:626\n231#1:627,3\n239#1:630\n239#1:631,3\n241#1:635,3\n243#1:639,3\n309#1:642\n309#1:643,3\n310#1:646,2\n310#1:648,2\n311#1:650\n311#1:651,3\n310#1:654\n320#1:655\n320#1:656,3\n322#1:659\n322#1:660,3\n329#1:663\n329#1:664,3\n331#1:668,3\n408#1:672,2\n446#1:674\n446#1:675,3\n241#1:634\n243#1:638\n331#1:667\n408#1:671\n571#1:678\n*E\n"})
public class ChatMessageService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChatService chatService;
    @NotNull
    private final ChatMessageRepository chatMessageRepository;
    @NotNull
    private final PersonMentionRepository personMentionRepository;
    @NotNull
    private final ChatRepository chatRepository;
    @NotNull
    private final ChatMessageReactionRepository chatMessageReactionRepository;
    @NotNull
    private final RemovedMessageReactionForSyncRepository removedMessageReactionForSyncRepository;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final DriveService driveService;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final Clock clock;
    @NotNull
    private static final Set<String> IMAGE_FORMATS;
    private static final int MAX_MESSAGE_LENGTH = 10000;

    public ChatMessageService(@NotNull ChatService chatService, @NotNull ChatMessageRepository chatMessageRepository, @NotNull PersonMentionRepository personMentionRepository, @NotNull ChatRepository chatRepository, @NotNull ChatMessageReactionRepository chatMessageReactionRepository, @NotNull RemovedMessageReactionForSyncRepository removedMessageReactionForSyncRepository, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull DriveService driveService, @NotNull TransactionUtils transactionUtils, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)chatService, (String)"chatService");
        Intrinsics.checkNotNullParameter((Object)chatMessageRepository, (String)"chatMessageRepository");
        Intrinsics.checkNotNullParameter((Object)personMentionRepository, (String)"personMentionRepository");
        Intrinsics.checkNotNullParameter((Object)chatRepository, (String)"chatRepository");
        Intrinsics.checkNotNullParameter((Object)chatMessageReactionRepository, (String)"chatMessageReactionRepository");
        Intrinsics.checkNotNullParameter((Object)removedMessageReactionForSyncRepository, (String)"removedMessageReactionForSyncRepository");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)driveService, (String)"driveService");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.chatService = chatService;
        this.chatMessageRepository = chatMessageRepository;
        this.personMentionRepository = personMentionRepository;
        this.chatRepository = chatRepository;
        this.chatMessageReactionRepository = chatMessageReactionRepository;
        this.removedMessageReactionForSyncRepository = removedMessageReactionForSyncRepository;
        this.applicationEventPublisher = applicationEventPublisher;
        this.driveService = driveService;
        this.transactionUtils = transactionUtils;
        this.clock = clock;
    }

    @Transactional
    @NotNull
    public ChatMessage create(@NotNull ChatMessage chatMessage, @NotNull List<? extends MultipartFile> files) throws ValidationException {
        ChatMessage chatMessage2;
        Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"chatMessage");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        ChatMessage chatMessage3 = chatMessage;
        if (chatMessage3 instanceof UserMessage) {
            chatMessage2 = files.isEmpty() ? this.createWithoutAttachments(chatMessage) : this.createWithAttachments((UserMessage)chatMessage, files);
        } else if (chatMessage3 instanceof SystemMessage) {
            chatMessage2 = this.createWithoutAttachments(chatMessage);
        } else {
            throw new ValidationException("Cannot create non-user-non-system message", null, 2, null);
        }
        ChatMessage savedChatMessage = chatMessage2;
        boolean bl = false;
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant(...)");
        ChatMessage updatedChatMessage = Companion.access$copy((Companion)Companion, (ChatMessage)savedChatMessage, (Instant)instant);
        this.chatMessageRepository.updateUpdatedAt(updatedChatMessage.getId().getValue(), updatedChatMessage.getUpdatedAt());
        this.chatService.updateOnNewMessage(updatedChatMessage);
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return updatedChatMessage;
    }

    public static /* synthetic */ ChatMessage create$default(ChatMessageService chatMessageService, ChatMessage chatMessage, List list, int n, Object object) throws ValidationException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create");
        }
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return chatMessageService.create(chatMessage, list);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public ChatMessage delete(@NotNull ChatMessageId chatMessageId, @NotNull ProfileId profileId) throws ValidationException {
        ChatMessage chatMessage;
        Intrinsics.checkNotNullParameter((Object)chatMessageId, (String)"chatMessageId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        UserMessage chatMessage2 = this.validatedMessageForDelete(chatMessageId, profileId);
        Intrinsics.checkNotNull((Object)chatMessage2);
        Object object = this.chatMessageRepository.save((Object)DbChatMessage.Companion.toDbChatMessage$default((DbChatMessage.Companion)DbChatMessage.Companion, (ChatMessage)((ChatMessage)UserMessage.Companion.toDeletedMessage(chatMessage2)), null, null, (int)3, null));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"save(...)");
        ChatMessage savedChatMessage = chatMessage = DbChatMessage.Companion.toChatMessage((DbChatMessage)object);
        boolean bl = false;
        Set set = SetsKt.setOf((Object)savedChatMessage.getChatId().getValue());
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant(...)");
        this.chatRepository.updateSyncDateByChatIds(set, instant);
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        if (!((Collection)chatMessage2.getAttachments()).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = chatMessage2.getAttachments();
            DriveService driveService = this.driveService;
            boolean $i$f$map = false;
            void var10_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ChatMessageAttachment chatMessageAttachment = (ChatMessageAttachment)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getDocumentId());
            }
            driveService.deleteFiles((List)destination$iv$iv, chatMessage2.getAuthor());
        }
        if (!((Collection)chatMessage2.getPersonMentions()).isEmpty()) {
            this.personMentionRepository.deleteByChatMessageId(chatMessageId.getValue());
        }
        this.deleteReactions(chatMessageId);
        return chatMessage;
    }

    @Transactional
    @NotNull
    public Optional<ChatMessage> findById(@NotNull ChatMessageId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Optional<ChatMessage> optional = this.chatMessageRepository.findById((Object)id.getValue()).map(arg_0 -> ChatMessageService.findById$lambda$3((Function1)findById.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"map(...)");
        return optional;
    }

    @Transactional
    @NotNull
    public ChatMessage getById(@NotNull ChatMessageId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object t = this.findById(id).orElseThrow(() -> ChatMessageService.getById$lambda$4(id));
        Intrinsics.checkNotNullExpressionValue(t, (String)"orElseThrow(...)");
        return (ChatMessage)t;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Map<ChatMessageId, ChatMessage> findByIds(@NotNull Set<ChatMessageId> ids) {
        void $this$associateTo$iv$iv;
        Object object;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Iterable iterable = ids;
        ChatMessageRepository chatMessageRepository = this.chatMessageRepository;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            object = (ChatMessageId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getValue());
        }
        List list = chatMessageRepository.findAllById((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAllById(...)");
        Iterable $this$associate$iv = list;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        $this$mapTo$iv$iv = $this$associate$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            object = destination$iv$iv;
            DbChatMessage dbChatMessage = (DbChatMessage)element$iv$iv;
            boolean bl = false;
            ChatMessageId chatMessageId = new ChatMessageId(dbChatMessage.getId());
            Intrinsics.checkNotNull((Object)dbChatMessage);
            Pair pair = TuplesKt.to((Object)chatMessageId, (Object)DbChatMessage.Companion.toChatMessage(dbChatMessage));
            object.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    @Transactional
    @NotNull
    public Stream<Pair<ChatId, ChatMessageId>> streamAllUserMessageIds() {
        Stream<Pair<ChatId, ChatMessageId>> stream = this.chatMessageRepository.streamAllUserMessageIds().map(arg_0 -> ChatMessageService.streamAllUserMessageIds$lambda$6((Function1)streamAllUserMessageIds.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"map(...)");
        return stream;
    }

    @Transactional
    @NotNull
    public Page<ChatMessage> getMessages(@NotNull ChatId chatId, int limit, @NotNull LoadDirection loadDirection, @Nullable AttachmentFilter attachmentFilter) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)loadDirection, (String)"loadDirection");
        return ChatMessageService.getMessagesWithSpecification$default((ChatMessageService)this, (LoadDirection)loadDirection, (int)limit, (ChatId)chatId, (AttachmentFilter)attachmentFilter, null, (int)16, null);
    }

    public static /* synthetic */ Page getMessages$default(ChatMessageService chatMessageService, ChatId chatId, int n, LoadDirection loadDirection, AttachmentFilter attachmentFilter, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getMessages");
        }
        if ((n2 & 4) != 0) {
            loadDirection = LoadDirection.OLDER;
        }
        if ((n2 & 8) != 0) {
            attachmentFilter = null;
        }
        return chatMessageService.getMessages(chatId, n, loadDirection, attachmentFilter);
    }

    @Transactional
    @NotNull
    public Page<ChatMessage> getMessagesStartingAtTimestamp(@NotNull ChatId chatId, int limit, @NotNull LoadDirection loadDirection, @NotNull Instant offsetTimestamp, @Nullable AttachmentFilter attachmentFilter, boolean includeOffsetMessage) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)loadDirection, (String)"loadDirection");
        Intrinsics.checkNotNullParameter((Object)offsetTimestamp, (String)"offsetTimestamp");
        Specification offsetTimestampSpec = loadDirection == LoadDirection.OLDER ? (includeOffsetMessage ? ChatMessageSpecifications.INSTANCE.createdBeforeOrAt(offsetTimestamp) : ChatMessageSpecifications.INSTANCE.createdBefore(offsetTimestamp)) : (includeOffsetMessage ? ChatMessageSpecifications.INSTANCE.createdAfterOrAt(offsetTimestamp) : ChatMessageSpecifications.INSTANCE.createdAfter(offsetTimestamp));
        return this.getMessagesWithSpecification(loadDirection, limit, chatId, attachmentFilter, offsetTimestampSpec);
    }

    public static /* synthetic */ Page getMessagesStartingAtTimestamp$default(ChatMessageService chatMessageService, ChatId chatId, int n, LoadDirection loadDirection, Instant instant, AttachmentFilter attachmentFilter, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getMessagesStartingAtTimestamp");
        }
        if ((n2 & 4) != 0) {
            loadDirection = LoadDirection.OLDER;
        }
        if ((n2 & 0x10) != 0) {
            attachmentFilter = null;
        }
        return chatMessageService.getMessagesStartingAtTimestamp(chatId, n, loadDirection, instant, attachmentFilter, bl);
    }

    private Page<ChatMessage> getMessagesWithSpecification(LoadDirection loadDirection, int limit, ChatId chatId, AttachmentFilter attachmentFilter, Specification<DbChatMessage> additionalSpecification) {
        Pageable pageable;
        if (loadDirection == LoadDirection.OLDER) {
            var7_6 = new String[]{"createdAt"};
            pageable = Offset.Companion.toPageable((Offset)new LimitOffset(0L, limit, 1, null), PagingUtilsKt.sortDesc((String[])var7_6));
        } else {
            var7_6 = new String[]{"createdAt"};
            pageable = Offset.Companion.toPageable((Offset)new LimitOffset(0L, limit, 1, null), PagingUtilsKt.sortAsc((String[])var7_6));
        }
        Pageable pageable2 = pageable;
        Specification specification = ChatMessageSpecifications.INSTANCE.withChatId(chatId.getValue()).and(additionalSpecification).and(ChatMessageSpecifications.INSTANCE.withAttachments(attachmentFilter));
        Page page = this.chatMessageRepository.findAll(specification, pageable2).map(arg_0 -> ChatMessageService.getMessagesWithSpecification$lambda$7((Function1)getMessagesWithSpecification.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"map(...)");
        return page;
    }

    static /* synthetic */ Page getMessagesWithSpecification$default(ChatMessageService chatMessageService, LoadDirection loadDirection, int n, ChatId chatId, AttachmentFilter attachmentFilter, Specification specification, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getMessagesWithSpecification");
        }
        if ((n2 & 0x10) != 0) {
            specification = null;
        }
        return chatMessageService.getMessagesWithSpecification(loadDirection, n, chatId, attachmentFilter, specification);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Page<ChatMessage> getRecentMessages(@NotNull Collection<ChatId> chatIds2, @Nullable Instant updatedSince, int limit) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(chatIds2, (String)"chatIds");
        if (!(chatIds2.size() <= 1000)) {
            boolean $i$a$-require-ChatMessageService$getRecentMessages$22 = false;
            String $i$a$-require-ChatMessageService$getRecentMessages$22 = "Got " + chatIds2.size() + " chat IDs, but only 1000 are allowed in a WHERE-IN-clause";
            throw new IllegalArgumentException($i$a$-require-ChatMessageService$getRecentMessages$22.toString());
        }
        Iterable $i$a$-require-ChatMessageService$getRecentMessages$22 = chatIds2;
        ChatMessageSpecifications chatMessageSpecifications = ChatMessageSpecifications.INSTANCE;
        boolean $i$f$map = false;
        void var7_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChatId chatId = (ChatId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getValue());
        }
        Specification specification = chatMessageSpecifications.withChatIdIn((Collection)((List)destination$iv$iv)).and(ChatMessageSpecifications.INSTANCE.updatedAfter(updatedSince));
        String[] stringArray = new String[]{"createdAt"};
        Pageable pageable = Offset.Companion.toPageable((Offset)new LimitOffset(0L, limit, 1, null), PagingUtilsKt.sortDesc((String[])stringArray));
        Page page = this.chatMessageRepository.findAll(specification, pageable).map(arg_0 -> ChatMessageService.getRecentMessages$lambda$10((Function1)getRecentMessages.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"map(...)");
        return page;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ProfileId> findUpdatedAuthorsAndReactors(@NotNull Iterable<? extends ParticipantId> participantIds, @NotNull Instant since) {
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        void $this$mapTo$iv$iv2;
        void $this$mapToSet$iv2;
        Collection collection;
        void $this$mapTo$iv$iv3;
        Intrinsics.checkNotNullParameter(participantIds, (String)"participantIds");
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        Iterable<? extends ParticipantId> $this$map$iv = participantIds;
        boolean $i$f$map22 = false;
        Iterable<? extends ParticipantId> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void p0;
            ParticipantId participantId = (ParticipantId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        List canonicalParticipantIds = (List)destination$iv$iv;
        Iterable $i$f$map22 = this.chatMessageRepository.findUpdatedAuthorsByParticipantIds((Iterable)canonicalParticipantIds, since);
        boolean $i$f$mapToSet22 = false;
        destination$iv$iv = $this$mapToSet$iv2;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv2));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            String bl = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(ProfileId.Companion.fromCanonicalId((String)it));
        }
        Set updatedAuthors = (Set)destination$iv$iv2;
        Iterable $i$f$mapToSet22 = this.chatMessageRepository.findUpdatedReactorsByParticipantIds((Iterable)canonicalParticipantIds, since);
        boolean $i$f$mapToSet = false;
        destination$iv$iv2 = $this$mapToSet$iv;
        Collection destination$iv$iv3 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String bl2 = (String)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(ProfileId.Companion.fromCanonicalId((String)it));
        }
        Set updatedReactors = (Set)destination$iv$iv3;
        return CollectionsKt.union((Iterable)updatedAuthors, (Iterable)updatedReactors);
    }

    @Transactional
    @NotNull
    public ChatMessageReaction react(@NotNull ChatMessageId chatMessageId, @NotNull ChatId chatId, @NotNull ProfileId profileId, @NotNull String reaction) {
        Intrinsics.checkNotNullParameter((Object)chatMessageId, (String)"chatMessageId");
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)reaction, (String)"reaction");
        UserMessage message = Companion.access$validatedForReaction((Companion)Companion, (ChatMessage)this.getById(chatMessageId), (ChatId)chatId);
        DbChatMessageReaction dbReaction = (DbChatMessageReaction)this.chatMessageReactionRepository.save((Object)new DbChatMessageReaction(chatMessageId.getValue(), profileId.toCanonicalId(), reaction));
        this.removedMessageReactionForSyncRepository.deleteById((Object)new DbReactionId(chatMessageId.getValue(), profileId.toCanonicalId()));
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNull((Object)dbReaction);
        return DbChatMessageReaction.Companion.toChatMessageReaction(dbReaction);
    }

    @Transactional
    public void deleteReaction(@NotNull ChatMessageId chatMessageId, @NotNull ChatId chatId, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)chatMessageId, (String)"chatMessageId");
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        UserMessage message = Companion.access$validatedForReaction((Companion)Companion, (ChatMessage)this.getById(chatMessageId), (ChatId)chatId);
        this.chatMessageReactionRepository.deleteById((Object)new DbReactionId(chatMessageId.getValue(), profileId.toCanonicalId()));
        this.removedMessageReactionForSyncRepository.save((Object)new DbRemovedMessageReactionForSync(chatMessageId.getValue(), profileId.toCanonicalId()));
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Transactional
    public void deleteReactions(@NotNull ChatMessageId chatMessageId) {
        Intrinsics.checkNotNullParameter((Object)chatMessageId, (String)"chatMessageId");
        List reactionProfileIds = this.chatMessageReactionRepository.findProfileIdsByMessageId(chatMessageId.getValue());
        this.chatMessageReactionRepository.deleteByMessageIds((Iterable)CollectionsKt.listOf((Object)chatMessageId.getValue()));
        for (DbProfileIdProjection profileIdProjection : reactionProfileIds) {
            this.removedMessageReactionForSyncRepository.save((Object)new DbRemovedMessageReactionForSync(chatMessageId.getValue(), profileIdProjection.getProfileId()));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ChatMessageId, List<ChatMessageReaction>> getReactions(@NotNull Iterable<ChatMessageId> messageIds) {
        ChatMessageId it;
        boolean bl;
        Object object;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(messageIds, (String)"messageIds");
        Iterable<ChatMessageId> iterable = messageIds;
        Object object2 = this.chatMessageReactionRepository;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            ChatMessageId chatMessageId = (ChatMessageId)t;
            object = destination$iv$iv;
            bl = false;
            object.add(it.getValue());
        }
        Map reactions2 = object2.findByMessageIds((Iterable)((List)destination$iv$iv));
        Iterable<ChatMessageId> $this$associateWith$iv = messageIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, (int)10)), (int)16));
        Iterable<ChatMessageId> $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object object3 : $this$associateWithTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void messageId;
            it = (ChatMessageId)object3;
            object = object3;
            object2 = result$iv;
            bl = false;
            Iterable $this$map$iv2 = reactions2.getOrDefault(messageId.getValue(), CollectionsKt.emptyList());
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it2;
                DbChatMessageReaction dbChatMessageReaction = (DbChatMessageReaction)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(DbChatMessageReaction.Companion.toChatMessageReaction((DbChatMessageReaction)it2));
            }
            List list = (List)destination$iv$iv2;
            object2.put(object, list);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ChatMessageReaction> getUpdatedReactions(@NotNull Iterable<? extends ParticipantId> participantIds, @NotNull Instant updatedSince) {
        DbChatMessageReaction p0;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(participantIds, (String)"participantIds");
        Intrinsics.checkNotNullParameter((Object)updatedSince, (String)"updatedSince");
        Iterable<? extends ParticipantId> iterable = participantIds;
        Object object = this.chatMessageReactionRepository;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ParticipantId participantId = (ParticipantId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        $this$map$iv = object.findByUpdatedAtGreaterThanAndParticipantIds((Iterable)((List)destination$iv$iv), updatedSince);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            p0 = (DbChatMessageReaction)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(DbChatMessageReaction.Companion.toChatMessageReaction((DbChatMessageReaction)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ReactionId> getDeletedReactionIds(@NotNull Iterable<? extends ParticipantId> participantIds, @NotNull Instant updatedSince) {
        DbReactionId p0;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(participantIds, (String)"participantIds");
        Intrinsics.checkNotNullParameter((Object)updatedSince, (String)"updatedSince");
        Iterable<? extends ParticipantId> iterable = participantIds;
        Object object = this.removedMessageReactionForSyncRepository;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ParticipantId participantId = (ParticipantId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        Iterable $this$mapToSet$iv = object.findByUpdatedAtGreaterThanAndParticipantIds((Iterable)((List)destination$iv$iv), updatedSince);
        boolean $i$f$mapToSet = false;
        $this$mapTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            p0 = (DbReactionId)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(ReactionId.Companion.toReactionId((DbReactionId)it));
        }
        return (Set)destination$iv$iv;
    }

    @EventListener
    public void onChatInfoChangedEvent(@NotNull ChatUpdatedEvent chatUpdatedEvent) {
        Intrinsics.checkNotNullParameter((Object)chatUpdatedEvent, (String)"chatUpdatedEvent");
        ChatUpdatedEvent $this$onChatInfoChangedEvent_u24lambda_u2421 = chatUpdatedEvent;
        boolean bl = false;
        if (!($this$onChatInfoChangedEvent_u24lambda_u2421.getNewChat() instanceof MultiUserChat) || !($this$onChatInfoChangedEvent_u24lambda_u2421.getOldChat() instanceof MultiUserChat)) {
            return;
        }
        if (!Intrinsics.areEqual((Object)((MultiUserChat)$this$onChatInfoChangedEvent_u24lambda_u2421.getOldChat()).getTitle(), (Object)((MultiUserChat)$this$onChatInfoChangedEvent_u24lambda_u2421.getNewChat()).getTitle())) {
            ChatMessageId chatMessageId = ChatMessageId.Companion.generate();
            ChatId chatId = $this$onChatInfoChangedEvent_u24lambda_u2421.getOldChat().getId();
            ChatMessagePayload chatMessagePayload = (ChatMessagePayload)new ChatMessagePayload.ChatTitleChanged(((MultiUserChat)$this$onChatInfoChangedEvent_u24lambda_u2421.getOldChat()).getTitle(), ((MultiUserChat)$this$onChatInfoChangedEvent_u24lambda_u2421.getNewChat()).getTitle());
            ProfileId profileId = $this$onChatInfoChangedEvent_u24lambda_u2421.getUpdater();
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            ChatMessageService.create$default((ChatMessageService)this, (ChatMessage)((ChatMessage)new SystemMessage(chatMessageId, chatId, chatMessagePayload, profileId, instant, instant2)), null, (int)2, null);
        }
        if (!Intrinsics.areEqual((Object)((MultiUserChat)$this$onChatInfoChangedEvent_u24lambda_u2421.getOldChat()).getIconId(), (Object)((MultiUserChat)$this$onChatInfoChangedEvent_u24lambda_u2421.getNewChat()).getIconId())) {
            ChatMessageId chatMessageId = ChatMessageId.Companion.generate();
            ChatId chatId = $this$onChatInfoChangedEvent_u24lambda_u2421.getOldChat().getId();
            ChatMessagePayload chatMessagePayload = (ChatMessagePayload)ChatMessagePayload.ChatIconChanged.INSTANCE;
            ProfileId profileId = $this$onChatInfoChangedEvent_u24lambda_u2421.getUpdater();
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            Instant instant3 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant3, (String)"now(...)");
            ChatMessageService.create$default((ChatMessageService)this, (ChatMessage)((ChatMessage)new SystemMessage(chatMessageId, chatId, chatMessagePayload, profileId, instant, instant3)), null, (int)2, null);
        }
    }

    @EventListener
    public void onChatCreatedEvent(@NotNull ChatCreatedEvent chatCreatedEvent) {
        Intrinsics.checkNotNullParameter((Object)chatCreatedEvent, (String)"chatCreatedEvent");
        ChatCreatedEvent $this$onChatCreatedEvent_u24lambda_u2422 = chatCreatedEvent;
        boolean bl = false;
        if ($this$onChatCreatedEvent_u24lambda_u2422.getChat() instanceof MultiUserChat) {
            ChatMessageId chatMessageId = ChatMessageId.Companion.generate();
            ChatId chatId = $this$onChatCreatedEvent_u24lambda_u2422.getChatId();
            ChatMessagePayload chatMessagePayload = (ChatMessagePayload)new ChatMessagePayload.ChatCreated(((MultiUserChat)$this$onChatCreatedEvent_u24lambda_u2422.getChat()).getTitle());
            ProfileId profileId = $this$onChatCreatedEvent_u24lambda_u2422.getCreator();
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            ChatMessageService.create$default((ChatMessageService)this, (ChatMessage)((ChatMessage)new SystemMessage(chatMessageId, chatId, chatMessagePayload, profileId, instant, instant2)), null, (int)2, null);
        }
    }

    @EventListener
    public void onChatParticipantsChangedEvent(@NotNull ChatParticipantsChangedEvent chatParticipantsChangedEvent) {
        Intrinsics.checkNotNullParameter((Object)chatParticipantsChangedEvent, (String)"chatParticipantsChangedEvent");
        ChatParticipantsChangedEvent $this$onChatParticipantsChangedEvent_u24lambda_u2423 = chatParticipantsChangedEvent;
        boolean bl = false;
        if ($this$onChatParticipantsChangedEvent_u24lambda_u2423.getWithSystemMessage()) {
            if (!((Collection)$this$onChatParticipantsChangedEvent_u24lambda_u2423.getParticipantsRemoved()).isEmpty()) {
                this.sendSystemMessageForRemovedParticipants(chatParticipantsChangedEvent);
            }
            if (!((Collection)$this$onChatParticipantsChangedEvent_u24lambda_u2423.getParticipantsAdded()).isEmpty()) {
                this.sendSystemMessageForAddedParticipants(chatParticipantsChangedEvent);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void sendSystemMessageForRemovedParticipants(ChatParticipantsChangedEvent chatParticipantsChangedEvent) {
        ChatParticipantsChangedEvent $this$sendSystemMessageForRemovedParticipants_u24lambda_u2424 = chatParticipantsChangedEvent;
        boolean bl = false;
        if ($this$sendSystemMessageForRemovedParticipants_u24lambda_u2424.getUpdater() == null) {
            this.handleDeletedParticipants($this$sendSystemMessageForRemovedParticipants_u24lambda_u2424);
        } else {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstanceToSet$iv = $this$sendSystemMessageForRemovedParticipants_u24lambda_u2424.getParticipantsRemoved();
            boolean $i$f$filterIsInstanceToSet = false;
            Iterable iterable = $this$filterIsInstanceToSet$iv;
            Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv));
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ProfileId)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Set removedProfileIdsStayingInUserGroups = SetsKt.minus((Set)((Set)destination$iv$iv), (Iterable)$this$sendSystemMessageForRemovedParticipants_u24lambda_u2424.getEffectiveProfileIdsRemoved());
            ChatMessageId chatMessageId = ChatMessageId.Companion.generate();
            ChatId chatId = $this$sendSystemMessageForRemovedParticipants_u24lambda_u2424.getChatId();
            ChatMessagePayload chatMessagePayload = (ChatMessagePayload)new ChatMessagePayload.RemovedFromChat($this$sendSystemMessageForRemovedParticipants_u24lambda_u2424.getParticipantsRemoved(), removedProfileIdsStayingInUserGroups);
            ProfileId profileId = $this$sendSystemMessageForRemovedParticipants_u24lambda_u2424.getUpdater();
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            ChatMessageService.create$default((ChatMessageService)this, (ChatMessage)((ChatMessage)new SystemMessage(chatMessageId, chatId, chatMessagePayload, profileId, instant, instant2)), null, (int)2, null);
        }
    }

    private void sendSystemMessageForAddedParticipants(ChatParticipantsChangedEvent chatParticipantsChangedEvent) {
        ChatParticipantsChangedEvent $this$sendSystemMessageForAddedParticipants_u24lambda_u2425 = chatParticipantsChangedEvent;
        boolean bl = false;
        if ($this$sendSystemMessageForAddedParticipants_u24lambda_u2425.getUpdater() != null && !$this$sendSystemMessageForAddedParticipants_u24lambda_u2425.isNewChat()) {
            ChatMessageId chatMessageId = ChatMessageId.Companion.generate();
            ChatId chatId = $this$sendSystemMessageForAddedParticipants_u24lambda_u2425.getChatId();
            ChatMessagePayload chatMessagePayload = (ChatMessagePayload)new ChatMessagePayload.AddedToChat($this$sendSystemMessageForAddedParticipants_u24lambda_u2425.getParticipantsAdded());
            ProfileId profileId = $this$sendSystemMessageForAddedParticipants_u24lambda_u2425.getUpdater();
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            ChatMessageService.create$default((ChatMessageService)this, (ChatMessage)((ChatMessage)new SystemMessage(chatMessageId, chatId, chatMessagePayload, profileId, instant, instant2)), null, (int)2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private ChatMessage createWithoutAttachments(ChatMessage chatMessage) throws ValidationException {
        List list;
        if (chatMessage instanceof UserMessage) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((UserMessage)chatMessage).getPersonMentions();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PersonMention personMention = (PersonMention)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(PersonMention.Companion.toDbPersonMention((PersonMention)it, chatMessage));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List dbPersonMentions = list;
        Object object = this.chatMessageRepository.save((Object)DbChatMessage.Companion.toDbChatMessage$default((DbChatMessage.Companion)DbChatMessage.Companion, (ChatMessage)ChatMessageService.validatedForCreate$default((ChatMessageService)this, (ChatMessage)chatMessage, null, (int)1, null), null, (List)dbPersonMentions, (int)1, null));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"save(...)");
        return DbChatMessage.Companion.toChatMessage((DbChatMessage)object);
    }

    private ChatMessage createWithAttachments(UserMessage chatMessage, List<? extends MultipartFile> files) throws ValidationException {
        if (chatMessage.getMessage() != null) {
            throw new ValidationException("Message text must be null", null, 2, null);
        }
        if (files.size() > 1) {
            throw new ValidationException("Only one attachment may be uploaded at a time", null, 2, null);
        }
        return (ChatMessage)this.driveService.uploadFiles(files, chatMessage.getChatId().toPermissionItemId(), chatMessage.getAuthor(), (Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void handleDeletedParticipants(ChatParticipantsChangedEvent $this$handleDeletedParticipants) {
        if ($this$handleDeletedParticipants.getParticipantsRemoved().size() == 1) {
            ParticipantId removedParticipant = (ParticipantId)CollectionsKt.first((Iterable)$this$handleDeletedParticipants.getParticipantsRemoved());
            if (removedParticipant instanceof ProfileId) {
                ChatMessageId chatMessageId = ChatMessageId.Companion.generate();
                ChatId chatId = $this$handleDeletedParticipants.getChatId();
                ChatMessagePayload chatMessagePayload = (ChatMessagePayload)new ChatMessagePayload.PersonDeleted((ProfileId)removedParticipant);
                ProfileId profileId = ProfileId.Companion.getDELETED_USER();
                Instant instant = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
                Instant instant2 = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
                ChatMessageService.create$default((ChatMessageService)this, (ChatMessage)((ChatMessage)new SystemMessage(chatMessageId, chatId, chatMessagePayload, profileId, instant, instant2)), null, (int)2, null);
            } else if (removedParticipant instanceof UserGroupId) {
                ChatMessageId chatMessageId = ChatMessageId.Companion.generate();
                ChatId chatId = $this$handleDeletedParticipants.getChatId();
                ChatMessagePayload chatMessagePayload = (ChatMessagePayload)new ChatMessagePayload.UserGroupDeleted((UserGroupId)removedParticipant);
                ProfileId profileId = ProfileId.Companion.getDELETED_USER();
                Instant instant = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
                Instant instant3 = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant3, (String)"now(...)");
                ChatMessageService.create$default((ChatMessageService)this, (ChatMessage)((ChatMessage)new SystemMessage(chatMessageId, chatId, chatMessagePayload, profileId, instant, instant3)), null, (int)2, null);
            }
        }
    }

    private <T extends ChatMessage> T validatedForCreate(T $this$validatedForCreate, List<DbChatMessageAttachment> attachments) throws ValidationException {
        T t;
        T $this$validatedForCreate_u24lambda_u2427 = t = $this$validatedForCreate;
        boolean bl = false;
        if ($this$validatedForCreate_u24lambda_u2427 instanceof UserMessage) {
            CharSequence charSequence = ((UserMessage)$this$validatedForCreate_u24lambda_u2427).getMessage();
            if ((charSequence == null || charSequence.length() == 0) && attachments.isEmpty()) {
                throw new ValidationException("User message with neither text nor attachments is not allowed.", null, 2, null);
            }
            if (((UserMessage)$this$validatedForCreate_u24lambda_u2427).getMessage() != null && StringsKt.replace$default((String)((UserMessage)$this$validatedForCreate_u24lambda_u2427).getMessage(), (String)"\r\n", (String)"\n", (boolean)false, (int)4, null).length() > 10000) {
                throw new ValidationException("User message to large. Only 10000 characters allowed.", "TEXT_MESSAGE_TOO_LARGE");
            }
            this.checkNoDuplicateMentions((UserMessage)$this$validatedForCreate_u24lambda_u2427);
            this.validateCitation((UserMessage)$this$validatedForCreate_u24lambda_u2427);
        }
        if (this.chatMessageRepository.existsById((Object)$this$validatedForCreate_u24lambda_u2427.getId().getValue())) {
            throw new ChatMessageAlreadyExistsException($this$validatedForCreate_u24lambda_u2427.getId(), "Chat message with id " + $this$validatedForCreate_u24lambda_u2427.getId() + " already exists.");
        }
        return t;
    }

    static /* synthetic */ ChatMessage validatedForCreate$default(ChatMessageService chatMessageService, ChatMessage chatMessage, List list, int n, Object object) throws ValidationException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: validatedForCreate");
        }
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        return chatMessageService.validatedForCreate(chatMessage, list);
    }

    public void validateCitation(@NotNull UserMessage $this$validateCitation) {
        Intrinsics.checkNotNullParameter((Object)$this$validateCitation, (String)"<this>");
        if ($this$validateCitation.getCitedMessageId() == null) {
            return;
        }
        DbChatMessage citedMessage = (DbChatMessage)this.chatMessageRepository.findById((Object)$this$validateCitation.getCitedMessageId().getValue()).orElseThrow(ChatMessageService::validateCitation$lambda$28);
        if (!Intrinsics.areEqual((Object)citedMessage.getChatId(), (Object)$this$validateCitation.getChatId().getValue())) {
            throw new CrossChatCitationException("Message from a different chat cannot be cited.");
        }
        Intrinsics.checkNotNull((Object)citedMessage);
        if (!(DbChatMessage.Companion.toChatMessage(citedMessage) instanceof UserMessage)) {
            throw new CitationOfNonUserMessageException("Can only cite user messages.");
        }
    }

    public void checkNoDuplicateMentions(@NotNull UserMessage $this$checkNoDuplicateMentions) {
        Intrinsics.checkNotNullParameter((Object)$this$checkNoDuplicateMentions, (String)"<this>");
        Set profileIdSet = new LinkedHashSet();
        for (PersonMention mention : $this$checkNoDuplicateMentions.getPersonMentions()) {
            if (profileIdSet.contains(mention.getProfileId())) {
                throw new ValidationException("Mention Metadata should contain each profile only once. " + mention.getProfileId() + " was present multiple times.", null, 2, null);
            }
            profileIdSet.add(mention.getProfileId());
        }
    }

    private UserMessage validatedMessageForDelete(ChatMessageId chatMessageId, ProfileId profileId) throws ValidationException {
        Optional $this$filterIsInstance$iv = this.findById(chatMessageId);
        boolean $i$f$filterIsInstance = false;
        Optional optional = $this$filterIsInstance$iv.map((Function)validatedMessageForDelete$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"map(...)");
        return (UserMessage)optional.filter(arg_0 -> ChatMessageService.validatedMessageForDelete$lambda$29((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0)).orElseThrow(() -> ChatMessageService.validatedMessageForDelete$lambda$30(chatMessageId));
    }

    private static final ChatMessage findById$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ChatMessage)$tmp0.invoke(p0);
    }

    private static final NotFoundException getById$lambda$4(ChatMessageId $id) {
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        return new NotFoundException("Chat message with id " + $id + " does not exist.");
    }

    private static final Pair streamAllUserMessageIds$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Pair)$tmp0.invoke(p0);
    }

    private static final ChatMessage getMessagesWithSpecification$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ChatMessage)$tmp0.invoke(p0);
    }

    private static final ChatMessage getRecentMessages$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ChatMessage)$tmp0.invoke(p0);
    }

    private static final CitationDoesNotExistException validateCitation$lambda$28() {
        return new CitationDoesNotExistException("Non-existent message cannot be cited.");
    }

    private static final boolean validatedMessageForDelete$lambda$29(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final ValidationException validatedMessageForDelete$lambda$30(ChatMessageId $chatMessageId) {
        Intrinsics.checkNotNullParameter((Object)$chatMessageId, (String)"$chatMessageId");
        return new ValidationException("ChatMessage with id " + $chatMessageId + " could not be deleted", null, 2, null);
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getApplicationEventPublisher$p(ChatMessageService $this) {
        return $this.applicationEventPublisher;
    }

    public static final /* synthetic */ ChatMessageRepository access$getChatMessageRepository$p(ChatMessageService $this) {
        return $this.chatMessageRepository;
    }

    public static final /* synthetic */ ChatMessage access$validatedForCreate(ChatMessageService $this, ChatMessage $receiver, List attachments) {
        return $this.validatedForCreate($receiver, attachments);
    }

    public static final /* synthetic */ Set access$getIMAGE_FORMATS$cp() {
        return IMAGE_FORMATS;
    }

    public static final /* synthetic */ ChatService access$getChatService$p(ChatMessageService $this) {
        return $this.chatService;
    }

    static {
        Object[] objectArray = new String[]{"image/bmp", "image/gif", "image/jpeg", "image/png", "image/x-png", "image/tiff", "image/webp", "image/svg+xml"};
        IMAGE_FORMATS = SetsKt.setOf((Object[])objectArray);
    }
}

