/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.authorization;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.chat.authorization.AuthorizationContext;
import de.justsoftware.chat.business.ProfileService;
import de.justsoftware.chat.business.UserGroupService;
import de.justsoftware.chat.business.model.ChatParticipant;
import de.justsoftware.chat.business.model.Profile;
import de.justsoftware.chat.exception.NotAllowedException;
import de.justsoftware.chat.exception.NotFoundException;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ParticipantId;
import de.justsoftware.chat.model.PermissionAction;
import de.justsoftware.chat.model.PermissionRole;
import de.justsoftware.chat.model.PermissionType;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.ProfileStatus;
import de.justsoftware.chat.model.TenantId;
import de.justsoftware.chat.model.UserGroupId;
import de.justsoftware.chat.persistence.ChatParticipantRepository;
import de.justsoftware.chat.persistence.model.DbChatParticipant;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.permission.client.model.AuthorizationResult;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import io.micrometer.observation.annotation.Observed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Observed
@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J2\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J*\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u00192\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J6\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001a0\u00192\u0018\u0010 \u001a\u0014\u0012\u0004\u0012\u00020!\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00150\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0012J*\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0012JB\u0010'\u001a\u000e\u0012\u0004\u0012\u0002H(\u0012\u0004\u0012\u00020\u001a0\u0019\"\b\b\u0000\u0010(*\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H(0\u00152\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u00152\u0006\u0010-\u001a\u00020\u0010H\u0016J*\u0010.\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u001a0\u00192\f\u00100\u001a\b\u0012\u0004\u0012\u00020/0\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u00101\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u00102\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00152\u0006\u00104\u001a\u00020\u0010H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lde/justsoftware/chat/authorization/AuthorizationService;", "", "permissionRequestConnector", "Lde/justsoftware/permission/client/rest/PermissionRequestConnector;", "userGroupService", "Lde/justsoftware/chat/business/UserGroupService;", "profileService", "Lde/justsoftware/chat/business/ProfileService;", "chatParticipantRepository", "Lde/justsoftware/chat/persistence/ChatParticipantRepository;", "(Lde/justsoftware/permission/client/rest/PermissionRequestConnector;Lde/justsoftware/chat/business/UserGroupService;Lde/justsoftware/chat/business/ProfileService;Lde/justsoftware/chat/persistence/ChatParticipantRepository;)V", "checkChatPermission", "", "chatId", "Lde/justsoftware/chat/model/ChatId;", "profileId", "Lde/justsoftware/chat/model/ProfileId;", "permissionType", "Lde/justsoftware/chat/model/PermissionType;", "checkManageOrTempManageChat", "filterChatIdsWithoutPermission", "", "chatIds", "", "hasPermissionForChats", "", "", "hasRoles", "Lde/justsoftware/permission/client/model/Role;", "Lde/justsoftware/permission/client/model/AuthorizationResult;", "rolesToCheck", "havePermission", "profileIdsOfParticipants", "Lde/justsoftware/chat/business/model/ChatParticipant;", "isMemberOfTenant", "tenantId", "Lde/justsoftware/chat/model/TenantId;", "may", "roleToCheck", "mayAll", "T", "Lde/justsoftware/chat/model/PermissionRole;", "itemsToCheck", "permissionActions", "Lde/justsoftware/chat/model/PermissionAction;", "userId", "mayInteractWithParticipants", "Lde/justsoftware/chat/model/ParticipantId;", "participantIds", "mayProfileCreateMultiUserChat", "mayProfileCreateOneOnOneChat", "searchRolesBy", "searchBy", "chat-service"})
@SourceDebugExtension(value={"SMAP\nAuthorizationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthorizationService.kt\nde/justsoftware/chat/authorization/AuthorizationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n1360#2:181\n1446#2,2:182\n1549#2:184\n1620#2,3:185\n1448#2,3:188\n1271#2,2:191\n1285#2,2:193\n1549#2:195\n1620#2,3:196\n1726#2,3:199\n1288#2:202\n1271#2,2:203\n1285#2,4:205\n1549#2:209\n1620#2,3:210\n1549#2:216\n1620#2,3:217\n809#2,2:224\n1238#2,2:239\n766#2:241\n857#2,2:242\n1549#2:244\n1620#2,3:245\n1241#2:248\n1620#2,3:257\n1549#2:260\n1620#2,3:261\n1549#2:267\n1620#2,3:268\n766#2:271\n857#2,2:272\n1271#2,2:283\n1285#2,4:285\n1238#2,4:291\n76#3:213\n96#3,2:214\n98#3,3:220\n152#3,3:234\n125#3:264\n152#3,2:265\n154#3:275\n22#4:223\n16#4:233\n7#4:256\n494#5,7:226\n453#5:237\n403#5:238\n494#5,7:249\n526#5:276\n511#5,6:277\n453#5:289\n403#5:290\n1#6:274\n*S KotlinDebug\n*F\n+ 1 AuthorizationService.kt\nde/justsoftware/chat/authorization/AuthorizationService\n*L\n71#1:181\n71#1:182,2\n71#1:184\n71#1:185,3\n71#1:188,3\n73#1:191,2\n73#1:193,2\n74#1:195\n74#1:196,3\n74#1:199,3\n73#1:202\n83#1:203,2\n83#1:205,4\n112#1:209\n112#1:210,3\n114#1:216\n114#1:217,3\n115#1:224,2\n122#1:239,2\n123#1:241\n123#1:242,2\n130#1:244\n130#1:245,3\n122#1:248\n134#1:257,3\n144#1:260\n144#1:261,3\n147#1:267\n147#1:268,3\n148#1:271\n148#1:272,2\n171#1:283,2\n171#1:285,4\n178#1:291,4\n114#1:213\n114#1:214,2\n114#1:220,3\n119#1:234,3\n145#1:264\n145#1:265,2\n145#1:275\n115#1:223\n119#1:233\n134#1:256\n118#1:226,7\n122#1:237\n122#1:238\n132#1:249,7\n167#1:276\n167#1:277,6\n178#1:289\n178#1:290\n*E\n"})
public class AuthorizationService {
    @NotNull
    private final PermissionRequestConnector permissionRequestConnector;
    @NotNull
    private final UserGroupService userGroupService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final ChatParticipantRepository chatParticipantRepository;

    public AuthorizationService(@NotNull PermissionRequestConnector permissionRequestConnector, @NotNull UserGroupService userGroupService, @NotNull ProfileService profileService, @NotNull ChatParticipantRepository chatParticipantRepository) {
        Intrinsics.checkNotNullParameter((Object)permissionRequestConnector, (String)"permissionRequestConnector");
        Intrinsics.checkNotNullParameter((Object)userGroupService, (String)"userGroupService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)chatParticipantRepository, (String)"chatParticipantRepository");
        this.permissionRequestConnector = permissionRequestConnector;
        this.userGroupService = userGroupService;
        this.profileService = profileService;
        this.chatParticipantRepository = chatParticipantRepository;
    }

    public boolean isMemberOfTenant(@NotNull TenantId tenantId, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Role role = Role.tenantRole((UUID)tenantId.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)role, (String)"tenantRole(...)");
        return this.may(role, profileId);
    }

    public boolean mayProfileCreateOneOnOneChat(@NotNull TenantId tenantId, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Role role = Role.itemRole((String)"CHAT_CREATE_ONE_TO_ONE", (String)AuthorizationContext.Companion.chatAppItemId(tenantId));
        Intrinsics.checkNotNullExpressionValue((Object)role, (String)"itemRole(...)");
        return this.may(role, profileId);
    }

    public boolean mayProfileCreateMultiUserChat(@NotNull TenantId tenantId, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Role role = Role.itemRole((String)"CHAT_CREATE_MANY_TO_MANY", (String)AuthorizationContext.Companion.chatAppItemId(tenantId));
        Intrinsics.checkNotNullExpressionValue((Object)role, (String)"itemRole(...)");
        return this.may(role, profileId);
    }

    @NotNull
    public Map<ParticipantId, Boolean> mayInteractWithParticipants(@NotNull Set<? extends ParticipantId> participantIds, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter(participantIds, (String)"participantIds");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Object[] objectArray = new PermissionAction[]{PermissionAction.USE, PermissionAction.READ};
        return this.mayAll(participantIds, SetsKt.setOf((Object[])objectArray), profileId);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public <T extends PermissionRole> Map<T, Boolean> mayAll(@NotNull Set<? extends T> itemsToCheck, @NotNull Set<? extends PermissionAction> permissionActions, @NotNull ProfileId userId) {
        Collection collection;
        Iterable destination$iv$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(itemsToCheck, (String)"itemsToCheck");
        Intrinsics.checkNotNullParameter(permissionActions, (String)"permissionActions");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        if (itemsToCheck.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Iterable $this$flatMap$iv = itemsToCheck;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            PermissionRole item = (PermissionRole)element$iv$iv;
            boolean bl3 = false;
            Iterable $this$map$iv = permissionActions;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void action;
                PermissionAction permissionAction = (PermissionAction)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(item.toActionRole((PermissionAction)action));
            }
            Iterable list$iv$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Set rolesToCheck = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Map authResults = this.hasRoles(rolesToCheck, userId);
        Iterable $this$associateWith$iv = itemsToCheck;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            boolean bl;
            Map map;
            Object t;
            block8: {
                void $this$all$iv;
                void $this$mapTo$iv$iv;
                PermissionRole bl3 = (PermissionRole)element$iv$iv;
                t = element$iv$iv;
                map = result$iv;
                boolean bl4 = false;
                Iterable $this$map$iv = permissionActions;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void action;
                    void item;
                    collection = (PermissionAction)item$iv$iv;
                    Collection collection2 = destination$iv$iv3;
                    boolean bl5 = false;
                    collection2.add(item.toActionRole((PermissionAction)action));
                }
                $this$map$iv = (List)destination$iv$iv3;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Role role = (Role)element$iv;
                        boolean bl6 = false;
                        if (authResults.get(role) == AuthorizationResult.OK) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            }
            Boolean bl7 = bl;
            map.put(t, bl7);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<Role, AuthorizationResult> hasRoles(@NotNull Set<Role> rolesToCheck, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter(rolesToCheck, (String)"rolesToCheck");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        if (rolesToCheck.isEmpty()) {
            return MapsKt.emptyMap();
        }
        ImmutableMap immutableMap = this.permissionRequestConnector.hasRoles((Iterable)rolesToCheck, (Iterable)SetsKt.setOf((Object)profileId.toRole()));
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"hasRoles(...)");
        ImmutableMap authResults = immutableMap;
        Iterable $this$associateWith$iv = rolesToCheck;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            Role role = (Role)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            AuthorizationResult authorizationResult = (AuthorizationResult)authResults.get((Object)it);
            if (authorizationResult == null) {
                authorizationResult = AuthorizationResult.NOT_FOUND;
            }
            AuthorizationResult authorizationResult2 = authorizationResult;
            map.put(t, authorizationResult2);
        }
        return result$iv;
    }

    @NotNull
    public Set<Role> searchRolesBy(@NotNull ProfileId searchBy) {
        Intrinsics.checkNotNullParameter((Object)searchBy, (String)"searchBy");
        ImmutableSet immutableSet = this.permissionRequestConnector.searchRoles(searchBy.toRole());
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"searchRoles(...)");
        return (Set)immutableSet;
    }

    public void checkChatPermission(@NotNull ChatId chatId, @NotNull ProfileId profileId, @NotNull PermissionType permissionType) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)permissionType, (String)"permissionType");
        Boolean bl = (Boolean)this.hasPermissionForChats(SetsKt.setOf((Object)chatId), profileId, permissionType).get(chatId);
        if (bl == null) {
            throw new NotFoundException("Chat with id " + chatId + " does not exist");
        }
        if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            throw new NotAllowedException("Failed permission check on " + chatId);
        }
        if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            // empty if block
        }
    }

    public void checkManageOrTempManageChat(@NotNull ChatId chatId, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        boolean hasManagers = this.filterChatIdsWithoutPermission((Iterable)SetsKt.setOf((Object)chatId), PermissionType.MANAGER).isEmpty();
        if (hasManagers) {
            this.checkChatPermission(chatId, profileId, PermissionType.MANAGER);
            return;
        }
        boolean hasWriters = this.filterChatIdsWithoutPermission((Iterable)SetsKt.setOf((Object)chatId), PermissionType.WRITER).isEmpty();
        if (hasWriters) {
            this.checkChatPermission(chatId, profileId, PermissionType.WRITER);
            return;
        }
        this.checkChatPermission(chatId, profileId, PermissionType.READER);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ChatId> filterChatIdsWithoutPermission(@NotNull Iterable<ChatId> chatIds2, @NotNull PermissionType permissionType) {
        Iterable $this$filterValues$iv;
        void $this$mapValuesTo$iv$iv;
        Iterator $this$mapValues$iv;
        void $this$mapTo$iv$iv;
        Map $this$mapToSet$iv;
        void $this$filterValues$iv2;
        void $this$filterIsInstanceTo$iv$iv;
        Map $this$filterIsInstanceToSet$iv;
        Iterable it;
        Object object;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Map permissions;
        Collection<Object> collection;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(chatIds2, (String)"chatIds");
        Intrinsics.checkNotNullParameter((Object)permissionType, (String)"permissionType");
        Iterable<ChatId> iterable = chatIds2;
        Object object2 = this.chatParticipantRepository;
        boolean $i$f$map232 = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            ChatId chatId = (ChatId)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(chatId.getValue());
        }
        Map $i$f$map232 = permissions = object2.findByChatIds((Iterable)((List)destination$iv$iv));
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        item$iv$iv2 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (item$iv$iv2.hasNext()) {
            void $this$mapTo$iv$iv3;
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)item$iv$iv2.next();
            boolean bl2 = false;
            List participants = (List)entry2.getValue();
            Iterable $this$map$iv2 = participants;
            boolean $i$f$map = false;
            object = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
                DbChatParticipant dbChatParticipant = (DbChatParticipant)item$iv$iv3;
                Collection collection2 = destination$iv$iv3;
                boolean bl3 = false;
                collection2.add(ParticipantId.Companion.fromCanonicalId(it.getParticipantId()));
            }
            Iterable iterable2 = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)iterable2);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$filterIsInstanceToSet = false;
        $this$flatMapTo$iv$iv = $this$filterIsInstanceToSet$iv;
        Object destination$iv$iv3 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)((Object)$this$filterIsInstanceToSet$iv)));
        boolean $i$f$filterIsInstanceTo = false;
        for (Object e : $this$filterIsInstanceTo$iv$iv) {
            if (!(e instanceof ProfileId)) continue;
            destination$iv$iv3.add(e);
        }
        Set profiles2 = (Set)destination$iv$iv3;
        boolean $i$a$-let-AuthorizationService$filterChatIdsWithoutPermission$activeOrBlockedProfilePermissions$332 = false;
        destination$iv$iv3 = this.profileService.findByIds(profiles2);
        boolean $i$f$filterValues = false;
        Object result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv2.entrySet()) {
            Profile it2 = (Profile)entry.getValue();
            boolean bl2 = false;
            if (!(it2.getStatus() == ProfileStatus.ACTIVE || it2.getStatus() == ProfileStatus.BLOCKED)) continue;
            ((HashMap)result$iv).put(entry.getKey(), entry.getValue());
        }
        $this$filterIsInstanceToSet$iv = (Map)result$iv;
        boolean $i$f$mapToSet = false;
        void $i$a$-let-AuthorizationService$filterChatIdsWithoutPermission$activeOrBlockedProfilePermissions$332 = $this$mapToSet$iv;
        destination$iv$iv3 = new LinkedHashSet($this$mapToSet$iv.size());
        boolean $i$f$mapTo3 = false;
        result$iv = $this$mapTo$iv$iv.entrySet().iterator();
        while (result$iv.hasNext()) {
            Map.Entry entry;
            Map.Entry entry3 = entry = (Map.Entry)result$iv.next();
            object2 = destination$iv$iv3;
            boolean bl = false;
            object2.add((ProfileId)entry3.getKey());
        }
        Set activeOrBlockedProfilePermissions = (Set)destination$iv$iv3;
        $this$mapToSet$iv = permissions;
        boolean $i$f$mapValues = false;
        $this$mapTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean bl = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv4;
            void $this$map$iv3;
            DbChatParticipant it4;
            void $this$filterTo$iv$iv;
            void it$iv$iv;
            Map.Entry bl2 = (Map.Entry)element$iv$iv$iv;
            Iterator iterator = destination$iv$iv3;
            boolean bl4 = false;
            object = (Map.Entry)element$iv$iv$iv;
            collection = it$iv$iv.getKey();
            object2 = iterator;
            boolean bl5 = false;
            List participants = (List)object.getValue();
            Iterable $this$filter$iv = participants;
            boolean $i$f$filter = false;
            it = $this$filter$iv;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it4 = (DbChatParticipant)element$iv$iv;
                boolean bl6 = false;
                ParticipantId participantId = ParticipantId.Companion.fromCanonicalId(it4.getParticipantId());
                boolean bl3 = participantId instanceof ProfileId ? activeOrBlockedProfilePermissions.contains(participantId) : true;
                if (!bl3) continue;
                destination$iv$iv4.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv4;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv3;
            Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv4 : $this$mapTo$iv$iv4) {
                void p0;
                it4 = (DbChatParticipant)item$iv$iv4;
                Collection collection3 = destination$iv$iv5;
                boolean bl8 = false;
                collection3.add(p0.getPermissionType());
            }
            List list = (List)destination$iv$iv5;
            object2.put(collection, list);
        }
        $this$mapValues$iv = destination$iv$iv3;
        boolean $i$f$filterValues2 = false;
        Map result$iv2 = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            List it5 = (List)entry$iv.getValue();
            boolean bl4 = false;
            if (!(!it5.contains(permissionType))) continue;
            ((HashMap)result$iv2).put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterValues$iv = ((Map)result$iv2).keySet();
        $i$f$mapToSet = false;
        result$iv2 = $this$mapToSet$iv;
        destination$iv$iv3 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)((Object)$this$mapToSet$iv)));
        boolean $i$f$mapTo2 = false;
        for (Object t : $this$mapTo$iv$iv) {
            UUID uUID = (UUID)t;
            object2 = destination$iv$iv3;
            boolean bl5 = false;
            object2.add(new ChatId(uUID));
        }
        return (Set)destination$iv$iv3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ChatId, Boolean> hasPermissionForChats(@NotNull Set<ChatId> chatIds2, @NotNull ProfileId profileId, @NotNull PermissionType permissionType) {
        boolean bl;
        Object object;
        Map $this$mapTo$iv$iv;
        Map $this$map$iv;
        Intrinsics.checkNotNullParameter(chatIds2, (String)"chatIds");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)permissionType, (String)"permissionType");
        Set userGroupsOfProfileId = this.userGroupService.getUserGroupIdsByProfileId(profileId);
        Iterable iterable = chatIds2;
        Object object2 = this.chatParticipantRepository;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
        boolean $i$f$mapTo = false;
        Iterator<Object> iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object t = iterator.next();
            object = (ChatId)t;
            Collection collection = destination$iv$iv;
            bl = false;
            collection.add(it.getValue());
        }
        $this$map$iv = object2.findByChatIds((Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        $i$f$mapTo = false;
        for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
            void it;
            Object object3;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2;
            object = entry;
            object2 = destination$iv$iv;
            bl = false;
            UUID uuid = (UUID)object.getKey();
            List participants = (List)object.getValue();
            Iterable iterable2 = participants;
            ChatId chatId = new ChatId(uuid);
            boolean $i$f$map2 = false;
            void var19_25 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it2;
                DbChatParticipant dbChatParticipant = (DbChatParticipant)item$iv$iv2;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(DbChatParticipant.Companion.toChatParticipant((DbChatParticipant)it2));
            }
            $this$map$iv2 = (List)destination$iv$iv2;
            boolean $i$f$filter232 = false;
            $this$mapTo$iv$iv2 = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl2;
                ChatParticipant it2 = (ChatParticipant)element$iv$iv;
                boolean bl4 = false;
                ParticipantId participantId = it2.getParticipantId();
                if (participantId instanceof ProfileId) {
                    bl2 = Intrinsics.areEqual((Object)profileId, (Object)it2.getParticipantId());
                } else if (participantId instanceof UserGroupId) {
                    bl2 = CollectionsKt.contains((Iterable)userGroupsOfProfileId, (Object)it2.getParticipantId());
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                if (!bl2) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            iterable2 = (List)destination$iv$iv3;
            PermissionType $i$f$filter232 = iterable2.iterator();
            if (!$i$f$filter232.hasNext()) {
                object3 = null;
            } else {
                Object p0 = (ChatParticipant)$i$f$filter232.next();
                boolean bl5 = false;
                p0 = (Comparable)p0.getPermissionType();
                while ($i$f$filter232.hasNext()) {
                    ChatParticipant p02 = (ChatParticipant)$i$f$filter232.next();
                    boolean bl3 = false;
                    Comparable comparable = (Comparable)p02.getPermissionType();
                    if (p0.compareTo(comparable) >= 0) continue;
                    p0 = comparable;
                }
                object3 = p0;
            }
            $i$f$filter232 = (PermissionType)object3;
            boolean bl6 = false;
            void v2 = it;
            object2.add(TuplesKt.to((Object)chatId, (Object)(v2 == null ? false : v2.compareTo((Enum)permissionType) >= 0)));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ProfileId, Boolean> havePermission(@NotNull Map<ChatParticipant, ? extends Set<ProfileId>> profileIdsOfParticipants, @NotNull PermissionType permissionType) {
        void $this$associateWith$iv;
        ProfileId profileId;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(profileIdsOfParticipants, (String)"profileIdsOfParticipants");
        Intrinsics.checkNotNullParameter((Object)permissionType, (String)"permissionType");
        Map<ChatParticipant, ? extends Set<ProfileId>> map = profileIdsOfParticipants;
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            ProfileId element$iv$iv;
            profileId = element$iv$iv = iterator.next();
            boolean bl = false;
            ChatParticipant participant = (ChatParticipant)profileId.getKey();
            if (!(participant.getPermissionType().compareTo((Enum)permissionType) >= 0)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Set allowedProfileIds = CollectionUtilsKt.flattenValuesToSet((Map)destination$iv$iv);
        $this$filter$iv = CollectionUtilsKt.flattenValuesToSet(profileIdsOfParticipants);
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (ProfileId element$iv$iv : $this$associateWithTo$iv$iv) {
            void profileId2;
            profileId = element$iv$iv;
            ProfileId profileId3 = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            Boolean bl2 = allowedProfileIds.contains(profileId2);
            map2.put(profileId3, bl2);
        }
        return result$iv;
    }

    private boolean may(Role roleToCheck, ProfileId profileId) {
        Object v = this.may(SetsKt.setOf((Object)roleToCheck), profileId).get(roleToCheck);
        if (v == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return (Boolean)v;
    }

    /*
     * WARNING - void declaration
     */
    private Map<Role, Boolean> may(Set<Role> rolesToCheck, ProfileId profileId) {
        void $this$mapValuesTo$iv$iv;
        Map $this$mapValues$iv = this.hasRoles(rolesToCheck, profileId);
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Boolean bl3 = it.getValue() == AuthorizationResult.OK;
            map3.put(k, bl3);
        }
        return destination$iv$iv;
    }
}

