/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.internal.controller;

import de.justsoftware.admin.application.internal.appconfigmigration.MigrateAppConfigApplicationService;
import de.justsoftware.admin.application.internal.appconfigmigration.MigrateAppConfigToroDto;
import de.justsoftware.admin.application.internal.controller.InternalController;
import de.justsoftware.admin.domain.republish.RepublishService;
import de.justsoftware.admin.domain.tenant.TenantService;
import de.justsoftware.admin.domain.tenant.model.TenantSettings;
import de.justsoftware.admin.id.TenantId;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/internal"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0011\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0013J\u0014\u0010\r\u001a\u00020\f2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u0013J\u0018\u0010\u0011\u001a\u00020\u00122\u000e\b\u0001\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0013J\b\u0010\u0016\u001a\u00020\u0012H\u0013J\b\u0010\u0017\u001a\u00020\u0012H\u0013J\b\u0010\u0018\u001a\u00020\u0012H\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/justsoftware/admin/application/internal/controller/InternalController;", "", "migrateAppConfigApplicationService", "Lde/justsoftware/admin/application/internal/appconfigmigration/MigrateAppConfigApplicationService;", "republishService", "Lde/justsoftware/admin/domain/republish/RepublishService;", "tenantService", "Lde/justsoftware/admin/domain/tenant/TenantService;", "(Lde/justsoftware/admin/application/internal/appconfigmigration/MigrateAppConfigApplicationService;Lde/justsoftware/admin/domain/republish/RepublishService;Lde/justsoftware/admin/domain/tenant/TenantService;)V", "getTenantSettings", "Lde/justsoftware/admin/domain/tenant/model/TenantSettings;", "tenantId", "", "handleBadRequest", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "postMigrationAppConfigs", "", "appConfigs", "", "Lde/justsoftware/admin/application/internal/appconfigmigration/MigrateAppConfigToroDto;", "postRepublishApps", "postRepublishIdpConfigs", "postRepublishTenants", "Companion", "admin-service"})
public class InternalController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrateAppConfigApplicationService migrateAppConfigApplicationService;
    @NotNull
    private final RepublishService republishService;
    @NotNull
    private final TenantService tenantService;
    @NotNull
    private static final Logger log;

    public InternalController(@NotNull MigrateAppConfigApplicationService migrateAppConfigApplicationService, @NotNull RepublishService republishService, @NotNull TenantService tenantService) {
        Intrinsics.checkNotNullParameter((Object)migrateAppConfigApplicationService, (String)"migrateAppConfigApplicationService");
        Intrinsics.checkNotNullParameter((Object)republishService, (String)"republishService");
        Intrinsics.checkNotNullParameter((Object)tenantService, (String)"tenantService");
        this.migrateAppConfigApplicationService = migrateAppConfigApplicationService;
        this.republishService = republishService;
        this.tenantService = tenantService;
    }

    @PostMapping(value={"/migration/app-configs"})
    @ResponseStatus(value=HttpStatus.OK)
    private void postMigrationAppConfigs(@RequestBody Collection<MigrateAppConfigToroDto> appConfigs) {
        this.migrateAppConfigApplicationService.migrate(appConfigs);
    }

    @GetMapping(value={"/tenant/{tenantId}"})
    private TenantSettings getTenantSettings(@PathVariable String tenantId) {
        return this.tenantService.getSettings(TenantId.Companion.fromString(tenantId));
    }

    @PostMapping(value={"/republish/apps"})
    @ResponseStatus(value=HttpStatus.OK)
    private void postRepublishApps() {
        this.republishService.republishAllAppConfigs();
    }

    @PostMapping(value={"/republish/idp-configs"})
    @ResponseStatus(value=HttpStatus.OK)
    private void postRepublishIdpConfigs() {
        this.republishService.republishAllIdpConfigs();
    }

    @PostMapping(value={"/republish-tenants"})
    @ResponseStatus(value=HttpStatus.OK)
    private void postRepublishTenants() {
        this.republishService.republishAllTenants();
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    private String handleBadRequest(Exception ex) {
        log.error(ex.getMessage(), (Throwable)ex);
        String string = ex.getMessage();
        if (string == null) {
            string = "BAD REQUEST";
        }
        return string;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    static {
        Logger logger = LoggerFactory.getLogger(InternalController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }
}

