/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.content.impl;

import de.justsoftware.drive.content.KafkaConfigurationProvider;
import java.util.Properties;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class KafkaConfigurationProviderImpl
implements KafkaConfigurationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaConfigurationProviderImpl.class);
    private static final StringDeserializer STRING_DESERIALIZER = new StringDeserializer();
    private final String _bootstrapServers;

    public KafkaConfigurationProviderImpl(@Value(value="${just.drive.kafka.boostrapServers:localhost:9092}") String bootstrapServers) {
        this._bootstrapServers = bootstrapServers;
        LOG.info("connecting to kafka-broker: {}", (Object)this._bootstrapServers);
    }

    public Consumer<String, String> stringConsumer(String group, int chunkSize) {
        Properties props = new Properties();
        props.put("bootstrap.servers", this._bootstrapServers);
        props.put("enable.auto.commit", "false");
        props.put("auto.offset.reset", "earliest");
        props.put("max.poll.records", (Object)chunkSize);
        props.put("group.id", group);
        return new KafkaConsumer(props, (Deserializer)STRING_DESERIALIZER, (Deserializer)STRING_DESERIALIZER);
    }
}

