/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.utils.CollectionUtils;

public class FetchResponse
extends AbstractRequestResponse {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentResponseSchema(ApiKeys.FETCH.id);
    private static final String RESPONSES_KEY_NAME = "responses";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITIONS_KEY_NAME = "partition_responses";
    private static final String THROTTLE_TIME_KEY_NAME = "throttle_time_ms";
    private static final String PARTITION_KEY_NAME = "partition";
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    private static final int DEFAULT_THROTTLE_TIME = 0;
    private static final String HIGH_WATERMARK_KEY_NAME = "high_watermark";
    private static final String RECORD_SET_KEY_NAME = "record_set";
    public static final long INVALID_HIGHWATERMARK = -1L;
    public static final ByteBuffer EMPTY_RECORD_SET = ByteBuffer.allocate(0);
    private final Map<TopicPartition, PartitionData> responseData;
    private final int throttleTime;

    public FetchResponse(Map<TopicPartition, PartitionData> responseData) {
        super(new Struct(ProtoUtils.responseSchema(ApiKeys.FETCH.id, 0)));
        this.initCommonFields(responseData);
        this.responseData = responseData;
        this.throttleTime = 0;
    }

    public FetchResponse(Map<TopicPartition, PartitionData> responseData, int throttleTime) {
        super(new Struct(CURRENT_SCHEMA));
        this.initCommonFields(responseData);
        this.struct.set(THROTTLE_TIME_KEY_NAME, (Object)throttleTime);
        this.responseData = responseData;
        this.throttleTime = throttleTime;
    }

    public FetchResponse(Struct struct) {
        super(struct);
        this.responseData = new HashMap<TopicPartition, PartitionData>();
        for (Object topicResponseObj : struct.getArray(RESPONSES_KEY_NAME)) {
            Struct topicResponse = (Struct)topicResponseObj;
            String topic = topicResponse.getString(TOPIC_KEY_NAME);
            for (Object partitionResponseObj : topicResponse.getArray(PARTITIONS_KEY_NAME)) {
                Struct partitionResponse = (Struct)partitionResponseObj;
                int partition2 = partitionResponse.getInt(PARTITION_KEY_NAME);
                short errorCode = partitionResponse.getShort(ERROR_CODE_KEY_NAME);
                long highWatermark = partitionResponse.getLong(HIGH_WATERMARK_KEY_NAME);
                ByteBuffer recordSet = partitionResponse.getBytes(RECORD_SET_KEY_NAME);
                PartitionData partitionData = new PartitionData(errorCode, highWatermark, recordSet);
                this.responseData.put(new TopicPartition(topic, partition2), partitionData);
            }
        }
        this.throttleTime = struct.hasField(THROTTLE_TIME_KEY_NAME) ? struct.getInt(THROTTLE_TIME_KEY_NAME) : 0;
    }

    private void initCommonFields(Map<TopicPartition, PartitionData> responseData) {
        Map<String, Map<Integer, PartitionData>> topicsData = CollectionUtils.groupDataByTopic(responseData);
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (Map.Entry<String, Map<Integer, PartitionData>> topicEntry : topicsData.entrySet()) {
            Struct topicData = this.struct.instance(RESPONSES_KEY_NAME);
            topicData.set(TOPIC_KEY_NAME, (Object)topicEntry.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, PartitionData> partitionEntry : topicEntry.getValue().entrySet()) {
                PartitionData fetchPartitionData = partitionEntry.getValue();
                Struct partitionData = topicData.instance(PARTITIONS_KEY_NAME);
                partitionData.set(PARTITION_KEY_NAME, (Object)partitionEntry.getKey());
                partitionData.set(ERROR_CODE_KEY_NAME, (Object)fetchPartitionData.errorCode);
                partitionData.set(HIGH_WATERMARK_KEY_NAME, (Object)fetchPartitionData.highWatermark);
                partitionData.set(RECORD_SET_KEY_NAME, (Object)fetchPartitionData.recordSet);
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS_KEY_NAME, (Object)partitionArray.toArray());
            topicArray.add(topicData);
        }
        this.struct.set(RESPONSES_KEY_NAME, (Object)topicArray.toArray());
    }

    public Map<TopicPartition, PartitionData> responseData() {
        return this.responseData;
    }

    public int getThrottleTime() {
        return this.throttleTime;
    }

    public static FetchResponse parse(ByteBuffer buffer) {
        return new FetchResponse((Struct)CURRENT_SCHEMA.read(buffer));
    }

    public static FetchResponse parse(ByteBuffer buffer, int version) {
        return new FetchResponse((Struct)ProtoUtils.responseSchema(ApiKeys.FETCH.id, version).read(buffer));
    }

    public static final class PartitionData {
        public final short errorCode;
        public final long highWatermark;
        public final ByteBuffer recordSet;

        public PartitionData(short errorCode, long highWatermark, ByteBuffer recordSet) {
            this.errorCode = errorCode;
            this.highWatermark = highWatermark;
            this.recordSet = recordSet;
        }
    }
}

