/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authentication.service;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import org.opensaml.xml.XMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.security.saml.parser.SAMLObject;
import org.springframework.security.saml.storage.SAMLMessageStorage;
import org.springframework.security.saml.storage.SAMLMessageStorageFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
@Service(value="redisSAMLMessageStorageFactory")
public class RedisSAMLMessageStorageFactory
implements SAMLMessageStorage,
SAMLMessageStorageFactory,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisSAMLMessageStorageFactory.class);
    private final RedisTemplate<String, SAMLObject<XMLObject>> _redisTemplate = new RedisTemplate();

    @Autowired
    public RedisSAMLMessageStorageFactory(RedisConnectionFactory connectionFactory) {
        this._redisTemplate.setConnectionFactory(connectionFactory);
        this._redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        this._redisTemplate.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        this._redisTemplate.setValueSerializer((RedisSerializer)new JdkSerializationRedisSerializer());
        this._redisTemplate.setHashValueSerializer((RedisSerializer)new JdkSerializationRedisSerializer());
    }

    @Nonnull
    private static final String redisKey(String messageId) {
        return "samlMessage:" + messageId;
    }

    public void storeMessage(String messageId, XMLObject message) {
        this.trace("store message by id: " + messageId);
        this._redisTemplate.boundValueOps((Object)RedisSAMLMessageStorageFactory.redisKey((String)messageId)).set((Object)new SAMLObject(message), 2L, TimeUnit.HOURS);
    }

    public XMLObject retrieveMessage(String messageId) {
        this.trace("retrieve message by id: " + messageId);
        String key = RedisSAMLMessageStorageFactory.redisKey((String)messageId);
        SAMLObject samlObject = (SAMLObject)this._redisTemplate.boundValueOps((Object)key).get();
        if (samlObject != null) {
            this._redisTemplate.delete((Object)key);
            this.trace("purged message by id: " + messageId);
        }
        return samlObject != null ? samlObject.getObject() : null;
    }

    public SAMLMessageStorage getMessageStorage(HttpServletRequest request) {
        return this;
    }

    private void trace(String message) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(message);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this._redisTemplate.afterPropertiesSet();
    }
}

