/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authentication.filter;

import de.justsoftware.authentication.service.AuthenticationMetricsService;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.saml.SAMLWebSSOHoKProcessingFilter;

@ParametersAreNonnullByDefault
public class JustSAMLWebSSOHoKProcessingFilter
extends SAMLWebSSOHoKProcessingFilter {
    private AuthenticationMetricsService _metrics;

    @Autowired(required=true)
    public void setMetricsService(AuthenticationMetricsService metrics) {
        this._metrics = metrics;
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        try {
            Authentication result = super.attemptAuthentication(request, response);
            this._metrics.loginSuccess();
            return result;
        }
        catch (AuthenticationException e) {
            this._metrics.loginFailure();
            throw e;
        }
    }
}

