/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.usergroup;

import de.justsoftware.people.authorization.NotAllowed;
import de.justsoftware.people.business.event.ProfilesCreatedEvent;
import de.justsoftware.people.business.event.ProfilesDeletedEvent;
import de.justsoftware.people.business.event.UserGroupCreatedOrPublishedEvent;
import de.justsoftware.people.business.event.UserGroupDeletedEvent;
import de.justsoftware.people.business.event.UserGroupMembersUpdatedEvent;
import de.justsoftware.people.business.event.UserGroupRolesUpdatedEvent;
import de.justsoftware.people.business.event.UserGroupUpdatedEvent;
import de.justsoftware.people.business.usergroup.UserGroupPublisher;
import de.justsoftware.people.business.usergroup.UserGroupService;
import de.justsoftware.people.business.usergroup.model.Membership;
import de.justsoftware.people.business.usergroup.model.UserGroup;
import de.justsoftware.people.exceptions.NotFoundException;
import de.justsoftware.people.model.ProfileId;
import de.justsoftware.people.model.TenantId;
import de.justsoftware.people.model.UserGroupId;
import de.justsoftware.people.model.UserGroupRole;
import de.justsoftware.people.persistence.UserGroupMemberRepository;
import de.justsoftware.people.persistence.UserGroupRepository;
import de.justsoftware.people.persistence.UserGroupRoleRepository;
import de.justsoftware.people.persistence.model.DbUserGroup;
import de.justsoftware.people.persistence.model.DbUserGroupMember;
import de.justsoftware.people.persistence.model.DbUserGroupRole;
import de.justsoftware.people.persistence.transaction.TransactionSupport;
import de.justsoftware.people.utils.CollectionUtilsKt;
import de.justsoftware.people.utils.KafkaUtilsKt;
import de.justsoftware.permission.client.kafka.WaitForOffsets;
import de.justsoftware.permission.client.model.Role;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 U2\u00020\u0001:\u0001UB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0010H\u0017J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0016J\"\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020$0#2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100&H\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u0011\u001a\u00020\u0012H\u0012J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020$0*2\u0006\u0010+\u001a\u00020\u0010H\u0016J\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00170&H\u0012J\u0016\u00100\u001a\u00020\u00192\f\u00101\u001a\b\u0012\u0004\u0012\u00020$02H\u0017J\u0010\u00103\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001c\u00104\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u0002050#2\u0006\u00106\u001a\u00020(H\u0012J\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020\u00170&2\u0006\u0010+\u001a\u00020\u0010H\u0016J\u0010\u00108\u001a\u00020$2\u0006\u0010+\u001a\u00020\u0010H\u0016J\u001c\u00109\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u0002050#2\u0006\u0010+\u001a\u00020\u0010H\u0016J.\u00109\u001a\u001a\u0012\u0004\u0012\u00020\u0010\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u0002050#0#2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100&H\u0016J\"\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020$0#2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100&H\u0016J(\u0010;\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100-0#2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00170&H\u0016J\u0010\u0010<\u001a\u00020\u00192\u0006\u0010=\u001a\u00020>H\u0017J\u0010\u0010?\u001a\u00020\u00192\u0006\u0010@\u001a\u00020AH\u0017J\u001e\u0010B\u001a\u00020\u00192\u0014\u0010C\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00150DH\u0017J$\u0010E\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u00102\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u0002050#H\u0017J\u0016\u0010G\u001a\u00020\u00192\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00170&H\u0012J\u0018\u0010I\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J$\u0010J\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u00102\u0012\u0010K\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u0002050#H\u0017J2\u0010L\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u00102\u0012\u0010K\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u0002050#2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020O0NH\u0012J,\u0010P\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00170&2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00170&H\u0012J,\u0010S\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u00102\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00170&2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00170&H\u0017J$\u0010S\u001a\u00020\u00192\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020T0-2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020T0-H\u0017R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lde/justsoftware/people/business/usergroup/UserGroupService;", "", "userGroupRepository", "Lde/justsoftware/people/persistence/UserGroupRepository;", "userGroupRoleRepository", "Lde/justsoftware/people/persistence/UserGroupRoleRepository;", "userGroupMemberRepository", "Lde/justsoftware/people/persistence/UserGroupMemberRepository;", "userGroupPublisher", "Lde/justsoftware/people/business/usergroup/UserGroupPublisher;", "transactionSupport", "Lde/justsoftware/people/persistence/transaction/TransactionSupport;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lde/justsoftware/people/persistence/UserGroupRepository;Lde/justsoftware/people/persistence/UserGroupRoleRepository;Lde/justsoftware/people/persistence/UserGroupMemberRepository;Lde/justsoftware/people/business/usergroup/UserGroupPublisher;Lde/justsoftware/people/persistence/transaction/TransactionSupport;Lorg/springframework/context/ApplicationEventPublisher;)V", "createOrGetAllTenantUsersGroup", "Lde/justsoftware/people/model/UserGroupId;", "tenantId", "Lde/justsoftware/people/model/TenantId;", "createUserGroup", "name", "", "creator", "Lde/justsoftware/people/model/ProfileId;", "deleteAllTenantUsersGroup", "", "deleteOldNotYetImportedGroups", "olderThan", "Ljava/time/Duration;", "deleteUserGroup", "groupId", "deleteUserGroupPermissionRole", "role", "Lde/justsoftware/permission/client/model/Role;", "findAllByIds", "", "Lde/justsoftware/people/business/usergroup/model/UserGroup;", "userGroupIds", "", "findAllTenantUsersGroup", "Lde/justsoftware/people/persistence/model/DbUserGroup;", "findUserGroup", "Ljava/util/Optional;", "userGroupId", "findUserGroupMembersByProfileIds", "", "Lde/justsoftware/people/persistence/model/DbUserGroupMember;", "profileIds", "forAllUserGroups", "userGroupConsumer", "Ljava/util/function/Consumer;", "getAllTenantUsersGroupId", "getDefaultPermissions", "Lde/justsoftware/people/model/UserGroupRole;", "userGroup", "getMembersOfGroup", "getUserGroup", "getUserGroupRoles", "getUserGroups", "getUserGroupsForProfiles", "onProfilesCreatedEvent", "event", "Lde/justsoftware/people/business/event/ProfilesCreatedEvent;", "onProfilesDeletedEvent", "profilesDeletedEvent", "Lde/justsoftware/people/business/event/ProfilesDeletedEvent;", "onTenantChanged", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "publishUserGroup", "permissions", "removeDeletedProfilesFromUserGroups", "deletedProfileIds", "renameUserGroup", "setUserGroupRoles", "userGroupRoles", "setUserGroupRolesAndPublishedPermissions", "waitForOffsetsBuilder", "Ljava/util/stream/Stream$Builder;", "Lde/justsoftware/permission/client/kafka/WaitForOffsets;", "updateAllTenantUsersGroupMembers", "membersToAdd", "membersToDelete", "updateMembers", "Lde/justsoftware/people/business/usergroup/model/Membership;", "Companion", "people-api"})
@SourceDebugExtension(value={"SMAP\nUserGroupService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserGroupService.kt\nde/justsoftware/people/business/usergroup/UserGroupService\n+ 2 CollectionUtils.kt\nde/justsoftware/people/utils/CollectionUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,498:1\n17#2:499\n17#2:541\n17#2:545\n17#2:551\n17#2:569\n17#2:575\n17#2:620\n1620#3,3:500\n1208#3,2:503\n1238#3,4:505\n1490#3:509\n1520#3,3:510\n1523#3,3:520\n1490#3:523\n1520#3,3:524\n1523#3,3:534\n1620#3,3:542\n1620#3,3:546\n1855#3,2:549\n1620#3,3:552\n1490#3:555\n1520#3,3:556\n1523#3,3:566\n1620#3,3:570\n1855#3,2:573\n1620#3,3:576\n1549#3:586\n1620#3,3:587\n1360#3:590\n1446#3,5:591\n1490#3:596\n1520#3,3:597\n1523#3,3:607\n1238#3,4:612\n1549#3:616\n1620#3,3:617\n1620#3,3:621\n1549#3:624\n1620#3,3:625\n1360#3:628\n1446#3,5:629\n1208#3,2:634\n1238#3,4:636\n1549#3:647\n1620#3,3:648\n1360#3:651\n1446#3,5:652\n1490#3:661\n1520#3,3:662\n1523#3,3:672\n1549#3:677\n1620#3,3:678\n1549#3:681\n1620#3,3:682\n1855#3,2:685\n372#4,7:513\n372#4,7:527\n372#4,7:559\n526#4:579\n511#4,6:580\n372#4,7:600\n453#4:610\n403#4:611\n526#4:640\n511#4,6:641\n372#4,7:665\n215#5,2:537\n215#5,2:539\n215#5,2:657\n215#5,2:659\n215#5,2:675\n*S KotlinDebug\n*F\n+ 1 UserGroupService.kt\nde/justsoftware/people/business/usergroup/UserGroupService\n*L\n76#1:499\n201#1:541\n209#1:545\n236#1:551\n255#1:569\n293#1:575\n341#1:620\n76#1:500,3\n77#1:503,2\n77#1:505,4\n173#1:509\n173#1:510,3\n173#1:520,3\n174#1:523\n174#1:524,3\n174#1:534,3\n201#1:542,3\n209#1:546,3\n209#1:549,2\n236#1:552,3\n247#1:555\n247#1:556,3\n247#1:566,3\n255#1:570,3\n277#1:573,2\n293#1:576,3\n327#1:586\n327#1:587,3\n329#1:590\n329#1:591,5\n330#1:596\n330#1:597,3\n330#1:607,3\n331#1:612,4\n340#1:616\n340#1:617,3\n341#1:621,3\n354#1:624\n354#1:625,3\n356#1:628\n356#1:629,5\n357#1:634,2\n357#1:636,4\n462#1:647\n462#1:648,3\n464#1:651\n464#1:652,5\n450#1:661\n450#1:662,3\n450#1:672,3\n455#1:677\n455#1:678,3\n456#1:681\n456#1:682,3\n457#1:685,2\n173#1:513,7\n174#1:527,7\n247#1:559,7\n299#1:579\n299#1:580,6\n330#1:600,7\n331#1:610\n331#1:611\n435#1:640\n435#1:641,6\n450#1:665,7\n175#1:537,2\n182#1:539,2\n392#1:657,2\n397#1:659,2\n451#1:675,2\n*E\n"})
public class UserGroupService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UserGroupRepository userGroupRepository;
    @NotNull
    private final UserGroupRoleRepository userGroupRoleRepository;
    @NotNull
    private final UserGroupMemberRepository userGroupMemberRepository;
    @NotNull
    private final UserGroupPublisher userGroupPublisher;
    @NotNull
    private final TransactionSupport transactionSupport;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private static final Consumer<WaitForOffsets> NOOP_OFFSETS_CONSUMER = UserGroupService::NOOP_OFFSETS_CONSUMER$lambda$55;
    private static final Logger LOGGER = LoggerFactory.getLogger(UserGroupService.class);
    @NotNull
    private static final String TENANT_USER_GROUP_NAME = " ";

    public UserGroupService(@NotNull UserGroupRepository userGroupRepository, @NotNull UserGroupRoleRepository userGroupRoleRepository, @NotNull UserGroupMemberRepository userGroupMemberRepository, @NotNull UserGroupPublisher userGroupPublisher, @NotNull TransactionSupport transactionSupport, @NotNull ApplicationEventPublisher applicationEventPublisher) {
        Intrinsics.checkNotNullParameter((Object)userGroupRepository, (String)"userGroupRepository");
        Intrinsics.checkNotNullParameter((Object)userGroupRoleRepository, (String)"userGroupRoleRepository");
        Intrinsics.checkNotNullParameter((Object)userGroupMemberRepository, (String)"userGroupMemberRepository");
        Intrinsics.checkNotNullParameter((Object)userGroupPublisher, (String)"userGroupPublisher");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        this.userGroupRepository = userGroupRepository;
        this.userGroupRoleRepository = userGroupRoleRepository;
        this.userGroupMemberRepository = userGroupMemberRepository;
        this.userGroupPublisher = userGroupPublisher;
        this.transactionSupport = transactionSupport;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @NotNull
    public Optional<UserGroup> findUserGroup(@NotNull UserGroupId userGroupId) {
        Intrinsics.checkNotNullParameter((Object)userGroupId, (String)"userGroupId");
        Optional<UserGroup> optional = this.userGroupRepository.findById(userGroupId.getId()).map(arg_0 -> UserGroupService.findUserGroup$lambda$0((Function1)findUserGroup.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"map(...)");
        return optional;
    }

    @NotNull
    public UserGroup getUserGroup(@NotNull UserGroupId userGroupId) {
        Intrinsics.checkNotNullParameter((Object)userGroupId, (String)"userGroupId");
        Object t = this.findUserGroup(userGroupId).orElseThrow(() -> UserGroupService.getUserGroup$lambda$1(userGroupId));
        Intrinsics.checkNotNullExpressionValue(t, (String)"orElseThrow(...)");
        return (UserGroup)t;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<UserGroupId, UserGroup> findAllByIds(@NotNull Set<UserGroupId> userGroupIds) {
        void $this$associateByTo$iv$iv;
        DbUserGroup p0;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter(userGroupIds, (String)"userGroupIds");
        Iterable iterable = userGroupIds;
        Object object = this.userGroupRepository;
        boolean $i$f$mapToSet = false;
        void var5_6 = $this$mapToSet$iv;
        Object destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            UserGroupId userGroupId = (UserGroupId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((UUID)p0.getId());
        }
        List list = object.findAllById((Iterable)((Set)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAllById(...)");
        Iterable $this$associateBy$iv = list;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        $this$mapTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            p0 = (DbUserGroup)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            DbUserGroup it = (DbUserGroup)element$iv$iv;
            collection = new UserGroupId(it.getId());
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            UserGroup userGroup = DbUserGroup.Companion.toUserGroup(it);
            object.put(collection, userGroup);
        }
        return destination$iv$iv;
    }

    @Transactional
    @NotNull
    public UserGroupId createUserGroup(@NotNull String name, @NotNull ProfileId creator, @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        Object object = this.userGroupRepository.save((Object)new DbUserGroup(uUID, (UUID)tenantId.getId(), name, (Long)creator.getId(), false, false, null));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"save(...)");
        DbUserGroup userGroup = (DbUserGroup)object;
        UserGroupId userGroupId = new UserGroupId(userGroup.getId());
        this.publishUserGroup(userGroupId, this.getDefaultPermissions(userGroup));
        return userGroupId;
    }

    @NotNull
    public synchronized UserGroupId createOrGetAllTenantUsersGroup(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        DbUserGroup dbUserGroup = this.findAllTenantUsersGroup(tenantId);
        if (dbUserGroup == null) {
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
            Object object = this.userGroupRepository.save((Object)new DbUserGroup(uUID, (UUID)tenantId.getId(), TENANT_USER_GROUP_NAME, null, true, false, null));
            DbUserGroup it = (DbUserGroup)object;
            boolean bl = false;
            UserGroupId userGroupId = new UserGroupId(it.getId());
            this.publishUserGroup(userGroupId, MapsKt.mapOf((Pair)TuplesKt.to((Object)userGroupId.asPermissionRole(), (Object)UserGroupRole.READER)));
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            dbUserGroup = (DbUserGroup)object2;
        }
        DbUserGroup usersGroup = dbUserGroup;
        return new UserGroupId(usersGroup.getId());
    }

    @NotNull
    public UserGroupId getAllTenantUsersGroupId(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        DbUserGroup dbUserGroup = this.findAllTenantUsersGroup(tenantId);
        if (dbUserGroup == null) {
            boolean bl = false;
            String string = "No all tenant users group available for tenant " + tenantId;
            throw new IllegalStateException(string.toString());
        }
        UUID uUID = dbUserGroup.getId();
        return new UserGroupId(uUID);
    }

    public void deleteAllTenantUsersGroup(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        DbUserGroup tenantUserGroup = this.findAllTenantUsersGroup(tenantId);
        if (tenantUserGroup == null) {
            LOGGER.debug("There is no user group for Tenant {}.", (Object)tenantId);
            return;
        }
        this.deleteUserGroup(new UserGroupId(tenantUserGroup.getId()));
    }

    @Transactional
    public void publishUserGroup(@NotNull UserGroupId userGroupId, @NotNull Map<Role, ? extends UserGroupRole> permissions) {
        Intrinsics.checkNotNullParameter((Object)userGroupId, (String)"userGroupId");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        UserGroup userGroup = this.getUserGroup(userGroupId);
        Stream.Builder offsetConsumer = Stream.builder();
        this.userGroupPublisher.publishUserGroup(userGroup, (Consumer)offsetConsumer);
        Intrinsics.checkNotNull(offsetConsumer);
        this.setUserGroupRolesAndPublishedPermissions(userGroupId, permissions, offsetConsumer);
        this.transactionSupport.doAfterCommit(() -> UserGroupService.publishUserGroup$lambda$6(this, userGroupId));
    }

    private Map<Role, UserGroupRole> getDefaultPermissions(DbUserGroup userGroup) {
        HashMap userGroupRoles = new HashMap();
        UserGroupId allTenantUsersGroupId = this.getAllTenantUsersGroupId(new TenantId(userGroup.getTenantId()));
        Map map = userGroupRoles;
        Role role = Role.userGroupRole((UUID)((UUID)allTenantUsersGroupId.getId()));
        Intrinsics.checkNotNullExpressionValue((Object)role, (String)"userGroupRole(...)");
        Object object = role;
        UserGroupRole userGroupRole = UserGroupRole.READER;
        map.put(object, userGroupRole);
        Long creatorId = userGroup.getCreatorId();
        if (creatorId != null) {
            object = userGroupRoles;
            Role role2 = Role.profileRole((long)creatorId);
            Intrinsics.checkNotNullExpressionValue((Object)role2, (String)"profileRole(...)");
            userGroupRole = role2;
            UserGroupRole userGroupRole2 = UserGroupRole.MANAGER;
            object.put(userGroupRole, userGroupRole2);
        }
        return userGroupRoles;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void updateMembers(@NotNull List<Membership> membersToAdd, @NotNull List<Membership> membersToDelete) {
        List members;
        UserGroupId userGroupId;
        Map.Entry element$iv;
        void $this$groupByTo$iv$iv;
        Membership p0;
        List list;
        void $this$groupByTo$iv$iv2;
        Intrinsics.checkNotNullParameter(membersToAdd, (String)"membersToAdd");
        Intrinsics.checkNotNullParameter(membersToDelete, (String)"membersToDelete");
        Iterable $this$groupBy$iv = membersToAdd;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
            Object object;
            Membership p02 = (Membership)element$iv$iv;
            boolean $i$a$-groupBy-UserGroupService$updateMembers$membersToAddByGroup$32 = false;
            UserGroupId key$iv$iv = p02.getUserGroupId();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Membership $i$a$-groupBy-UserGroupService$updateMembers$membersToAddByGroup$32 = (Membership)element$iv$iv;
            list = list$iv$iv;
            boolean bl = false;
            list.add(p0.getProfileId());
        }
        Map membersToAddByGroup = destination$iv$iv;
        Iterable $this$groupBy$iv2 = membersToDelete;
        boolean $i$f$groupBy2 = false;
        destination$iv$iv = $this$groupBy$iv2;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void p03;
            Object object;
            p0 = (Membership)element$iv$iv;
            boolean $i$a$-groupBy-UserGroupService$updateMembers$membersToDeleteByGroup$32 = false;
            UserGroupId key$iv$iv = p0.getUserGroupId();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Membership $i$a$-groupBy-UserGroupService$updateMembers$membersToDeleteByGroup$32 = (Membership)element$iv$iv;
            list = list$iv$iv;
            boolean bl = false;
            list.add(p03.getProfileId());
        }
        Map membersToDeleteByGroup = destination$iv$iv2;
        Map $this$forEach$iv = membersToAddByGroup;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            userGroupId = (UserGroupId)entry.getKey();
            members = (List)entry.getValue();
            this.updateMembers(userGroupId, CollectionsKt.toSet((Iterable)members), SetsKt.emptySet());
        }
        $this$forEach$iv = membersToDeleteByGroup;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            userGroupId = (UserGroupId)entry.getKey();
            members = (List)entry.getValue();
            this.updateMembers(userGroupId, SetsKt.emptySet(), CollectionsKt.toSet((Iterable)members));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void updateMembers(@NotNull UserGroupId userGroupId, @NotNull Set<ProfileId> membersToAdd, @NotNull Set<ProfileId> membersToDelete) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)userGroupId, (String)"userGroupId");
        Intrinsics.checkNotNullParameter(membersToAdd, (String)"membersToAdd");
        Intrinsics.checkNotNullParameter(membersToDelete, (String)"membersToDelete");
        Iterable $this$mapToSet$iv = this.userGroupMemberRepository.findByUserGroupId((UUID)userGroupId.getId());
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Iterator it;
            DbUserGroupMember dbUserGroupMember = (DbUserGroupMember)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ProfileId(it.getProfileId()));
        }
        Set currentGroupMembers = (Set)destination$iv$iv;
        Set newMembers = SetsKt.minus(membersToAdd, (Iterable)currentGroupMembers);
        Set filteredMembersToDelete = CollectionsKt.intersect((Iterable)membersToDelete, (Iterable)currentGroupMembers);
        this.userGroupMemberRepository.saveAll((Iterable)Companion.toDbUserGroupMembers$people_api((Collection)Companion.toDbUserGroupMemberIds$people_api((Collection)newMembers, userGroupId)));
        Iterable $this$mapToSet$iv2 = filteredMembersToDelete;
        boolean $i$f$mapToSet2 = false;
        Iterable $i$f$mapTo22 = $this$mapToSet$iv2;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv2));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ProfileId profileId = (ProfileId)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(((Number)it.getId()).longValue());
        }
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)((Set)destination$iv$iv2), (int)1000);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            this.userGroupMemberRepository.deleteByUserGroupIdAndProfileIds((UUID)userGroupId.getId(), CollectionsKt.toSet((Iterable)it));
        }
        boolean entriesProcessed = this.userGroupPublisher.publishUserGroupMemberships(userGroupId, newMembers, filteredMembersToDelete);
        if (!entriesProcessed) {
            LOGGER.warn("Permission has not processed all user group changes. Aborting SOLR reindex. Potentially inconsistent state. In emergencies you can trigger a SOLR index for profiles manually.");
            return;
        }
        this.transactionSupport.doAfterCommit(() -> UserGroupService.updateMembers$lambda$16(this, userGroupId, newMembers, filteredMembersToDelete));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ProfileId> getMembersOfGroup(@NotNull UserGroupId userGroupId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)userGroupId, (String)"userGroupId");
        Iterable $this$mapToSet$iv = this.userGroupMemberRepository.findByUserGroupId((UUID)userGroupId.getId());
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DbUserGroupMember dbUserGroupMember = (DbUserGroupMember)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ProfileId(it.getProfileId()));
        }
        return (Set)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ProfileId, List<UserGroupId>> getUserGroupsForProfiles(@NotNull Set<ProfileId> profileIds) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Iterable $this$groupBy$iv = this.findUserGroupMembersByProfileIds(profileIds);
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            DbUserGroupMember it2 = (DbUserGroupMember)element$iv$iv;
            boolean $i$a$-groupBy-UserGroupService$getUserGroupsForProfiles$32 = false;
            ProfileId key$iv$iv = new ProfileId(it2.getProfileId());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            DbUserGroupMember $i$a$-groupBy-UserGroupService$getUserGroupsForProfiles$32 = (DbUserGroupMember)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            list.add(new UserGroupId(it.getUserGroupId()));
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void deleteUserGroup(@NotNull UserGroupId groupId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Iterable $this$mapToSet$iv = this.userGroupMemberRepository.findByUserGroupId((UUID)groupId.getId());
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DbUserGroupMember dbUserGroupMember = (DbUserGroupMember)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ProfileId(it.getProfileId()));
        }
        Set membersOfGroup = (Set)destination$iv$iv;
        this.userGroupMemberRepository.deleteByUserGroupId((UUID)groupId.getId());
        Role role = Role.userGroupRole((UUID)((UUID)groupId.getId()));
        Intrinsics.checkNotNullExpressionValue((Object)role, (String)"userGroupRole(...)");
        this.deleteUserGroupPermissionRole(role);
        this.userGroupRepository.deleteById(groupId.getId());
        this.transactionSupport.doAfterCommit(() -> UserGroupService.deleteUserGroup$lambda$21(this, groupId, membersOfGroup));
    }

    public void deleteOldNotYetImportedGroups(@NotNull Duration olderThan) {
        Intrinsics.checkNotNullParameter((Object)olderThan, (String)"olderThan");
        LOGGER.info("Scheduled deletion of old not yet imported groups");
        Iterable $this$forEach$iv = this.userGroupRepository.findNotYetImportedGroups();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DbUserGroup it = (DbUserGroup)element$iv;
            boolean bl = false;
            Instant maxCreatedAtAge = Instant.now().minus(olderThan);
            Instant instant = it.getCreatedAt();
            boolean bl2 = instant != null ? instant.isBefore(maxCreatedAtAge) : false;
            if (!bl2) continue;
            this.deleteUserGroup(new UserGroupId(it.getId()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void deleteUserGroupPermissionRole(@NotNull Role role) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        String string = role.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Iterable $this$mapToSet$iv = this.userGroupRoleRepository.findAllByRole(string);
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DbUserGroupRole dbUserGroupRole = (DbUserGroupRole)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new UserGroupId(it.getUserGroupId()));
        }
        Set userGroupIds = (Set)destination$iv$iv;
        if (userGroupIds.isEmpty()) {
            return;
        }
        Map userGroupRoles = this.getUserGroupRoles(userGroupIds);
        for (UserGroupId userGroupId : userGroupIds) {
            Map map;
            if ((Map)userGroupRoles.get(userGroupId) != null) {
                void $this$filterTo$iv$iv;
                Map $this$filter$iv;
                boolean $i$f$filter = false;
                Map bl = $this$filter$iv;
                Map destination$iv$iv2 = new LinkedHashMap();
                boolean $i$f$filterTo = false;
                Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry entry = element$iv$iv = iterator.next();
                    boolean bl2 = false;
                    Role key = (Role)entry.getKey();
                    if (!(!Intrinsics.areEqual((Object)role, (Object)key))) continue;
                    destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                map = destination$iv$iv2;
            } else {
                map = MapsKt.emptyMap();
            }
            Map newRoles = map;
            this.setUserGroupRoles(userGroupId, newRoles);
        }
    }

    public void renameUserGroup(@NotNull UserGroupId groupId, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        UserGroup userGroup = this.getUserGroup(groupId);
        if (userGroup.isAllTenantUsers()) {
            throw new NotAllowed("You must not rename the group with id '" + groupId + "'. It is an allTenantUsers group.");
        }
        DbUserGroup dbUserGroup = DbUserGroup.copy$default((DbUserGroup)DbUserGroup.Companion.toDbUserGroup(userGroup), null, null, (String)name, null, (boolean)false, (boolean)false, null, (int)123, null);
        this.userGroupRepository.save((Object)dbUserGroup);
        this.userGroupPublisher.publishUserGroup(DbUserGroup.Companion.toUserGroup(dbUserGroup), NOOP_OFFSETS_CONSUMER);
        this.transactionSupport.doAfterCommit(() -> UserGroupService.renameUserGroup$lambda$25(this, groupId));
    }

    @NotNull
    public Map<Role, UserGroupRole> getUserGroupRoles(@NotNull UserGroupId userGroupId) {
        Intrinsics.checkNotNullParameter((Object)userGroupId, (String)"userGroupId");
        Map map = (Map)this.getUserGroupRoles(SetsKt.setOf((Object)userGroupId)).get(userGroupId);
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<UserGroupId, Map<Role, UserGroupRole>> getUserGroupRoles(@NotNull Set<UserGroupId> userGroupIds) {
        void $this$mapValuesTo$iv$iv;
        Object $this$groupByTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(userGroupIds, (String)"userGroupIds");
        Iterable $this$map$iv = userGroupIds;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            UserGroupId userGroupId = (UserGroupId)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add((UUID)p0.getId());
        }
        $this$map$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        UserGroupRoleRepository $i$f$map22 = this.userGroupRoleRepository;
        boolean $i$f$flatMap22 = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo22 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Collection p0 = (Collection)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = $i$f$map22.findAllByUserGroupIdIn(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv2;
        boolean $i$f$groupBy = false;
        Iterable $i$f$flatMap22 = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator $i$f$flatMapTo22 = $this$groupByTo$iv$iv.iterator();
        while ($i$f$flatMapTo22.hasNext()) {
            void it;
            Object object2;
            Object element$iv$iv = $i$f$flatMapTo22.next();
            DbUserGroupRole it2 = (DbUserGroupRole)element$iv$iv;
            boolean $i$a$-groupBy-UserGroupService$getUserGroupRoles$52 = false;
            UserGroupId key$iv$iv = new UserGroupId(it2.getUserGroupId());
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            DbUserGroupRole $i$a$-groupBy-UserGroupService$getUserGroupRoles$52 = (DbUserGroupRole)element$iv$iv;
            object = list$iv$iv;
            boolean bl = false;
            object.add(TuplesKt.to((Object)Role.create((String)it.getRole()), (Object)it.getUserGroupRole()));
        }
        Object $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object object3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = object3;
            boolean bl2 = false;
            List values = (List)entry.getValue();
            Map map = MapsKt.toMap((Iterable)values);
            object.put(k, map);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void setUserGroupRoles(@NotNull UserGroupId userGroupId, @NotNull Map<Role, ? extends UserGroupRole> userGroupRoles) {
        void $this$mapToSet$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)userGroupId, (String)"userGroupId");
        Intrinsics.checkNotNullParameter(userGroupRoles, (String)"userGroupRoles");
        Stream.Builder builder = Stream.builder();
        Intrinsics.checkNotNullExpressionValue(builder, (String)"builder(...)");
        this.setUserGroupRolesAndPublishedPermissions(userGroupId, userGroupRoles, builder);
        Iterable iterable = this.userGroupMemberRepository.findByUserGroupId((UUID)userGroupId.getId());
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            DbUserGroupMember dbUserGroupMember = (DbUserGroupMember)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getProfileId());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$mapToSet = false;
        $this$mapTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            long p0 = ((Number)item$iv$iv).longValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ProfileId(p0));
        }
        Set membersOfGroup = (Set)destination$iv$iv;
        this.transactionSupport.doAfterCommit(() -> UserGroupService.setUserGroupRoles$lambda$33(this, userGroupId, membersOfGroup));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<UserGroupId, UserGroup> getUserGroups(@NotNull Set<UserGroupId> userGroupIds) {
        void $this$associateByTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(userGroupIds, (String)"userGroupIds");
        Iterable $this$map$iv = userGroupIds;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            UserGroupId userGroupId = (UserGroupId)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add((UUID)p0.getId());
        }
        $this$map$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        UserGroupRepository $i$f$map22 = this.userGroupRepository;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Object destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Iterable p0 = (Iterable)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = $i$f$map22.findAllById(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv2;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        $this$flatMapTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            DbUserGroup list$iv$iv = (DbUserGroup)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            DbUserGroup it = (DbUserGroup)element$iv$iv;
            UserGroupId userGroupId = new UserGroupId(it.getId());
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            UserGroup userGroup = DbUserGroup.Companion.toUserGroup(it);
            object.put(userGroupId, userGroup);
        }
        return destination$iv$iv2;
    }

    @Transactional
    public void forAllUserGroups(@NotNull Consumer<UserGroup> userGroupConsumer) {
        Intrinsics.checkNotNullParameter(userGroupConsumer, (String)"userGroupConsumer");
        this.userGroupRepository.streamAll().map(arg_0 -> UserGroupService.forAllUserGroups$lambda$38((Function1)forAllUserGroups.1.INSTANCE, arg_0)).forEach(userGroupConsumer);
    }

    @KafkaListener(id="just.people.tenantConsumer", containerFactory="tenantListenerFactory", topics={"just.tenants"}, idIsGroup=false)
    public void onTenantChanged(@NotNull ConsumerRecords<TenantId, String> records) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        KafkaUtilsKt.filterAndLogDeserializationErrors(records).forEach(arg_0 -> UserGroupService.onTenantChanged$lambda$39(this, arg_0));
    }

    @Async
    @EventListener
    public void onProfilesCreatedEvent(@NotNull ProfilesCreatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.transactionSupport.doInTransaction(() -> UserGroupService.onProfilesCreatedEvent$lambda$43(event, this));
    }

    @Async
    @EventListener
    public void onProfilesDeletedEvent(@NotNull ProfilesDeletedEvent profilesDeletedEvent) {
        Intrinsics.checkNotNullParameter((Object)profilesDeletedEvent, (String)"profilesDeletedEvent");
        this.removeDeletedProfilesFromUserGroups(profilesDeletedEvent.getProfileIds());
    }

    private void updateAllTenantUsersGroupMembers(TenantId tenantId, Set<ProfileId> membersToAdd, Set<ProfileId> membersToDelete) {
        UserGroupId allTenantUsersGroup = this.createOrGetAllTenantUsersGroup(tenantId);
        this.updateMembers(allTenantUsersGroup, membersToAdd, membersToDelete);
    }

    /*
     * WARNING - void declaration
     */
    private void setUserGroupRolesAndPublishedPermissions(UserGroupId userGroupId, Map<Role, ? extends UserGroupRole> userGroupRoles, Stream.Builder<WaitForOffsets> waitForOffsetsBuilder) {
        void $this$filterTo$iv$iv;
        Map map = (Map)this.getUserGroupRoles(SetsKt.setOf((Object)userGroupId)).get(userGroupId);
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map oldUserGroupRoles = map;
        this.transactionSupport.doInTransaction(() -> UserGroupService.setUserGroupRolesAndPublishedPermissions$lambda$44(this, userGroupId, userGroupRoles));
        Map $this$filter$iv = oldUserGroupRoles;
        boolean $i$f$filter = false;
        Map map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            Role role = (Role)entry.getKey();
            UserGroupRole userGroupRole = (UserGroupRole)entry.getValue();
            if (!(!userGroupRoles.containsKey(role) || userGroupRoles.get(role) != userGroupRole)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map userGroupRolesToDelete = destination$iv$iv;
        this.userGroupPublisher.publishUserGroupRoles(userGroupId, userGroupRoles, userGroupRolesToDelete, (Consumer)waitForOffsetsBuilder);
        new WaitForOffsets(waitForOffsetsBuilder.build()).waitForOffsets();
    }

    private void removeDeletedProfilesFromUserGroups(Set<ProfileId> deletedProfileIds) {
        this.transactionSupport.doInTransaction(() -> UserGroupService.removeDeletedProfilesFromUserGroups$lambda$52(this, deletedProfileIds));
    }

    /*
     * WARNING - void declaration
     */
    private List<DbUserGroupMember> findUserGroupMembersByProfileIds(Set<ProfileId> profileIds) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = profileIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ProfileId profileId = (ProfileId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)p0.getId()).longValue());
        }
        $this$map$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        UserGroupMemberRepository userGroupMemberRepository = this.userGroupMemberRepository;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Collection p0 = (Collection)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = userGroupMemberRepository.findByProfileIdIn(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    private DbUserGroup findAllTenantUsersGroup(TenantId tenantId) {
        return (DbUserGroup)CollectionsKt.firstOrNull((List)this.userGroupRepository.findByAllTenantUsersIsTrueAndTenantId((UUID)tenantId.getId()));
    }

    private static final UserGroup findUserGroup$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (UserGroup)$tmp0.invoke(p0);
    }

    private static final NotFoundException getUserGroup$lambda$1(UserGroupId $userGroupId) {
        Intrinsics.checkNotNullParameter((Object)$userGroupId, (String)"$userGroupId");
        return new NotFoundException("Could not find user group " + $userGroupId, $userGroupId.toString());
    }

    private static final void publishUserGroup$lambda$6(UserGroupService this$0, UserGroupId $userGroupId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$userGroupId, (String)"$userGroupId");
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new UserGroupCreatedOrPublishedEvent((Object)this$0, $userGroupId));
    }

    private static final void updateMembers$lambda$16(UserGroupService this$0, UserGroupId $userGroupId, Set $newMembers, Set $filteredMembersToDelete) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$userGroupId, (String)"$userGroupId");
        Intrinsics.checkNotNullParameter((Object)$newMembers, (String)"$newMembers");
        Intrinsics.checkNotNullParameter((Object)$filteredMembersToDelete, (String)"$filteredMembersToDelete");
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new UserGroupMembersUpdatedEvent((Object)this$0, $userGroupId, $newMembers, $filteredMembersToDelete));
    }

    private static final void deleteUserGroup$lambda$21(UserGroupService this$0, UserGroupId $groupId, Set $membersOfGroup) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$groupId, (String)"$groupId");
        Intrinsics.checkNotNullParameter((Object)$membersOfGroup, (String)"$membersOfGroup");
        this$0.userGroupPublisher.publishUserGroupDeleted($groupId, $membersOfGroup);
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new UserGroupDeletedEvent((Object)this$0, $groupId, $membersOfGroup));
    }

    private static final void renameUserGroup$lambda$25(UserGroupService this$0, UserGroupId $groupId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$groupId, (String)"$groupId");
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new UserGroupUpdatedEvent((Object)this$0, $groupId));
    }

    private static final void setUserGroupRoles$lambda$33(UserGroupService this$0, UserGroupId $userGroupId, Set $membersOfGroup) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$userGroupId, (String)"$userGroupId");
        Intrinsics.checkNotNullParameter((Object)$membersOfGroup, (String)"$membersOfGroup");
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new UserGroupRolesUpdatedEvent((Object)this$0, $userGroupId, $membersOfGroup));
    }

    private static final UserGroup forAllUserGroups$lambda$38(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (UserGroup)$tmp0.invoke(p0);
    }

    private static final void onTenantChanged$lambda$39(UserGroupService this$0, ConsumerRecord record) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        if (record.value() == null) {
            Object object = record.key();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"key(...)");
            this$0.deleteAllTenantUsersGroup((TenantId)object);
        } else {
            Object object = record.key();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"key(...)");
            this$0.createOrGetAllTenantUsersGroup((TenantId)object);
        }
    }

    private static final HashSet onProfilesCreatedEvent$lambda$43$lambda$41$lambda$40(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (HashSet)$tmp0.invoke(p0);
    }

    private static final void onProfilesCreatedEvent$lambda$43(ProfilesCreatedEvent $event, UserGroupService this$0) {
        Map.Entry entry;
        Map.Entry element$iv;
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        HashMap<Object, HashSet> profilesToAdd = new HashMap<Object, HashSet>();
        Map $this$forEach$iv = $event.getCreatedProfiles();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            ProfileId profileId = (ProfileId)entry.getKey();
            TenantId tenantId = (TenantId)entry.getValue();
            if (tenantId == null) continue;
            profilesToAdd.computeIfAbsent(tenantId, arg_0 -> UserGroupService.onProfilesCreatedEvent$lambda$43$lambda$41$lambda$40((Function1)onProfilesCreatedEvent.1.1.1.INSTANCE, arg_0)).add(profileId);
        }
        $this$forEach$iv = profilesToAdd;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            TenantId tenantId = (TenantId)entry.getKey();
            HashSet profileIds = (HashSet)entry.getValue();
            this$0.updateAllTenantUsersGroupMembers(tenantId, (Set)profileIds, SetsKt.emptySet());
        }
    }

    private static final void setUserGroupRolesAndPublishedPermissions$lambda$44(UserGroupService this$0, UserGroupId $userGroupId, Map $userGroupRoles) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$userGroupId, (String)"$userGroupId");
        Intrinsics.checkNotNullParameter((Object)$userGroupRoles, (String)"$userGroupRoles");
        this$0.userGroupRoleRepository.deleteByUserGroupId((UUID)$userGroupId.getId());
        this$0.userGroupRoleRepository.saveAll((Iterable)Companion.toDbUserGroupRoles$people_api($userGroupRoles, $userGroupId));
    }

    /*
     * WARNING - void declaration
     */
    private static final void removeDeletedProfilesFromUserGroups$lambda$52(UserGroupService this$0, Set $deletedProfileIds) {
        Iterable $this$mapTo$iv$iv;
        List membersToDelete;
        Map.Entry element$iv;
        Object object;
        Object $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$deletedProfileIds, (String)"$deletedProfileIds");
        Iterable $this$groupBy$iv = this$0.findUserGroupMembersByProfileIds($deletedProfileIds);
        boolean $i$f$groupBy = false;
        Object object2 = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object object3;
            Object element$iv$iv = iterator.next();
            DbUserGroupMember it2 = (DbUserGroupMember)element$iv$iv;
            boolean $i$a$-groupBy-UserGroupService$removeDeletedProfilesFromUserGroups$1$profilesToDelete$32 = false;
            UserGroupId key$iv$iv = new UserGroupId(it2.getUserGroupId());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            DbUserGroupMember $i$a$-groupBy-UserGroupService$removeDeletedProfilesFromUserGroups$1$profilesToDelete$32 = (DbUserGroupMember)element$iv$iv;
            object = list$iv$iv;
            boolean bl = false;
            object.add(new ProfileId(it.getProfileId()));
        }
        Map profilesToDelete = destination$iv$iv;
        Object $this$forEach$iv = profilesToDelete;
        boolean $i$f$forEach = false;
        $this$groupByTo$iv$iv = $this$forEach$iv.entrySet().iterator();
        while ($this$groupByTo$iv$iv.hasNext()) {
            Map.Entry $i$f$groupByTo2 = element$iv = $this$groupByTo$iv$iv.next();
            boolean bl = false;
            UserGroupId userGroupId = (UserGroupId)$i$f$groupByTo2.getKey();
            membersToDelete = (List)$i$f$groupByTo2.getValue();
            this$0.updateMembers(userGroupId, SetsKt.emptySet(), CollectionsKt.toSet((Iterable)membersToDelete));
        }
        Iterable $this$map$iv = $deletedProfileIds;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            membersToDelete = (ProfileId)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(((Number)p0.getId()).longValue());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            long p0 = ((Number)item$iv$iv).longValue();
            object = destination$iv$iv;
            boolean bl = false;
            object.add(Role.profileRole((long)p0));
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        object2 = $this$forEach$iv.iterator();
        while (object2.hasNext()) {
            element$iv = object2.next();
            Role p0 = (Role)element$iv;
            boolean bl = false;
            this$0.deleteUserGroupPermissionRole(p0);
        }
    }

    private static final void NOOP_OFFSETS_CONSUMER$lambda$55(WaitForOffsets it) {
    }
}

