/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.profile;

import de.justsoftware.people.business.event.ProfilesCreatedEvent;
import de.justsoftware.people.business.event.ProfilesDeletedEvent;
import de.justsoftware.people.business.event.ProfilesUpdatedEvent;
import de.justsoftware.people.business.externallink.ExternalLinkService;
import de.justsoftware.people.business.externallink.model.ExternalLinkConfig;
import de.justsoftware.people.business.profile.ProfileService;
import de.justsoftware.people.business.profile.model.DeletableProfile;
import de.justsoftware.people.business.profile.model.Profile;
import de.justsoftware.people.business.search.solr.model.ProfileSearchReadModel;
import de.justsoftware.people.model.DynamicProfileFields;
import de.justsoftware.people.model.ProfileId;
import de.justsoftware.people.model.TenantId;
import de.justsoftware.people.persistence.ProfileAttributeRepository;
import de.justsoftware.people.persistence.ProfileRepository;
import de.justsoftware.people.persistence.model.DbProfile;
import de.justsoftware.people.persistence.model.DbProfileAttribute;
import de.justsoftware.people.persistence.transaction.TransactionSupport;
import de.justsoftware.people.utils.CollectionUtilsKt;
import de.justsoftware.people.utils.KafkaUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 %2\u00020\u0001:\u0001%B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\"\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J#\u0010\u0019\u001a\u00020\u001a2\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001cH\u0011\u00a2\u0006\u0002\b\u001eJ!\u0010\u001f\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020 0\u001cH\u0011\u00a2\u0006\u0002\b!J$\u0010\"\u001a\u00020\u001a2\u001a\u0010#\u001a\u0016\u0012\u0004\u0012\u00020\u000f\u0012\f\u0012\n\u0012\u0004\u0012\u00020$\u0018\u00010\u00170\u000eH\u0012R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lde/justsoftware/people/business/profile/ProfileService;", "", "profileRepository", "Lde/justsoftware/people/persistence/ProfileRepository;", "profileAttributeRepository", "Lde/justsoftware/people/persistence/ProfileAttributeRepository;", "transactionSupport", "Lde/justsoftware/people/persistence/transaction/TransactionSupport;", "externalLinkService", "Lde/justsoftware/people/business/externallink/ExternalLinkService;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lde/justsoftware/people/persistence/ProfileRepository;Lde/justsoftware/people/persistence/ProfileAttributeRepository;Lde/justsoftware/people/persistence/transaction/TransactionSupport;Lde/justsoftware/people/business/externallink/ExternalLinkService;Lorg/springframework/context/ApplicationEventPublisher;)V", "findUndeletedProfileByIds", "", "Lde/justsoftware/people/model/ProfileId;", "Lde/justsoftware/people/business/profile/model/Profile;", "profileIds", "", "getProfile", "profileSearchReadModel", "Lde/justsoftware/people/business/search/solr/model/ProfileSearchReadModel;", "configuredLinks", "", "Lde/justsoftware/people/business/externallink/model/ExternalLinkConfig;", "onProfileAttributesChanged", "", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "Lde/justsoftware/people/model/DynamicProfileFields;", "onProfileAttributesChanged$people_api", "onProfileChanged", "Lde/justsoftware/people/business/profile/model/DeletableProfile;", "onProfileChanged$people_api", "saveProfileAttributes", "profileAttributes", "Lde/justsoftware/people/persistence/model/DbProfileAttribute;", "Companion", "people-api"})
@SourceDebugExtension(value={"SMAP\nProfileService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileService.kt\nde/justsoftware/people/business/profile/ProfileService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionUtils.kt\nde/justsoftware/people/utils/CollectionUtilsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,170:1\n1549#2:171\n1620#2,3:172\n1360#2:175\n1446#2,2:176\n1620#2,3:179\n1448#2,3:182\n1194#2,2:185\n1222#2,4:187\n1194#2,2:191\n1222#2,4:193\n1549#2:201\n1620#2,3:202\n1549#2:205\n1620#2,3:206\n1855#2:212\n1856#2:216\n1271#2,2:218\n1285#2,2:220\n1288#2:223\n1238#2,4:226\n1194#2,2:230\n1222#2,4:232\n1238#2,4:238\n1549#2:242\n1620#2,3:243\n1855#2,2:246\n17#3:178\n7#3,3:209\n10#3,3:213\n13#3:217\n125#4:197\n152#4,3:198\n1#5:222\n468#6:224\n414#6:225\n453#6:236\n403#6:237\n494#6,7:248\n*S KotlinDebug\n*F\n+ 1 ProfileService.kt\nde/justsoftware/people/business/profile/ProfileService\n*L\n72#1:171\n72#1:172,3\n74#1:175\n74#1:176,2\n77#1:179,3\n74#1:182,3\n78#1:185,2\n78#1:187,4\n89#1:191,2\n89#1:193,4\n93#1:201\n93#1:202,3\n94#1:205\n94#1:206,3\n99#1:212\n99#1:216\n107#1:218,2\n107#1:220,2\n107#1:223\n111#1:226,4\n132#1:230,2\n132#1:232,4\n133#1:238,4\n146#1:242\n146#1:243,3\n148#1:246,2\n77#1:178\n99#1:209,3\n99#1:213,3\n99#1:217\n90#1:197\n90#1:198,3\n111#1:224\n111#1:225\n133#1:236\n133#1:237\n152#1:248,7\n*E\n"})
public class ProfileService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProfileRepository profileRepository;
    @NotNull
    private final ProfileAttributeRepository profileAttributeRepository;
    @NotNull
    private final TransactionSupport transactionSupport;
    @NotNull
    private final ExternalLinkService externalLinkService;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    public static final String PERSON_TOPIC = "just.persons";
    @NotNull
    public static final String PERSON_PROFILE_ATTRIBUTES_TOPIC = "just.persons.profileAttributes";
    @NotNull
    private static final String PROFILE_LISTENER_ID = "profileConsumer";
    @NotNull
    private static final String PROFILE_ATTRIBUTES_LISTENER_ID = "profileAttributesConsumer";
    private static final Logger LOG = LoggerFactory.getLogger(ProfileService.class);

    public ProfileService(@NotNull ProfileRepository profileRepository, @NotNull ProfileAttributeRepository profileAttributeRepository, @NotNull TransactionSupport transactionSupport, @NotNull ExternalLinkService externalLinkService, @NotNull ApplicationEventPublisher applicationEventPublisher) {
        Intrinsics.checkNotNullParameter((Object)profileRepository, (String)"profileRepository");
        Intrinsics.checkNotNullParameter((Object)profileAttributeRepository, (String)"profileAttributeRepository");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        Intrinsics.checkNotNullParameter((Object)externalLinkService, (String)"externalLinkService");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        this.profileRepository = profileRepository;
        this.profileAttributeRepository = profileAttributeRepository;
        this.transactionSupport = transactionSupport;
        this.externalLinkService = externalLinkService;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @NotNull
    public Profile getProfile(@NotNull ProfileSearchReadModel profileSearchReadModel) {
        Intrinsics.checkNotNullParameter((Object)profileSearchReadModel, (String)"profileSearchReadModel");
        return Profile.Companion.toProfile$default((Profile.Companion)Profile.Companion, (ProfileSearchReadModel)profileSearchReadModel, null, (int)1, null);
    }

    @NotNull
    public Profile getProfile(@NotNull ProfileSearchReadModel profileSearchReadModel, @NotNull List<ExternalLinkConfig> configuredLinks) {
        Intrinsics.checkNotNullParameter((Object)profileSearchReadModel, (String)"profileSearchReadModel");
        Intrinsics.checkNotNullParameter(configuredLinks, (String)"configuredLinks");
        Map map = profileSearchReadModel.getFields();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getFields(...)");
        Map fields = map;
        if (fields.isEmpty()) {
            return Profile.Companion.toProfile$default((Profile.Companion)Profile.Companion, (ProfileSearchReadModel)profileSearchReadModel, null, (int)1, null);
        }
        List links = this.externalLinkService.getLinkFromConfigAndData(configuredLinks, fields);
        return Profile.Companion.toProfile(profileSearchReadModel, links);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ProfileId, Profile> findUndeletedProfileByIds(@NotNull Iterable<ProfileId> profileIds) {
        void $this$associateByTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Iterable<ProfileId> $this$map$iv = profileIds;
        boolean $i$f$map = false;
        Iterable<ProfileId> iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ProfileId profileId = (ProfileId)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(((Number)p0.getId()).longValue());
        }
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            List chunk = (List)element$iv$iv;
            boolean bl = false;
            Map attributes = DbProfileAttribute.Companion.toDynamicProfileFields((Iterable)this.profileAttributeRepository.findAllByProfileIdIn((Iterable)chunk));
            List profiles = this.profileRepository.findAllByDeletedIsFalseAndIdIn((Iterable)chunk);
            Iterable $this$mapToSet$iv = profiles;
            boolean $i$f$mapToSet = false;
            Iterable iterable2 = $this$mapToSet$iv;
            Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                DbProfile dbProfile = (DbProfile)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                Object object2 = (DynamicProfileFields)attributes.get(new ProfileId(it.getId()));
                if (object2 == null || (object2 = object2.getFields()) == null) {
                    object2 = MapsKt.emptyMap();
                }
                collection.add(DbProfile.Companion.toProfile$default((DbProfile.Companion)DbProfile.Companion, (DbProfile)it, (Map)object2, null, (int)2, null));
            }
            Iterable list$iv$iv = (Set)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            Profile bl = (Profile)element$iv$iv;
            object = destination$iv$iv3;
            boolean bl3 = false;
            object.put(p0.getId(), element$iv$iv);
        }
        return destination$iv$iv3;
    }

    /*
     * WARNING - void declaration
     */
    @KafkaListener(id="profileConsumer", containerFactory="profileListenerFactory", topics={"just.persons"}, idIsGroup=false)
    public void onProfileChanged$people_api(@NotNull ConsumerRecords<ProfileId, DeletableProfile> records) {
        void $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        Map $this$associateWith$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection<Object> collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Iterable $this$mapTo$iv$iv3;
        Object object;
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Iterable $this$associateBy$iv = KafkaUtilsKt.filterAndLogDeserializationErrors(records);
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            ConsumerRecord consumerRecord = (ConsumerRecord)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.put((ProfileId)p0.key(), element$iv$iv);
        }
        Map $this$map$iv3 = destination$iv$iv;
        boolean $i$f$map22 = false;
        Map capacity$iv22 = $this$map$iv3;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv3.size());
        boolean $i$f$mapTo22 = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv3.entrySet()) {
            Object element$iv$iv;
            element$iv$iv = item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            ConsumerRecord record = (ConsumerRecord)element$iv$iv.getValue();
            Object object2 = record.value();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"value(...)");
            object.add(DbProfile.Companion.toDbProfile((DeletableProfile)object2));
        }
        List changedProfiles = (List)destination$iv$iv2;
        $this$mapTo$iv$iv3 = changedProfiles;
        object = this.profileRepository;
        boolean $i$f$map32 = false;
        void $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void p0;
            DbProfile record = (DbProfile)item$iv$iv2;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(p0.getId());
        }
        List list = object.findAllById((Iterable)((List)destination$iv$iv3));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAllById(...)");
        Iterable $i$f$map22 = list;
        boolean $i$f$map = false;
        void $i$f$map32 = $this$map$iv;
        Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            DbProfile item$iv$iv2 = (DbProfile)item$iv$iv;
            object = destination$iv$iv22;
            boolean bl = false;
            object.add(p0.getId());
        }
        Set knownProfiles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv22));
        this.profileRepository.saveAll((Iterable)changedProfiles);
        Iterable $this$partition$iv = changedProfiles;
        boolean $i$f$partition = false;
        ArrayList<DbProfile> first$iv = new ArrayList<DbProfile>();
        Iterable second$iv = new ArrayList();
        Iterable $this$forEach$iv$iv = $this$partition$iv;
        boolean $i$f$forEach = false;
        Iterator p0 = $this$forEach$iv$iv.iterator();
        while (p0.hasNext()) {
            void p02;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = p0.next();
            boolean bl = false;
            DbProfile p03 = (DbProfile)element$iv;
            boolean $i$a$-partition-ProfileService$onProfileChanged$32 = false;
            ArrayList<DbProfile> target$iv = p03.getDeleted() ? first$iv : second$iv;
            DbProfile $i$a$-partition-ProfileService$onProfileChanged$32 = (DbProfile)element$iv;
            object = target$iv;
            boolean bl2 = false;
            ((ArrayList)object).add(p02.getId());
        }
        Pair pair = TuplesKt.to(first$iv, second$iv);
        List deletedProfiles = (List)pair.component1();
        List updatedProfiles = (List)pair.component2();
        if (!((Collection)deletedProfiles).isEmpty()) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ProfilesDeletedEvent((Object)this, ProfileId.Companion.toProfileIds((Iterable)deletedProfiles)));
            LOG.info("Deleted " + ((Collection)deletedProfiles).size() + " profile(s)");
        }
        second$iv = CollectionsKt.minus((Iterable)updatedProfiles, (Iterable)knownProfiles);
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateWith$iv), (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            TenantId tenantId;
            DbProfile profile;
            Object v2;
            block13: {
                long target$iv = ((Number)element$iv$iv).longValue();
                collection = element$iv$iv;
                object = result$iv;
                boolean bl = false;
                Iterable iterable2 = changedProfiles;
                for (Object object3 : iterable2) {
                    void id;
                    DbProfile profile2 = (DbProfile)object3;
                    boolean bl3 = false;
                    if (!(profile2.getId() == id)) continue;
                    v2 = object3;
                    break block13;
                }
                v2 = null;
            }
            DbProfile dbProfile = profile = (DbProfile)v2;
            Intrinsics.checkNotNull((Object)dbProfile);
            if (dbProfile.getTenantId() == null) {
                tenantId = null;
            } else {
                UUID uUID = profile.getTenantId();
                Intrinsics.checkNotNull((Object)uUID);
                tenantId = new TenantId(uUID);
            }
            TenantId tenantId2 = tenantId;
            object.put(collection, tenantId2);
        }
        $this$associateWith$iv = result$iv;
        boolean $i$f$mapKeys = false;
        result$iv = $this$mapKeys$iv;
        Map destination$iv$iv4 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void entry;
            Object object3;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            object = destination$iv$iv4;
            boolean bl4 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            object3 = new ProfileId(((Number)entry.getKey()).longValue());
            Object object4 = object;
            boolean bl5 = false;
            Object v = it$iv$iv.getValue();
            object4.put(object3, v);
        }
        Map newProfilesAndTenant = destination$iv$iv4;
        if (!newProfilesAndTenant.isEmpty()) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ProfilesCreatedEvent((Object)this, newProfilesAndTenant));
            LOG.info("Added " + newProfilesAndTenant.size() + " profile(s)");
        }
        if (!((Collection)updatedProfiles).isEmpty()) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ProfilesUpdatedEvent((Object)this, ProfileId.Companion.toProfileIds((Iterable)updatedProfiles)));
            LOG.info("Updated " + ((Collection)updatedProfiles).size() + " profile(s)");
        }
    }

    /*
     * WARNING - void declaration
     */
    @KafkaListener(id="profileAttributesConsumer", containerFactory="profileAttributesListenerFactory", topics={"just.persons.profileAttributes"}, idIsGroup=false)
    public void onProfileAttributesChanged$people_api(@NotNull ConsumerRecords<ProfileId, DynamicProfileFields> records) {
        void $this$mapValuesTo$iv$iv;
        Map map;
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Iterable $this$associateBy$iv = KafkaUtilsKt.filterAndLogDeserializationErrors(records);
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            ConsumerRecord consumerRecord = (ConsumerRecord)element$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            map.put((ProfileId)p0.key(), element$iv$iv);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        Map capacity$iv22 = $this$mapValues$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            List list;
            void it$iv$iv;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl2 = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map = map2;
            boolean bl3 = false;
            ProfileId profileId = (ProfileId)entry.getKey();
            ConsumerRecord records2 = (ConsumerRecord)entry.getValue();
            DynamicProfileFields dynamicProfileFields = (DynamicProfileFields)records2.value();
            if (dynamicProfileFields != null) {
                Intrinsics.checkNotNull((Object)profileId);
                list = DbProfileAttribute.Companion.toDbProfileAttributes(dynamicProfileFields, profileId);
            } else {
                list = null;
            }
            List list2 = list;
            map.put(k, list2);
        }
        Map attributeChanges = destination$iv$iv2;
        this.saveProfileAttributes(attributeChanges);
        LOG.info("Updated profile attributes of " + attributeChanges.size() + " profiles");
    }

    private void saveProfileAttributes(Map<ProfileId, ? extends List<DbProfileAttribute>> profileAttributes) {
        if (profileAttributes.isEmpty()) {
            return;
        }
        this.transactionSupport.doInTransaction(() -> ProfileService.saveProfileAttributes$lambda$17(profileAttributes, this));
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ProfilesUpdatedEvent((Object)this, profileAttributes.keySet()));
    }

    /*
     * WARNING - void declaration
     */
    private static final void saveProfileAttributes$lambda$17(Map $profileAttributes, ProfileService this$0) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$profileAttributes, (String)"$profileAttributes");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$map$iv = $profileAttributes.keySet();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ProfileId profileId = (ProfileId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)p0.getId()).longValue());
        }
        $this$map$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        ProfileAttributeRepository $i$f$map22 = this$0.profileAttributeRepository;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Iterable p0 = (Iterable)element$iv;
            boolean bl = false;
            $i$f$map22.deleteByProfileIdIn(p0);
        }
        Map $this$filterValues$iv = CollectionUtilsKt.filterNotNullValues((Map)$profileAttributes);
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            List p0 = (List)entry$iv.getValue();
            boolean bl = false;
            if (!(!((Collection)p0).isEmpty())) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        List toSave = CollectionsKt.flatten((Iterable)((Map)result$iv).values());
        if (!((Collection)toSave).isEmpty()) {
            this$0.profileAttributeRepository.saveAll((Iterable)toSave);
        }
    }
}

